// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef MIPC_ECALL_INTERFACE_H_
#define MIPC_ECALL_INTERFACE_H_

#include "mipc_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_const.h"

/** @brief mipc ecall make an ecall */
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_call_ivs_onekey_ecall_struct;

/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_CALL_IVS_ONEKEY_ECALL_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_call_ivs_onekey_ecall_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] ecall_type
  *@param[in] ecall_format
  *@param[in] msd_length
  *@param[in] msd_data
*/
mipc_api_result_enum mipc_call_ivs_onekey_ecall_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_call_ivs_onekey_ecall_struct *result_ptr,
    mipc_ecall_type_const_enum ecall_type,
    mipc_ecall_msd_format_const_enum ecall_format,
    unsigned int msd_length,
    unsigned char* msd_data
);

/**
  *@brief function for async.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] ecall_type
  *@param[in] ecall_format
  *@param[in] msd_length
  *@param[in] msd_data
*/
mipc_api_result_enum mipc_call_ivs_onekey_ecall_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_CALL_IVS_ONEKEY_ECALL_CB cb,
    void *cb_priv_ptr,
    mipc_ecall_type_const_enum ecall_type,
    mipc_ecall_msd_format_const_enum ecall_format,
    unsigned int msd_length,
    unsigned char* msd_data
);

/** @brief mipc ecall update msd struct */
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_ecall_ivs_update_msd_struct;

/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_UPDATE_MSD_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_update_msd_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] ecall_type
  *@param[in] ecall_format
  *@param[in] msd_length
  *@param[in] msd_data
*/
mipc_api_result_enum mipc_ecall_ivs_update_msd_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_update_msd_struct *result_ptr,
    mipc_ecall_msd_format_const_enum msd_format,
    unsigned int msd_length,
    unsigned char* msd_data
);

/**
  *@brief function for async.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] ecall_type
  *@param[in] ecall_format
  *@param[in] msd_length
  *@param[in] msd_data
*/
mipc_api_result_enum mipc_ecall_ivs_update_msd_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_UPDATE_MSD_CB cb,
    void *cb_priv_ptr,
    mipc_ecall_msd_format_const_enum msd_format,
    unsigned int msd_length,
    unsigned char* msd_data
);

/** @brief mipc ecall reset ivs struct */
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_ecall_ivs_reset_struct;

/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_RESET_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_reset_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
*/
mipc_api_result_enum mipc_ecall_ivs_reset_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_reset_struct *result_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] dail_address dail address
  *@param[in] dial_addr_type
  *@param[in] type, isn't mandatory, default voice
  *@param[in] domain isn't mandatory,default auto
  *@param[in] ecc_retry_domain isn't mandatory,default auto
  *@param[in] ecc_category isn't mandatory,default 0
  *@param[in] clir isn't mandatory,default false
*/
mipc_api_result_enum mipc_ecall_ivs_reset_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_RESET_CB cb,
    void *cb_priv_ptr
);


/** @brief mipc ecall get sim info resp struct*/
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
    mipc_ecall_sim_type_const_enum sim_type;
    char* usim_test_ecall_uri;
    char* usim_test_ecall_num;
    char* usim_reconf_ecall_uri;
    char* usim_reconf_ecall_num;
} mipc_ecall_ivs_get_sim_info_struct;

/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_GET_SIM_INFO_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_get_sim_info_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_get_sim_info_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_get_sim_info_struct *result_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_get_sim_info_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_GET_SIM_INFO_CB cb,
    void *cb_priv_ptr
);


/** @brief mipc ecall set reg state resp struct*/
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_ecall_ivs_set_reg_state_struct;


/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_SET_REG_STATE_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_reg_state_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_reg_state_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_reg_state_struct *result_ptr,
    mipc_nw_register_mode_const_enum reg_state
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_reg_state_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_SET_REG_STATE_CB cb,
    void *cb_priv_ptr,
    mipc_nw_register_mode_const_enum reg_state
);


/** @brief mipc ecall set test addr resp struct*/
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_ecall_ivs_set_test_addr_struct;


/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_SET_TEST_ADDR_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_test_addr_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_test_addr_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_test_addr_struct *result_ptr,
    char *test_address,
	mipc_call_dial_address_type_const_enum address_type
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_test_addr_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_SET_TEST_ADDR_CB cb,
    void *cb_priv_ptr,
    char *test_address,
	mipc_call_dial_address_type_const_enum address_type
);

/** @brief mipc ecall set reconf addr resp struct*/
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_ecall_ivs_set_reconf_addr_struct;


/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_SET_RECONF_ADDR_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_reconf_addr_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_reconf_addr_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_reconf_addr_struct *result_ptr,
    char *reconf_address,
	mipc_call_dial_address_type_const_enum address_type
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_reconf_addr_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_SET_RECONF_ADDR_CB cb,
    void *cb_priv_ptr,
    char *reconf_address,
	mipc_call_dial_address_type_const_enum address_type
);

/** @brief mipc ecall addr pri resp struct*/
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
} mipc_ecall_ivs_set_addr_pri_struct;


/**
  *@brief callback function prototype for async. SIM status get operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_IVS_SET_ADDR_PRI_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_addr_pri_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_addr_pri_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_ivs_set_addr_pri_struct *result_ptr,
    mipc_ecall_address_priority_class_const_enum first_pri,
    mipc_ecall_address_priority_class_const_enum second_pri,
    mipc_ecall_address_priority_class_const_enum third_pri,
    mipc_ecall_address_priority_class_const_enum fourth_pri
);

/**
  *@brief function for sync.
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] cb
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
  *@param[in] test_address test address
  *@param[in] num
  *@param[in] type
*/
mipc_api_result_enum mipc_ecall_ivs_set_addr_pri_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_IVS_SET_ADDR_PRI_CB cb,
    void *cb_priv_ptr,
    mipc_ecall_address_priority_class_const_enum first_pri,
    mipc_ecall_address_priority_class_const_enum second_pri,
    mipc_ecall_address_priority_class_const_enum third_pri,
    mipc_ecall_address_priority_class_const_enum fourth_pri
);

/////////////////////////////////INDICATIONS////////////////////////////////////////////
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
    /** @brief ecall state list*/
    mipc_ecall_status_const_enum state;
    uint8_t callid;
} mipc_ecall_status_ind_struct;


/**
  *@brief callback function prototype for  call status changed notification operation
  * This function will be called when radio state changed.
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_ECALL_STATUS_IND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ecall_status_ind_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function to register callback function for call status changed
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_ecall_status_register(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_ECALL_STATUS_IND_CB cb,
    void *cb_priv_ptr
);


#endif /* MIPC_ECALL_INTERFACE_H_ */

