#include <syslog.h>  //openlog(), syslog(), closelog()

#define DEBUG 1

#if DEBUG
#define LOGD(...)   {\
        fprintf(stderr, ## __VA_ARGS__);\
		syslog(LOG_DEBUG, ## __VA_ARGS__);}

#define LOGI(...)   {\
        fprintf(stderr, ## __VA_ARGS__);\
		syslog(LOG_INFO, ## __VA_ARGS__);}

#define LOGW(...)   {\
        fprintf(stderr, ## __VA_ARGS__);\
		syslog(LOG_WARNING, ## __VA_ARGS__);}

#define LOGE(...)   {\
        fprintf(stderr, ## __VA_ARGS__);\
		syslog(LOG_ERR, ## __VA_ARGS__);}
#else
#define LOGD(...)   {\
        syslog(LOG_DEBUG, ## __VA_ARGS__);}

#define LOGI(...)   {\
		syslog(LOG_INFO, ## __VA_ARGS__);}

#define LOGW(...)   {\
        syslog(LOG_WARNING, ## __VA_ARGS__);}

#define LOGE(...)   {\
        syslog(LOG_ERR, ## __VA_ARGS__);}
#endif
