# use new tinysys structure when TINYSYS_STRUCTURE_VERSION is 2
ifeq (2,$(strip $(TINYSYS_STRUCTURE_VERSION)))

LOCAL_PATH := $(call my-dir)
include $(CLEAR_VARS)

TINYSYS_MEDMCU := tinysys-medmcu
TINYSYS_MEDMCU_IMAGE_NAME := medmcu.img
TINYSYS_MEDMCU_CLEAN_MODULE := clean-$(TINYSYS_MEDMCU)
TINYSYS_MEDMCU_INSTALLED_TARGET := $(PRODUCT_OUT)/$(TINYSYS_MEDMCU_IMAGE_NAME)
TINYSYS_MEDMCU_SIGN_IMAGE_TARGET := $(addsuffix -verified$(suffix $(TINYSYS_MEDMCU_INSTALLED_TARGET)),$(basename $(TINYSYS_MEDMCU_INSTALLED_TARGET)))

LOCAL_MODULE := $(TINYSYS_MEDMCU)
LOCAL_MODULE_STEM := $(TINYSYS_MEDMCU_IMAGE_NAME)
LOCAL_MODULE_CLASS := TINYSYS_OBJ
LOCAL_MULTILIB := 32
LOCAL_MODULE_OWNER := mtk
LOCAL_MODULE_PATH := $(PRODUCT_OUT)
include $(BUILD_SYSTEM)/base_rules.mk

TINYSYS_MEDMCU_BUILT_INTERMEDIATES := \
    $(call intermediates-dir-for,$(LOCAL_MODULE_CLASS),$(LOCAL_MODULE))
TINYSYS_MEDMCU_DEPENDENT_FOLDERS := \
    $(wildcard $(LOCAL_PATH) $(LOCAL_PATH)/../common $(LOCAL_PATH)/../kernel/*/FreeRTOS/Source $(LOCAL_PATH)/../private)
TINYSYS_MEDMCU_MAKE_DEPENDENCIES := \
    $(shell find $(TINYSYS_MEDMCU_DEPENDENT_FOLDERS) -name .git -prune -o -type f | sort)
TINYSYS_MEDMCU_MAKE_DEPENDENCIES := \
    $(filter-out %/.git %/.gitignore %/.gitattributes,$(TINYSYS_MEDMCU_MAKE_DEPENDENCIES))
TINYSYS_MEDMCU_BUILD_CMD := \
	PROJECT=$(MTK_TARGET_PROJECT) \
	O=$(abspath $(TINYSYS_MEDMCU_BUILT_INTERMEDIATES)) \
	BUILD_TYPE=$(if $(filter-out user,$(TARGET_BUILD_VARIANT)),debug,release) \
	-C $(LOCAL_PATH)

# Config header targets
TINYSYS_MEDMCU_CONFIG_HEADER := $(TINYSYS_MEDMCU)-configheader

.PHONY: $(TINYSYS_MEDMCU_CONFIG_HEADER)
$(TINYSYS_MEDMCU_CONFIG_HEADER):
	$(PREBUILT_MAKE_PREFIX)$(MAKE) $(TINYSYS_MEDMCU_BUILD_CMD) configheader

# Main targets
.PHONY: $(TINYSYS_MEDMCU)
$(TINYSYS_MEDMCU): $(TINYSYS_MEDMCU_SIGN_IMAGE_TARGET)
$(TINYSYS_MEDMCU_SIGN_IMAGE_TARGET):
.KATI_RESTAT: $(LOCAL_INSTALLED_MODULE)

$(LOCAL_BUILT_MODULE): $(TINYSYS_MEDMCU_MAKE_DEPENDENCIES) | check-$(TINYSYS_MEDMCU)-config
	$(PREBUILT_MAKE_PREFIX)$(MAKE) $(TINYSYS_MEDMCU_BUILD_CMD)

#ifneq (yes,$(MTK_REMAKE_SUBMAKE_FLAG))
#$(LOCAL_BUILT_MODULE) $(TINYSYS_MEDMCU_CONFIG_HEADER): $(TINYSYS_MEDMCU_CLEAN_MODULE)
#endif

###########################################################
# TinySys Check config
###########################################################
.PHONY: check-$(TINYSYS_MEDMCU)-config
check-$(TINYSYS_MEDMCU)-config: $(TINYSYS_MEDMCU_CONFIG_HEADER)
ifneq (yes,$(strip $(DISABLE_MTK_CONFIG_CHECK)))
	python device/mediatek/build/build/tools/check_kernel_config.py --prjconfig $(MTK_TARGET_PROJECT_FOLDER)/ProjectConfig.mk --project $(MTK_TARGET_PROJECT) --header `find $(TINYSYS_MEDMCU_BUILT_INTERMEDIATES) -type f -name tinysys_config.h | tr "\n" "," | sed -e "s/,$$//"`
else
	-python device/mediatek/build/build/tools/check_kernel_config.py --prjconfig $(MTK_TARGET_PROJECT_FOLDER)/ProjectConfig.mk --project $(MTK_TARGET_PROJECT) --header `find $(TINYSYS_MEDMCU_BUILT_INTERMEDIATES) -type f -name tinysys_config.h | tr "\n" "," | sed -e "s/,$$//"`
endif

ifneq (,$(filter yes,$(MTK_TINYSYS_MEDMCU_SUPPORT)))
.PHONY: check-mtk-config
check-mtk-config: check-$(TINYSYS_MEDMCU)-config
endif

###########################################################
# Collect NOTICE files
###########################################################
TINYSYS_MEDMCU_NOTICE_FILES := \
  $(shell find $(LOCAL_PATH) -type f -name '*NOTICE*.txt' -printf '%P\n')
TINYSYS_MEDMCU_NOTICE_FILES_INSTALLED := \
  $(TINYSYS_MEDMCU_NOTICE_FILES:%=$(TARGET_OUT_NOTICE_FILES)/src/tinysys/%)

$(TARGET_OUT_INTERMEDIATES)/NOTICE.html: $(TINYSYS_MEDMCU_NOTICE_FILES_INSTALLED)

$(TINYSYS_MEDMCU_NOTICE_FILES_INSTALLED): \
  $(TARGET_OUT_NOTICE_FILES)/src/tinysys/%: $(LOCAL_PATH)/% | $(ACP)
	@echo Copying: $@
	$(hide) mkdir -p $(dir $@)
	$(hide) $(ACP) $< $

endif
