include $(COMMON_BUILD_DIR)/clear_vars.mk
-include $(SCP_BUILD_DIR)/clear_vars.mk

###########################################################
## Common SCP build environment
###########################################################
RV33_VAR    := MRV33E25
REL_ROOT_DIR := ../../../..
CROSS_COMPILE = $(REL_ROOT_DIR)/prebuilt/clang/md32rv/linux-x86
#CROSS_COMPILE = /mtkeda/Utility/CodeLine/md32rv/1.4.1/ToolChain/LLVM/
#CROSS_COMPILE = /mtkeda/Utility/Doble/md32rv/rv1.4.1_printf/ToolChain/LLVM/
CC           := $(CROSS_COMPILE)/bin/clang
CPP          := $(CROSS_COMPILE)/bin/clang-cpp
LLD          := $(CROSS_COMPILE)/bin/ld.lld
#LLD          := /mtkeda/Utility/Doble/md32rv/alpha70/ToolChain/LLVM/bin/ld.lld
AR           := $(CROSS_COMPILE)/bin/llvm-ar
RANLIB       := $(CROSS_COMPILE)/bin/llvm-ranlib
OBJCOPY      := $(CROSS_COMPILE)/bin/llvm-objcopy
OBJDUMP      := $(CROSS_COMPILE)/bin/llvm-objdump
SIZE         := $(CROSS_COMPILE)/bin/llvm-size
STRIP        := $(CROSS_COMPILE)/bin/strip
READELF      := $(CROSS_COMPILE)/bin/llvm-readelf
LLVM_RTLIB   := $(CROSS_COMPILE)/lib/clang/7.0.0/lib/riscv32/$(RV33_VAR)
LLVM_DKWLIB  := $(CROSS_COMPILE)/dkwlib/$(RV33_VAR)/lib
LLVM_NEWLIB  := $(CROSS_COMPILE)/riscv32-elf/$(RV33_VAR)/lib
LLVM_INCLUDE := $(CROSS_COMPILE)/riscv32-elf/$(RV33_VAR)/include

LLVM_DKWINC  := $(COMMON_INCLUDE_DIR)/dkwlib_inc/
#TMP_MODULE_ROOT := /proj/mtk11261/misc/alps/vendor/mediatek/proprietary/tinysys/private/ESL_simulator/ESL_RV33/toolchain/riscv32
#GOBJDUMP := $(TMP_MODULE_ROOT)/bin/riscv32-unknown-elf-objdump
#READELF := $(TMP_MODULE_ROOT)/bin/riscv32-unknown-elf-readelf
#OBJCOPY := $(TMP_MODULE_ROOT)/bin/riscv32-unknown-elf-objcopy
# Apply default environment if CROSS_COMPILE is not defined
ifeq (,$(CROSS_COMPILE))
  REL_ROOT_DIR := ../../../../..
  MRV_MODULE_ROOT := $(REL_ROOT_DIR)/prebuilt/clang/md32rv/linux-x86

  CC      := $(MRV_MODULE_ROOT)/bin/clang
  CPP     := $(MRV_MODULE_ROOT)/bin/clang-cpp
  LLD     := $(MRV_MODULE_ROOT)/bin/ld.lld
  AR      := $(MRV_MODULE_ROOT)/bin/llvm-ar
  RANLIB  := $(MRV_MODULE_ROOT)/bin/llvm-ranlib
  OBJCOPY := $(MRV_MODULE_ROOT)/bin/llvm-objcopy
  OBJDUMP := $(MRV_MODULE_ROOT)/bin/llvm-objdump
  SIZE    := $(MRV_MODULE_ROOT)/bin/llvm-size
  #STRIP   := $(MRV_MODULE_ROOT)/bin/strip
  READELF := $(MRV_MODULE_ROOT)/bin/llvm-readelf
  LLVM_RTLIB  := $(MRV_MODULE_ROOT)/lib/clang/5.0.1/lib/riscv32/$(RV33_VAR)
  LLVM_NEWLIB := $(MRV_MODULE_ROOT)/riscv32-elf/$(RV33_VAR)/lib
endif # CROSS_COMPILE is not defined

ifeq (1,$(V))
  $(info $(TINYSYS_MEDMCU): CC=$(CC))
  $(info $(TINYSYS_MEDMCU): CPP=$(CPP))
  $(info $(TINYSYS_MEDMCU): LLD=$(LLD))
  $(info $(TINYSYS_MEDMCU): AR=$(AR))
  $(info $(TINYSYS_MEDMCU): RANLIB=$(RANLIB))
  $(info $(TINYSYS_MEDMCU): OBJCOPY=$(OBJCOPY))
  $(info $(TINYSYS_MEDMCU): OBJDUMP=$(OBJDUMP))
  $(info $(TINYSYS_MEDMCU): SIZE=$(SIZE))
  $(info $(TINYSYS_MEDMCU): STRIP=$(STRIP))
  $(info $(TINYSYS_MEDMCU): READELF=$(READELF))
  $(info $(TINYSYS_MEDMCU): LLVM_RTLIB=$(LLVM_RTLIB))
  $(info $(TINYSYS_MEDMCU): LLVM_DKWLIB=$(LLVM_DKWLIB))
endif

CFLAGS += -Werror -Wall -Wextra -Wshadow -Wpointer-arith -Wbad-function-cast \
  -Wcast-align -Wsign-compare -Waggregate-return -Wstrict-prototypes \
  -Wmissing-prototypes -Wmissing-declarations -Wunused \
  -Wno-unused-parameter -Wno-format \
  -g -fomit-frame-pointer -fno-strict-aliasing \
  -fno-builtin -mllvm -enable-printf-opt=false -Os -D__gracefulExit -DLLVM \
  --target=riscv32-unknown-elf -mcpu=$(RV33_VAR)

# Define build type. Default to release
BUILD_TYPE ?= release

ifeq (1,$(V))
  $(info $(TINYSYS_MEDMCU): BUILD_TYPE=$(BUILD_TYPE))
endif

ifeq (debug,$(strip $(BUILD_TYPE)))
  CFLAGS += -DTINYSYS_DEBUG_BUILD
endif

###########################################################
## Processor-based environment and targets
###########################################################
PROCESSOR_DIR                  := $(SCP_PROJECT_DIR)/$(PROCESSOR)
PLATFORM_BASE_DIR              := $(PROCESSOR_DIR)/$(PLATFORM)
PLATFORM_DIR                   := $(PLATFORM_BASE_DIR)/platform
PROJECT_DIR                    := $(PLATFORM_BASE_DIR)/$(PROJECT)
ifeq (,$(wildcard $(PROJECT_DIR)))
PROJECT_DIR                    := $(PLATFORM_BASE_DIR)/internal/$(PROJECT)
endif
PLATFORM_FEATURES_DIR          := $(PLATFORM_DIR)/features
SCP_BUILT_DIR                  := $(SCP_BUILT_DIR)/$(PROCESSOR)/medmcu
DRIVERS_PLATFORM_DIR           := $(SCP_DRIVERS_DIR)/$(PROCESSOR)/$(PLATFORM)
GENERATED_DIR                  := $(SCP_BUILT_DIR)/generated
GENERATED_INCLUDE_DIR          := $(GENERATED_DIR)/include
$(PROCESSOR).TINYSYS_CONFIG_H  := $(GENERATED_INCLUDE_DIR)/tinysys_config.h
$(PROCESSOR).BIN_BUILT := \
  $(SCP_BUILT_DIR)/$(TINYSYS_MEDMCU)-$(PROCESSOR).bin

$(PROCESSOR)_MEDHW_GC0_PM.BIN_BUILT := $(SCP_BUILT_DIR)/medhw-gc0-pm.bin
$(PROCESSOR)_MEDHW_GC1_PM.BIN_BUILT := $(SCP_BUILT_DIR)/medhw-gc1-pm.bin
$(PROCESSOR)_MEDHW_GC2_PM.BIN_BUILT := $(SCP_BUILT_DIR)/medhw-gc2-pm.bin
$(PROCESSOR)_MEDHW_GC0_DM.BIN_BUILT := $(SCP_BUILT_DIR)/medhw-gc0-dm.bin
$(PROCESSOR)_MEDHW_GC1_DM.BIN_BUILT := $(SCP_BUILT_DIR)/medhw-gc1-dm.bin
$(PROCESSOR)_MEDHW_GC2_DM.BIN_BUILT := $(SCP_BUILT_DIR)/medhw-gc2-dm.bin
$(PROCESSOR)_MEDHW.BIN_BUILT := $(SCP_BUILT_DIR)/medhw.bin

# Set to no on DVT and SLT load
CFG_HEAP_ON_L1TCM                 = yes

ifeq (yes,$(CFG_HEAP_ON_L1TCM))
$(PROCESSOR)_L1TCM.BIN_BUILT := \
  $(SCP_BUILT_DIR)/$(TINYSYS_MEDMCU)-$(PROCESSOR)_L1TCM.bin
else
$(PROCESSOR)_DRAM.BIN_BUILT := \
  $(SCP_BUILT_DIR)/$(TINYSYS_MEDMCU)-$(PROCESSOR)_DRAM.bin
endif
$(PROCESSOR).LINK_LD := $(SCP_BUILT_DIR)/link.ld


SCP_BIN_STEM              := $(basename $($(PROCESSOR).BIN_BUILT))
$(PROCESSOR).BIN_NH       := $(SCP_BIN_STEM)-no-mtk-header.bin
$(PROCESSOR).BIN_MEDHW_NH := $(DRIVERS_PLATFORM_DIR)/med/medhw/bin
MEDHW_GC0_PM              := assembly_code_medhw_gc0.bin
MEDHW_GC1_PM              := assembly_code_medhw_gc1.bin
MEDHW_GC2_PM              := assembly_code_medhw_gc2.bin
MEDHW_GC0_DM              := dm_data_medhw_gc0.bin
MEDHW_GC1_DM              := dm_data_medhw_gc1.bin
MEDHW_GC2_DM              := dm_data_medhw_gc2.bin
ifeq (yes,$(CFG_HEAP_ON_L1TCM))
$(PROCESSOR).BIN_L1TCM_NH  := $(SCP_BIN_STEM)_L1TCM-no-mtk-header.bin
else
$(PROCESSOR).BIN_DRAM_NH  := $(SCP_BIN_STEM)_DRAM-no-mtk-header.bin
endif
$(PROCESSOR).ELF_FILE     := $(SCP_BIN_STEM).elf
$(PROCESSOR).MAP_FILE     := $(SCP_BIN_STEM).map
$(PROCESSOR).ASM_FILE     := $(SCP_BIN_STEM).asm
$(PROCESSOR).ASM2_FILE    := $(SCP_BIN_STEM).asm2
$(PROCESSOR).RELF_FILE    := $(SCP_BIN_STEM).relf
$(PROCESSOR).IMG_HDR_CFG  := $(SCP_BUILT_DIR)/img_hdr_$(notdir $(SCP_BIN_STEM)).cfg
$(PROCESSOR)_MEDHW_GC0_PM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_medhw-gc0-pm.cfg
$(PROCESSOR)_MEDHW_GC1_PM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_medhw-gc1-pm.cfg
$(PROCESSOR)_MEDHW_GC2_PM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_medhw-gc2-pm.cfg
$(PROCESSOR)_MEDHW_GC0_DM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_medhw-gc0-dm.cfg
$(PROCESSOR)_MEDHW_GC1_DM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_medhw-gc1-dm.cfg
$(PROCESSOR)_MEDHW_GC2_DM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_medhw-gc2-dm.cfg
ifeq (yes,$(CFG_HEAP_ON_L1TCM))
$(PROCESSOR)_L1TCM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_$(notdir $(SCP_BIN_STEM))_l1tcm.cfg
else
$(PROCESSOR)_DRAM.IMG_HDR_CFG := $(SCP_BUILT_DIR)/img_hdr_$(notdir $(SCP_BIN_STEM))_dram.cfg
endif

# ESL-specific outputs
$(PROCESSOR).ESL_AP_LINK_LD   := $(SCP_BUILT_DIR)/link.ap.ld
$(PROCESSOR).ESL_MCU0_LINK_LD := $(SCP_BUILT_DIR)/link.mcu0.ld
$(PROCESSOR).ESL_MCU1_LINK_LD := $(SCP_BUILT_DIR)/link.mcu1.ld
$(PROCESSOR).ESL_AP_ELF       := $(SCP_BIN_STEM).ap.elf
$(PROCESSOR).ESL_MCU0_ELF     := $(SCP_BIN_STEM).mcu0.elf
$(PROCESSOR).ESL_MCU1_ELF     := $(SCP_BIN_STEM).mcu1.elf
$(PROCESSOR).ESL_AP_MAP       := $(SCP_BIN_STEM).ap.map
$(PROCESSOR).ESL_MCU0_MAP     := $(SCP_BIN_STEM).mcu0.map
$(PROCESSOR).ESL_MCU1_MAP     := $(SCP_BIN_STEM).mcu1.map
$(PROCESSOR).ESL_AP_ASM       := $(SCP_BIN_STEM).ap.asm
$(PROCESSOR).ESL_MCU0_ASM     := $(SCP_BIN_STEM).mcu0.asm
$(PROCESSOR).ESL_MCU1_ASM     := $(SCP_BIN_STEM).mcu1.asm
$(PROCESSOR).ESL_AP_BIN       := $(SCP_BIN_STEM).ap.bin
$(PROCESSOR).ESL_MCU0_BIN     := $(SCP_BIN_STEM).mcu0.bin
$(PROCESSOR).ESL_MCU1_BIN     := $(SCP_BIN_STEM).mcu1.bin

PLATFORM_MK := $(PLATFORM_DIR)/platform.mk
ifeq ($(wildcard $(PLATFORM_MK)),)
  $(error $(TINYSYS_MEDMCU): $(PLATFORM_MK) is missing)
endif

# Reset any previously defined SCP options before including my own definitions
$(foreach v,$(SCP_PREVIOUS_CFG_OPTS), \
  $(eval $(v) := ) \
)
scp_old_cfgs := $(.VARIABLES)

include $(PLATFORM_MK)

scp_new_cfgs := $(.VARIABLES)
SCP_PREVIOUS_CFG_OPTS := \
  $(filter CFG_%,$(filter-out $(scp_old_cfgs),$(scp_new_cfgs)))

ifneq (yesyes,$(CFG_ESL_BUILD)$(CFG_ESL_DUAL_CORE))
  ALL_SCP_BINS := $(ALL_SCP_BINS) $($(PROCESSOR).BIN_BUILT)
else
  ALL_SCP_ESL_BINS := $(ALL_SCP_ESL_BINS) \
    $($(PROCESSOR).ESL_AP_BIN) \
    $($(PROCESSOR).ESL_MCU0_BIN) \
    $($(PROCESSOR).ESL_MCU1_BIN)
endif

INCLUDES += $(GENERATED_INCLUDE_DIR)
INCLUDES += $(LLVM_DKWINC)
CFLAGS   += -include $($(PROCESSOR).TINYSYS_CONFIG_H)

# Include project-specific files only when available
ifneq ($(wildcard $(PROJECT_DIR)/inc),)
  INCLUDES += $(PROJECT_DIR)/inc
endif

ifneq ($(wildcard $(PROJECT_DIR)/src/project.c),)
  C_FILES += $(wildcard $(PROJECT_DIR)/src/project.c)
endif

C_FILES   := $(patsubst ./%,%,$(C_FILES))
S_FILES   := $(patsubst ./%,%,$(S_FILES))
C_OBJS    := $(sort $(C_FILES:%.c=$(SCP_BUILT_DIR)/%.o))
S_OBJS    := $(sort $(S_FILES:%.S=$(SCP_BUILT_DIR)/%.o))

OBJS += $(sort $(C_OBJS) $(S_OBJS))
$(OBJS): $($(PROCESSOR).TINYSYS_CONFIG_H)

# Set dependency
DEPS += $(sort $(filter-out %.d,$(MAKEFILE_LIST)))

# Stash the list of configuration names and values to generate config header
CONFIG_MK_FILES := \
  $(PLATFORM_MK) \
  $(wildcard $(PROJECT_DIR)/project.mk)
$(call stash_config_options,$(CONFIG_MK_FILES))

INCLUDES := $(call normalize-includes,$(INCLUDES))

###########################################################
## Generic build targets
###########################################################
$(C_OBJS): PRIVATE_BUILD_TAG := $(TINYSYS_MEDMCU)
$(C_OBJS): PRIVATE_CC := $(CC)
$(C_OBJS): PRIVATE_CFLAGS := $(CFLAGS)
$(C_OBJS): PRIVATE_INCLUDES := $(INCLUDES)
$(C_OBJS): $(SCP_BUILT_DIR)/%.o: %.c
	$(compile-c-or-s-to-o)

$(S_OBJS): PRIVATE_BUILD_TAG := $(TINYSYS_MEDMCU)
$(S_OBJS): PRIVATE_CC := $(CC)
$(S_OBJS): PRIVATE_CFLAGS := $(CFLAGS)
$(S_OBJS): PRIVATE_INCLUDES := $(INCLUDES)
$(S_OBJS): $(SCP_BUILT_DIR)/%.o: %.S
	$(compile-c-or-s-to-o)

# Generate header file that contains all config options and its values
.PHONY: configheader
configheader: $($(PROCESSOR).TINYSYS_CONFIG_H)

.PHONY: $($(PROCESSOR).TINYSYS_CONFIG_H)
$($(PROCESSOR).TINYSYS_CONFIG_H): PRIVATE_PROCESSOR := $(PROCESSOR)
$($(PROCESSOR).TINYSYS_CONFIG_H):
	$(call gen-tinysys-header,__TINYSYS_CONFIG_H, \
		$($(PRIVATE_PROCESSOR).CONFIG_OPTIONS), $(TINYSYS_MEDMCU),)

$(OBJS): $(DEPS)
-include $(OBJS:.o=.d)

###########################################################
## Processor-based SCP build targets
###########################################################
$($(PROCESSOR).BIN_BUILT): PRIVATE_PROCESSOR:= $(PROCESSOR)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_NH := $($(PROCESSOR).BIN_NH)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BUILT_DIR := $(SCP_BUILT_DIR)
$($(PROCESSOR).BIN_BUILT): PRIVATE_IMG_HDR_CFG := $($(PROCESSOR).IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_GC0_PM_BUILT := $($(PROCESSOR)_MEDHW_GC0_PM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_GC1_PM_BUILT := $($(PROCESSOR)_MEDHW_GC1_PM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_GC2_PM_BUILT := $($(PROCESSOR)_MEDHW_GC2_PM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_GC0_DM_BUILT := $($(PROCESSOR)_MEDHW_GC0_DM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_GC1_DM_BUILT := $($(PROCESSOR)_MEDHW_GC1_DM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_GC2_DM_BUILT := $($(PROCESSOR)_MEDHW_GC2_DM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_MEDHW_NH := $($(PROCESSOR).BIN_MEDHW_NH)
$($(PROCESSOR).BIN_BUILT): PRIVATE_MEDHW_GC0_PM_IMG_HDR_CFG := $($(PROCESSOR)_MEDHW_GC0_PM.IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_MEDHW_GC1_PM_IMG_HDR_CFG := $($(PROCESSOR)_MEDHW_GC1_PM.IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_MEDHW_GC2_PM_IMG_HDR_CFG := $($(PROCESSOR)_MEDHW_GC2_PM.IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_MEDHW_GC0_DM_IMG_HDR_CFG := $($(PROCESSOR)_MEDHW_GC0_DM.IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_MEDHW_GC1_DM_IMG_HDR_CFG := $($(PROCESSOR)_MEDHW_GC1_DM.IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_MEDHW_GC2_DM_IMG_HDR_CFG := $($(PROCESSOR)_MEDHW_GC2_DM.IMG_HDR_CFG)
$($(PROCESSOR).BIN_BUILT): PRIVATE_ELF_FILE := $($(PROCESSOR).ELF_FILE)
$($(PROCESSOR).BIN_BUILT): PRIVATE_PLATFORM_DIR := $(PLATFORM_DIR)
$($(PROCESSOR).BIN_BUILT): PRIVATE_PROJECT_DIR := $(PROJECT_DIR)
ifeq (yes,$(CFG_HEAP_ON_L1TCM))
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_L1TCM_BUILT := $($(PROCESSOR)_L1TCM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_L1TCM_NH := $($(PROCESSOR).BIN_L1TCM_NH)
$($(PROCESSOR).BIN_BUILT): PRIVATE_L1TCM_IMG_HDR_CFG := $($(PROCESSOR)_L1TCM.IMG_HDR_CFG)
else
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_DRAM_BUILT := $($(PROCESSOR)_DRAM.BIN_BUILT)
$($(PROCESSOR).BIN_BUILT): PRIVATE_BIN_DRAM_NH := $($(PROCESSOR).BIN_DRAM_NH)
$($(PROCESSOR).BIN_BUILT): PRIVATE_DRAM_IMG_HDR_CFG := $($(PROCESSOR)_DRAM.IMG_HDR_CFG)
endif
$($(PROCESSOR).BIN_BUILT): PRIVATE_OBJCOPY := $(OBJCOPY)

ifeq (yes,$(CFG_HEAP_ON_L1TCM))
$($(PROCESSOR).BIN_BUILT): $($(PROCESSOR).ELF_FILE) \
  $($(PROCESSOR).IMG_HDR_CFG) $($(PROCESSOR)_DRAM.IMG_HDR_CFG) $(DEPS) \
  $($(PROCESSOR)_MEDHW_GC0_PM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC1_PM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC2_PM.IMG_HDR_CFG) \
  $($(PROCESSOR)_MEDHW_GC0_DM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC1_DM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC2_DM.IMG_HDR_CFG) $(DEPS) \
  | $(OBJSIZE) $(MKIMAGE)
else
$($(PROCESSOR).BIN_BUILT): $($(PROCESSOR).ELF_FILE) \
  $($(PROCESSOR).IMG_HDR_CFG) $($(PROCESSOR)_L1TCM.IMG_HDR_CFG) $(DEPS) \
  $($(PROCESSOR)_MEDHW_GC0_PM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC1_PM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC2_PM.IMG_HDR_CFG) \
  $($(PROCESSOR)_MEDHW_GC0_DM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC1_DM.IMG_HDR_CFG) $($(PROCESSOR)_MEDHW_GC2_DM.IMG_HDR_CFG) $(DEPS) \
  | $(OBJSIZE) $(MKIMAGE)
endif
	@echo '$(TINYSYS_MEDMCU): BIN   $@'
ifeq (yes,$(CFG_HEAP_ON_L1TCM))
	$(hide)$(PRIVATE_OBJCOPY) -O binary --remove-section .l1tcm_region $(PRIVATE_ELF_FILE) $(PRIVATE_BIN_NH)
	#$(hide)$(PRIVATE_OBJCOPY) -O binary $(PRIVATE_ELF_FILE) $(PRIVATE_BIN_NH)
	-rm -f $(PRIVATE_BIN_L1TCM_NH)
	-rm -f $(PRIVATE_BIN_L1TCM_BUILT)
	-$(hide)$(PRIVATE_OBJCOPY) -O binary --only-keep=.l1tcm_region $(PRIVATE_ELF_FILE) $(PRIVATE_BIN_L1TCM_NH)

	@if [ -s '$(PRIVATE_BIN_L1TCM_NH)' ]; then \
		echo "$(TINYSYS_MEDMCU): enable cache support for $(PRIVATE_PROCESSOR)"; \
		$(MKIMAGE) $(PRIVATE_BIN_L1TCM_NH) $(PRIVATE_L1TCM_IMG_HDR_CFG) > $(PRIVATE_BIN_L1TCM_BUILT); \
	fi;
else
	$(hide)$(PRIVATE_OBJCOPY) -O binary --remove-section .dram_region $(PRIVATE_ELF_FILE) $(PRIVATE_BIN_NH)
	#$(hide)$(PRIVATE_OBJCOPY) -O binary $(PRIVATE_ELF_FILE) $(PRIVATE_BIN_NH)
	-rm -f $(PRIVATE_BIN_DRAM_NH)
	-rm -f $(PRIVATE_BIN_DRAM_BUILT)
	-$(hide)$(PRIVATE_OBJCOPY) -O binary --only-keep=.dram_region $(PRIVATE_ELF_FILE) $(PRIVATE_BIN_DRAM_NH)

	@if [ -s '$(PRIVATE_BIN_DRAM_NH)' ]; then \
		echo "$(TINYSYS_MEDMCU): enable cache support for $(PRIVATE_PROCESSOR)"; \
		$(MKIMAGE) $(PRIVATE_BIN_DRAM_NH) $(PRIVATE_DRAM_IMG_HDR_CFG) > $(PRIVATE_BIN_DRAM_BUILT); \
	fi;
endif
	@if [ -s '$(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC0_PM)' ]; then \
		echo "$(TINYSYS_MEDMCU): $(MEDHW_GC0_PM) binary found"; \
		$(MKIMAGE) $(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC0_PM) $(PRIVATE_MEDHW_GC0_PM_IMG_HDR_CFG) > $(PRIVATE_BIN_MEDHW_GC0_PM_BUILT); \
		$(MKIMAGE) $(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC0_DM) $(PRIVATE_MEDHW_GC0_DM_IMG_HDR_CFG) > $(PRIVATE_BIN_MEDHW_GC0_DM_BUILT); \
		cat $(PRIVATE_BIN_MEDHW_GC0_PM_BUILT) $(PRIVATE_BIN_MEDHW_GC0_DM_BUILT) > $($(PROCESSOR)_MEDHW.BIN_BUILT); \
	fi;
	@if [ -s '$(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC1_PM)' ]; then \
		echo "$(TINYSYS_MEDMCU): $(MEDHW_GC1_PM) binary found"; \
		$(MKIMAGE) $(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC1_PM) $(PRIVATE_MEDHW_GC1_PM_IMG_HDR_CFG) > $(PRIVATE_BIN_MEDHW_GC1_PM_BUILT); \
		$(MKIMAGE) $(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC1_DM) $(PRIVATE_MEDHW_GC1_DM_IMG_HDR_CFG) > $(PRIVATE_BIN_MEDHW_GC1_DM_BUILT); \
		cat $(PRIVATE_BIN_MEDHW_GC1_PM_BUILT) $(PRIVATE_BIN_MEDHW_GC1_DM_BUILT) >> $($(PROCESSOR)_MEDHW.BIN_BUILT); \
	fi;
	@if [ -s '$(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC2_PM)' ]; then \
		echo "$(TINYSYS_MEDMCU): $(MEDHW_GC2_PM) binary found"; \
		$(MKIMAGE) $(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC2_PM) $(PRIVATE_MEDHW_GC2_PM_IMG_HDR_CFG) > $(PRIVATE_BIN_MEDHW_GC2_PM_BUILT); \
		$(MKIMAGE) $(PRIVATE_BIN_MEDHW_NH)/$(MEDHW_GC2_DM) $(PRIVATE_MEDHW_GC2_DM_IMG_HDR_CFG) > $(PRIVATE_BIN_MEDHW_GC2_DM_BUILT); \
		cat $(PRIVATE_BIN_MEDHW_GC2_PM_BUILT) $(PRIVATE_BIN_MEDHW_GC2_DM_BUILT) >> $($(PROCESSOR)_MEDHW.BIN_BUILT); \
	fi;
	$(hide)$(MKIMAGE) $(PRIVATE_BIN_NH) $(PRIVATE_IMG_HDR_CFG) > $@


ifeq (yes,$(CFG_HEAP_ON_L1TCM))
.PHONY: $($(PROCESSOR)_L1TCM.BIN_BUILT)
else
.PHONY: $($(PROCESSOR)_DRAM.BIN_BUILT)
endif

ifeq (1,$(V))
	$(hide)$(SIZE) $(PRIVATE_ELF_FILE)
	$(hide)$(OBJSIZE) $(PRIVATE_BUILT_DIR)/$(SCP_RTOS_SRC_DIR)
	$(hide)$(OBJSIZE) $(PRIVATE_BUILT_DIR)/$(PRIVATE_PLATFORM_DIR)
	$(hide)$(OBJSIZE) $(PRIVATE_BUILT_DIR)/$(PRIVATE_PROJECT_DIR)
endif

MY_LIBFLAGS_SEARCH_PATH := $(patsubst -L%,%,$(filter -L%,$(LIBFLAGS)))
MY_LIBFLAGS_SEARCH_NAME := $(patsubst -l%,lib%.a,$(filter -l%,$(LIBFLAGS)))
MY_LIBFLAGS_SEARCH_FILE := $(wildcard $(foreach p,$(MY_LIBFLAGS_SEARCH_PATH),$(foreach n,$(MY_LIBFLAGS_SEARCH_NAME),$(p)/$(n))))
$($(PROCESSOR).ELF_FILE): PRIVATE_CC := $(CC)
$($(PROCESSOR).ELF_FILE): PRIVATE_LLD := $(LLD)
$($(PROCESSOR).ELF_FILE): PRIVATE_PLATFORM := $(PLATFORM)
$($(PROCESSOR).ELF_FILE): PRIVATE_MAP_FILE := $($(PROCESSOR).MAP_FILE)
$($(PROCESSOR).ELF_FILE): PRIVATE_ASM_FILE := $($(PROCESSOR).ASM_FILE)
$($(PROCESSOR).ELF_FILE): PRIVATE_LDFLAGS := $(LDFLAGS)
$($(PROCESSOR).ELF_FILE): PRIVATE_LIBS := $(LIBFLAGS)
$($(PROCESSOR).ELF_FILE): PRIVATE_OBJDUMP := $(OBJDUMP)
$($(PROCESSOR).ELF_FILE): PRIVATE_RV33_VAR := $(RV33_VAR)
$($(PROCESSOR).ELF_FILE): PRIVATE_OBJS := $(OBJS)
$($(PROCESSOR).ELF_FILE): PRIVATE_LINK_LD := $($(PROCESSOR).LINK_LD)
$($(PROCESSOR).ELF_FILE): $(OBJS)
$($(PROCESSOR).ELF_FILE): $(MY_LIBFLAGS_SEARCH_FILE)
$($(PROCESSOR).ELF_FILE): $($(PROCESSOR).LINK_LD) $(DEPS)
	@echo '$(TINYSYS_MEDMCU): ELF     $@'
	@mkdir -p $(dir $@)
	$(hide)$(PRIVATE_LLD) -Map=$(PRIVATE_MAP_FILE) -o $@ -T $(PRIVATE_LINK_LD) $(PRIVATE_LDFLAGS) $(PRIVATE_OBJS) $(PRIVATE_LIBS)
	$(hide)$(PRIVATE_OBJDUMP) -mcpu=$(PRIVATE_RV33_VAR) -S $@ > $(PRIVATE_ASM_FILE)
	#$(hide)$(GOBJDUMP) -S $@ >  $($(PROCESSOR).ASM2_FILE)
	#$(hide)$(READELF) -a $@ > $($(PROCESSOR).RELF_FILE)
	@echo '$(TINYSYS_MEDMCU): Memory Check'
	$(hide)PLATFORM=$(PRIVATE_PLATFORM) $(MCHECK) -d SCP $(SCP_SETTING_INI) $(PRIVATE_MAP_FILE)

$($(PROCESSOR).LINK_LD): PRIVATE_CC := $(CC)
$($(PROCESSOR).LINK_LD): PRIVATE_CFLAGS := $(CFLAGS)
$($(PROCESSOR).LINK_LD): PRIVATE_INCLUDES := $(INCLUDES)
$($(PROCESSOR).LINK_LD): $(PLATFORM_DIR)/link.ld.c configheader
	@echo '$(TINYSYS_MEDMCU): CC      $@'
	@mkdir -p $(dir $@)
	$(hide)$(PRIVATE_CC) -Xpreprocessor $(PRIVATE_CFLAGS) $(PRIVATE_INCLUDES) -E -P $< -o $@_tmp
	$(hide)$(GEN_LINK_LD) -i $@_tmp -o $@

$($(PROCESSOR).IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

ifeq (yes,$(CFG_HEAP_ON_L1TCM))
$($(PROCESSOR)_L1TCM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))
else
$($(PROCESSOR)_DRAM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))
endif

$($(PROCESSOR)_MEDHW_GC0_PM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

$($(PROCESSOR)_MEDHW_GC1_PM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

$($(PROCESSOR)_MEDHW_GC2_PM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

$($(PROCESSOR)_MEDHW_GC0_DM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

$($(PROCESSOR)_MEDHW_GC1_DM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

$($(PROCESSOR)_MEDHW_GC2_DM.IMG_HDR_CFG): $(DEPS)
	$(call gen-image-header,$(TINYSYS_MEDMCU))

###########################################################
## ESL object definition
###########################################################
ESL_AP_C_FILES  := $(patsubst ./%,%,$(ESL_AP_C_FILES))
ESL_AP_S_FILES  := $(patsubst ./%,%,$(ESL_AP_S_FILES))
ESL_MCU_C_FILES := $(patsubst ./%,%,$(ESL_MCU_C_FILES))
ESL_MCU_S_FILES := $(patsubst ./%,%,$(ESL_MCU_S_FILES))
ESL_AP_C_OBJS  := $(sort $(ESL_AP_C_FILES:%.c=$(SCP_BUILT_DIR)/%.o))
ESL_MCU_C_OBJS := $(sort $(ESL_MCU_C_FILES:%.c=$(SCP_BUILT_DIR)/%.o))
ESL_AP_S_OBJS  := $(sort $(ESL_AP_S_FILES:%.S=$(SCP_BUILT_DIR)/%.o))
ESL_MCU_S_OBJS := $(sort $(ESL_MCU_S_FILES:%.S=$(SCP_BUILT_DIR)/%.o))

ESL_AP_OBJS  := $(sort $(ESL_AP_C_OBJS) $(ESL_AP_S_OBJS))
ESL_MCU_OBJS := $(sort $(ESL_MCU_C_OBJS) $(ESL_MCU_S_OBJS))
ESL_C_OBJS := $(sort $(ESL_AP_C_OBJS) $(ESL_MCU_C_OBJS))
ESL_S_OBJS := $(sort $(ESL_AP_S_OBJS) $(ESL_MCU_S_OBJS))
$(ESL_C_OBJS) $(ESL_S_OBJS): $($(PROCESSOR).TINYSYS_CONFIG_H)

###########################################################
## ESL build targets
###########################################################
$(ESL_C_OBJS) $(ESL_S_OBJS): $(DEPS)

$(ESL_C_OBJS): PRIVATE_BUILD_TAG := $(TINYSYS_MEDMCU)
$(ESL_C_OBJS): PRIVATE_CC := $(CC)
$(ESL_C_OBJS): PRIVATE_CFLAGS := $(CFLAGS)
$(ESL_C_OBJS): PRIVATE_INCLUDES := $(INCLUDES)
$(ESL_C_OBJS): $(SCP_BUILT_DIR)/%.o: %.c
	$(compile-c-or-s-to-o)

$(ESL_S_OBJS): PRIVATE_BUILD_TAG := $(TINYSYS_MEDMCU)
$(ESL_S_OBJS): PRIVATE_CC := $(CC)
$(ESL_S_OBJS): PRIVATE_CFLAGS := $(CFLAGS)
$(ESL_S_OBJS): PRIVATE_INCLUDES := $(INCLUDES)
$(ESL_S_OBJS): $(SCP_BUILT_DIR)/%.o: %.S
	$(compile-c-or-s-to-o)

# ESL LDs
$($(PROCESSOR).ESL_AP_LINK_LD): PRIVATE_CC := $(CC)
$($(PROCESSOR).ESL_AP_LINK_LD): PRIVATE_CFLAGS := $(CFLAGS) -Xpreprocessor -DPLAT_DUAL -DPLAT_DUAL_AP -E -P
$($(PROCESSOR).ESL_AP_LINK_LD): PRIVATE_INCLUDES := $(INCLUDES)
$($(PROCESSOR).ESL_AP_LINK_LD): $(PLATFORM_DIR)/link.ld.c configheader
	@echo '$(TINYSYS_MEDMCU): CC      $@'
	@mkdir -p $(dir $@)
	$(hide)$(PRIVATE_CC) $(PRIVATE_CFLAGS) $(PRIVATE_INCLUDES) -E -P $< -o $@

$($(PROCESSOR).ESL_MCU0_LINK_LD): PRIVATE_CC := $(CC)
$($(PROCESSOR).ESL_MCU0_LINK_LD): PRIVATE_CFLAGS := $(CFLAGS) -Xpreprocessor -DPLAT_DUAL -DPLAT_DUAL_MCU0 -E -P
$($(PROCESSOR).ESL_MCU0_LINK_LD): PRIVATE_INCLUDES := $(INCLUDES)
$($(PROCESSOR).ESL_MCU0_LINK_LD): $(PLATFORM_DIR)/link.ld.c configheader
	@echo '$(TINYSYS_MEDMCU): CC      $@'
	@mkdir -p $(dir $@)
	$(hide)$(PRIVATE_CC) $(PRIVATE_CFLAGS) $(PRIVATE_INCLUDES) -E -P $< -o $@

$($(PROCESSOR).ESL_MCU1_LINK_LD): PRIVATE_CC := $(CC)
$($(PROCESSOR).ESL_MCU1_LINK_LD): PRIVATE_CFLAGS := $(CFLAGS) -Xpreprocessor -DPLAT_DUAL -DPLAT_DUAL_MCU1 -E -P
$($(PROCESSOR).ESL_MCU1_LINK_LD): PRIVATE_INCLUDES := $(INCLUDES)
$($(PROCESSOR).ESL_MCU1_LINK_LD): $(PLATFORM_DIR)/link.ld.c configheader
	@echo '$(TINYSYS_MEDMCU): CC      $@'
	@mkdir -p $(dir $@)
	$(hide)$(PRIVATE_CC) $(PRIVATE_CFLAGS) $(PRIVATE_INCLUDES) -E -P $< -o $@

# ESL ELFs
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_LLD := $(LLD)
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_LINK_LD := $($(PROCESSOR).ESL_AP_LINK_LD)
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_MAP_FILE := $($(PROCESSOR).ESL_AP_MAP)
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_LDFLAGS := $(LDFLAGS)
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_LIBS := $(LIBFLAGS)
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_OBJS := $(OBJS)
$($(PROCESSOR).ESL_AP_ELF): PRIVATE_AP_OBJS := $(ESL_AP_OBJS)
$($(PROCESSOR).ESL_AP_ELF): $($(PROCESSOR).ESL_AP_LINK_LD) $(OBJS) $(ESL_AP_OBJS)
	$(hide)$(PRIVATE_LLD) -Map=$(PRIVATE_MAP_FILE) -o $@ -T $(PRIVATE_LINK_LD) $(PRIVATE_LDFLAGS) $(PRIVATE_OBJS) $(PRIVATE_AP_OBJS) $(PRIVATE_LIBS)

$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_LLD := $(LLD)
$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_LINK_LD := $($(PROCESSOR).ESL_MCU0_LINK_LD)
$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_MAP_FILE := $($(PROCESSOR).ESL_MCU0_MAP)
$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_LDFLAGS := $(LDFLAGS)
$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_LIBS := $(LIBFLAGS)
$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_OBJS := $(OBJS)
$($(PROCESSOR).ESL_MCU0_ELF): PRIVATE_MCU_OBJS := $(ESL_MCU_OBJS)
$($(PROCESSOR).ESL_MCU0_ELF): $($(PROCESSOR).ESL_MCU0_LINK_LD) $(OBJS) $(ESL_MCU_OBJS)
	$(hide)$(PRIVATE_LLD) -Map=$(PRIVATE_MAP_FILE) -o $@ -T $(PRIVATE_LINK_LD) $(PRIVATE_LDFLAGS) $(PRIVATE_OBJS) $(PRIVATE_MCU_OBJS) $(PRIVATE_LIBS)

$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_LLD := $(LLD)
$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_LINK_LD := $($(PROCESSOR).ESL_MCU1_LINK_LD)
$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_MAP_FILE := $($(PROCESSOR).ESL_MCU1_MAP)
$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_LDFLAGS := $(LDFLAGS)
$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_LIBS := $(LIBFLAGS)
$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_OBJS := $(OBJS)
$($(PROCESSOR).ESL_MCU1_ELF): PRIVATE_MCU_OBJS := $(ESL_MCU_OBJS)
$($(PROCESSOR).ESL_MCU1_ELF): $($(PROCESSOR).ESL_MCU1_LINK_LD) $(OBJS) $(ESL_MCU_OBJS)
	$(hide)$(PRIVATE_LLD) -Map=$(PRIVATE_MAP_FILE) -o $@ -T $(PRIVATE_LINK_LD) $(PRIVATE_LDFLAGS) $(PRIVATE_OBJS) $(PRIVATE_MCU_OBJS) $(PRIVATE_LIBS)

# ESL BINs
$($(PROCESSOR).ESL_AP_BIN): PRIVATE_OBJDUMP := $(OBJDUMP)
$($(PROCESSOR).ESL_AP_BIN): PRIVATE_OBJCOPY := $(OBJCOPY)
$($(PROCESSOR).ESL_AP_BIN): PRIVATE_ELF_FILE := $($(PROCESSOR).ESL_AP_ELF)
$($(PROCESSOR).ESL_AP_BIN): PRIVATE_ASM_FILE := $($(PROCESSOR).ESL_AP_ASM)
$($(PROCESSOR).ESL_AP_BIN): PRIVATE_RV33_VAR := $(RV33_VAR)
$($(PROCESSOR).ESL_AP_BIN): $($(PROCESSOR).ESL_AP_ELF)
	@echo '$(TINYSYS_MEDMCU): ASM   $(PRIVATE_ASM_FILE)'
	$(hide)$(PRIVATE_OBJDUMP) -mcpu=$(PRIVATE_RV33_VAR) -S $< > $(PRIVATE_ASM_FILE)
	@echo '$(TINYSYS_MEDMCU): BIN   $@'
	$(hide)$(PRIVATE_OBJCOPY) -O binary $(PRIVATE_ELF_FILE) $@

$($(PROCESSOR).ESL_MCU0_BIN): PRIVATE_OBJDUMP := $(OBJDUMP)
$($(PROCESSOR).ESL_MCU0_BIN): PRIVATE_OBJCOPY := $(OBJCOPY)
$($(PROCESSOR).ESL_MCU0_BIN): PRIVATE_ELF_FILE := $($(PROCESSOR).ESL_MCU0_ELF)
$($(PROCESSOR).ESL_MCU0_BIN): PRIVATE_ASM_FILE := $($(PROCESSOR).ESL_MCU0_ASM)
$($(PROCESSOR).ESL_MCU0_BIN): PRIVATE_RV33_VAR := $(RV33_VAR)
$($(PROCESSOR).ESL_MCU0_BIN): $($(PROCESSOR).ESL_MCU0_ELF)
	$(hide)$(PRIVATE_OBJDUMP) -mcpu=$(PRIVATE_RV33_VAR) -S $< > $(PRIVATE_ASM_FILE)
	@echo '$(TINYSYS_MEDMCU): BIN   $@'
	$(hide)$(PRIVATE_OBJCOPY) -O binary $(PRIVATE_ELF_FILE) $@

$($(PROCESSOR).ESL_MCU1_BIN): PRIVATE_OBJDUMP := $(OBJDUMP)
$($(PROCESSOR).ESL_MCU1_BIN): PRIVATE_OBJCOPY := $(OBJCOPY)
$($(PROCESSOR).ESL_MCU1_BIN): PRIVATE_ELF_FILE := $($(PROCESSOR).ESL_MCU1_ELF)
$($(PROCESSOR).ESL_MCU1_BIN): PRIVATE_ASM_FILE := $($(PROCESSOR).ESL_MCU1_ASM)
$($(PROCESSOR).ESL_MCU1_BIN): PRIVATE_RV33_VAR := $(RV33_VAR)
$($(PROCESSOR).ESL_MCU1_BIN): $($(PROCESSOR).ESL_MCU1_ELF)
	$(hide)$(PRIVATE_OBJDUMP) -mcpu=$(PRIVATE_RV33_VAR) -S $< > $(PRIVATE_ASM_FILE)
	@echo '$(TINYSYS_MEDMCU): BIN   $@'
	$(hide)$(PRIVATE_OBJCOPY) -O binary $(PRIVATE_ELF_FILE) $@

-include $(OBJS:.o=.d)
-include $($(sort $(ESL_C_OBJS) $(ESL_S_OBJS)):.o=.d)
