###########################################################
## Sort required Tiny System intermediate binaries and
## print the result.
## For each processor, loader must precede tinysys binary.
###########################################################

# $(1): the list of unordered binary file paths
# $(2): prefix of processors to be filtered
define sort_scp_binaries
$(eval _arg := $(strip $(1))) \
$(if $(_arg),, \
  $(error $(TINYSYS_MEDMCU): sort_tinysys_binaries: argument missing)) \
$(eval SORTED_TINYSYS_DEPS :=) \
$(foreach p,$(filter $(2)_%,$(PROCESSORS)), \
  $(eval m := $(filter %/$(TINYSYS_MEDMCU)-$(p).bin,$(_arg))) \
  $(if $(m), \
    $(eval SORTED_TINYSYS_DEPS := $(SORTED_TINYSYS_DEPS) $(m)), \
    $(error $(TINYSYS_MEDMCU): Missing tinysys image for processor $(p)) \
  ) \
) \
$(strip $(SORTED_TINYSYS_DEPS)) \
$(eval m :=) \
$(eval _arg :=)
endef
