/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver\'s
 * applicable license agreements with MediaTek Inc.
 */

#include <tinysys_config.h>
#include <FreeRTOS.h>
#include <task.h>
#include <timers.h>
#include <queue.h>
#ifdef CFG_XGPT_SUPPORT
#include <interrupt.h>
#include <xgpt.h>
#endif
#include <FreeRTOSConfig.h>
#include <dmgr.h>
#include <dmgr_api.h>
#include <mt_printf.h>
#include <sleep.h>
#include <dvfs_common.h>

extern void *pxCurrentTCB;

enum dramMgrState eExceptState;
char *pcPrompt = "[DMGR]";

#ifdef CFG_DMGR_DEBUG
UBaseType_t uxLogBitmap = CFG_DMGR_DEBUG;
#endif				/* CFG_DMGR_DEBUG */

/*****************************************************************************
** CFG_DYNAMIC_DRAM_V2, Switch on/off DRAM in the context of a task.
*****************************************************************************/

#ifdef CFG_DYNAMIC_DRAM_V2

struct {
	unsigned long long ullDmgrMaxCost;
	unsigned long long ullDmgrSendQTimeStamp;
	unsigned long long ullDmgrLastDetectTimeStamp;
	unsigned long long ullDmgrLastPowerOnTimeStamp;
	unsigned long long ullDmgrDetectWfiSTimeStamp;
	unsigned long long ullDmgrDetectWfiETimeStamp;
	uint32_t ullDmgrDetectSlpCnt;
	uint32_t ullDmgrPowerOnSlpCnt;
	uint32_t ullDmgrDetectWFICnt;
	uint32_t ullDmgrPowerOnWFICnt;
	uint32_t ullDmgrTmrCnt;
} xDmgrCost = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

enum dramMgrState eDramMgrState;
static QueueHandle_t xDramMgrRxQueue;
static List_t xDramMgrSuspendList;
static List_t xDramMgrFreeList;
static ListItem_t dramMgrItemPool[MAX_DMGR_LIST_ITEM];

static void prvDmgrHwTimerStart(void)
{
	struct timer_device *pxDev = id_to_dev(DMGR_TIMER);
	unsigned int ulBaseAddr = pxDev->base_addr;

	DRV_WriteReg32(ulBaseAddr + TIMER_RST_VAL, DMGR_TIMER_RSTVAL);
	DRV_SetReg32(ulBaseAddr + TIMER_IRQ_CTRL_REG, TIMER_ENABLE);
	/* select clock source to clk_32k and enable timer */
	DRV_SetReg32(ulBaseAddr + TIMER_EN,
		     (TIMER_CLK_SRC_CLK_32K << TIMER_CLK_SRC_SHIFT) |
		     TIMER_IRQ_ENABLE);
}

static void prvDmgrHwTimerStop(void)
{
	struct timer_device *pxDev = id_to_dev(DMGR_TIMER);
	unsigned int ulBaseAddr = pxDev->base_addr;

	DRV_ClrReg32(ulBaseAddr + TIMER_EN, TIMER_ENABLE);
	DRV_ClrReg32(ulBaseAddr + TIMER_IRQ_CTRL_REG, TIMER_IRQ_ENABLE);
	/* act timer interrupt */
	DRV_SetReg32(ulBaseAddr + TIMER_IRQ_CTRL_REG, TIMER_IRQ_CLEAR);
	//DRV_WriteReg32(ulBaseAddr + TIMER_RST_VAL, 0);
}

static void prvDmgrEventSend(TaskHandle_t xHandle, enum dramMgrAction eAction)
{
	struct dramMgrQueueEvent xEvent;
	BaseType_t xHigherPriorityTaskWoken;
	BaseType_t xRet = pdPASS;

	xEvent.xHandle = (TaskHandle_t) xHandle;
	xEvent.eAction = eAction;
	/* send the current tcb to DramMgr to be suspended */
	xDmgrCost.ullDmgrSendQTimeStamp = read_xgpt_stamp_ns();
	xRet =
	    xQueueSendFromISR(xDramMgrRxQueue, &xEvent,
			      &xHigherPriorityTaskWoken);
	configASSERT(xRet == pdTRUE);
	/* context switching to dram manager */
	portYIELD_FROM_ISR(xHigherPriorityTaskWoken);
}

static unsigned int prvDmgrPollingAck(void *arg)
{
	uint32_t ulIsAck = vDmgrPortGetDramAckFromISR();

	UNUSED(arg);
	configASSERT(eDramMgrState == STAT_DRAM_WARM_UP);

	xDmgrCost.ullDmgrTmrCnt++;
	prvDmgrHwTimerStop();
	if (ulIsAck) {
		DMGR_PRINTF(LOG_ONOFF, "p:dram on");
		prvDmgrEventSend((TaskHandle_t) NULL, ACT_DRAM_POWER_ON);
	} else
		prvDmgrHwTimerStart();

	return 0;
}

static void prvSuspendTask(TaskHandle_t xHandle)
{
	ListItem_t *pxDramMgrItem = NULL;

	configASSERT(listLIST_IS_EMPTY(&xDramMgrFreeList) != pdTRUE);

	/* get a empty item from free list */
	pxDramMgrItem = listGET_HEAD_ENTRY(&xDramMgrFreeList);
	uxListRemove(pxDramMgrItem);

	/* initialize the item and then insert it into suspend list */
	vListInitialiseItem(pxDramMgrItem);
	listSET_LIST_ITEM_VALUE(pxDramMgrItem, (TickType_t) xHandle);
	vListInsertEnd(&xDramMgrSuspendList, pxDramMgrItem);

	/* as we have recorded the task in suspend list, it can be suspended */
	vTaskSuspend(xHandle);
	DMGR_PRINTF(LOG_TASKTRACE, "Suspend %s", pcTaskGetTaskName(xHandle));
}

static void prvResumeTask(TaskHandle_t xHandle)
{
	ListItem_t *pxDramMgrItem = NULL;

	configASSERT(listLIST_IS_EMPTY(&xDramMgrSuspendList) != pdTRUE);

	/* get an item from suspend list */
	pxDramMgrItem = listGET_HEAD_ENTRY(&xDramMgrSuspendList);
	xHandle = (TaskHandle_t) listGET_LIST_ITEM_VALUE(pxDramMgrItem);
	uxListRemove(pxDramMgrItem);

	vTaskResume(xHandle);
	DMGR_PRINTF(LOG_TASKTRACE, "Resume %s", pcTaskGetTaskName(xHandle));

	/* insert the empty item into free list */
	vListInitialiseItem(pxDramMgrItem);
	vListInsertEnd(&xDramMgrFreeList, pxDramMgrItem);
}

static void prvTaskDramManager(void *pvParameters)
{
	struct dramMgrQueueEvent xEvent;
	enum dramMgrAction eAction;
	TaskHandle_t xHandle;
	BaseType_t xRet;
	unsigned long long ullDiff;

	UNUSED(pvParameters);

	while (1) {
		xRet = xQueueReceive(xDramMgrRxQueue, &xEvent, portMAX_DELAY);
		if (xRet != pdPASS) {
			PRINTF_E("[DMGR] xQueueReceive failed, %ld\n\r", xRet);
			continue;
		}

		xHandle = xEvent.xHandle;
		eAction = xEvent.eAction;

		/*
		 * Normal FSM for DRAM Manager
		 */
		DMGR_PRINTF(LOG_STATE, "State=%d, Action=%d", eDramMgrState,
			    eAction);

		switch (eDramMgrState) {
		case STAT_DRAM_PW_OFF:
			switch (eAction) {
			case ACT_DRAM_DETECT_ACCESS:
				vDmgrPortEnDRAMUnblock();
				xDmgrCost.ullDmgrDetectWfiSTimeStamp = get_last_wfi_s_time();
				xDmgrCost.ullDmgrDetectWfiETimeStamp = get_last_wfi_e_time();

				/* Record starting time for cost computation */
				xDmgrCost.ullDmgrLastDetectTimeStamp = read_xgpt_stamp_ns();
				xDmgrCost.ullDmgrDetectSlpCnt = get_sleep_cnt();
				xDmgrCost.ullDmgrDetectWFICnt = get_wfi_cnt();
				xDmgrCost.ullDmgrTmrCnt = 0;

				prvSuspendTask(xHandle);
				eDramMgrState = STAT_DRAM_WARM_UP;
				prvDmgrHwTimerStart();
				break;
			default:
				configASSERT(0);
			}

			break;
		case STAT_DRAM_WARM_UP:
			switch (eAction) {
			case ACT_DRAM_DETECT_ACCESS:
				prvSuspendTask(xHandle);
				break;
			case ACT_DRAM_POWER_ON:
				/* Supposed there are no events following POWER_ON events,
				 * so task resuming is only done here.
				 */
				while (listLIST_IS_EMPTY(&xDramMgrSuspendList)
				       != pdTRUE) {
					prvResumeTask(xHandle);
				}
				eDramMgrState = STAT_DRAM_PW_ON;

				/* Calculate the cost and record the max one */
				xDmgrCost.ullDmgrLastPowerOnTimeStamp = read_xgpt_stamp_ns();
				xDmgrCost.ullDmgrPowerOnSlpCnt = get_sleep_cnt();
				xDmgrCost.ullDmgrPowerOnWFICnt = get_wfi_cnt();
				ullDiff = xDmgrCost.ullDmgrLastPowerOnTimeStamp -
							xDmgrCost.ullDmgrLastDetectTimeStamp;

				if (ullDiff > xDmgrCost.ullDmgrMaxCost) {
					xDmgrCost.ullDmgrMaxCost = ullDiff;
					DMGR_PRINTF(LOG_LATENCY, "update Max Cost = %llu",
						xDmgrCost.ullDmgrMaxCost);
#ifdef CFG_IRQ_MONITOR_SUPPORT
					if (ullDiff > DURATION_LIMIT_NS)
						configASSERT(0);
#endif
				}

				break;
			default:
				configASSERT(0);
			}

			break;
		case STAT_DRAM_PW_ON:
			configASSERT(0);

		default:
			;
		}
	}
}

#endif

/****************************************************************************/

/*****************************************************************************
** Hook functions are the functions that must be embedded in some places of
** the new platform and then deliver the events to the DRAM Manager.
*****************************************************************************/

BaseType_t xDmgrHookSwitchOnDramPower(void)
{
	BaseType_t xRet = pdPASS;

	switch (xDmgrPortAccessType()) {
	case TYPE_NORMAL:
#ifdef CFG_DYNAMIC_DRAM_V2
		/* the access is located in cacheable memory */
		DMGR_PRINTF(LOG_ONOFF, "p:notify dmgr");
		prvDmgrEventSend((TaskHandle_t) pxCurrentTCB,
				 ACT_DRAM_DETECT_ACCESS);
		break;
#endif
	case TYPE_EXCEPTION:
	case TYPE_CRITICAL:
#ifdef CFG_L1C_ISR_SUPPORT
		DMGR_PRINTF(LOG_ONOFF, "e:dram on");
		vDmgrPortEnDRAMFromISR();
		eExceptState = STAT_DRAM_PW_ON;
		break;
#else
		/* Don't allow access DRAM in Critical Section and Interrupt */
		//configASSERT(0); let it enter exception and coredump
#endif
	default:
		xRet = pdFALSE;
	}

	return xRet;
}

void vDmgrHookIdleApplication(void)
{
	taskENTER_CRITICAL();
	{
#ifdef CFG_DYNAMIC_DRAM_V2
		if (eDramMgrState == STAT_DRAM_PW_ON) {
			vDmgrPortDisDRAM();
			eDramMgrState = STAT_DRAM_PW_OFF;
			DMGR_PRINTF(LOG_ONOFF, "p:dram off");
		}
#endif

		if (eExceptState == STAT_DRAM_PW_ON) {
			vDmgrPortDisDRAM();
			eExceptState = STAT_DRAM_PW_OFF;
			DMGR_PRINTF(LOG_ONOFF, "e:dram off");
		}
	}
	taskEXIT_CRITICAL();
}

void vDmgrHookDVFSDramOn(void)
{
	vDmgrPortEnRegion();
}

void vDmgrHookDVFSDramOff(void)
{
	vDmgrPortDisRegion();
}

BaseType_t xDmgrHookInit(void)
{
	BaseType_t xRet = pdPASS;

#ifdef CFG_DYNAMIC_DRAM_V2
	uint32_t i;
	struct timer_device *pxDev;

	xDramMgrRxQueue =
	    xQueueCreate(MAX_DMGR_QUEUE_EVENT,
			 sizeof (struct dramMgrQueueEvent));
	vListInitialise(&xDramMgrSuspendList);
	vListInitialise(&xDramMgrFreeList);
	/* insert all list items into free list */

	for (i = 0; i < MAX_DMGR_LIST_ITEM; i++) {
		vListInitialiseItem(&dramMgrItemPool[i]);
		vListInsertEnd(&xDramMgrFreeList, &dramMgrItemPool[i]);
	}

	xRet =
	    xTaskCreate(prvTaskDramManager, "DMgr", configMINIMAL_STACK_SIZE,
			NULL, PRI_DMGR, NULL);

	/* timer for polling the dram ack state by every 1ms */
	pxDev = id_to_dev(DMGR_TIMER);
	intc_irq_request(&pxDev->irq, prvDmgrPollingAck, (void *) "DMGR_Timer");
	prvDmgrHwTimerStop();
	eDramMgrState = STAT_DRAM_PW_OFF;
#endif

	eExceptState = STAT_DRAM_PW_OFF;
	vDmgrPortDisRegion();

	return xRet;
}

/****************************************************************************/
