/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver\'s
 * applicable license agreements with MediaTek Inc.
 */

#include <FreeRTOS.h>
#include <task.h>
#include <tinysys_config.h>
#include <mt_printf.h>
#include <peripheral.h>
#ifdef CFG_XGPT_SUPPORT
#include <interrupt.h>
#include <xgpt.h>
#endif

#define TEST_PRINTF     PRINTF_E
#define INT_TIMER       TMR5
#define UNUSED(x)       (void)(x)

#define DRAM_REGION_RO __attribute__ ((section (".dram_region_ro")))
#define DRAM_REGION_RW __attribute__ ((section (".dram_region_rw")))
#define DRAM_REGION_BSS __attribute__ ((section (".dram_region_bss")))
#define DRAM_REGION_VARIABLE __attribute__ ((section (".dram_region_variable")))
#define DRAM_REGION_FUNCTION __attribute__ ((section (".dram_region_func")))

DRAM_REGION_VARIABLE int dram_addr_a[256];
DRAM_REGION_VARIABLE int dram_addr_b[128];
DRAM_REGION_VARIABLE int dram_addr_c[64];
volatile int sram_var;

static void task1_s_d(void *pvParameters)
{
	unsigned int *dram_addr = (unsigned int *) dram_addr_a;
	portTickType xLastExecutionTime, xDelayTime;
	unsigned int task1_param;

	UNUSED(pvParameters);
	xLastExecutionTime = xTaskGetTickCount();
	xDelayTime = ((portTickType) 223 / portTICK_RATE_MS);

	do {
		task1_param = 10000;
		TEST_PRINTF("...> task 1 works\n");

		while (task1_param) {
			*dram_addr = 0xaa5555aa;
			task1_param--;
		}
		vTaskDelayUntil(&xLastExecutionTime, xDelayTime);
	} while (1);
}

DRAM_REGION_FUNCTION static void task2_d_d(void *pvParameters)
{
	unsigned int *dram_addr = (unsigned int *) dram_addr_b;
	portTickType xLastExecutionTime, xDelayTime;
	unsigned int task2_param;

	UNUSED(pvParameters);
	xLastExecutionTime = xTaskGetTickCount();
	xDelayTime = ((portTickType) 101 / portTICK_RATE_MS);

	do {
		task2_param = 20000;
		TEST_PRINTF("...> task 2 works\n");

		while (task2_param) {
			*dram_addr = 0xaa5555aa;
			task2_param--;
		}
		vTaskDelayUntil(&xLastExecutionTime, xDelayTime);
	} while (1);
}

DRAM_REGION_FUNCTION static void task3_d_s(void *pvParameters)
{
	unsigned int sram;
	unsigned int *sram_addr = (unsigned int *) &sram;
	portTickType xLastExecutionTime, xDelayTime;
	unsigned int task3_param;

	UNUSED(pvParameters);
	xLastExecutionTime = xTaskGetTickCount();
	xDelayTime = ((portTickType) 53 / portTICK_RATE_MS);

	do {
		task3_param = 10000;
		TEST_PRINTF("...> task 3 works\n");

		while (task3_param) {
			*sram_addr = 0xaa5555aa;
			task3_param--;
		}

		vTaskDelayUntil(&xLastExecutionTime, xDelayTime);
	} while (1);
}

static void task4_s_d(void *pvParameters)
{
	unsigned int *dram_addr = (unsigned int *) dram_addr_c;
	portTickType xLastExecutionTime, xDelayTime;
	unsigned int task4_param;

	UNUSED(pvParameters);
	xLastExecutionTime = xTaskGetTickCount();
	xDelayTime = ((portTickType) 167 / portTICK_RATE_MS);

	*dram_addr = 0xaa5555aa;

	do {
		task4_param = 10000;
		TEST_PRINTF("...> task 4 works\n");

		while (task4_param) {
			sram_var = *dram_addr;
			task4_param--;
		}
		vTaskDelayUntil(&xLastExecutionTime, xDelayTime);
	} while (1);
}

DRAM_REGION_FUNCTION static void task5_d_d(void *pvParameters)
{
	unsigned int *dram_addr = (unsigned int *) dram_addr_a;
	portTickType xLastExecutionTime, xDelayTime;
	unsigned int task5_param;

	UNUSED(pvParameters);
	xLastExecutionTime = xTaskGetTickCount();
	xDelayTime = ((portTickType) 313 / portTICK_RATE_MS);

	do {
		task5_param = 20000;
		TEST_PRINTF("...> task 5 works\n");

		while (task5_param) {
			*dram_addr = 0xaa5555aa;
			task5_param--;
		}
		vTaskDelayUntil(&xLastExecutionTime, xDelayTime);
	} while (1);
}

DRAM_REGION_FUNCTION static void task6_d_s(void *pvParameters)
{
	unsigned int sram;
	unsigned int *sram_addr = (unsigned int *) &sram;
	portTickType xLastExecutionTime, xDelayTime;
	unsigned int task6_param;

	UNUSED(pvParameters);
	xLastExecutionTime = xTaskGetTickCount();
	xDelayTime = ((portTickType) 71 / portTICK_RATE_MS);

	do {
		task6_param = 10000;
		TEST_PRINTF("...> task 6 works\n");

		while (task6_param) {
			*sram_addr = 0xaa5555aa;
			task6_param--;
		}

		vTaskDelayUntil(&xLastExecutionTime, xDelayTime);
	} while (1);
}

static void prvTestTimerStart(void)
{
	struct timer_device *pxDev = id_to_dev(INT_TIMER);
	unsigned int ulBaseAddr = pxDev->base_addr;

	DRV_WriteReg32(ulBaseAddr + TIMER_RST_VAL, TIME_TO_TICK_MS(97));
	DRV_SetReg32(ulBaseAddr + TIMER_IRQ_CTRL_REG, TIMER_ENABLE);
	/* select clock source to clk_32k and enable timer */
	DRV_SetReg32(ulBaseAddr + TIMER_EN,
		     (TIMER_CLK_SRC_CLK_32K << TIMER_CLK_SRC_SHIFT) |
		     TIMER_IRQ_ENABLE);
}

DRAM_REGION_FUNCTION static unsigned int prvTestTimerIntTask(void *pvParameters)
{
	struct timer_device *pxDev = id_to_dev(INT_TIMER);
	unsigned int ulBaseAddr = pxDev->base_addr;

	UNUSED(pvParameters);
	DRV_SetReg32(ulBaseAddr + TIMER_IRQ_CTRL_REG, TIMER_IRQ_CLEAR);
	mbi();
	TEST_PRINTF("...> timer interrupt\n");

	return 0;
}

void dmgr_test(void)
{
	struct timer_device *pxDev;

	xTaskCreate(task1_s_d, "task1", configMINIMAL_STACK_SIZE, NULL,
		    PRI_TEST, NULL);
	xTaskCreate(task2_d_d, "task2", configMINIMAL_STACK_SIZE, NULL,
		    PRI_TEST, NULL);
	xTaskCreate(task3_d_s, "task3", configMINIMAL_STACK_SIZE, NULL,
		    PRI_TEST, NULL);
	xTaskCreate(task4_s_d, "task4", configMINIMAL_STACK_SIZE, NULL,
		    PRI_TEST, NULL);
	xTaskCreate(task5_d_d, "task5", configMINIMAL_STACK_SIZE, NULL,
		    PRI_TEST, NULL);
	xTaskCreate(task6_d_s, "task6", configMINIMAL_STACK_SIZE, NULL,
		    PRI_TEST, NULL);

	pxDev = id_to_dev(INT_TIMER);
	intc_irq_request(&pxDev->irq, prvTestTimerIntTask, "TST_Timer");
	prvTestTimerStart();
}
