/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#include "tinysys_reg.h"
#include "mbox_common_type.h"
#include "mbox_common.h"
#include "mbox_platform.h"
#include "mbox_pin.h"
#include "interrupt.h"
#include "mt_printf.h"
#include "ipi_id.h"
#include "driver_api.h"
#include "mt_printf.h"
#include "irq.h"
#include "ipi_table.h"
#ifdef CFG_XGPT_SUPPORT
#include <xgpt.h>
#endif

#define DIV_ROUND_UP(x, y)  (((x) + (y) - 1) / (y))

void init_pin_number(void);
unsigned int find_mbox_num(unsigned int irq_num);
int set_mbox_64d(unsigned int mbox, unsigned int is64d, void *data);
void mbox_setup_pin_table(int mbox);
void dump_pin_table(int8_t);
int register_irq_handler(void (*mbox_isr)(void *data), void *prdata);
extern void mbox_isr_pre_cb(void);
extern void mbox_isr_post_cb(void);

void mbox_isr_pre_cb(void) {return;}
void mbox_isr_post_cb(void) {return;}

/*
 * init send/recv pin function, must in mbox_port.c
 */
void init_pin_number(void)
{
	TOTAL_RECV_PIN = sizeof(mbox_pin_recv_table)/sizeof(struct pin_recv);
	TOTAL_SEND_PIN = sizeof(mbox_pin_send_table)/sizeof(struct pin_send);
}


/*
 * find mbox number in mbox_isr funtion
 */
unsigned int find_mbox_num(unsigned int irq_num)
{
	return irq_num;
}

/*
 * set mbox 64d function
 */
int set_mbox_64d(unsigned int mbox, unsigned int is64d, void *data)
{
	//set mbox is 64d
	if (is64d == MBOX_OPT_32_SLOT)
		DRV_ClrReg32(R_SECURE_CTRL, B_MBOX0_SIZE << mbox);
	else
		DRV_SetReg32(R_SECURE_CTRL, B_MBOX0_SIZE << mbox);

	return 0;
}

/*
 * set send/recv offset and pin by is64d
 */
void mbox_setup_pin_table(int mbox)
{
	unsigned int i;
	int last_ofs = 0, last_idx = 0, last_slot = 0, last_sz = 0;

	for (i = 0; i < TOTAL_RECV_PIN; i++) {
		if (mbox == mbox_pin_recv_table[i].mbox) {
			/* update pin offset, idex */
			mbox_pin_recv_table[i].offset = last_ofs + last_slot;
			mbox_pin_recv_table[i].pin_index = last_idx + last_sz;

			/* calculate occupied msg size, offset, slots*/
			last_idx = mbox_pin_recv_table[i].pin_index;
			last_sz = DIV_ROUND_UP(mbox_pin_recv_table[i].msg_size,
						mbox_table[mbox].is64d + 1);
			last_ofs = last_sz * (mbox_table[mbox].is64d + 1);
			last_slot = last_idx * (mbox_table[mbox].is64d + 1);
		} else if (mbox < mbox_pin_recv_table[i].mbox)
			break; /* no need to search the rest ipi */
	}

	for (i = 0; i < TOTAL_SEND_PIN; i++) {
		if (mbox == mbox_pin_send_table[i].mbox) {
			/* update pin offset, idex */
			mbox_pin_send_table[i].offset = last_ofs + last_slot;
			mbox_pin_send_table[i].pin_index = last_idx + last_sz;

			/* calculate occupied msg size, offset, slots*/
			last_idx = mbox_pin_send_table[i].pin_index;
			last_sz = DIV_ROUND_UP(mbox_pin_send_table[i].msg_size,
						mbox_table[mbox].is64d + 1);
			last_ofs = last_sz * (mbox_table[mbox].is64d + 1);
			last_slot = last_idx * (mbox_table[mbox].is64d + 1);
		} else if (mbox < mbox_pin_send_table[i].mbox)
			break; /* no need to search the rest ipi */
	}

	if (last_idx > 32 ||
	   (last_ofs + last_slot) > (mbox_table[mbox].is64d + 1) * 32) {
		PRINTF_E("mbox%d index(%d)/slot(%d) exceed the maximum\n",
			mbox, last_idx, last_ofs);
		configASSERT(0);
	}
}

extern uint64_t mbox_get_time_stamp(void);
uint64_t mbox_get_time_stamp(void)
{
#ifdef CFG_XGPT_SUPPORT
	return (uint64_t) read_xgpt_stamp_ns();
#else
	return 0;
#endif
}

/*
 * dump pin table with selected mbox
 * bit[0:3] represent to mbox0~mbox4
 */
void dump_pin_table(int8_t mbox)
{
	unsigned int i;

	PRINTF_D("pin recv table:\n");
	for (i = 0; i < TOTAL_RECV_PIN; i++) {
		if ((1 << mbox_pin_recv_table[i].mbox) & mbox)
			PRINTF_D("  mbox%d pin%02d index: %02u, offset: %02u, sz: %02u\n",
				mbox_pin_recv_table[i].mbox,
				mbox_pin_recv_table[i].ipi_id,
				mbox_pin_recv_table[i].pin_index,
				mbox_pin_recv_table[i].offset,
				mbox_pin_recv_table[i].msg_size);
	}

	PRINTF_D("pin send table:\n");
	for (i = 0; i < TOTAL_SEND_PIN; i++) {
		if ((1 << mbox_pin_send_table[i].mbox) & mbox)
			PRINTF_D("  mbox%d pin%02d index: %02u, offset: %02u, sz: %02u\n",
				mbox_pin_send_table[i].mbox,
				mbox_pin_send_table[i].ipi_id,
				mbox_pin_send_table[i].pin_index,
				mbox_pin_send_table[i].offset,
				mbox_pin_send_table[i].msg_size);
	}

}

/*
 * register_irq_handler
 */
int register_irq_handler(void (*mbox_isr)(void *data), void *prdata)
{
	int mbox;

	mbox = *(int *)prdata;

	/* clear mbox interrupt to ensure mbox is clean before request */
	mbox_clr_irq(mbox, 0xffffffff);

	if (intc_irq_request(&INTC_IRQ_MBOX[mbox],
				(void *)mbox_isr, &mbox_table[mbox]) != 0) {
		PRINTF_E("mbox %d irq request failed\n", mbox);
		return MBOX_CONFIG_ERR;
	} else {
		intc_irq_wakeup_set(&INTC_IRQ_MBOX[mbox], 0x1);
		return MBOX_DONE;
	}
}

