/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#include "FreeRTOS.h"
#include "task.h"
#include <tinysys_reg.h>
#include <driver_api.h>
#include <mt_printf.h>
#include <irq.h>
#include <intc.h>
#include <encoding.h>
#include <wdt.h>
#ifdef CFG_XGPT_SUPPORT
#include <xgpt.h>
#endif
#include <peripheral.h>

void mtk_wdt_disable(void)
{
	DRV_WriteReg32(WDT_CFGREG, DISABLE_WDT);
}
void mtk_wdt_enable(void)
{
	DRV_WriteReg32(WDT_CFGREG, START_WDT);
}
void mtk_wdt_irq_clear(void)
{
	DRV_WriteReg32(WDT_IRQ_REG, 0x1);
}
void mtk_wdt_restart(void)
{
	DRV_WriteReg32(WDT_KICKREG, KICK_WDT);
}

int mtk_wdt_set_time_out_value(unsigned int value)
{
	if (value > 0xFFFFF) {
		PRINTF_D("SCP WDT Timeout value overflow\n");
		return -1;
	}
	mtk_wdt_disable();
	DRV_WriteReg32(WDT_CFGREG, 1 << WDT_EN | value);
	return 0;
}

void scp_endless_loop(void)
{
	taskDISABLE_INTERRUPTS();
	/* cleanup gvic setting for avoiding interrupt or wakeup triggered */
	vic_set_mask(0, 0x0);
	vic_set_wakeup_mask(0, 0x0);
	/* Halt CPU */
	while(1)
		__asm volatile ("wfi");
}

void scp_ready_to_reboot(void)
{
	/* set reboot flag to let AP know we are ready to reboot*/
	*(volatile unsigned int *)SCP_GPR_REBOOT_FLAG = CORE_RDY_TO_REBOOT;

}
void mtk_wdt_isr(void)
{
	PRINTF_D("%s core%lu\n", __func__, mrv_read_csr(CSR_MHARTID));
	/* notify another core */
	DRV_WriteReg32(GIPC_IN_SET, GIPC4_SETCLR_BIT_0);
	scp_ready_to_reboot();
	scp_endless_loop();
}

void scp_halt_isr(void)
{
	PRINTF_D("%s core%lu\n", __func__, mrv_read_csr(CSR_MHARTID));
	scp_ready_to_reboot();
	scp_endless_loop();
}

void mtk_wdt_init(void)
{
	mtk_wdt_disable();
#ifdef CFG_XGPT_SUPPORT
	/* needs 70us to reload counter value */
	udelay(70);
#endif
	mtk_wdt_irq_clear();
	intc_irq_request(&INTC_IRQ_WDT, (void *) mtk_wdt_isr, NULL);
	intc_irq_wakeup_set(&INTC_IRQ_WDT, 1);
	mtk_halt_isr_init();
	mtk_wdt_enable();
	mtk_wdt_restart(); /* restart wdt after wdt reset */
	PRINTF_D("SCP mtk_wdt_init: WDT_CFGREG=0x%x!!\n", DRV_Reg32(WDT_CFGREG));
}


void mtk_halt_isr_init(void)
{
	/* clear ipc first */
	DRV_WriteReg32(GIPC_IN_CLR, GIPC4_SETCLR_BIT_0);
	intc_irq_request(&INTC_IRQ_HALT, (void *) scp_halt_isr, NULL);
	intc_irq_wakeup_set(&INTC_IRQ_HALT, 1);
}


