/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#include "encoding.h"
#include "stdint.h"
#include "logger.h"
#include "mt_printf.h"

#ifdef CFG_VCORE_DVFS_SUPPORT
#include <dvfs.h>
#endif

#ifdef CFG_DMA_SUPPORT
#include "dma_api.h"
#endif

#ifdef CFG_COMMON_IPI_SUPPORT
#include <ipi.h>
#include "ipi_id.h"
#endif

#define LOGGER_WAIT_DRAM  3


extern unsigned int logger_update_dram_ready_time(void);
extern void logger_update_post_process(void);
extern unsigned int logger_addr_remap(unsigned int addr);
extern void logger_addr_unremap(unsigned int addr);
extern int logger_update_notify_ap(void);
extern void logger_wake_unlock(void);
extern void logger_ipi_registration(LAST_LOG_INFO logger_info);
extern void logger_enter_critical(void);
extern void logger_exit_critical(void);
extern void logger_wake_lock(void);
extern void logger_dcache_flush(void *addr, uint32_t size);
extern void logger_dcache_invalidate(void *addr, uint32_t size);
extern unsigned int logger_update_dma(unsigned int src_buf,
				      unsigned int src_r_pos,
				      unsigned int dst_buf,
				      unsigned int dst_w_pos,
				      unsigned int src_len,
				      unsigned int dst_len);

extern uint32_t ap_to_scp(uint32_t ap_addr);

struct logger_init_msg {
	unsigned int addr;
	unsigned int size;
} msg_logger_init;

void *msg_logger_en, *msg_logger_wk;

#ifdef CFG_WAKELOCK_SUPPORT
wakelock_t scp_logger_wakelock;
#endif

void logger_dcache_flush(void *addr, uint32_t size) {}
void logger_dcache_invalidate(void *addr, uint32_t size) {}
void logger_addr_unremap(unsigned int addr) {}

#ifdef CFG_COMMON_IPI_SUPPORT
static void logger_wakeup_handler(unsigned int id, void *prdata, void *data)
{
	unsigned int wakeup;

	wakeup = *(unsigned int *)data;
	logger_update_wakeup_ap(wakeup);
}

static void logger_enable_handler(unsigned int id, void *prdata, void *data)
{
	unsigned int enable;

	enable = *(unsigned int *)data;
	logger_update_enable(enable);
}

void logger_init_handler(unsigned int id, void *prdata, void *data)
{
	unsigned int ret;
	struct logger_init_msg msg = *(struct logger_init_msg *)data;

	ret = logger_dram_register(msg.addr, msg.size);
	if (ret == 0) {
		configASSERT(0);
		return;
	}
}
#endif

unsigned int logger_addr_remap(unsigned int addr)
{
#ifdef CFG_DMA_SUPPORT
	return ap_to_scp(addr);
#endif
}

unsigned int logger_update_dram_ready_time(void)
{
	unsigned int ret = 0;

#ifdef CFG_VCORE_DVFS_SUPPORT
	/* 0 go for rest of update, 1 go for postponding to next tick */
	ret = dvfs_enable_DRAM_no_wait_for_logger(SCP_A_LOGGER_MEM_ID);
#endif
	return (ret ? LOGGER_WAIT_DRAM : 0);
}

void logger_update_post_process(void)
{
#ifdef CFG_VCORE_DVFS_SUPPORT
	dvfs_disable_DRAM_no_wait_for_logger(SCP_A_LOGGER_MEM_ID);
#endif
}

unsigned int logger_update_dma(unsigned int src_buf, unsigned int src_r_pos,
			       unsigned int dst_buf, unsigned int dst_w_pos,
			       unsigned int src_len, unsigned int dst_len)
{
#ifdef CFG_DMA_SUPPORT
	DMA_RESULT ret = 0;

	ret =
	    scp_dma_transaction(dst_buf + dst_w_pos, src_buf + src_r_pos,
				src_len, LOGGER_DMA_ID, NO_RESERVED);

	if (ret != DMA_RESULT_DONE) {
		PRINTF_E("log dma trans fail%u\n", ret);
		return 0;
	}

	return src_len;
#endif
}

int logger_update_notify_ap(void)
{
#ifdef CFG_COMMON_IPI_SUPPORT
	unsigned int magic = 0x5A5A5A5A;

	if (!ipi_send(IPI_OUT_LOGGER_WAKEUP_1, &magic, sizeof(magic)/4, 0))
		return 1;
#endif
	return 0;
}

void logger_ipi_registration(LAST_LOG_INFO logger_info)
{
#ifdef CFG_COMMON_IPI_SUPPORT
	int ret;

#ifdef CFG_LOG_FILTER
	extern void set_log_filter(void);
	struct mtk_mbox_queue_t msg_logger_flt;
	ret = ipi_register(
		IPI_IN_SCP_LOG_FILTER_1, set_log_filter, 0, &msg_logger_flt);
	if (ret != IPI_ACTION_DONE)
		PRINTF_E("register log filter ipi failed, %d\n", ret);
#endif // CFG_LOG_FILTER

	ret = ipi_register(
		IPI_IN_LOGGER_INIT_1, logger_init_handler, 0, &msg_logger_init);
	if (ret != IPI_ACTION_DONE)
		PRINTF_E("register log init ipi failed, %d\n", ret);

	/* cmd for disable/enable log and wakeup flag */
	ret = ipi_register(
		IPI_IN_LOGGER_ENABLE_1, logger_enable_handler, 0, &msg_logger_en);
	if (ret != IPI_ACTION_DONE)
		PRINTF_E("register log enable ipi failed, %d\n", ret);

	ret = ipi_register(
		IPI_IN_LOGGER_WAKEUP_1, logger_wakeup_handler, 0, &msg_logger_wk);
	if (ret != IPI_ACTION_DONE)
		PRINTF_E("register log wakeup ipi failed, %d\n", ret);

	/*send ipi */
	while (ipi_send(IPI_OUT_LOGGER_INIT_1, &logger_info, sizeof(logger_info)/4, 0))
		;

#endif
}

void logger_wake_unlock(void)
{
#ifdef CFG_WAKELOCK_SUPPORT
	wake_unlock_FromISR(&scp_logger_wakelock);
#endif
}

void logger_wake_lock(void)
{
#ifdef CFG_WAKELOCK_SUPPORT
	/*wakelock init */
	wake_lock_init(&logger_wakelock, "logwk");
	/*logger wake lock until receive AP side DRAM info. */
	wake_lock(&logger_wakelock);
#endif
}

void logger_enter_critical(void)
{
	taskENTER_CRITICAL();
}

void logger_exit_critical(void)
{
	taskEXIT_CRITICAL();
}
