/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#ifdef configExtension_F
#define DUMP_REG_FPU		0//1
#else
#define DUMP_REG_FPU		0
#endif

#ifdef configExtension_ACC
#define DUMP_REG_ACC		0//1
#else
#define DUMP_REG_ACC		0
#endif

#ifdef configExtension_UAM
#define DUMP_REG_UAM		0//1
#else
#define DUMP_REG_UAM		0
#endif

#define DUMP_MAGIC		0xca
#define DUMP_REG_MREG		1
#define DUMP_REG_COP		0
#define DUMP_REG_DBG		0

#define DUMP_VERSION	((DUMP_MAGIC << 24) | (DUMP_REG_FPU << 23)\
	| (DUMP_REG_ACC << 22) | (DUMP_REG_UAM << 21)\
	| (DUMP_REG_MREG << 19) | (DUMP_REG_COP << 18)\
	| (DUMP_REG_DBG << 1)) | sizeof(struct TaskContextType)

enum mrv_stack {
	e_pc,
	e_x1,
	e_x2,
	e_x3,
	e_x4,
	e_x5,
	e_x6,
	e_x7,
	e_x8,
	e_x9,
	e_x10,
	e_x11,
	e_x12,
	e_x13,
	e_x14,
	e_x15,
	e_x16,
	e_x17,
	e_x18,
	e_x19,
	e_x20,
	e_x21,
	e_x22,
	e_x23,
	e_x24,
	e_x25,
	e_x26,
	e_x27,
	e_x28,
	e_x29,
	e_x30,
	e_x31,
	e_mstatus,
#if DUMP_REG_UAM
	e_uab0,
	e_uas0,
	e_uam0,
	e_uab1,
	e_uas1,
	e_uam1,
	e_uab2,
	e_uas2,
	e_uam2,
	e_uab3,
	e_uas3,
	e_uam3,
#endif
#if DUMP_REG_ACC
	e_acc0l,
	e_acc0h,
	e_acc0g,
	e_acc1l,
	e_acc1h,
	e_acc1g,
	e_acc2l,
	e_acc2h,
	e_acc2g,
	e_acc3l,
	e_acc3h,
	e_acc3g,
#endif
#if DUMP_REG_FPU
	e_f0,
	e_f1,
	e_f2,
	e_f3,
	e_f4,
	e_f5,
	e_f6,
	e_f7,
	e_f8,
	e_f9,
	e_f10,
	e_f11,
	e_f12,
	e_f13,
	e_f14,
	e_f15,
	e_f16,
	e_f17,
	e_f18,
	e_f19,
	e_f20,
	e_f21,
	e_f22,
	e_f23,
	e_f24,
	e_f25,
	e_f26,
	e_f27,
	e_f28,
	e_f29,
	e_f30,
	e_f31,
	e_fcsr,
#endif

};

typedef struct TaskContextType {
	long x0;
	long x1;
	long x2;
	long x3;		/* 0x10*/
	long x4;
	long x5;
	long x6;
	long x7;		/* 0x20*/
	long x8;
	long x9;
	long x10;
	long x11;		/* 0x30*/
	long x12;
	long x13;
	long x14;
	long x15;		/* 0x40*/
	long x16;
	long x17;
	long x18;
	long x19;		/* 0x50*/
	long x20;
	long x21;
	long x22;
	long x23;		/* 0x60*/
	long x24;
	long x25;
	long x26;
	long x27;		/* 0x70*/
	long x28;
	long x29;
	long x30;
	long x31;		/* 0x80*/
	long pc;
	long mstatus;
	long mepc;
#if DUMP_REG_UAM
	long uab0;
	long uas0;
	long uam0;		/* 0x90*/
	long uab1;
	long uas1;
	long uam1;
	long uab2;		/* 0xa0*/
	long uas2;
	long uam2;
	long uab3;
	long uas3;		/* 0xb0*/
	long uam3;
#endif
#if DUMP_REG_ACC
	long acc0l;
	long acc0h;
	long acc0g;		/* 0xc0*/
	long acc1l;
	long acc1h;
	long acc1g;
	long acc2l;		/* 0xd0*/
	long acc2h;
	long acc2g;
	long acc3l;
	long acc3h;		/* 0xe0*/
	long acc3g;
#endif
#if DUMP_REG_FPU
	long f0;
	long f1;
	long f2;		/* 0xf0*/
	long f3;
	long f4;
	long f5;
	long f6;		/* 0x100*/
	long f7;
	long f8;
	long f9;
	long f10;		/* 0x110*/
	long f11;
	long f12;
	long f13;
	long f14;		/* 0x120*/
	long f15;
	long f16;
	long f17;
	long f18;		/* 0x130*/
	long f19;
	long f20;
	long f21;
	long f22;		/* 0x140*/
	long f23;
	long f24;
	long f25;
	long f26;		/* 0x150*/
	long f27;
	long f28;
	long f29;
	long f30;		/* 0x160*/
	long f31;
	long fcsr;
#endif
#if DUMP_REG_MREG
	long fflags;	/* 0x170*/
	long frm;
	long misa;
	long mtvec;
	long mctren;
	long mflag;
	long mcycle;
	long mtime;		/* 0x190*/
	long minstret;
	long mcycleh;
	long mtimeh;
	long minstreth;	/* 0x1a0*/
	long mpmuctr;
	long mtbufctr;
	long mvendorid;
	long marchid;	/* 0x1b0*/
	long mimpid;
	long mhartid;
	long mnpc;		/* 0x1c0*/
	long mverid0;
	long mverid1;
	long mverid2;
	long micause;	/* 0x1d0*/
	long midbgmask;
	long midbgwakeup;
	long mipend_g0;
	long mimask_g0;	/* 0x1e0*/
	long miwakeup_g0;
	long milsel_g0;
	long miemask_g0;
	long medeleg;	/* 0x1f0*/
	long mideleg;
	long mie;
	long mip;		/* 0x200*/
	long mpu_en;
	long mpu_litcm;
	long mpu_ldtcm;
	long mpu_hitcm;	/* 0x210*/
	long mpu_hdtcm;
	long mpu_l00;
	long mpu_l01;
	long mpu_l02;	/* 0x220*/
	long mpu_l03;
	long mpu_l04;
	long mpu_l05;
	long mpu_l06;	/* 0x230*/
	long mpu_l07;
	long mpu_l08;
	long mpu_l09;
	long mpu_l10;	/* 0x240*/
	long mpu_l11;
	long mpu_l12;
	long mpu_l13;
	long mpu_l14;	/* 0x250*/
	long mpu_l15;
	long mpu_h00;
	long mpu_h01;
	long mpu_h02;	/* 0x260*/
	long mpu_h03;
	long mpu_h04;
	long mpu_h05;
	long mpu_h06;
	long mpu_h07;
	long mpu_h08;
	long mpu_h09;
	long mpu_h10;
	long mpu_h11;
	long mpu_h12;
	long mpu_h13;
	long mpu_h14;
	long mpu_h15;
	long mdbgbp0;
	long mdbgbp1;
	long mdbgbp2;
	long mdbgbp3;
	long mdbgbpc;
	long mdbgwpm0;
	long mdbgwpm1;
	long mdbgwpm2;
	long mdbgwpm3;
	long dscratch;
	long mscratch;
	long mcause;
	long mtval;
	long mimabtcau;
	long mimabtaddr;
#endif
#if DUMP_REG_COP
	long dcache_con;
	long dcache_membar;
	long dcache_rulechk;
	long dcache_rlcwmode;
	long dcache_pmask;
	long dcache_status;
	long dcache_op;
	long dcache_rlcwid;
	long core_pf_ctrl_0;
	long icache_con;
	long icache_op;
	long icache_status;
	long icache_membar;
#endif
#if DUMP_REG_DBG
	long thread_mode_ctrl_0;
	long btb_con;
	long icache_pmask;
	long tbufctr;
	long tbufclr;
	long tbufstr;
	long tbufrcmd;
	long tbufrdata;
	long mtmrctr;
	long mtmrstatus;
	long mtmrcvr;
	long mtmrrvr;
	long mtmrdvr;
#endif
} TaskContext;


void mt_ram_dump_init(void);
void stackDump(long epc, long stack[], long re_pc, long re_sp, long re_ra);
//void wdt_isr_save_context(long stack[]);


