/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#ifndef __BUS_TRACKER_H__
#define __BUS_TRACKER_H__

#include <encoding.h>
#include <peripheral.h>
#ifdef CFG_WDT_SUPPORT
#include <wdt.h>
#endif
#define BUS_TRACKER_DEBUG	1
#define BUS_TRACKER_LOG		1

#if BUS_TRACKER_DEBUG
#define TRACKER_DBG(x...) printf(x)
#else
#define TRACKER_DBG(x...)
#endif
#define BUS_TRACKER_DEBUG	1

#if BUS_TRACKER_LOG
#define TRACKER_LOG(x...) printf(x)
#else
#define TRACKER_LOG(x...)
#endif

#ifndef CFG_FPGA
#define BUS_TRACKER_STAGE1_TIMEOUT	(19600)	/* 1ms @ 196Mhz = 19600 *0x10 */
#define BUS_TRACKER_STAGE2_TIMEOUT	(196000000)	/* 16s @ 196Mhz = 19600000 *0x10*/
#else
#define BUS_TRACKER_STAGE1_TIMEOUT	(19600)
#define BUS_TRACKER_STAGE2_TIMEOUT	(19600)
#endif
#define BUS_TRACKER_WATCHPOINT		(0)
#define BUS_TRACKER_WATCHPOINT_MASK	(0)

void dump_bus_tracker_status(void);
unsigned int bus_tracker_handler(void *ptr);
void bus_tracker_init(void);

/* AXI abort */
static inline unsigned int axi_get_cause(void)
{
	unsigned long reg;
	reg = mrv_read_csr(CSR_MIMABTCAU);
	return (unsigned int) reg;
}
static inline unsigned int axi_get_address(void)
{
	unsigned long reg;
	reg = mrv_read_csr(CSR_MIMABTADDR);
	return (unsigned int) reg;
}
static inline void axi_clear_status(void)
{
	mrv_write_csr(CSR_MIMABTCAU, 0);
	return;
}

static inline void bus_tracker_plat_init(void)
{

/* due to scp bus idle is simulated by register,
   bus tracker should be initialed before bus transaction start */
	drv_write_reg32(SCP_DBG_CTRL, TRACKER_FORCE_IDLE);

#ifdef CFG_BUS_TRACKER_INTERRUPT_MODE
	drv_write_reg32(SCP_TRACKER_CTRL,
			BUS_WP_SLV_ERR_EN | DBG_AW_TIMEOUT_IRQ_EN |
			DBG_AR_TIMEOUT_IRQ_EN | DBG_SLV_ERR_EN |
			DBG_TIMEOUT_EN | DBG_CON_EN);

#else
	drv_write_reg32(SCP_TRACKER_CTRL,
			BUS_WP_SLV_ERR_EN | DBG_SLV_ERR_EN | DBG_TIMEOUT_EN
			| DBG_CON_EN);
#endif
}

static inline void bus_tracker_handler_plat_start(void)
{
#ifndef CFG_BUS_TRACKER_INTERRUPT_MODE
	TRACKER_LOG("bus err cause/addr %08x %08x\n", axi_get_cause(),
		axi_get_address());
#endif
}
static inline void bus_tracker_handler_plat_end(void)
{
	axi_clear_status();
	vic_set_mask(0, 0x0);
	vic_set_wakeup_mask(0, 0x0);
#ifdef CFG_WDT_SUPPORT
	mtk_wdt_set_time_out_value(10);	/*assign a small value to make ee sooner */
	mtk_wdt_restart();

#endif
	/* Halt CPU */
	__asm volatile ("wfi");
}

#endif	/* __BUS_TRACKER_H__ */
