/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#include "tinysys_reg.h"
#include "mbox_common_type.h"
#include "mbox_common.h"
#ifdef CFG_XGPT_SUPPORT
#include <xgpt.h>
#endif

#ifdef CFG_LEGACY_IPI_SUPPORT
#include "scp_ipi.h"
#else
#include <ipi.h>
#include <ipi_id.h>
#endif


#ifdef CFG_IPI_TEST
#include "ipi_id.h"
#include "mbox_common.h"
#include "mt_printf.h"
#endif

#ifdef CFG_COMMON_WAKELOCK_SUPPORT
#include <wakelock.h>
#endif

#ifdef CFG_PBFR_SUPPORT
#include "mt_pbfr.h"
#endif

wakelock_t ap_wakelock;
wakelock_t connsys_wakelock;
unsigned int msg_test;
#ifdef CFG_PBFR_SUPPORT
int pbfr_start = 0;		//pbfr control flag
#endif

unsigned long long ipi_get_ts(void);
void ipi_notify_receiver(int ipi_id);
void ipi_mdelay(unsigned long ms);
void ipi_platform_init(void);


/**
 * @brief check SCP -> AP IPI is using now
 * @return pdFALSE, IPI is NOT using now
 * @return pdTRUE, IPI is using, and AP does not receive the IPI yet.
 */
uint32_t is_ipi_busy(void)
{
	int i;

	for (i = 0; i < IPI_MBOX_TOTAL; i++)
		if (DRV_Reg32(mbox_table[i].send_status_reg))
			return pdTRUE;

	return pdFALSE;
}

unsigned long long ipi_get_ts(void)
{
#ifdef CFG_XGPT_SUPPORT
	return read_xgpt_stamp_ns();
#else
	return 0;
#endif
}

/**
 * @brief send notify to SPM to wakeup AP
 */
void ipi_notify_receiver(int ipi_id)
{
	/* wakeup APMCU */
	DRV_SetReg32(SCP2SPM_IPC_SET, 0x1);

	return;
}

void ipi_mdelay(unsigned long ms)
{
#ifdef CFG_XGPT_SUPPORT
	mdelay(ms);
#else
	// do busy waiting w/o xgpt ...
#endif
}

/**
 * @brief AP wakeup SCP and keep SCP awake
 */
static void infra_irq_handler(void)
{
	unsigned int reg_val;

	reg_val = DRV_Reg32(INFRA_IRQ_SET) & 0xf;

	/* clr interrupt as early as possible to let AP leave busy waiting */
	DRV_WriteReg32(INFRA_IRQ_CLR, reg_val);

	if (reg_val & (1 << AP_AWAKE_LOCK))
		wake_lock_FromISR(&ap_wakelock);

	if (reg_val & (1 << AP_AWAKE_UNLOCK))
		wake_unlock_FromISR(&ap_wakelock);

	if (reg_val & (1 << CONNSYS_AWAKE_LOCK))
		wake_lock_FromISR(&connsys_wakelock);

	if (reg_val & (1 << CONNSYS_AWAKE_UNLOCK))
		wake_unlock_FromISR(&connsys_wakelock);

}

void ipi_awake_init(void)
{
	wake_lock_init(&ap_wakelock, "AP_W");
	wake_lock_init(&connsys_wakelock, "CO_W");
	if (intc_irq_request(&INTC_IRQ_INFRA, (void *)infra_irq_handler, NULL))
		PRINTF_E("infra irq request failed\n");
	intc_irq_wakeup_set(&INTC_IRQ_INFRA, 1);
}

static void scp_ipi_debug(unsigned int id, void *prdata, void *data)
{
	unsigned int buffer;

	buffer = *(unsigned int *)data;
	PRINTF_D("scp get debug ipi buf=%u, id=%u\n", buffer, id);
#ifdef CFG_PBFR_SUPPORT
	if (pbfr_start == PBFR_STOP) {
		pbfr_start = PBFR_START;
		PRINTF_D("pbfr start load info....\n");
		pbfr_start_loadinfo(0);
	} else if (pbfr_start == PBFR_START) {
		pbfr_start = PBFR_REPORT;
		pbfr_report_loadinfo(0);
	} else if (pbfr_start == PBFR_REPORT) {
		pbfr_start = PBFR_STOP;
		PRINTF_D("pbfr stop load info.\n");
		pbfr_stop_loadinfo();
	}
#endif
}

void ipi_platform_init(void)
{
	int ret = -1;

	ipi_init();
#ifdef CFG_LEGACY_IPI_SUPPORT
	scp_legacy_ipi_init();
#endif

#ifdef CFG_AMP_CORE1_EN
	if (mrv_read_csr(CSR_MHARTID) == 0)
#endif
	{
		ipi_awake_init();
	}

	if (mrv_read_csr(CSR_MHARTID) == 0)
		ret = ipi_register(IPI_IN_TEST_0, scp_ipi_debug, 0, &msg_test);
	else
		ret = ipi_register(IPI_IN_TEST_1, scp_ipi_debug, 0, &msg_test);
	if (ret)
		PRINTF_E("ipi test register failed, ret %d\n", ret);
}
