/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver\'s
 * applicable license agreements with MediaTek Inc.
 */

#include <FreeRTOS.h>
#include <dmgr_api.h>
#include <dmgr.h>
#include <peripheral.h>
#include <irq.h>
#include <encoding.h>
#include <mt_printf.h>
#include <dvfs.h>

#define e_GET_MCAUSE(x) __asm volatile("csrr %0, mcause":"=r"(x)::)
#define e_GET_MEPC(x)   __asm volatile("csrr %0, mepc":"=r"(x)::)

#ifdef GCC_7_2
#define e_GET_MTVAL(x)  __asm volatile("csrr %0, mbadaddr":"=r"(x)::)
#else
#define e_GET_MTVAL(x)  __asm volatile("csrr %0, mtval":"=r"(x)::)
#endif				/* GCC_7_2 */

/*****************************************************************************
 * Setting for Platform-Specific DRAM access detect, like MPU
 ****************************************************************************/

inline void vDmgrPortEnRegion(void)
{
#ifdef CFG_MPU_SUPPORT
#if CFG_L1C_DRAM_SIZE_0
	mpu_region_enable(MPU_REGION_DRAM_RO);
	mpu_region_enable(MPU_REGION_DRAM_RW);
#endif
#if CFG_L1C_DRAM_SIZE_1
	mpu_region_enable(MPU_REGION_DRAM);
#endif
#endif
}

inline void vDmgrPortDisRegion(void)
{
#ifdef CFG_MPU_SUPPORT
	mrv_dcache_flush_all();
#if CFG_L1C_DRAM_SIZE_0
	mpu_region_disable(MPU_REGION_DRAM_RO);
	mpu_region_disable(MPU_REGION_DRAM_RW);
#endif
#if CFG_L1C_DRAM_SIZE_1
	mpu_region_disable(MPU_REGION_DRAM);
#endif
#endif
}

/*****************************************************************************
 * Logic to tell if the execution instruction or load/store data is in DRAM
 ****************************************************************************/

DramMgrAccssType_t xDmgrPortAccessType(void)
{
	uint32_t ulCause, ulMMFAR, ulPC;

	e_GET_MCAUSE(ulCause);
	e_GET_MTVAL(ulMMFAR);
	e_GET_MEPC(ulPC);

	DMGR_PRINTF(LOG_TRAP, "mcause=0x%08x, mepc=0x%08x, vtval=0x%08x",
		    (unsigned int) ulCause, (unsigned int) ulPC,
		    (unsigned int) ulMMFAR);

	if ((CFG_L1C_DRAM_ADDR <= ulPC &&
			    ulPC < CFG_L1C_DRAM_ADDR + CFG_L1C_DRAM_SIZE) ||
	    (CFG_L1C_DRAM_ADDR <= ulMMFAR &&
			    ulMMFAR < CFG_L1C_DRAM_ADDR + CFG_L1C_DRAM_SIZE)) {
		/* if ISR execution locates in the range of cacheable memory */
		if (is_in_isr()) {
			DMGR_WARN("Access DRAM in ISR, PC=0x%x, MMFAR=0x%08x!!!",
				  (unsigned int) ulPC, (unsigned int) ulMMFAR);
			return TYPE_EXCEPTION;
		}

		/* if dram access is in critical secton */
		if (xGetCriticalNesting() > 0) {
			DMGR_WARN
			    ("Access DRAM in CRITICAL SECTION, PC=0x%x, MMFAR=0x%08x!!!",
			     (unsigned int) ulPC, (unsigned int) ulMMFAR);
			return TYPE_CRITICAL;
		}

		/* if instruction accessed locates in the range of cacheable memory */
		if (ulCause == CAUSE_FAULT_FETCH) {
			return TYPE_NORMAL;
		}
		/* if data accessed locates in the range of cacheable memory */
		if (ulCause == CAUSE_FAULT_LOAD || ulCause == CAUSE_FAULT_STORE) {
			return TYPE_NORMAL;
		}

	}
	return TYPE_INVALID;
}

/*****************************************************************************
 * Sync operation porting for DRAM On/Off
 ****************************************************************************/

inline void vDmgrPortEnDRAMFromISR(void)
{
	dvfs_enable_DRAM_resource_from_isr(DRAM_MANAGER_MEM_ID);
}

inline void vDmgrPortDisDRAM(void)
{
	dvfs_disable_DRAM_resource(DRAM_MANAGER_MEM_ID);
}

/*****************************************************************************
 * Async operation porting for DRAM On/Off
 ****************************************************************************/

inline int32_t vDmgrPortGetDramAckFromISR(void)
{
	return get_dram_ack_from_isr_for_dmgr();
}

inline void vDmgrPortEnDRAMUnblock(void)
{
	enable_dram_resource_for_dmgr(DRAM_MANAGER_MEM_ID);
}
