/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 */

#include <FreeRTOS.h>
#include <task.h>
#include <stdio.h>
#include <driver_api.h>
#include <interrupt.h>
#include <mtk_sem.h>
#include <mt_printf.h>
#ifdef CFG_XGPT_SUPPORT
#include <xgpt.h>
#endif
#include <dvfs.h>
#include <dvfs_common.h>

#define DVFS_DEBUG         0

#if DVFS_DEBUG
#define DVFSLOG(fmt, arg...)        \
    do {            \
        PRINTF_D(DVFSTAG fmt, ##arg);   \
    } while (0)
#else
#define DVFSLOG(...)
#endif

#if DVFS_DEBUG
#define DVFSFUC(fmt, arg...)        \
    do {            \
        PRINTF_D(DVFSTAG "%s("fmt")\n", __func__, ##arg);  \
    } while (0)
#else
#define DVFSFUC(...)
#endif

#if DVFS_DEBUG
#define DVFSDBG(fmt, arg...)        \
    do {            \
        PRINTF_W(DVFSTAG fmt, ##arg);   \
    } while (0)
#else
#define DVFSDBG(fmt, arg...)
#endif

#ifdef CFG_XGPT_SUPPORT
static volatile uint64_t dvfs_profile_time[PROFILE_MODE_NUM][PROFILE_TYPE_NUM];

static char dvfs_profile_name[PROFILE_MODE_NUM][10] = {
	"SLEEP",
	"WAKE-UP",
	"RTOS",
	"WAIT-ISR",
	"UPDATE",
	"BLOCK",
	"DVFS",
	"WFI",
	"DRAM",
};
#endif

extern int g_scp_dvfs_debug;

/*****************************************
* ADB CMD Control APIs
****************************************/
void dvfs_debug_set(int id, void *data, unsigned int len)
{
	(void)id;
	(void)len;
	uint8_t *msg = (uint8_t *) data;

	g_scp_dvfs_debug = *msg;
	DVFSLOG("set g_scp_dvfs_debug = %d\n", *msg);
}

/*****************************************
 * AP/INFRA Resource APIs
 ****************************************/
#ifdef CFG_DMA_SUPPORT
void enable_clk_bus(scp_reserve_mem_id_t dma_id)
{
	DVFSFUC("%d", dma_id);
	taskENTER_CRITICAL();
	enable_infra(dma_id, NEED_WAIT);
	taskEXIT_CRITICAL();
}

void disable_clk_bus(scp_reserve_mem_id_t dma_id)
{
	DVFSFUC("%d", dma_id);
	taskENTER_CRITICAL();
	disable_infra(dma_id);
	taskEXIT_CRITICAL();
}

void enable_clk_bus_from_isr(scp_reserve_mem_id_t dma_id)
{
	DVFSFUC("%d", dma_id);
	enable_infra(dma_id, NEED_WAIT);
}

void disable_clk_bus_from_isr(scp_reserve_mem_id_t dma_id)
{
	DVFSFUC("%d", dma_id);
	disable_infra(dma_id);
}

void dvfs_disable_DRAM_resource(scp_reserve_mem_id_t dma_id)
{
	DVFSFUC("%d", dma_id);
	taskENTER_CRITICAL();
	disable_AP_resource(dma_id);
	disable_infra(dma_id);
	taskEXIT_CRITICAL();
}

/*****************************************
 * Time Profiling APIs
 ****************************************/
static bool __dvfs_chk_profile_cond(enum dvfs_profile_mode mode,
		enum dvfs_profile_type type)
{
	if (mode >= PROFILE_MODE_NUM || type >= PROFILE_TYPE_NUM)
		return false;

#if !(SLEEP_TIMER_PROFILING)
	if (mode == SLP_TMR_M || mode == WK_TMR_M || mode == RTOS_TMR_M)
		return false;
#endif

#if !(DVFS_TIMER_PROFILING)
	if (mode == DVFS_TMR_M)
		return false;
#endif

#if !(WFI_TIMER_PROFILING)
	if (mode == WFI_TMR_M)
		return false;
#endif

#if !(DRAM_TIMER_PROFILING)
	if (mode == DRAM_TMR_M)
		return false;
#endif
	return true;
}

void dvfs_time_profiling(enum dvfs_profile_mode mode,
		enum dvfs_profile_type type)
{
#ifdef CFG_XGPT_SUPPORT
	uint64_t t1, t2;

	if (!__dvfs_chk_profile_cond(mode, type))
		return;

	switch (type) {
	case TMR_START_T:
	case TMR_END_T:
		dvfs_profile_time[mode][type] = read_xgpt_stamp_ns();
		break;
	case TMR_DURATION_T:
		t2 = dvfs_profile_time[mode][TMR_END_T];
		t1 = dvfs_profile_time[mode][TMR_START_T];
		dvfs_profile_time[mode][type] = (t2 -t1) / 1000;
		break;
	case TMR_RESET_T:
		dvfs_profile_time[mode][type] = 0;
		break;
	case TMR_RESTART_T:
		dvfs_profile_time[mode][TMR_START_T] =
				dvfs_profile_time[mode][TMR_END_T];
		break;
	default:
		PRINTF_W("this time profiling type not support.\n");
		break;
	}
#endif
}

uint64_t dvfs_get_time_duarion(enum dvfs_profile_mode mode)
{
#ifdef CFG_XGPT_SUPPORT
	if (__dvfs_chk_profile_cond(mode, TMR_DURATION_T)) {
		dvfs_time_profiling(mode, TMR_DURATION_T);

		return dvfs_profile_time[mode][TMR_DURATION_T];
	}
#endif
	return 0;
}

void dvfs_dump_time_profiling(enum dvfs_profile_mode mode)
{
#ifdef CFG_XGPT_SUPPORT
	if (!__dvfs_chk_profile_cond(mode, TMR_DURATION_T))
		return;

	dvfs_time_profiling(mode, TMR_DURATION_T);

	PRINTF_E("%s sw time: %llu(tick) => %llu(tick) = %lluus\n",
			dvfs_profile_name[mode],
			dvfs_profile_time[mode][TMR_START_T],
			dvfs_profile_time[mode][TMR_END_T],
			dvfs_profile_time[mode][TMR_DURATION_T]);
#endif
}
#endif

uint64_t get_last_wfi_s_time(void)
{
	return dvfs_profile_time[WFI_TMR_M][TMR_START_T];
}

uint64_t get_last_wfi_e_time(void)
{
	return dvfs_profile_time[WFI_TMR_M][TMR_END_T];
}
