/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 */

#ifndef _DVFS_COMMON_
#define _DVFS_COMMON_

#ifdef CFG_DMA_SUPPORT
#include <mt_dma.h>
#endif
#include <sleep.h>
#ifdef CFG_XGPT_SUPPORT
#include <xgpt.h>
#endif

/***********************************************************************************
** Definitions
************************************************************************************/

/* DVFS Status */
#define DVFS_STATUS_OK                           0
#define DVFS_STATUS_BUSY                         -1
#define DVFS_REQUEST_SAME_CLOCK                  -2
#define DVFS_STATUS_ERR                          -3
#define DVFS_STATUS_TIMEOUT                      -4
#define DVFS_CLK_ERROR                           -5
#define DVFS_STATUS_CMD_FIX                      -6
#define DVFS_STATUS_CMD_LIMITED                  -7
#define DVFS_STATUS_CMD_DISABLE                  -8

#define SCP_IDLE_MODE                             0
#define SCP_SLEEP_MODE                            1

#define SCP_ENABLE                                1
#define SCP_DISABLE                               0

#define NEED_WAIT                                 1
#define NO_WAIT                                   0

/***********************************************************************************
** Enum for Time Profiling
************************************************************************************/
enum dvfs_profile_mode {
	SLP_TMR_M = 0,
	WK_TMR_M = 1,
	RTOS_TMR_M = 2,
	WAIT_TMR_M= 3,
	UPDATE_TMR_M = 4,
	BLOCK_TMR_M = 5,
	DVFS_TMR_M = 6,
	WFI_TMR_M = 7,
	DRAM_TMR_M = 8,
	PROFILE_MODE_NUM = 9,
};

enum dvfs_profile_type {
	TMR_START_T = 0,
	TMR_END_T,
	TMR_DURATION_T,
	TMR_RESET_T,
	TMR_RESTART_T,
	PROFILE_TYPE_NUM,
};

/*****************************************
* ADB CMD Control APIs
****************************************/
void dvfs_debug_set(int id, void *data, unsigned int len);

/*****************************************
 * AP/INFRA Resource APIs
 ****************************************/
#ifdef CFG_DMA_SUPPORT
void enable_AP_resource(scp_reserve_mem_id_t dma_id);
void disable_AP_resource(scp_reserve_mem_id_t dma_id);
void enable_infra(scp_reserve_mem_id_t dma_id, uint32_t wait_ack);
void disable_infra(scp_reserve_mem_id_t dma_id);
#endif

/*****************************************
 * Time Profiling APIs
 ****************************************/
void dvfs_time_profiling(enum dvfs_profile_mode mode, enum dvfs_profile_type type);
uint64_t dvfs_get_time_duarion(enum dvfs_profile_mode mode);
void dvfs_dump_time_profiling(enum dvfs_profile_mode mode);
uint64_t get_last_wfi_s_time(void);
uint64_t get_last_wfi_e_time(void);
#endif				/* _DVFS_COMMON_ */
