/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

/* buff at end of l2_tcm, total 512 byte
include send and receive */
#define TINY_IPC_BUFF_SIZE	512

enum ipi_id {
	TIPC_SCP_CORE0_READY = 0,
	TIPC_SLT_CORE0_CTL,
	TIPC_CORE0_END = 15,
	TIPC_SCP_CORE1_READY = 16,
	TIPC_SLT_CORE1_CTL,
	TIPC_CORE1_END,
	NR_TIPC,
};

typedef void(*tipc_handler_t)(int id, void *data, unsigned int len);

struct tipc_desc_t {
    tipc_handler_t handler;
    const char  *name;
};

enum tipc_status {
    T_ERROR =-1,
    T_DONE,
    T_BUSY,
};
#define IPC_WAIT	1
#define IPC_NOWAIT 	0


#define TIPC_RECEIVE_BUFF (L2TCM_START + L2TCM_SIZE - TINY_IPC_BUFF_SIZE)
#define TIPC_SEND_BUFF (L2TCM_START + L2TCM_SIZE - (TINY_IPC_BUFF_SIZE/2))

enum tipc_status tiny_ipc_send(int id, void* buf, uint32_t len, uint32_t wait);

enum tipc_status tiny_ipc_registration(int id, tipc_handler_t handler, const char *name);

extern struct INTC_IRQ INTC_IRQ_GIPC0;

void tiny_ipc_init(void);

void tiny_ipc_isr(void);



