/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver\'s
 * applicable license agreements with MediaTek Inc.
 */

#ifndef _WDT_H_
#define _WDT_H_

#define WDT_IRQ_REG	(CORE0_WDT_IRQ + mrv_read_csr(CSR_MHARTID)*0x10000)
#define WDT_CFGREG	(CORE0_WDT_CFG + mrv_read_csr(CSR_MHARTID)*0x10000)
#define WDT_KICKREG	(CORE0_WDT_KICK + mrv_read_csr(CSR_MHARTID)*0x10000)
#define WDT_CUR_VAL_REG	(CORE0_WDT_CUR_VAL + mrv_read_csr(CSR_MHARTID)*0x10000)

#define START_WDT 0x800FFFFF  //enable wdt, timeout in 31 sec
#define KICK_WDT 0x1
#define DISABLE_WDT 0x000FFFFF
#define WDT_EN 0x1F
#define WDT_INSTANT_TRIGGER 0x0

#define SCP_GPR_REBOOT_FLAG	(SCP_GPR_CORE0_REBOOT + mrv_read_csr(CSR_MHARTID)*0x10000)

void mtk_wdt_disable(void);
void mtk_wdt_enable(void);
void mtk_wdt_restart(void);
void mtk_wdt_irq_clear(void);
int mtk_wdt_set_time_out_value(unsigned int value);
void mtk_wdt_isr(void);
void mtk_wdt_init(void);
void scp_ready_to_reboot(void);
void scp_halt_isr(void);
void mtk_halt_isr_init(void);
void scp_endless_loop(void);

#endif /* _WDT_H_ */

