/* Copyright Statement:
 *
 * @2015 MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek Inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE.
 */

#include "mt_pbfr.h"
#include "xgpt.h"
#include "encoding.h"

#ifdef CFG_PBFR_SUPPORT
#  define CFG_PBFR_SUPPORT_TESTING
#endif /* CFG_PBFR_SUPPORT */

/* temporarily use OS tick timer as wall timer */
#if defined(CFG_PBFR_SUPPORT_TESTING) && (configUSE_TICK_HOOK == 0)
#  error "Need configUSE_TICK_HOOK = 1 for PBFR testing"
#endif /* CFG_PBFR_SUPPORT */

unsigned long long pbfr_get_timestamp(int isr_ctx)
{
	unsigned long long ret;

	(void) isr_ctx;
	ret = read_xgpt_stamp_ns();
	return ret;
}

#ifdef PBFR_SUPPORT_CACHE_COUNT
unsigned long long pbfr_get_timestamp(int isr_ctx) { return 0; }
void vPortEnableCacheCount(void) {}
void vPortDisableCacheCount(void) {}
unsigned long long vPortGetICacheAccessCount(void) { return 0; }
unsigned long long vPortGetICacheMissCount(void){ return 0; }
unsigned long long vPortGetDCacheAccessCount(void) { return 0; }
unsigned long long vPortGetDCacheMissCount(void) { return 0; }
void vPortHaltCacheCount(void) {}
void vPortResumeCacheCount(void) {}
#endif

#ifdef PBFR_SUPPORT_IOSTALL
void vPortEnableIOStallRate(void) {}
void vPortDisableIOStallRate(void) {}
int vPortGetIOStallRate(void) { return 0; }
#endif
