/* Copyright Statement:
 *
 * @2015 MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek Inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE.
 */
#ifndef _MT_PBFR_H_
#define _MT_PBFR_H_

#include "encoding.h"

#define PBFR_STOP	0
#define PBFR_START	1
#define PBFR_REPORT	2

#if defined(P_MODE_0)		// task/RTOS in machine mode
#define read_mcause()  mrv_read_csr(CSR_MCAUSE)
#ifdef MRV55
#define read_micause() mrv_read_csr(MRV_VIC_MICAUSE_G)
#else
#define read_micause() mrv_read_csr(MRV_VIC_MICAUSE)
#endif
#elif defined(P_MODE_1)		// task/RTOS in user mode
#define read_mcause()  (unsigned long)syscall(SYS_get_csr, CSR_MCAUSE, 0, 0)
#ifdef MRV55
#define read_micause() (unsigned long)syscall(SYS_get_csr, MRV_VIC_MICAUSE_G, 0, 0)
#else
#define read_micause() (unsigned long)syscall(SYS_get_csr, MRV_VIC_MICAUSE, 0, 0)
#endif
#endif				/* P_MODE_0 */

/* VIC_VEC indicates the last taken interrupt vector */
#define read_taken_INT() ({ unsigned long __tmp_mc, __tmp_mic; \
  __tmp_mc = read_mcause();                                    \
  if(__tmp_mc == IRQ_M_EXT) {                                  \
    __tmp_mic = read_micause();                                \
    __tmp_mc |= (__tmp_mic << 16);                             \
  }                                                            \
  __tmp_mc;})

unsigned long long pbfr_get_timestamp(int isr_ctx);

#ifdef PBFR_SUPPORT_CACHE_COUNT
unsigned long long pbfr_get_timestamp(int isr_ctx);
void vPortEnableCacheCount(void);
void vPortDisableCacheCount(void);
unsigned long long vPortGetICacheAccessCount(void);
unsigned long long vPortGetICacheMissCount(void);
unsigned long long vPortGetDCacheAccessCount(void);
unsigned long long vPortGetDCacheMissCount(void);
void vPortHaltCacheCount(void);
void vPortResumeCacheCount(void);
#endif

#ifdef PBFR_SUPPORT_IOSTALL
void vPortEnableIOStallRate(void);
void vPortDisableIOStallRate(void);
int vPortGetIOStallRate(void);
#endif

#endif
