/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly
 * prohibited.
 */
/* MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY
 * ACKNOWLEDGES THAT IT IS RECEIVER\'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY
 * THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK
 * SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO
 * RECEIVER\'S SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN
 * FORUM. RECEIVER\'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK\'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER
 * WILL BE, AT MEDIATEK\'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE
 * AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY
 * RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation
 * ("MediaTek Software") have been modified by MediaTek Inc. All revisions are
 * subject to any receiver\'s applicable license agreements with MediaTek Inc.
 */

#include "encoding.h"
#include <stdio.h>
#include <string.h>
#include <main.h>
#include <scp_it.h>
#include <mt_printf.h>
#ifdef CFG_WDT_SUPPORT
#include <wdt.h>
#endif

TaskContext taskCtxDump[2] __attribute__((section(".sync")));
#ifdef CFG_CACHE_SUPPORT
extern void *__dram_end;
#endif

void stackDump(long epc, long stack[], long re_pc, long re_sp, long re_ra)
{
	int i;
	unsigned long tbuf_from, tbuf_to, tuf_wp;
	TaskContext *ctx_ptr = &taskCtxDump[mrv_read_csr(CSR_MHARTID)];

	ctx_ptr->x0			= DUMP_VERSION;
	ctx_ptr->x1			= stack[e_x1];
	ctx_ptr->x2			= stack[e_x2];
	ctx_ptr->x3			= stack[e_x3];
	ctx_ptr->x4			= stack[e_x4];
	ctx_ptr->x5			= stack[e_x5];
	ctx_ptr->x6			= stack[e_x6];
	ctx_ptr->x7			= stack[e_x7];
	ctx_ptr->x8			= stack[e_x8];
	ctx_ptr->x9			= stack[e_x9];
	ctx_ptr->x10		= stack[e_x10];
	ctx_ptr->x11		= stack[e_x11];
	ctx_ptr->x12		= stack[e_x12];
	ctx_ptr->x13		= stack[e_x13];
	ctx_ptr->x14		= stack[e_x14];
	ctx_ptr->x15		= stack[e_x15];
	ctx_ptr->x16		= stack[e_x16];
	ctx_ptr->x17		= stack[e_x17];
	ctx_ptr->x18		= stack[e_x18];
	ctx_ptr->x19		= stack[e_x19];
	ctx_ptr->x20		= stack[e_x20];
	ctx_ptr->x21		= stack[e_x21];
	ctx_ptr->x22		= stack[e_x22];
	ctx_ptr->x23		= stack[e_x23];
	ctx_ptr->x24		= stack[e_x24];
	ctx_ptr->x25		= stack[e_x25];
	ctx_ptr->x26		= stack[e_x26];
	ctx_ptr->x27		= stack[e_x27];
	ctx_ptr->x28		= stack[e_x28];
	ctx_ptr->x29		= stack[e_x29];
	ctx_ptr->x30		= stack[e_x30];
	ctx_ptr->x31		= stack[e_x31];
	ctx_ptr->pc		= stack[e_pc];
	ctx_ptr->mstatus		= stack[e_mstatus];
	ctx_ptr->mepc		= epc;

	PRINTF_E("Regs dump\n\r");
	PRINTF_E("x0:0x%08x x1:0x%08x\n", (uint32_t)(ctx_ptr->x0),
		(uint32_t)(ctx_ptr->x1));
	PRINTF_E("x2:0x%08x x3:0x%08x\n", (uint32_t)(ctx_ptr->x2),
		(uint32_t)(ctx_ptr->x3));
	PRINTF_E("pc:0x%08x mstatus:0x%08x\n", (uint32_t)(ctx_ptr->pc),
		(uint32_t)(ctx_ptr->mstatus));
	PRINTF_E("mepc:0x%08x\n", (uint32_t)(ctx_ptr->mepc));

	/* reset pc, sp, ra for mrv_coredump() */
	ctx_ptr->pc = re_pc;
	ctx_ptr->x2 = re_sp;
	ctx_ptr->x1 = re_ra;
#if DUMP_REG_UAM
	ctx_ptr->uab0		= stack[e_uab0];
	ctx_ptr->uas0		= stack[e_uas0];
	ctx_ptr->uam0		= stack[e_uam0];
	ctx_ptr->uab1		= stack[e_uab1];
	ctx_ptr->uas1		= stack[e_uas1];
	ctx_ptr->uam1		= stack[e_uam1];
	ctx_ptr->uab2		= stack[e_uab2];
	ctx_ptr->uas2		= stack[e_uas2];
	ctx_ptr->uam2		= stack[e_uam2];
	ctx_ptr->uab3		= stack[e_uab3];
	ctx_ptr->uas3		= stack[e_uas3];
	ctx_ptr->uam3		= stack[e_uam3];
#endif
#if DUMP_REG_ACC
	ctx_ptr->acc0l		= stack[e_acc0l];
	ctx_ptr->acc0h		= stack[e_acc0h];
	ctx_ptr->acc0g		= stack[e_acc0g];
	ctx_ptr->acc1l		= stack[e_acc1l];
	ctx_ptr->acc1h		= stack[e_acc1h];
	ctx_ptr->acc1g		= stack[e_acc1g];
	ctx_ptr->acc2l		= stack[e_acc2l];
	ctx_ptr->acc2h		= stack[e_acc2h];
	ctx_ptr->acc2g		= stack[e_acc2g];
	ctx_ptr->acc3l		= stack[e_acc3l];
	ctx_ptr->acc3h		= stack[e_acc3h];
	ctx_ptr->acc3g		= stack[e_acc3g];
#endif
#if DUMP_REG_FPU
	ctx_ptr->f0			= stack[e_f0];
	ctx_ptr->f1			= stack[e_f1];
	ctx_ptr->f2			= stack[e_f2];
	ctx_ptr->f3			= stack[e_f3];
	ctx_ptr->f4			= stack[e_f4];
	ctx_ptr->f5			= stack[e_f5];
	ctx_ptr->f6			= stack[e_f6];
	ctx_ptr->f7			= stack[e_f7];
	ctx_ptr->f8			= stack[e_f8];
	ctx_ptr->f9			= stack[e_f9];
	ctx_ptr->f10		= stack[e_f10];
	ctx_ptr->f11		= stack[e_f11];
	ctx_ptr->f12		= stack[e_f12];
	ctx_ptr->f13		= stack[e_f13];
	ctx_ptr->f14		= stack[e_f14];
	ctx_ptr->f15		= stack[e_f15];
	ctx_ptr->f16		= stack[e_f16];
	ctx_ptr->f17		= stack[e_f17];
	ctx_ptr->f18		= stack[e_f18];
	ctx_ptr->f19		= stack[e_f19];
	ctx_ptr->f20		= stack[e_f20];
	ctx_ptr->f21		= stack[e_f21];
	ctx_ptr->f22		= stack[e_f22];
	ctx_ptr->f23		= stack[e_f23];
	ctx_ptr->f24		= stack[e_f24];
	ctx_ptr->f25		= stack[e_f25];
	ctx_ptr->f26		= stack[e_f26];
	ctx_ptr->f27		= stack[e_f27];
	ctx_ptr->f28		= stack[e_f28];
	ctx_ptr->f29		= stack[e_f29];
	ctx_ptr->f30		= stack[e_f30];
	ctx_ptr->f31		= stack[e_f31];
	ctx_ptr->fcsr		= stack[e_fcsr];
#endif
#if DUMP_REG_MREG
	ctx_ptr->fflags 	= mrv_read_csr(CSR_FFLAGS);
	ctx_ptr->frm		= mrv_read_csr(CSR_FRM);
	ctx_ptr->misa		= mrv_read_csr(CSR_MISA);
	ctx_ptr->mtvec		= mrv_read_csr(CSR_MTVEC);
	ctx_ptr->mctren 	= mrv_read_csr(CSR_MCTREN);
	ctx_ptr->mflag		= 0x0;//mrv_read_csr(CSR_UFLAG);
	ctx_ptr->mcycle 	= mrv_read_csr(CSR_MCYCLE);
	ctx_ptr->mtime		= mrv_read_csr(CSR_TIMER);
	ctx_ptr->minstret		= mrv_read_csr(CSR_MINSTRET);
	ctx_ptr->mcycleh			= mrv_read_csr(CSR_MCYCLEH);
	ctx_ptr->mtimeh 		= mrv_read_csr(CSR_TIMERH);
	ctx_ptr->minstreth		= mrv_read_csr(CSR_MINSTRETH);
	ctx_ptr->mpmuctr			= mrv_read_csr(CSR_PMU_MPMUCTR);
	ctx_ptr->mtbufctr		= mrv_read_csr(CSR_TBUF_MTBUFCTR);
	ctx_ptr->mvendorid		= mrv_read_csr(CSR_MVENDORID);
	ctx_ptr->marchid			= mrv_read_csr(CSR_MARCHID);
	ctx_ptr->mimpid 		= mrv_read_csr(CSR_MIMPID);
	ctx_ptr->mhartid			= mrv_read_csr(CSR_MHARTID);
	ctx_ptr->mnpc			= mrv_read_csr(CSR_MNPC);
	ctx_ptr->mverid0			= mrv_read_csr(CSR_MVERID0);
	ctx_ptr->mverid1			= mrv_read_csr(CSR_MVERID1);
	ctx_ptr->mverid2			= mrv_read_csr(CSR_MVERID2);
	ctx_ptr->micause			= mrv_read_csr(CSR_VIC_MICAUSE);
	ctx_ptr->midbgmask		= 0x0;//mrv_read_csr(CSR_VIC_MIDBGMASK);
	ctx_ptr->midbgwakeup	= 0x0;//mrv_read_csr(CSR_VIC_MIDBGWAKEUP);
	ctx_ptr->mipend_g0		= mrv_read_csr(CSR_VIC_MIPEND_G0);
	ctx_ptr->mimask_g0		= mrv_read_csr(CSR_VIC_MIMASK_G0);
	ctx_ptr->miwakeup_g0		= mrv_read_csr(CSR_VIC_MIWAKEUP_G0);
	ctx_ptr->milsel_g0		= mrv_read_csr(CSR_VIC_MILSEL_G0);
	ctx_ptr->miemask_g0		= 0x0;//mrv_read_csr(CSR_VIC_MIEMASK_G0);
	ctx_ptr->medeleg			= mrv_read_csr(CSR_MEDELEG);
	ctx_ptr->mideleg			= mrv_read_csr(CSR_MIDELEG);
	ctx_ptr->mie			= mrv_read_csr(CSR_MIE);
	ctx_ptr->mip			= mrv_read_csr(CSR_MIP);
	ctx_ptr->mpu_en 		= mrv_read_csr(CSR_MPU_ENTRY_EN);
	ctx_ptr->mpu_litcm		= mrv_read_csr(CSR_MPU_LITCM);
	ctx_ptr->mpu_ldtcm		= mrv_read_csr(CSR_MPU_LDTCM);
	ctx_ptr->mpu_hitcm		= mrv_read_csr(CSR_MPU_HITCM);
	ctx_ptr->mpu_hdtcm		= mrv_read_csr(CSR_MPU_HDTCM);
	ctx_ptr->mpu_l00			= mrv_read_csr(CSR_MPU_L00);
	ctx_ptr->mpu_l01			= mrv_read_csr(CSR_MPU_L01);
	ctx_ptr->mpu_l02			= mrv_read_csr(CSR_MPU_L02);
	ctx_ptr->mpu_l03			= mrv_read_csr(CSR_MPU_L03);
	ctx_ptr->mpu_l04			= mrv_read_csr(CSR_MPU_L04);
	ctx_ptr->mpu_l05			= mrv_read_csr(CSR_MPU_L05);
	ctx_ptr->mpu_l06			= mrv_read_csr(CSR_MPU_L06);
	ctx_ptr->mpu_l07			= mrv_read_csr(CSR_MPU_L07);
	ctx_ptr->mpu_l08			= mrv_read_csr(CSR_MPU_L08);
	ctx_ptr->mpu_l09			= mrv_read_csr(CSR_MPU_L09);
	ctx_ptr->mpu_l10			= mrv_read_csr(CSR_MPU_L10);
	ctx_ptr->mpu_l11			= mrv_read_csr(CSR_MPU_L11);
	ctx_ptr->mpu_l12			= mrv_read_csr(CSR_MPU_L12);
	ctx_ptr->mpu_l13			= mrv_read_csr(CSR_MPU_L13);
	ctx_ptr->mpu_l14			= mrv_read_csr(CSR_MPU_L14);
	ctx_ptr->mpu_l15			= mrv_read_csr(CSR_MPU_L15);
	ctx_ptr->mpu_h00			= mrv_read_csr(CSR_MPU_H00);
	ctx_ptr->mpu_h01			= mrv_read_csr(CSR_MPU_H01);
	ctx_ptr->mpu_h02			= mrv_read_csr(CSR_MPU_H02);
	ctx_ptr->mpu_h03			= mrv_read_csr(CSR_MPU_H03);
	ctx_ptr->mpu_h04			= mrv_read_csr(CSR_MPU_H04);
	ctx_ptr->mpu_h05			= mrv_read_csr(CSR_MPU_H05);
	ctx_ptr->mpu_h06			= mrv_read_csr(CSR_MPU_H06);
	ctx_ptr->mpu_h07			= mrv_read_csr(CSR_MPU_H07);
	ctx_ptr->mpu_h08			= mrv_read_csr(CSR_MPU_H08);
	ctx_ptr->mpu_h09			= mrv_read_csr(CSR_MPU_H09);
	ctx_ptr->mpu_h10			= mrv_read_csr(CSR_MPU_H10);
	ctx_ptr->mpu_h11			= mrv_read_csr(CSR_MPU_H11);
	ctx_ptr->mpu_h12			= mrv_read_csr(CSR_MPU_H12);
	ctx_ptr->mpu_h13			= mrv_read_csr(CSR_MPU_H13);
	ctx_ptr->mpu_h14			= mrv_read_csr(CSR_MPU_H14);
	ctx_ptr->mpu_h15			= mrv_read_csr(CSR_MPU_H15);
	ctx_ptr->mdbgbp0			= mrv_read_csr(CSR_MDBGBP0);
	ctx_ptr->mdbgbp1			= mrv_read_csr(CSR_MDBGBP1);
	ctx_ptr->mdbgbp2			= mrv_read_csr(CSR_MDBGBP2);
	ctx_ptr->mdbgbp3			= mrv_read_csr(CSR_MDBGBP3);
	ctx_ptr->mdbgbpc			= mrv_read_csr(CSR_MDBGBPC);
	ctx_ptr->mdbgwpm0		= mrv_read_csr(CSR_MDBGWPM0);
	ctx_ptr->mdbgwpm1		= mrv_read_csr(CSR_MDBGWPM1);
	ctx_ptr->mdbgwpm2		= mrv_read_csr(CSR_MDBGWPM2);
	ctx_ptr->mdbgwpm3		= mrv_read_csr(CSR_MDBGWPM3);
	ctx_ptr->dscratch		= 0x0;//mrv_read_csr(CSR_DSCRATCH);
	ctx_ptr->mscratch		= mrv_read_csr(CSR_MSCRATCH);
	ctx_ptr->mcause 		= mrv_read_csr(CSR_MCAUSE);
	ctx_ptr->mtval			= mrv_read_csr(CSR_MTVAL);
	ctx_ptr->mimabtcau		= mrv_read_csr(CSR_MIMABTCAU);
	ctx_ptr->mimabtaddr		= mrv_read_csr(CSR_MIMABTADDR);

#endif

#if DUMP_REG_COP
	ctx_ptr->dcache_con			= stack[e_dcache_con];
	ctx_ptr->dcache_membar		= stack[e_dcache_membar];
	ctx_ptr->dcache_rulechk 	= stack[e_dcache_rulechk];
	ctx_ptr->dcache_rlcwmode		= stack[e_dcache_rlcwmode];
	ctx_ptr->dcache_pmask		= stack[e_dcache_pmask];
	ctx_ptr->dcache_status		= stack[e_dcache_status];
	ctx_ptr->dcache_op			= stack[e_dcache_op];
	ctx_ptr->dcache_rlcwid		= stack[e_dcache_rlcwid];
	ctx_ptr->core_pf_ctrl_0 	= stack[e_core_pf_ctrl_0];
	ctx_ptr->icache_con			= stack[e_icache_con];
	ctx_ptr->icache_op			= stack[e_icache_op];
	ctx_ptr->icache_status		= stack[e_icache_status];
	ctx_ptr->icache_membar		= stack[e_icache_membar];
#endif
#if DUMP_REG_DBG
	ctx_ptr->thread_mode_ctrl_0	= stack[e_thread_mode_ctrl_0];
	ctx_ptr->btb_con				= stack[e_btb_con];
	ctx_ptr->icache_pmask		= stack[e_icache_pmask];
	ctx_ptr->tbufctr				= stack[e_tbufctr];
	ctx_ptr->tbufclr				= stack[e_tbufclr];
	ctx_ptr->tbufstr				= stack[e_tbufstr];
	ctx_ptr->tbufrcmd			= stack[e_tbufrcmd];
	ctx_ptr->tbufrdata			= stack[e_tbufrdata];
	ctx_ptr->mtmrctr				= stack[e_mtmrctr];
	ctx_ptr->mtmrstatus			= stack[e_mtmrstatus];
	ctx_ptr->mtmrcvr				= stack[e_mtmrcvr];
	ctx_ptr->mtmrrvr				= stack[e_mtmrrvr];
	ctx_ptr->mtmrdvr				= stack[e_mtmrdvr];
#endif

#if DUMP_REG_MREG
#if 0 //not helpful
	PRINTF_E("fflags: 0x%08x\n\r", (uint32_t)(ctx_ptr->fflags));
	PRINTF_E("frm: 0x%08x\n\r", (uint32_t)(ctx_ptr->frm));
	PRINTF_E("misa: 0x%08x\n\r", (uint32_t)(ctx_ptr->misa));
	PRINTF_E("mtvec: 0x%08x\n\r", (uint32_t)(ctx_ptr->mtvec));
#endif
#if 0 //not helpful
	PRINTF_E("mctren: 0x%08x\n\r", (uint32_t)(ctx_ptr->mctren));
	PRINTF_E("mflag: 0x%08x\n\r", (uint32_t)(ctx_ptr->mflag));
	PRINTF_E("mcycle: 0x%08x\n\r", (uint32_t)(ctx_ptr->mcycle));
	PRINTF_E("mtime: 0x%08x\n\r", (uint32_t)(ctx_ptr->mtime));
	PRINTF_E("minstret: 0x%08x\n\r", (uint32_t)(ctx_ptr->minstret));
	PRINTF_E("mcycleh: 0x%08x\n\r", (uint32_t)(ctx_ptr->mcycleh));
	PRINTF_E("mtimeh: 0x%08x\n\r", (uint32_t)(ctx_ptr->mtimeh));
	PRINTF_E("minstreth: 0x%08x\n\r", (uint32_t)(ctx_ptr->minstreth));
	PRINTF_E("mpmuctr: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpmuctr));
	PRINTF_E("mtbufctr: 0x%08x\n\r", (uint32_t)(ctx_ptr->mtbufctr));
	PRINTF_E("mvendorid: 0x%08x\n\r", (uint32_t)(ctx_ptr->mvendorid));
	PRINTF_E("marchid: 0x%08x\n\r", (uint32_t)(ctx_ptr->marchid));
	PRINTF_E("mimpid: 0x%08x\n\r", (uint32_t)(ctx_ptr->mimpid));
	PRINTF_E("mhartid: 0x%08x\n\r", (uint32_t)(ctx_ptr->mhartid));
	PRINTF_E("mnpc: 0x%08x\n\r", (uint32_t)(ctx_ptr->mnpc));
	PRINTF_E("mverid0: 0x%08x\n\r", (uint32_t)(ctx_ptr->mverid0));
	PRINTF_E("mverid1: 0x%08x\n\r", (uint32_t)(ctx_ptr->mverid1));
	PRINTF_E("mverid2: 0x%08x\n\r", (uint32_t)(ctx_ptr->mverid2));
	PRINTF_E("micause: 0x%08x\n\r", (uint32_t)(ctx_ptr->micause));
	PRINTF_E("midbgmask: 0x%08x\n\r", (uint32_t)(ctx_ptr->midbgmask));
	PRINTF_E("midbgwakeup: 0x%08x\n\r", (uint32_t)(ctx_ptr->midbgwakeup));
	PRINTF_E("mipend_g0: 0x%08x\n\r", (uint32_t)(ctx_ptr->mipend_g0));
	PRINTF_E("mimask_g0: 0x%08x\n\r", (uint32_t)(ctx_ptr->mimask_g0));
	PRINTF_E("miwakeup_g0: 0x%08x\n\r", (uint32_t)(ctx_ptr->miwakeup_g0));
	PRINTF_E("milsel_g0: 0x%08x\n\r", (uint32_t)(ctx_ptr->milsel_g0));
	PRINTF_E("miemask_g0: 0x%08x\n\r", (uint32_t)(ctx_ptr->miemask_g0));
	PRINTF_E("medeleg: 0x%08x\n\r", (uint32_t)(ctx_ptr->medeleg));
	PRINTF_E("mideleg: 0x%08x\n\r", (uint32_t)(ctx_ptr->mideleg));
	PRINTF_E("mie: 0x%08x\n\r", (uint32_t)(ctx_ptr->mie));
	PRINTF_E("mip: 0x%08x\n\r", (uint32_t)(ctx_ptr->mip));
	PRINTF_E("mpu_en: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_en));
	PRINTF_E("mpu_litcm: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_litcm));
	PRINTF_E("mpu_ldtcm: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_ldtcm));
	PRINTF_E("mpu_hitcm: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_hitcm));
	PRINTF_E("mpu_hdtcm: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_hdtcm));
	PRINTF_E("mpu_l00: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l00));
	PRINTF_E("mpu_l01: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l01));
	PRINTF_E("mpu_l02: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l02));
	PRINTF_E("mpu_l03: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l03));
	PRINTF_E("mpu_l04: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l04));
	PRINTF_E("mpu_l05: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l05));
	PRINTF_E("mpu_l06: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l06));
	PRINTF_E("mpu_l07: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l07));
	PRINTF_E("mpu_l08: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l08));
	PRINTF_E("mpu_l09: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l09));
	PRINTF_E("mpu_l10: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l10));
	PRINTF_E("mpu_l11: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l11));
	PRINTF_E("mpu_l12: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l12));
	PRINTF_E("mpu_l13: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l13));
	PRINTF_E("mpu_l14: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l14));
	PRINTF_E("mpu_l15: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_l15));
	PRINTF_E("mpu_h00: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h00));
	PRINTF_E("mpu_h01: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h01));
	PRINTF_E("mpu_h02: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h02));
	PRINTF_E("mpu_h03: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h03));
	PRINTF_E("mpu_h04: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h04));
	PRINTF_E("mpu_h05: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h05));
	PRINTF_E("mpu_h06: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h06));
	PRINTF_E("mpu_h07: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h07));
	PRINTF_E("mpu_h08: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h08));
	PRINTF_E("mpu_h09: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h09));
	PRINTF_E("mpu_h10: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h10));
	PRINTF_E("mpu_h11: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h11));
	PRINTF_E("mpu_h12: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h12));
	PRINTF_E("mpu_h13: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h13));
	PRINTF_E("mpu_h14: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h14));
	PRINTF_E("mpu_h15: 0x%08x\n\r", (uint32_t)(ctx_ptr->mpu_h15));
	PRINTF_E("mdbgbp0: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgbp0));
	PRINTF_E("mdbgbp1: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgbp1));
	PRINTF_E("mdbgbp2: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgbp2));
	PRINTF_E("mdbgbp3: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgbp3));
	PRINTF_E("mdbgbpc: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgbpc));
	PRINTF_E("mdbgwpm0: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgwpm0));
	PRINTF_E("mdbgwpm1: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgwpm1));
	PRINTF_E("mdbgwpm2: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgwpm2));
	PRINTF_E("mdbgwpm3: 0x%08x\n\r", (uint32_t)(ctx_ptr->mdbgwpm3));
	PRINTF_E("dscratch: 0x%08x\n\r", (uint32_t)(ctx_ptr->dscratch));

	PRINTF_E("mscratch: 0x%08x\n\r", (uint32_t)(ctx_ptr->mscratch));
#endif
	PRINTF_E("mcause: 0x%08x\n\r", (uint32_t)(ctx_ptr->mcause));
	PRINTF_E("mtval: 0x%08x\n\r", (uint32_t)(ctx_ptr->mtval));
#if 0 //not helpful
	PRINTF_E("mimabtcau: 0x%08x\n\r", (uint32_t)(ctx_ptr->mimabtcau));
	PRINTF_E("mimabtaddr: 0x%08x\n\r", (uint32_t)(ctx_ptr->mimabtaddr));
#endif
#endif

	PRINTF_E("T Buff(%x)\n",
		(uint32_t)mrv_read_csr(CSR_TBUF_MTBUFCTR));
	tuf_wp = (mrv_read_csr(CSR_TBUF_MTBUFSTR) >> 4);
	//PRINTF_E("wp %x\n", (uint32_t)tuf_wp);
	for(i = 0;i < 16; i++) {
		tbuf_from = ((0x1 << CSR_TBUF_MTBUFRCMD_R)
			| (((tuf_wp + i) & 0xf) << CSR_TBUF_MTBUFRCMD_RP)
			| (0 << CSR_TBUF_MTBUFRCMD_LOG));
		tbuf_to = ((0x1 << CSR_TBUF_MTBUFRCMD_R)
			| (((tuf_wp + i) & 0xf) << CSR_TBUF_MTBUFRCMD_RP)
			| (1 << CSR_TBUF_MTBUFRCMD_LOG));
		mrv_set_csr(CSR_TBUF_MTBUFRCMD, tbuf_from);
		tbuf_from = mrv_read_csr(CSR_TBUF_MTBUFRDATA);
		mrv_set_csr(CSR_TBUF_MTBUFRCMD, tbuf_to);
		tbuf_to = mrv_read_csr(CSR_TBUF_MTBUFRDATA);
		PRINTF_E("%02d 0x%08x:0x%08x\n",i ,
			(uint32_t)(tbuf_from), (uint32_t)(tbuf_to));
	}
#ifdef CFG_CACHE_SUPPORT
	if ((epc & 0x2) || ( (uint32_t)epc >= ((uint32_t)(&__dram_end))))
#else
	if (epc & 0x2)
#endif
		return;

	PRINTF_E("Code: %04x %04x %04x %04x <%04x> %04x %04x %04x %04x\n",
		*(uint16_t *)(epc-8),*(uint16_t *)(epc-6),
		*(uint16_t *)(epc-4), *(uint16_t *)(epc-2),
		*(uint16_t *)(epc), *(uint16_t *)(epc+2),
		*(uint16_t *)(epc+4), *(uint16_t *)(epc+6),
		*(uint16_t *)(epc+8));

}

void mt_ram_dump_init(void)
{
    memset(&taskCtxDump, 0, sizeof(taskCtxDump));
    PRINTF_E("ram dump: %p\n\r", &taskCtxDump);
}

#ifdef CFG_STACK_PROTECTOR
void __stack_chk_fail(void);

void __stack_chk_fail()
{
    printf("__stack_chk_fail() %p\n", __builtin_return_address(0));
    while(1);
}

void *__stack_chk_guard = (void *)(0x99999999);

#endif

