#!/usr/bin/env python
# coding: UTF-8

import sys, getopt
import string
import struct
import operator
import re
import os

exclude_list = []
exclude_files = ''
link_ld_content = []
def usage():
	print 'link_ld.py -i <input> -o <output>'

def exclude_list_search(inputfile):
	global exclude_list
	global exclude_files
	global link_ld_content
	fo = open(inputfile,'rb+')
	line = "gaia"
	while line:
		line = fo.readline()
		m0 = re.findall('\$(.+?\.o[bj]*)\$', line)
		if m0:
			exclude_list += m0
			line = line.replace('$', '')
		link_ld_content.append(line)
	fo.close()
	#print link_ld_content
	exclude_list = list(dict.fromkeys(exclude_list))
	#print exclude_list
	exclude_files += " ".join(exclude_list)

def regen_link_ld(outputfile):
	global exclude_list
	global link_ld_content
	fo = open(outputfile,'w')

	line=link_ld_content.pop(0)
	while line:
		m0 = re.match('[ \t]*@\*@\(', line)
		if m0:
			line = line.replace(m0.group(0), "*(EXCLUDE_FILE(" + exclude_files +")")
			#print m0.group(0)
		#print line
		fo.write(line)
		line=link_ld_content.pop(0)
	fo.close()

def main(argv):
	inputfile = ''
	outputfile = ''
	try:
		opts, args = getopt.getopt(argv,"hi:o:",["ifile=","ofile="])
	except getopt.GetoptError:
		usage()
		sys.exit(2)
	for opt, arg in opts:
		if opt == '-h':
			usage()
			sys.exit()
		elif opt in ("-i", "--ifile"):
			inputfile = arg
		elif opt in ("-o", "--ofile"):
			outputfile = arg
	print 'intput：', inputfile
	print 'output：', outputfile
	exclude_list_search(inputfile)
	regen_link_ld(outputfile)

if '__main__'==__name__:
	ret = main(sys.argv[1:])
	sys.exit(ret)

