#!/bin/sh

if [ "$1" == "start" ]; then
	ifconfig ap0 192.168.15.1 netmask 255.255.255.240

	if [ $? != 0 ]; then
		exit 1
	fi
	mkdir -p /run/wg870/dnsmasq.d
	echo "port=0" > /run/wg870/dnsmasq.conf
	echo "interface=ap0" >> /run/wg870/dnsmasq.conf
	echo "listen-address=192.168.15.1" >> /run/wg870/dnsmasq.conf
	echo "bind-interfaces"  >> /run/wg870/dnsmasq.conf
	echo "localise-queries" >> /run/wg870/dnsmasq.conf
	echo "dhcp-range=192.168.15.2,192.168.15.14,255.255.255.240,1h"  >> /run/wg870/dnsmasq.conf
	ps -eo "%p %a" | grep "/usr/bin/dnsmasq -x /run/wg870/dnsmasq.pid" | grep -v grep
	if [ $? != 0 ]; then
		/usr/bin/dnsmasq -x /run/wg870/dnsmasq.pid -7 /run/wg870/dnsmasq.d --local-service -C /run/wg870/dnsmasq.conf -r /run/wg870
	fi

elif [ "$1" == "stop" ]; then
	ps -eo "%p %a" | grep "/usr/bin/dnsmasq -x /run/wg870/dnsmasq.pid" | grep -v grep | awk '{print "kill "$1}' | sh
	ifconfig ap0 down
	if [ $? != 0 ]; then
		exit 1
	fi
else
	exit 2
fi

exit 0
