#!/bin/sh

for ((i=0; i < 10; i++)); do
	state=`systemctl is-active wg870_drv_insmod.service`
	if [ "$state" == "active" ]; then
		break	
	elif [ "$state" != "activating" ]; then

		systemctl start wg870_drv_insmod.service
	fi
	usleep 100000 
done

if [ "$state" != "active" ]; then
	exit 1
fi

for ((i=0; i < 10; i++)); do
	connmanctl technologies | grep -q "/net/connman/technology/wifi"
	if [ $? == 0 ]; then
		connman_started=1
		break
	fi
done

if [ "$connman_started" == ""]; then
	exit 2
fi

ifconfig | grep -q wlan0

if [ $? != 0 ]; then
	connmanctl enable wifi

	for ((i=0; i < 5; i++)); do
		usleep 100000 
		ifconfig | grep -q wlan0
		if [ $? == 0 ]; then
			wlan0_started=1
			wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=wlan0 disconnect
			break
		fi
	done
else
	wlan0_started=1
fi


if [ "$wlan0_started" == ""]; then
    exit 3
fi

ifconfig | grep -q ap0

if [ $? != 0 ]; then
	wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=wlan0 DRIVER interface_create ap0
	connmanctl tether wifi on lynq 1qaz@WSX#$%^

	for ((i=0; i < 5; i++)); do
		usleep 100000 
		ifconfig | grep -q ap0
		if [ $? == 0 ]; then
			ap0_started=1
			wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=ap0 disconnect
			break
		fi
	done
else
	ap0_started=1
fi


if [ "$ap0_started" == ""]; then
    exit 4
fi

