/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 */

#ifndef __PWR_CTRL_H__
#define __PWR_CTRL_H__

/* SPM_WAKEUP_MISC */
#define WAKE_MISC_GIC_WAKEUP              0x3FF  /* bit0 ~ bit9 */
#define WAKE_MISC_DVFSRC_IRQ	         (1U << 16)
#define WAKE_MISC_REG_CPU_WAKEUP         (1U << 17)
#define WAKE_MISC_PCM_TIMER_EVENT        (1U << 18)
#define WAKE_MISC_PMIC_OUT_B		     ((1U << 19) | (1U << 20))
#define WAKE_MISC_TWAM_IRQ_B             (1U << 21)
#define WAKE_MISC_PMSR_IRQ_B_SET0        (1U << 22)
#define WAKE_MISC_PMSR_IRQ_B_SET1        (1U << 23)
#define WAKE_MISC_PMSR_IRQ_B_SET2        (1U << 24)
#define WAKE_MISC_SPM_ACK_CHK_WAKEUP_0   (1U << 25)
#define WAKE_MISC_SPM_ACK_CHK_WAKEUP_1	 (1U << 26)
#define WAKE_MISC_SPM_ACK_CHK_WAKEUP_2	 (1U << 27)
#define WAKE_MISC_SPM_ACK_CHK_WAKEUP_3	 (1U << 28)
#define WAKE_MISC_SPM_ACK_CHK_WAKEUP_ALL (1U << 29)
#define WAKE_MISC_PMIC_IRQ_ACK			 (1U << 30)
#define WAKE_MISC_PMIC_SCP_IRQ			 (1U << 31)

struct pwr_ctrl {

	/* Auto-gen Start */
	uint32_t pcm_flags;
	uint32_t pcm_flags_cust;
	uint32_t pcm_flags_cust_set;
	uint32_t pcm_flags_cust_clr;
	uint32_t pcm_flags1;
	uint32_t pcm_flags1_cust;
	uint32_t pcm_flags1_cust_set;
	uint32_t pcm_flags1_cust_clr;
	uint32_t timer_val;
	uint32_t timer_val_cust;
	uint32_t timer_val_ramp_en;
	uint32_t timer_val_ramp_en_sec;
	uint32_t wake_src;
	uint32_t wake_src_cust;
	uint32_t wakelock_timer_val;
	uint32_t wdt_disable;

	/* SPM_AP_STANDBY_CON */
	uint8_t reg_wfi_op;
	uint8_t reg_wfi_type;
	uint8_t reg_mp0_cputop_idle_mask;
	uint8_t reg_mp1_cputop_idle_mask;
	uint8_t reg_mcusys_idle_mask;
	uint8_t reg_md_apsrc_1_sel;
	uint8_t reg_md_apsrc_0_sel;
	uint8_t reg_conn_apsrc_sel;

	/* SPM_SRC6_MASK */
	uint8_t reg_dpmaif_srcclkena_mask_b;
	uint8_t reg_dpmaif_infra_req_mask_b;
	uint8_t reg_dpmaif_apsrc_req_mask_b;
	uint8_t reg_dpmaif_vrf18_req_mask_b;
	uint8_t reg_dpmaif_ddr_en_mask_b;
	uint8_t reg_pcie1_active_srcclkena_mask_b;
	uint8_t reg_pcie1_active_infra_req_mask_b;
	uint8_t reg_pcie1_active_apsrc_req_mask_b;
	uint8_t reg_pcie1_active_vrf18_req_mask_b;
	uint8_t reg_pcie1_active_ddr_en_mask_b;
	uint8_t reg_pcie2_active_srcclkena_mask_b;
	uint8_t reg_pcie2_active_infra_req_mask_b;
	uint8_t reg_pcie2_active_apsrc_req_mask_b;
	uint8_t reg_pcie2_active_vrf18_req_mask_b;
	uint8_t reg_pcie2_active_ddr_en_mask_b;
	uint8_t reg_pcie3_active_srcclkena_mask_b;
	uint8_t reg_pcie3_active_infra_req_mask_b;
	uint8_t reg_pcie3_active_apsrc_req_mask_b;
	uint8_t reg_pcie3_active_vrf18_req_mask_b;
	uint8_t reg_pcie3_active_ddr_en_mask_b;
	uint8_t reg_pcie1_srcclkena_mask_b;
	uint8_t reg_pcie1_infra_req_mask_b;
	uint8_t reg_pcie1_apsrc_req_mask_b;
	uint8_t reg_pcie1_vrf18_req_mask_b;
	uint8_t reg_pcie1_ddr_en_mask_b;
	uint8_t reg_pcie2_srcclkena_mask_b;
	uint8_t reg_pcie2_infra_req_mask_b;
	uint8_t reg_pcie2_apsrc_req_mask_b;
	uint8_t reg_pcie2_vrf18_req_mask_b;
	uint8_t reg_pcie2_ddr_en_mask_b;
	uint8_t reg_pcie3_srcclkena_mask_b;
	uint8_t reg_pcie3_infra_req_mask_b;

	/* SPM_SRC_REQ */
	uint8_t reg_spm_apsrc_req;
	uint8_t reg_spm_f26m_req;
	uint8_t reg_spm_infra_req;
	uint8_t reg_spm_vrf18_req;
	uint8_t reg_spm_ddr_en_req;
	uint8_t reg_spm_dvfs_req;
	uint8_t reg_spm_sw_mailbox_req;
	uint8_t reg_spm_sspm_mailbox_req;
	uint8_t reg_spm_adsp_mailbox_req;
	uint8_t reg_spm_scp_mailbox_req;

	/* SPM_SRC_MASK */
	uint8_t reg_md_srcclkena_0_mask_b;
	uint8_t reg_md_srcclkena2infra_req_0_mask_b;
	uint8_t reg_md_apsrc2infra_req_0_mask_b;
	uint8_t reg_md_apsrc_req_0_mask_b;
	uint8_t reg_md_vrf18_req_0_mask_b;
	uint8_t reg_md_ddr_en_0_mask_b;
	uint8_t reg_md_srcclkena_1_mask_b;
	uint8_t reg_md_srcclkena2infra_req_1_mask_b;
	uint8_t reg_md_apsrc2infra_req_1_mask_b;
	uint8_t reg_md_apsrc_req_1_mask_b;
	uint8_t reg_md_vrf18_req_1_mask_b;
	uint8_t reg_md_ddr_en_1_mask_b;
	uint8_t reg_conn_srcclkena_mask_b;
	uint8_t reg_conn_srcclkenb_mask_b;
	uint8_t reg_conn_infra_req_mask_b;
	uint8_t reg_conn_apsrc_req_mask_b;
	uint8_t reg_conn_vrf18_req_mask_b;
	uint8_t reg_conn_ddr_en_mask_b;
	uint8_t reg_conn_vfe28_mask_b;
	uint8_t reg_srcclkeni0_srcclkena_mask_b;
	uint8_t reg_srcclkeni0_infra_req_mask_b;
	uint8_t reg_srcclkeni1_srcclkena_mask_b;
	uint8_t reg_srcclkeni1_infra_req_mask_b;
	uint8_t reg_srcclkeni2_srcclkena_mask_b;
	uint8_t reg_srcclkeni2_infra_req_mask_b;
	uint8_t reg_infrasys_apsrc_req_mask_b;
	uint8_t reg_infrasys_ddr_en_mask_b;
	uint8_t reg_md32_srcclkena_mask_b;
	uint8_t reg_md32_infra_req_mask_b;
	uint8_t reg_md32_apsrc_req_mask_b;
	uint8_t reg_md32_vrf18_req_mask_b;
	uint8_t reg_md32_ddr_en_mask_b;

	/* SPM_SRC2_MASK */
	uint8_t reg_scp_srcclkena_mask_b;
	uint8_t reg_scp_infra_req_mask_b;
	uint8_t reg_scp_apsrc_req_mask_b;
	uint8_t reg_scp_vrf18_req_mask_b;
	uint8_t reg_scp_ddr_en_mask_b;
	uint8_t reg_netsys_srcclkena_mask_b;
	uint8_t reg_netsys_infra_req_mask_b;
	uint8_t reg_netsys_apsrc_req_mask_b;
	uint8_t reg_netsys_vrf18_req_mask_b;
	uint8_t reg_netsys_ddr_en_mask_b;
	uint8_t reg_ufs_srcclkena_mask_b;
	uint8_t reg_ufs_infra_req_mask_b;
	uint8_t reg_ufs_apsrc_req_mask_b;
	uint8_t reg_ufs_vrf18_req_mask_b;
	uint8_t reg_ufs_ddr_en_mask_b;
	uint8_t reg_disp0_apsrc_req_mask_b;
	uint8_t reg_disp0_ddr_en_mask_b;
	uint8_t reg_disp1_apsrc_req_mask_b;
	uint8_t reg_disp1_ddr_en_mask_b;
	uint8_t reg_gce_infra_req_mask_b;
	uint8_t reg_gce_apsrc_req_mask_b;
	uint8_t reg_gce_vrf18_req_mask_b;
	uint8_t reg_gce_ddr_en_mask_b;
	uint8_t reg_usb_srcclkena_mask_b;
	uint8_t reg_usb_infra_req_mask_b;
	uint8_t reg_usb_apsrc_req_mask_b;
	uint8_t reg_usb_vrf18_req_mask_b;
	uint8_t reg_usb_ddr_en_mask_b;
	uint8_t reg_cg_check_srcclkena_mask_b;
	uint8_t reg_cg_check_apsrc_req_mask_b;
	uint8_t reg_cg_check_vrf18_req_mask_b;
	uint8_t reg_cg_check_ddr_en_mask_b;

	/* SPM_SRC3_MASK */
	uint8_t reg_dvfsrc_event_trigger_mask_b;
	uint8_t reg_sw2spm_int0_mask_b;
	uint8_t reg_sw2spm_int1_mask_b;
	uint8_t reg_sw2spm_int2_mask_b;
	uint8_t reg_sw2spm_int3_mask_b;
	uint8_t reg_sc_adsp2spm_wakeup_mask_b;
	uint8_t reg_sc_sspm2spm_wakeup_mask_b;
	uint8_t reg_sc_scp2spm_wakeup_mask_b;
	uint8_t reg_csyspwrreq_mask;
	uint8_t reg_spm_srcclkena_reserved_mask_b;
	uint8_t reg_spm_infra_req_reserved_mask_b;
	uint8_t reg_spm_apsrc_req_reserved_mask_b;
	uint8_t reg_spm_vrf18_req_reserved_mask_b;
	uint8_t reg_spm_ddr_en_reserved_mask_b;
	uint8_t reg_mcupm_srcclkena_mask_b;
	uint8_t reg_mcupm_infra_req_mask_b;
	uint8_t reg_mcupm_apsrc_req_mask_b;
	uint8_t reg_mcupm_vrf18_req_mask_b;
	uint8_t reg_mcupm_ddr_en_mask_b;
	uint8_t reg_msdc0_srcclkena_mask_b;
	uint8_t reg_msdc0_infra_req_mask_b;
	uint8_t reg_msdc0_apsrc_req_mask_b;
	uint8_t reg_msdc0_vrf18_req_mask_b;
	uint8_t reg_msdc0_ddr_en_mask_b;
	uint8_t reg_msdc1_srcclkena_mask_b;
	uint8_t reg_msdc1_infra_req_mask_b;
	uint8_t reg_msdc1_apsrc_req_mask_b;
	uint8_t reg_msdc1_vrf18_req_mask_b;
	uint8_t reg_msdc1_ddr_en_mask_b;

	/* SPM_SRC4_MASK */
	uint32_t ccif_event_mask_b;
	uint8_t reg_audio_srcclkena_mask_b;
	uint8_t reg_audio_infra_req_mask_b;
	uint8_t reg_audio_apsrc_req_mask_b;
	uint8_t reg_audio_vrf18_req_mask_b;
	uint8_t reg_audio_ddr_en_mask_b;
	uint8_t reg_dramc0_md32_infra_req_mask_b;
	uint8_t reg_dramc0_md32_vrf18_req_mask_b;
	uint8_t reg_dramc1_md32_infra_req_mask_b;
	uint8_t reg_dramc1_md32_vrf18_req_mask_b;
	uint8_t reg_conn_srcclkenb2pwrap_mask_b;
	uint8_t reg_dramc0_md32_wakeup_mask;
	uint8_t reg_dramc1_md32_wakeup_mask;
	uint8_t reg_cldma_srcclkena_mask_b;
	uint8_t reg_cldma_infra_req_mask_b;
	uint8_t reg_cldma_apsrc_req_mask_b;
	uint8_t reg_cldma_vrf18_req_mask_b;

	/* SPM_SRC5_MASK */
	uint32_t reg_mcusys_merge_apsrc_req_mask_b;
	uint32_t reg_mcusys_merge_ddr_en_mask_b;
	uint8_t reg_pcie_active_srcclkena_mask_b;
	uint8_t reg_pcie_active_infra_req_mask_b;
	uint8_t reg_pcie_active_apsrc_req_mask_b;
	uint8_t reg_pcie_active_vrf18_req_mask_b;
	uint8_t reg_pcie_active_ddr_en_mask_b;
	uint8_t reg_pcie_srcclkena_mask_b;
	uint8_t reg_pcie_infra_req_mask_b;
	uint8_t reg_pcie_apsrc_req_mask_b;
	uint8_t reg_pcie_vrf18_req_mask_b;
	uint8_t reg_pcie_ddr_en_mask_b;
	uint8_t reg_pcie3_ddr_en_mask_b;
	uint8_t reg_pcie3_apsrc_req_mask_b;
	uint8_t reg_pcie3_vrf18_req_mask_b;

	/* SPM_WAKEUP_EVENT_MASK */
	uint32_t reg_wakeup_event_mask;

	/* SPM_WAKEUP_EVENT_EXT_MASK */
	uint32_t reg_ext_wakeup_event_mask;

	/* Auto-gen End */
};

/* code gen by convert_SPM_FS.py, need struct pwr_ctrl */
enum pwr_ctrl_enum {
	PW_PCM_FLAGS,
	PW_PCM_FLAGS_CUST,
	PW_PCM_FLAGS_CUST_SET,
	PW_PCM_FLAGS_CUST_CLR,
	PW_PCM_FLAGS1,
	PW_PCM_FLAGS1_CUST,
	PW_PCM_FLAGS1_CUST_SET,
	PW_PCM_FLAGS1_CUST_CLR,
	PW_TIMER_VAL,
	PW_TIMER_VAL_CUST,
	PW_TIMER_VAL_RAMP_EN,
	PW_TIMER_VAL_RAMP_EN_SEC,
	PW_WAKE_SRC,
	PW_WAKE_SRC_CUST,
	PW_WAKELOCK_TIMER_VAL,
	PW_WDT_DISABLE,

	/* SPM_AP_STANDBY_CON */
	PW_REG_WFI_OP,
	PW_REG_WFI_TYPE,
	PW_REG_MP0_CPUTOP_IDLE_MASK,
	PW_REG_MP1_CPUTOP_IDLE_MASK,
	PW_REG_MCUSYS_IDLE_MASK,
	PW_REG_MD_APSRC_1_SEL,
	PW_REG_MD_APSRC_0_SEL,
	PW_REG_CONN_APSRC_SEL,

	/* SPM_SRC6_MASK */
	PW_REG_DPMAIF_SRCCLKENA_MASK_B,
	PW_REG_DPMAIF_INFRA_REQ_MASK_B,
	PW_REG_DPMAIF_APSRC_REQ_MASK_B,
	PW_REG_DPMAIF_VRF18_REQ_MASK_B,
	PW_REG_DPMAIF_DDR_EN_MASK_B,
	PW_REG_PCIE1_ACTIVE_SRCCLKENA_MASK_B,
	PW_REG_PCIE1_ACTIVE_INFRA_REQ_MASK_B,
	PW_REG_PCIE1_ACTIVE_APSRC_REQ_MASK_B,
	PW_REG_PCIE1_ACTIVE_VRF18_REQ_MASK_B,
	PW_REG_PCIE1_ACTIVE_DDR_EN_MASK_B,
	PW_REG_PCIE2_ACTIVE_SRCCLKENA_MASK_B,
	PW_REG_PCIE2_ACTIVE_INFRA_REQ_MASK_B,
	PW_REG_PCIE2_ACTIVE_APSRC_REQ_MASK_B,
	PW_REG_PCIE2_ACTIVE_VRF18_REQ_MASK_B,
	PW_REG_PCIE2_ACTIVE_DDR_EN_MASK_B,
	PW_REG_PCIE3_ACTIVE_SRCCLKENA_MASK_B,
	PW_REG_PCIE3_ACTIVE_INFRA_REQ_MASK_B,
	PW_REG_PCIE3_ACTIVE_APSRC_REQ_MASK_B,
	PW_REG_PCIE3_ACTIVE_VRF18_REQ_MASK_B,
	PW_REG_PCIE3_ACTIVE_DDR_EN_MASK_B,
	PW_REG_PCIE1_SRCCLKENA_MASK_B,
	PW_REG_PCIE1_INFRA_REQ_MASK_B,
	PW_REG_PCIE1_APSRC_REQ_MASK_B,
	PW_REG_PCIE1_VRF18_REQ_MASK_B,
	PW_REG_PCIE1_DDR_EN_MASK_B,
	PW_REG_PCIE2_SRCCLKENA_MASK_B,
	PW_REG_PCIE2_INFRA_REQ_MASK_B,
	PW_REG_PCIE2_APSRC_REQ_MASK_B,
	PW_REG_PCIE2_VRF18_REQ_MASK_B,
	PW_REG_PCIE2_DDR_EN_MASK_B,
	PW_REG_PCIE3_SRCCLKENA_MASK_B,
	PW_REG_PCIE3_INFRA_REQ_MASK_B,

	/* SPM_SRC_REQ */
	PW_REG_SPM_APSRC_REQ,
	PW_REG_SPM_F26M_REQ,
	PW_REG_SPM_INFRA_REQ,
	PW_REG_SPM_VRF18_REQ,
	PW_REG_SPM_DDR_EN_REQ,
	PW_REG_SPM_DVFS_REQ,
	PW_REG_SPM_SW_MAILBOX_REQ,
	PW_REG_SPM_SSPM_MAILBOX_REQ,
	PW_REG_SPM_ADSP_MAILBOX_REQ,
	PW_REG_SPM_SCP_MAILBOX_REQ,

	/* SPM_SRC_MASK */
	PW_REG_MD_SRCCLKENA_0_MASK_B,
	PW_REG_MD_SRCCLKENA2INFRA_REQ_0_MASK_B,
	PW_REG_MD_APSRC2INFRA_REQ_0_MASK_B,
	PW_REG_MD_APSRC_REQ_0_MASK_B,
	PW_REG_MD_VRF18_REQ_0_MASK_B,
	PW_REG_MD_DDR_EN_0_MASK_B,
	PW_REG_MD_SRCCLKENA_1_MASK_B,
	PW_REG_MD_SRCCLKENA2INFRA_REQ_1_MASK_B,
	PW_REG_MD_APSRC2INFRA_REQ_1_MASK_B,
	PW_REG_MD_APSRC_REQ_1_MASK_B,
	PW_REG_MD_VRF18_REQ_1_MASK_B,
	PW_REG_MD_DDR_EN_1_MASK_B,
	PW_REG_CONN_SRCCLKENA_MASK_B,
	PW_REG_CONN_SRCCLKENB_MASK_B,
	PW_REG_CONN_INFRA_REQ_MASK_B,
	PW_REG_CONN_APSRC_REQ_MASK_B,
	PW_REG_CONN_VRF18_REQ_MASK_B,
	PW_REG_CONN_DDR_EN_MASK_B,
	PW_REG_CONN_VFE28_MASK_B,
	PW_REG_SRCCLKENI0_SRCCLKENA_MASK_B,
	PW_REG_SRCCLKENI0_INFRA_REQ_MASK_B,
	PW_REG_SRCCLKENI1_SRCCLKENA_MASK_B,
	PW_REG_SRCCLKENI1_INFRA_REQ_MASK_B,
	PW_REG_SRCCLKENI2_SRCCLKENA_MASK_B,
	PW_REG_SRCCLKENI2_INFRA_REQ_MASK_B,
	PW_REG_INFRASYS_APSRC_REQ_MASK_B,
	PW_REG_INFRASYS_DDR_EN_MASK_B,
	PW_REG_MD32_SRCCLKENA_MASK_B,
	PW_REG_MD32_INFRA_REQ_MASK_B,
	PW_REG_MD32_APSRC_REQ_MASK_B,
	PW_REG_MD32_VRF18_REQ_MASK_B,
	PW_REG_MD32_DDR_EN_MASK_B,

	/* SPM_SRC2_MASK */
	PW_REG_SCP_SRCCLKENA_MASK_B,
	PW_REG_SCP_INFRA_REQ_MASK_B,
	PW_REG_SCP_APSRC_REQ_MASK_B,
	PW_REG_SCP_VRF18_REQ_MASK_B,
	PW_REG_SCP_DDR_EN_MASK_B,
	PW_REG_NETSYS_SRCCLKENA_MASK_B,
	PW_REG_NETSYS_INFRA_REQ_MASK_B,
	PW_REG_NETSYS_APSRC_REQ_MASK_B,
	PW_REG_NETSYS_VRF18_REQ_MASK_B,
	PW_REG_NETSYS_DDR_EN_MASK_B,
	PW_REG_UFS_SRCCLKENA_MASK_B,
	PW_REG_UFS_INFRA_REQ_MASK_B,
	PW_REG_UFS_APSRC_REQ_MASK_B,
	PW_REG_UFS_VRF18_REQ_MASK_B,
	PW_REG_UFS_DDR_EN_MASK_B,
	PW_REG_DISP0_APSRC_REQ_MASK_B,
	PW_REG_DISP0_DDR_EN_MASK_B,
	PW_REG_DISP1_APSRC_REQ_MASK_B,
	PW_REG_DISP1_DDR_EN_MASK_B,
	PW_REG_GCE_INFRA_REQ_MASK_B,
	PW_REG_GCE_APSRC_REQ_MASK_B,
	PW_REG_GCE_VRF18_REQ_MASK_B,
	PW_REG_GCE_DDR_EN_MASK_B,
	PW_REG_USB_SRCCLKENA_MASK_B,
	PW_REG_USB_INFRA_REQ_MASK_B,
	PW_REG_USB_APSRC_REQ_MASK_B,
	PW_REG_USB_VRF18_REQ_MASK_B,
	PW_REG_USB_DDR_EN_MASK_B,
	PW_REG_CG_CHECK_SRCCLKENA_MASK_B,
	PW_REG_CG_CHECK_APSRC_REQ_MASK_B,
	PW_REG_CG_CHECK_VRF18_REQ_MASK_B,
	PW_REG_CG_CHECK_DDR_EN_MASK_B,

	/* SPM_SRC3_MASK */
	PW_REG_DVFSRC_EVENT_TRIGGER_MASK_B,
	PW_REG_SW2SPM_INT0_MASK_B,
	PW_REG_SW2SPM_INT1_MASK_B,
	PW_REG_SW2SPM_INT2_MASK_B,
	PW_REG_SW2SPM_INT3_MASK_B,
	PW_REG_SC_ADSP2SPM_WAKEUP_MASK_B,
	PW_REG_SC_SSPM2SPM_WAKEUP_MASK_B,
	PW_REG_SC_SCP2SPM_WAKEUP_MASK_B,
	PW_REG_CSYSPWRREQ_MASK,
	PW_REG_SPM_SRCCLKENA_RESERVED_MASK_B,
	PW_REG_SPM_INFRA_REQ_RESERVED_MASK_B,
	PW_REG_SPM_APSRC_REQ_RESERVED_MASK_B,
	PW_REG_SPM_VRF18_REQ_RESERVED_MASK_B,
	PW_REG_SPM_DDR_EN_RESERVED_MASK_B,
	PW_REG_MCUPM_SRCCLKENA_MASK_B,
	PW_REG_MCUPM_INFRA_REQ_MASK_B,
	PW_REG_MCUPM_APSRC_REQ_MASK_B,
	PW_REG_MCUPM_VRF18_REQ_MASK_B,
	PW_REG_MCUPM_DDR_EN_MASK_B,
	PW_REG_MSDC0_SRCCLKENA_MASK_B,
	PW_REG_MSDC0_INFRA_REQ_MASK_B,
	PW_REG_MSDC0_APSRC_REQ_MASK_B,
	PW_REG_MSDC0_VRF18_REQ_MASK_B,
	PW_REG_MSDC0_DDR_EN_MASK_B,
	PW_REG_MSDC1_SRCCLKENA_MASK_B,
	PW_REG_MSDC1_INFRA_REQ_MASK_B,
	PW_REG_MSDC1_APSRC_REQ_MASK_B,
	PW_REG_MSDC1_VRF18_REQ_MASK_B,
	PW_REG_MSDC1_DDR_EN_MASK_B,

	/* SPM_SRC4_MASK */
	PW_CCIF_EVENT_MASK_B,
	PW_REG_AUDIO_SRCCLKENA_MASK_B,
	PW_REG_AUDIO_INFRA_REQ_MASK_B,
	PW_REG_AUDIO_APSRC_REQ_MASK_B,
	PW_REG_AUDIO_VRF18_REQ_MASK_B,
	PW_REG_AUDIO_DDR_EN_MASK_B,
	PW_REG_DRAMC0_MD32_INFRA_REQ_MASK_B,
	PW_REG_DRAMC0_MD32_VRF18_REQ_MASK_B,
	PW_REG_DRAMC1_MD32_INFRA_REQ_MASK_B,
	PW_REG_DRAMC1_MD32_VRF18_REQ_MASK_B,
	PW_REG_CONN_SRCCLKENB2PWRAP_MASK_B,
	PW_REG_DRAMC0_MD32_WAKEUP_MASK,
	PW_REG_DRAMC1_MD32_WAKEUP_MASK,
	PW_REG_CLDMA_SRCCLKENA_MASK_B,
	PW_REG_CLDMA_INFRA_REQ_MASK_B,
	PW_REG_CLDMA_APSRC_REQ_MASK_B,
	PW_REG_CLDMA_VRF18_REQ_MASK_B,

	/* SPM_SRC5_MASK */
	PW_REG_MCUSYS_MERGE_APSRC_REQ_MASK_B,
	PW_REG_MCUSYS_MERGE_DDR_EN_MASK_B,
	PW_REG_PCIE_ACTIVE_SRCCLKENA_MASK_B,
	PW_REG_PCIE_ACTIVE_INFRA_REQ_MASK_B,
	PW_REG_PCIE_ACTIVE_APSRC_REQ_MASK_B,
	PW_REG_PCIE_ACTIVE_VRF18_REQ_MASK_B,
	PW_REG_PCIE_ACTIVE_DDR_EN_MASK_B,
	PW_REG_PCIE_SRCCLKENA_MASK_B,
	PW_REG_PCIE_INFRA_REQ_MASK_B,
	PW_REG_PCIE_APSRC_REQ_MASK_B,
	PW_REG_PCIE_VRF18_REQ_MASK_B,
	PW_REG_PCIE_DDR_EN_MASK_B,
	PW_REG_PCIE3_DDR_EN_MASK_B,
	PW_REG_PCIE3_APSRC_REQ_MASK_B,
	PW_REG_PCIE3_VRF18_REQ_MASK_B,

	/* SPM_WAKEUP_EVENT_MASK */
	PW_REG_WAKEUP_EVENT_MASK,

	/* SPM_WAKEUP_EVENT_EXT_MASK */
	PW_REG_EXT_WAKEUP_EVENT_MASK,

	PW_MAX_COUNT,
};


#endif /* __PWR_CTRL_H__ */
