/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 */


#ifndef __MTK_SPM_COMM_H__
#define __MTK_SPM_COMM_H__

struct mtk_spm_wake_status {
	u32 r12;			/* SPM_BK_WAKE_EVENT */
	u32 r12_ext;		/* SPM_WAKEUP_EXT_STA */
	u32 raw_sta;		/* SPM_WAKEUP_STA */
	u32 raw_ext_sta;	/* SPM_WAKEUP_EXT_STA */
	u32 md32pcm_wakeup_sta;/* MD32CPM_WAKEUP_STA */
	u32 md32pcm_event_sta;/* MD32PCM_EVENT_STA */
	u32 wake_misc;		/* SPM_BK_WAKE_MISC */
	u32 timer_out;		/* SPM_BK_PCM_TIMER */
	u32 r13;			/* PCM_REG13_DATA */
	u32 idle_sta;		/* SUBSYS_IDLE_STA */
	u32 req_sta0;		/* SRC_REQ_STA_0 */
	u32 req_sta1;		/* SRC_REQ_STA_1 */
	u32 req_sta2;		/* SRC_REQ_STA_2 */
	u32 req_sta3;		/* SRC_REQ_STA_3 */
	u32 req_sta4;		/* SRC_REQ_STA_4 */
	u32 cg_check_sta;	/* SPM_CG_CHECK_STA */
	u32 debug_flag;		/* PCM_WDT_LATCH_SPARE_0 */
	u32 debug_flag1;	/* PCM_WDT_LATCH_SPARE_1 */
	u32 b_sw_flag0;		/* SPM_SW_RSV_7 */
	u32 b_sw_flag1;		/* SPM_SW_RSV_8 */
	u32 isr;			/* SPM_IRQ_STA */
	u32 sw_flag0;		/* SPM_SW_FLAG_0 */
	u32 sw_flag1;		/* SPM_SW_FLAG_1 */
	u32 clk_settle;		/* SPM_CLK_SETTLE */
	u32 src_req;	/* SPM_SRC_REQ */
	u32 log_index;
	u32 is_abort;
	u32 rt_req_sta0; /* SPM_SW_RSV_2 */
	u32 rt_req_sta1; /* SPM_SW_RSV_3 */
	u32 rt_req_sta2; /* SPM_SW_RSV_4 */
	u32 rt_req_sta3; /* SPM_SW_RSV_5 */
	u32 rt_req_sta4; /* SPM_SW_RSV_6 */
	u32 mcupm_req_sta;
};

struct spm_wakesrc_irq_list {
	unsigned int wakesrc;
	const char *name;
	int order;
	unsigned int irq_no;
};

/*
 * Auto generated by DE, please DO NOT modify this file directly.
 * From Legacy sleep_def.h
 */
/* --- SPM Flag Define --- */
#define SPM_FLAG_DISABLE_CPU_PDN                 (0x1U << 0)
#define SPM_FLAG_DISABLE_INFRA_PDN               (0x1U << 1)
#define SPM_FLAG_DISABLE_DDRPHY_PDN              (0x1U << 2)
#define SPM_FLAG_DISABLE_VCORE_DVS               (0x1U << 3)
#define SPM_FLAG_DISABLE_VCORE_DFS               (0x1U << 4)
#define SPM_FLAG_DISABLE_COMMON_SCENARIO         (0x1U << 5)
#define SPM_FLAG_DISABLE_BUS_CLK_OFF             (0x1U << 6)
#define SPM_FLAG_DISABLE_ARMPLL_OFF              (0x1U << 7)
#define SPM_FLAG_KEEP_CSYSPWRACK_HIGH            (0x1U << 8)
#define SPM_FLAG_ENABLE_LVTS_WORKAROUND          (0x1U << 9)
#define SPM_FLAG_RUN_COMMON_SCENARIO             (0x1U << 10)
#define SPM_FLAG_USE_LEGACY_26M_WAKE_ISR         (0x1U << 11)
#define SPM_FLAG_ENABLE_SPM_DBG_WDT_DUMP         (0x1U << 12)
#define SPM_FLAG_DISABLE_26M_OFF                 (0x1U << 13)
#define SPM_FLAG_ENABLE_PCIE_0P6V_WORKAROUND     (0x1U << 14)
#define SPM_FLAG_DISABLE_SYSRAM_SLEEP            (0x1U << 16)
#define SPM_FLAG_DISABLE_SSPM_SRAM_SLEEP         (0x1U << 17)
#define SPM_FLAG_DISABLE_MCUPM_PDN               (0x1U << 18)
#define SPM_FLAG_ENABLE_MSDC_CONTROL             (0x1U << 19)
#define SPM_FLAG_USE_SRCCLKENO2                  (0x1U << 20)
#define SPM_FLAG_DISABLE_DRAMC_MCU_SRAM_SLEEP    (0x1U << 22)
#define SPM_FLAG_DISABLE_DRAMC_MCU_OFF           (0x1U << 23)
#define SPM_FLAG_NETSYS_DVFS_ENABLE              (0x1U << 24)
#define SPM_FLAG_ENABLE_MD_MUMTAS                (0x1U << 25)
#define SPM_FLAG_CPUEB_DEBUG                     (0x1U << 26)
#define SPM_FLAG_VTCXO_STATE                     (0x1U << 27)
#define SPM_FLAG_INFRA_STATE                     (0x1U << 28)
#define SPM_FLAG_APSRC_STATE                     (0x1U << 29)
#define SPM_FLAG_VRF18_STATE                     (0x1U << 30)
#define SPM_FLAG_DDREN_STATE                     (0x1U << 31)

/* --- SPM Flag1 Define --- */
#define SPM_FLAG1_DISABLE_AXI_BUS_TO_26M        (0x1U << 0)
#define SPM_FLAG1_DISABLE_SYSPLL_OFF            (0x1U << 1)
#define SPM_FLAG1_DISABLE_PWRAP_CLK_SWITCH      (0x1U << 2)
#define SPM_FLAG1_DISABLE_ULPOSC_OFF            (0x1U << 3)
#define SPM_FLAG1_FW_SET_ULPOSC_ON              (0x1U << 4)
#define SPM_FLAG1_ENABLE_REKICK                 (0x1U << 5)
#define SPM_FLAG1_DISABLE_NO_RESUME             (0x1U << 6)
#define SPM_FLAG1_ENABLE_BIG_BUCK_OFF           (0x1U << 7)
#define SPM_FLAG1_ENABLE_BIG_BUCK_ON            (0x1U << 8)
#define SPM_FLAG1_FORCE_CPU_BUCK_OFF            (0x1U << 9)
#define SPM_FLAG1_DISABLE_SRCLKEN_LOW           (0x1U << 10)
#define SPM_FLAG1_DISABLE_SCP_CLK_SWITCH        (0x1U << 11)
#define SPM_FLAG1_DISABLE_TOP_26M_CK_OFF        (0x1U << 12)
#define SPM_FLAG1_DISABLE_PCM_26M_SWITCH        (0x1U << 13)
#define SPM_FLAG1_DISABLE_CKSQ_OFF              (0x1U << 14)
#define SPM_FLAG1_DISABLE_UNIPLL_OFF            (0x1U << 15)
#define SPM_FLAG1_ENABLE_SGMIISPLL_CON          (0x1U << 16)
#define SPM_FLAG1_DISABLE_PCIE_RESUME_DEBOUNCE  (0x1U << 17)
#define SPM_FLAG1_ENABLE_PCIE_SRAM_AUTO_OFF     (0x1U << 18)
#define SPM_FLAG1_DISABLE_DEVAPC_SRAM_SLEEP     (0x1U << 20)
#define SPM_FLAG1_DISABLE_AXI_MEM_CLK_OFF       (0x1U << 21)
#define SPM_FLAG1_DISABLE_VS1_VOTER             (0x1U << 22)
#define SPM_FLAG1_DISABLE_VS2_VOTER             (0x1U << 23)
#define SPM_FLAG1_DISABLE_SCP_VREQ_MASK_CONTROL (0x1U << 24)

/* --- SPM DEBUG Define --- */
#define SPM_DBG_DEBUG_IDX_26M_WAKE                 (0x1U << 0)
#define SPM_DBG_DEBUG_IDX_26M_SLEEP                (0x1U << 1)
#define SPM_DBG_DEBUG_IDX_INFRA_WAKE               (0x1U << 2)
#define SPM_DBG_DEBUG_IDX_INFRA_SLEEP              (0x1U << 3)
#define SPM_DBG_DEBUG_IDX_APSRC_WAKE               (0x1U << 4)
#define SPM_DBG_DEBUG_IDX_APSRC_SLEEP              (0x1U << 5)
#define SPM_DBG_DEBUG_IDX_VRF18_WAKE               (0x1U << 6)
#define SPM_DBG_DEBUG_IDX_VRF18_SLEEP              (0x1U << 7)
#define SPM_DBG_DEBUG_IDX_DDREN_WAKE               (0x1U << 8)
#define SPM_DBG_DEBUG_IDX_DDREN_SLEEP              (0x1U << 9)
#define SPM_DBG_DEBUG_IDX_DRAM_SREF_ABORT_IN_APSRC (0x1U << 10)
#define SPM_DBG_DEBUG_IDX_DRAM_SREF_ABORT_IN_DDREN (0x1U << 11)
#define SPM_DBG_DEBUG_IDX_CPUEB_PDN                (0x1U << 12)
#define SPM_DBG_DEBUG_IDX_CPUEB_ON                 (0x1U << 13)
#define SPM_DBG_DEBUG_IDX_CPUEB_BEFORE_ON          (0x1U << 14)
#define SPM_DBG_DEBUG_IDX_CPUEB_ABORT              (0x1U << 15)
#define SPM_DBG_DEBUG_IDX_SYSRAM_SLP               (0x1U << 16)
#define SPM_DBG_DEBUG_IDX_SSPM_WFI                 (0x1U << 17)
#define SPM_DBG_DEBUG_IDX_SSPM_SRAM_SLP            (0x1U << 18)
#define SPM_DBG_DEBUG_IDX_SSPM_ON                  (0x1U << 19)
#define SPM_DBG_DEBUG_IDX_SYSRAM_ON                (0x1U << 20)
#define SPM_DBG_DEBUG_IDX_ENTER_RESOURCE           (0x1U << 21)
#define SPM_DBG_DEBUG_IDX_PCIE_FORCE_0P6V          (0x1U << 22)
#define SPM_DBG_DEBUG_IDX_SSPM_ABORT               (0x1U << 23)
#define SPM_DBG_DEBUG_IDX_VMDDQ_OFF                (0x1U << 24)
#define SPM_DBG_DEBUG_IDX_VMDDQ_ON                 (0x1U << 25)
#define SPM_DBG_DEBUG_IDX_DVFS                     (0x1U << 26)
#define SPM_DBG_DEBUG_IDX_DVFS_CROSS               (0x1U << 27)
#define SPM_DBG_DEBUG_IDX_SPM_GO_WAKEUP_NOW        (0x1U << 28)
#define SPM_DBG_DEBUG_IDX_APSRC_SLEEP_ABORT        (0x1U << 29)

/* --- SPM DEBUG1 Define --- */
#define SPM_DBG1_DEBUG_IDX_CURRENT_IS_LP                (0x1U << 0)
#define SPM_DBG1_DEBUG_IDX_VCORE_DVFS_START             (0x1U << 1)
#define SPM_DBG1_DEBUG_IDX_SYSPLL_OFF                   (0x1U << 2)
#define SPM_DBG1_DEBUG_IDX_SYSPLL_ON                    (0x1U << 3)
#define SPM_DBG1_DEBUG_IDX_CURRENT_IS_VCORE_DFS         (0x1U << 4)
#define SPM_DBG1_DEBUG_IDX_INFRA_MTCMOS_OFF             (0x1U << 5)
#define SPM_DBG1_DEBUG_IDX_INFRA_MTCMOS_ON              (0x1U << 6)
#define SPM_DBG1_DEBUG_IDX_VTCXO_SLEEP_ABORT_0          (0x1U << 7)
#define SPM_DBG1_DEBUG_IDX_VTCXO_SLEEP_ABORT_1          (0x1U << 8)
#define SPM_DBG1_DEBUG_IDX_NOISE_IRQ                    (0x1U << 9)
#define SPM_DBG1_DEBUG_IDX_PWRAP_CLK_TO_ULPOSC          (0x1U << 11)
#define SPM_DBG1_DEBUG_IDX_PWRAP_CLK_TO_26M             (0x1U << 12)
#define SPM_DBG1_DEBUG_IDX_SCP_CLK_TO_32K               (0x1U << 13)
#define SPM_DBG1_DEBUG_IDX_SCP_CLK_TO_26M               (0x1U << 14)
#define SPM_DBG1_DEBUG_IDX_BUS_CLK_OFF                  (0x1U << 15)
#define SPM_DBG1_DEBUG_IDX_BUS_CLK_ON                   (0x1U << 16)
#define SPM_DBG1_DEBUG_IDX_SRCLKEN2_LOW                 (0x1U << 17)
#define SPM_DBG1_DEBUG_IDX_SRCLKEN2_HIGH                (0x1U << 18)
#define SPM_DBG1_DEBUG_IDX_ULPOSC_IS_OFF_BUT_SHOULD_ON  (0x1U << 20)
#define SPM_DBG1_DEBUG_IDX_PMIC_IRQ_ACK_LOW_ABORT       (0x1U << 21)
#define SPM_DBG1_DEBUG_IDX_PMIC_IRQ_ACK_HIGH_ABORT      (0x1U << 22)
#define SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_LOW_ABORT    (0x1U << 23)
#define SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_HIGH_ABORT   (0x1U << 24)
#define SPM_DBG1_DEBUG_IDX_EMI_SLP_IDLE_ABORT           (0x1U << 25)
#define SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_LOW_ABORT        (0x1U << 26)
#define SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_HIGH_ABORT       (0x1U << 27)
#define SPM_DBG1_DEBUG_IDX_SPM_DVFS_CMD_RDY_ABORT       (0x1U << 28)
#define SPM_DBG1_DEBUG_IDX_SSPM_HANDSHAKE_ABORT         (0x1U << 29)
#define SPM_DBG1_DEBUG_IDX_SPM_DISABLE_DDREN_EVENT      (0x1U << 30)
#define SPM_DBG1_DEBUG_IDX_DISABLE_DVFSRC               (0x1U << 31)

/* ABORT MASK for DEBUG FOORTPRINT */
#define DEBUG_ABORT_MASK (SPM_DBG_DEBUG_IDX_DRAM_SREF_ABORT_IN_APSRC \
	| SPM_DBG_DEBUG_IDX_DRAM_SREF_ABORT_IN_DDREN)

#define DEBUG_ABORT_MASK_1 (SPM_DBG1_DEBUG_IDX_VTCXO_SLEEP_ABORT_0 \
	| SPM_DBG1_DEBUG_IDX_VTCXO_SLEEP_ABORT_1 \
	| SPM_DBG1_DEBUG_IDX_PMIC_IRQ_ACK_LOW_ABORT \
	| SPM_DBG1_DEBUG_IDX_PMIC_IRQ_ACK_HIGH_ABORT \
	| SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_LOW_ABORT \
	| SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_HIGH_ABORT \
	| SPM_DBG1_DEBUG_IDX_EMI_SLP_IDLE_ABORT \
	| SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_LOW_ABORT \
	| SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_HIGH_ABORT \
	| SPM_DBG1_DEBUG_IDX_SPM_DVFS_CMD_RDY_ABORT \
	| SPM_DBG1_DEBUG_IDX_SSPM_HANDSHAKE_ABORT)

#endif
