#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
if [ "$1" == "-h" ]
then
    echo -E "ATTENTION: only one value can be set at a time, other pamameters values should be set to -2"
    echo -E "Usage:$0 <data_enable> <roaming> <default_data> <domestic_roaming> <international_roaming>"
    echo -E "data_enable: specify if data enable or not,-2 means skip this setting."
    echo -E "roaming: specify the roaming setting, -2 means skip this setting"
    echo -E "default_data: specify the default data sim(0 0r 1), -2 means skip this setting"
    echo -E "domestic_roaming: specify the domestic roaming setting, -2 means skip this setting"
    echo -E "international_roaming: specify the international roaming setting, -2 means skip this setting"
    exit 0
fi

if [ "$#" != 5 ]
then
    echo -E "parameter is invaild!"
    echo -E "ATTENTION: only one value can be set at a time, other pamameters values should be set to -2"
    echo -E "Usage:$0 <data_enable> <roaming> <default_data> <domestic_roaming> <international_roaming>"
    echo -E "data_enable: specify if data enable or not,-2 means skip this setting."
    echo -E "roaming: specify the roaming setting, -2 means skip this setting"
    echo -E "default_data: specify the default data sim(0 0r 1), -2 means skip this setting"
    echo -E "domestic_roaming: specify the domestic roaming setting, -2 means skip this setting"
    echo -E "international_roaming: specify the international roaming setting, -2 means skip this setting"
    exit  0
fi

num=0
for value in $1 $2 $3 $4 $5
do
    if [ $value -eq -2 ]
    then
        let "num++"
    fi
done

if [ $num -lt  4 ]
then
   echo -E "error: RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD: $1, $2, $3, $4, $5"
   echo -E "ATTENTION: only one value can be set at a time, other pamameters values should be set to -2"
   exit 0
fi

recv_data() {
    cat <&9 | while read line
    do
       result=${line}
       catp=$(ps | grep '[c]at' | awk '{print $1}')
       if [ "$line" != "" ];then
          if [ "$line" != "stopemdone" ];then
              echo $line
          fi
          if [ "$catp" != "" ];then
            kill $catp
          fi
       fi
    done
}

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

data_enable=$1
roaming=$2
default_data=$3
domestic_roaming=$4
international_roaming=$5

echo -E "RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD $data_enable $roaming $default_data $domestic_roaming $international_roaming"
#send Terminal response CMD
echo "RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD $data_enable $roaming $default_data $domestic_roaming $international_roaming" >&9
#recv_data

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
