#ifndef __CSIF_L1CORE_PUBLIC_API_H__
#define __CSIF_L1CORE_PUBLIC_API_H__

/*******************************************************************************
 *  Headers
 *******************************************************************************/
#include "kal_general_types.h"
#if defined(__MAUI_BASIC__)
#if defined(__MD97__)
    #include "mt6297/csif_basic_def.h"
#elif defined(__MD98__)
    #include "mt6297p/csif_basic_def.h"
#else
    #error "Unsupport generation type"
#endif
#else
    #include "csif_common_def.h"
#endif

/*******************************************************************************
 * Typedefs
 *******************************************************************************/
/*
emum CSIF_C2S_N0_ENUM_T defined in
"common/interface/driver/sys_drv/csif/csif_c2s_isr_config_n0.h"

emum CSIF_C2S_N1_ENUM_T defined in
"common/interface/driver/sys_drv/csif/csif_c2s_isr_config_n1.h"

emum CSIF_S2C_N0_ENUM_T defined in
"common/interface/driver/sys_drv/csif/csif_s2c_isr_config_n0.h"

emum CSIF_S2C_N1_ENUM_T defined in
"common/interface/driver/sys_drv/csif/csif_s2c_isr_config_n1.h"

*/

typedef kal_char                csif_char;
typedef kal_uint8               csif_uint8;
typedef kal_int8                csif_int8;
typedef kal_uint16              csif_uint16;
typedef kal_int16               csif_int16;
typedef kal_uint32              csif_uint32;
typedef kal_int32               csif_int32;
typedef kal_uint64              csif_uint64;
typedef kal_int64               csif_int64;
typedef kal_bool                csif_bool;

/* Define status register type */
typedef struct {
    csif_uint32 id;
    csif_uint32 code;
    csif_uint32 masked_status;
    csif_uint32 *reg_addr;
} CSIF_ID_STATUS_t;

typedef struct {
    csif_uint32 r_idx;
    csif_uint32 w_idx;
    csif_uint32 mail_num;
} CSIF_MAILBOX_STATUS_t;

typedef struct {
    csif_uint32 addr;
    csif_uint32 size;
} CSIF_OLPDET_CONFIG_t;

typedef struct {
    CSIF_MAILBOX_C2S_INDEX mID;
    csif_uint32 mail;
} CSIF_MAIL_INFO_t;

typedef struct {
    CSIF_C2S_INDEX nID;
    csif_uint32 code;
} CSIF_IRQ_INFO_t;

/* User callback should be registered in common/interface/driver/sys_drv/csif/ */

typedef enum {
    CSIF_DSP_MPU0,
    CSIF_DSP_MPU1,
    CSIF_L1_MPU0,
    CSIF_L1_MPU1,
    CSIF_MPU_TOTAL_NUM
} CSIF_MPU_ENUM_T;

typedef enum {
    CSIF_MPU_READ,
    CSIF_MPU_WRITE,
    CSIF_MPU_TOTAL_TYPE
} CSIF_MPU_TYPE_ENUM_T;

typedef enum {
    CSIF_SET_CONTENT_ERROR,
    CSIF_CLR_CONTENT_ERROR,
    CSIF_OLP_HIT_ERROR,
#if defined(MT6885) || defined(MT6873) || defined(MT6853)|| defined(CHIP10992) || defined(MT6833) || defined(MT6877) || defined(MT6298)
    CSIF_CLR_NOHIT_ERROR,    // CLR_NOHIT_ERROR only available from Petrus
#elif defined(MT6297)
#else
    #error "Unsupport project, need to do platform option porting!!"
#endif
    CSIF_OLPDET_ERROR_TOTAL_NUM
} CSIF_OLPDET_ERROR_TYPE_ENUM_T;

typedef enum {
    CSIF_FULL_ERROR,
    CSIF_CONTENT_ERROR,
    CSIF_MAILBOX_ERROR_TOTAL_NUM
} CSIF_MAILBOX_ERROR_TYPE_ENUM_T;

/* Define user callback function type */
typedef void (*CSIF_InterruptEntryFun)(CSIF_ID_STATUS_t*);

/*******************************************************************************
 * User-Aware MCU part API
 *******************************************************************************/

extern void csif_init(void);

extern void CSIF_S2C_N0_Handler(kal_uint32 irq_id);
extern void CSIF_S2C_N1_Handler(kal_uint32 irq_id);
extern void CSIF_S2C_N2_Handler(kal_uint32 irq_id);
extern void CSIF_S2C_N3_Handler(kal_uint32 irq_id);
extern void CSIF_S2C_N4_Handler(kal_uint32 irq_id);
extern void CSIF_S2C_N5_Handler(kal_uint32 irq_id);
extern void CSIF_L1_ERR_Handler(kal_uint32 irq_id);

extern void CSIF_C2S_SWI_Set(CSIF_C2S_INDEX nID, csif_uint32 code);
extern csif_uint32 CSIF_C2S_SWI_Read(CSIF_C2S_INDEX nID);
extern csif_uint32 CSIF_C2S_SWI_MASKED_Read(CSIF_C2S_INDEX nID);

extern csif_uint32 CSIF_S2C_SWI_Read(CSIF_S2C_INDEX nID);
extern csif_uint32 CSIF_S2C_SWI_MASKED_Read(CSIF_S2C_INDEX nID);
extern csif_uint32 CSIF_S2C_SWI_Enable_Read(CSIF_S2C_INDEX nID);
extern void CSIF_S2C_SWI_Enable(CSIF_S2C_INDEX nID, csif_uint32 code);
extern void CSIF_S2C_SWI_Disable(CSIF_S2C_INDEX nID, csif_uint32 code);
//#define CSIF_S2C_SWI_Enable(nID, code);
//#define CSIF_S2C_SWI_Disable(nID, code);

extern csif_uint32 CSIF_S2C_Overflow_Read(CSIF_S2C_INDEX nID);
extern void CSIF_S2C_Overflow_Clear(CSIF_S2C_INDEX nID, csif_uint32 code);
extern csif_uint32 CSIF_C2S_Overflow_Read(CSIF_C2S_INDEX nID);
extern void CSIF_C2S_Overflow_Clear(CSIF_C2S_INDEX nID, csif_uint32 code);

extern void CSIF_MPU_Set(CSIF_MPU_ENUM_T mpuID, csif_uint32 start, csif_uint32 range, CSIF_MPU_TYPE_ENUM_T type);
//#define CSIF_MPU_Set(mpuID, start, range, type);

extern csif_uint32 CSIF_CORE_IDLE_Read(void);

extern csif_uint32 CSIF_IDLE_ENABLE_Read(CSIF_S2C_INDEX nID);
extern void CSIF_IDLE_ENABLE_Set(CSIF_S2C_INDEX nID, csif_uint32 enable_map);
extern void CSIF_IDLE_ENABLE_Clr(CSIF_S2C_INDEX nID, csif_uint32 clr_bit_map);

extern void CSIF_MAILBOX_C2S_Send(CSIF_MAILBOX_C2S_INDEX mID, csif_uint32 mail);
extern CSIF_MAILBOX_STATUS_t CSIF_MAILBOX_C2S_Status_Read(CSIF_MAILBOX_C2S_INDEX mID);
extern csif_uint32 CSIF_MAILBOX_C2S_Max_FIFO_Usage_Read(CSIF_MAILBOX_C2S_INDEX mID);
extern csif_uint32 CSIF_MAILBOX_S2C_Read(CSIF_MAILBOX_S2C_INDEX mID);
extern CSIF_MAILBOX_STATUS_t CSIF_MAILBOX_S2C_Status_Read(CSIF_MAILBOX_S2C_INDEX mID);
extern csif_uint32 CSIF_MAILBOX_S2C_Max_FIFO_Usage_Read(CSIF_MAILBOX_S2C_INDEX mID);

// for L1 MCU LPWR scenario debug feature, not normal case usage
extern csif_uint32 CSIF_MAILBOX_C2S_Read(CSIF_MAILBOX_C2S_INDEX mID);

extern void CSIF_OLPDET_Set(csif_uint32 addr, csif_uint32 size);
extern void CSIF_OLPDET_Clr(csif_uint32 addr, csif_uint32 size);
extern csif_uint32 CSIF_Total_Inuse_Mem_Size(void);

#if defined(MT6885) || defined(MT6873) || defined(MT6853) || defined(CHIP10992) || defined(MT6833) || defined(MT6877) || defined(MT6298)
extern csif_uint32 CSIF_Total_Max_Mem_Size(void);
extern void CSIF_Total_Max_Mem_Size_Clear(void);
#elif defined(MT6297)
#else
    #error "Unsupport project, need to do platform option porting!!"
#endif

// Multiple operation API
extern void CSIF_OLPDET_Multiple_Set(csif_uint32 length, CSIF_OLPDET_CONFIG_t* olpdet_config_array);
extern void CSIF_OLPDET_Multiple_Clr(csif_uint32 length, CSIF_OLPDET_CONFIG_t* olpdet_config_array);

extern void CSIF_MAILBOX_C2S_Multiple_Send(csif_uint32 length, CSIF_MAIL_INFO_t* mail_info_array);

extern void CSIF_MAILBOX_C2S_Multiple_Send_C2S_SWI_Multiple_Set(csif_uint32 mailbox_length, CSIF_MAIL_INFO_t* mail_info_array, \
                                                                csif_uint32 irq_length,     CSIF_IRQ_INFO_t* irq_info_array);


#endif /*__CSIF_L1CORE_PUBLIC_API_H__*/
