/*******************************************
*   please DO NOT include this file
*   this file is for mcu/dsp csif driver include only 
************************************************/

/*******************************************************************************
  * IRQ Enums 
  *******************************************************************************/

/* C2S IRQ */

#undef M_CSIF_C2S_INFO
#define M_CSIF_C2S_INFO(CSIFHandler, Code, IRQ_ovfl_allow, Value) CSIF_C2S_ID_##Code=Value,


typedef enum CSIF_C2S_InterruptHandlerCode_N0_Enum{
    #include "basic/csif_c2s_isr_config_n0.h"
    CSIF_C2S_N0_TOTAL_NUMBER_ENUM
}CSIF_C2S_N0_ENUM_T;

typedef enum CSIF_C2S_InterruptHandlerCode_N1_Enum{
    //CSIF_C2S_N1_START_ID = 31,
    #include "basic/csif_c2s_isr_config_n1.h"
    CSIF_C2S_N1_TOTAL_NUMBER_ENUM
}CSIF_C2S_N1_ENUM_T;

typedef enum CSIF_C2S_InterruptHandlerCode_N2_Enum{
    //CSIF_C2S_N2_START_ID = 63,
    #include "basic/csif_c2s_isr_config_n2.h"
    CSIF_C2S_N2_TOTAL_NUMBER_ENUM
}CSIF_C2S_N2_ENUM_T;
typedef enum CSIF_C2S_InterruptHandlerCode_N3_Enum{
    //CSIF_C2S_N3_START_ID = 95,
    #include "basic/csif_c2s_isr_config_n3.h"
    CSIF_C2S_N3_TOTAL_NUMBER_ENUM
}CSIF_C2S_N3_ENUM_T;

#undef M_CSIF_C2S_INFO

/* S2C IRQ*/

#undef M_CSIF_S2C_INFO
#define M_CSIF_S2C_INFO(CSIFHandler, Code, IRQ_ovfl_allow, Value) CSIF_S2C_ID_##Code=Value,

typedef enum CSIF_S2C_InterruptHandlerCode_N0_Enum{
    #include "basic/csif_s2c_isr_config_n0.h"
    CSIF_S2C_N0_TOTAL_NUMBER_ENUM
}CSIF_S2C_N0_ENUM_T;

typedef enum CSIF_S2C_InterruptHandlerCode_N1_Enum{
    //CSIF_S2C_N1_START_ID = 31,
    #include "basic/csif_s2c_isr_config_n1.h"
    CSIF_S2C_N1_TOTAL_NUMBER_ENUM
}CSIF_S2C_N1_ENUM_T;

typedef enum CSIF_S2C_InterruptHandlerCode_N2_Enum{
    //CSIF_S2C_N2_START_ID = 63,
    #include "basic/csif_s2c_isr_config_n2.h"
    CSIF_S2C_N2_TOTAL_NUMBER_ENUM
}CSIF_S2C_N2_ENUM_T;

typedef enum CSIF_S2C_InterruptHandlerCode_N3_Enum{
    //CSIF_S2C_N3_START_ID = 95,
    #include "basic/csif_s2c_isr_config_n3.h"
    CSIF_S2C_N3_TOTAL_NUMBER_ENUM
}CSIF_S2C_N3_ENUM_T;

typedef enum CSIF_S2C_InterruptHandlerCode_N4_Enum{
    //CSIF_S2C_N4_START_ID = 127,
    #include "basic/csif_s2c_isr_config_n4.h"
    CSIF_S2C_N4_TOTAL_NUMBER_ENUM
}CSIF_S2C_N4_ENUM_T;

typedef enum CSIF_S2C_InterruptHandlerCode_N5_Enum{
    //CSIF_S2C_N5_START_ID = 159,
    #include "basic/csif_s2c_isr_config_n5.h"
    CSIF_S2C_N5_TOTAL_NUMBER_ENUM
}CSIF_S2C_N5_ENUM_T;

#undef M_CSIF_S2C_INFO

#if defined(__MSONIC__)
/* DSP Error */
#undef M_CSIF_DSP_ERR_INFO
#define M_CSIF_DSP_ERR_INFO(CSIFErrHandler, Code, Value) CSIF_DSP_Err_##Code=Value,

typedef enum CSIF_DSP_Err_InterruptHandlerCode_Enum{
    #include "basic/csif_dsp_err_isr_config.h"
    CSIF_DSP_ERR_TOTAL_NUMBER
}CSIF_DSP_ERR_ENUM_T;

#undef M_CSIF_DSP_ERR_INFO

#elif defined(__CR4__) || defined(__MIPS_I7200__) || defined(__MIPS_IA__)
/* L1 Error */
#undef M_CSIF_L1_ERR_INFO
#define M_CSIF_L1_ERR_INFO(CSIFErrHandler, Code, Value) CSIF_L1_Err_##Code=Value,

typedef enum CSIF_L1_Err_InterruptHandlerCode_Enum{
    #include "basic/csif_l1_err_isr_config.h"
    CSIF_L1_ERR_TOTAL_NUMBER
}CSIF_L1_ERR_ENUM_T;

#undef M_CSIF_L1_ERR_INFO
#else
#error "not supported core"
#endif


/* CSIF C2S Int enum */
typedef enum CSIF_C2S_Index_Enum{
    CSIF_ENUM_C2S_N0,
    CSIF_ENUM_C2S_N1,
    CSIF_ENUM_C2S_N2,
    CSIF_ENUM_C2S_N3,
    CSIF_ENUM_ALL_C2S_INT_NUM
}CSIF_C2S_INDEX;

/* CSIF S2C Int enum */
typedef enum CSIF_S2C_Index_Enum{
    CSIF_ENUM_S2C_N0,
    CSIF_ENUM_S2C_N1,
    CSIF_ENUM_S2C_N2,
    CSIF_ENUM_S2C_N3,
    CSIF_ENUM_S2C_N4,
    CSIF_ENUM_S2C_N5,
    CSIF_ENUM_ALL_S2C_INT_NUM
}CSIF_S2C_INDEX;


/*******************************************************************************
  * Mailbox Enum 
  *******************************************************************************/
/* MAILBOX HW INDEX */
#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

#define M_CSIF_MAILBOX_HW_INFO(Size, HW_ID) CSIF_MAILBOX_##HW_ID,
#define M_CSIF_MAILBOX_C2S_INFO(Code, HW_ID)
#define M_CSIF_MAILBOX_S2C_INFO(Code, HW_ID)
typedef enum CSIF_MAILBOX_HW_Index_Enum{
    #include "basic/csif_mailbox_config.h"
    CSIF_MAILBOX_HW_TOTAL_NUMBER
}CSIF_MAILBOX_HW_INDEX;

#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

/* MAILBOX Total num */
#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

#define M_CSIF_MAILBOX_HW_INFO(Size, HW_ID)
#define M_CSIF_MAILBOX_C2S_INFO(Code, HW_ID) CSIF_MAILBOX_TOTAL_ID_##Code,
#define M_CSIF_MAILBOX_S2C_INFO(Code, HW_ID) CSIF_MAILBOX_TOTAL_ID_##Code,
typedef enum CSIF_MAILBOX_TOTAL_Index_Enum{
    #include "basic/csif_mailbox_config.h"
    CSIF_MAILBOX_SW_TOTAL_NUMBER
}CSIF_MAILBOX_TOTAL_ENUM_T;

#undef M_CSIF_MAILBOX_C2S_INFO
#define M_CSIF_MAILBOX_C2S_INFO(Code, HW_ID) CSIF_MAILBOX_TOTAL_C2S_ID_##Code,
#undef M_CSIF_MAILBOX_S2C_INFO
#define M_CSIF_MAILBOX_S2C_INFO(Code, HW_ID)

typedef enum CSIF_MAILBOX_TOTAL_C2S_NUM_Enum{
    #include "basic/csif_mailbox_config.h"
    CSIF_MAILBOX_SW_TOTAL_C2S_NUMBER
}CSIF_MAILBOX_TOTAL_C2S_ENUM_T;

#undef M_CSIF_MAILBOX_C2S_INFO
#define M_CSIF_MAILBOX_C2S_INFO(Code, HW_ID)
#undef M_CSIF_MAILBOX_S2C_INFO
#define M_CSIF_MAILBOX_S2C_INFO(Code, HW_ID) CSIF_MAILBOX_TOTAL_S2C_ID_##Code,

typedef enum CSIF_MAILBOX_TOTAL_S2C_NUM_Enum{
    #include "basic/csif_mailbox_config.h"
    CSIF_MAILBOX_SW_TOTAL_S2C_NUMBER
}CSIF_MAILBOX_TOTAL_S2C_ENUM_T;

#if defined(__MSONIC__)
KAL_CASSERT((CSIF_MAILBOX_SW_TOTAL_NUMBER <= CSIF_MAILBOX_HW_TOTAL_NUMBER));
#endif

#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

/* C2S MAILBOX Index*/
#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

#define M_CSIF_MAILBOX_HW_INFO(Size, HW_ID)
#define M_CSIF_MAILBOX_C2S_INFO(Code, HW_ID) CSIF_MAILBOX_C2S_##Code=CSIF_MAILBOX_##HW_ID,
#define M_CSIF_MAILBOX_S2C_INFO(Code, HW_ID)
typedef enum CSIF_MAILBOX_C2S_Index_Enum{
    #include "basic/csif_mailbox_config.h"
    CSIF_MAILBOX_C2S_LAST_ID
}CSIF_MAILBOX_C2S_INDEX;

#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

/* S2C MAILBOX Index*/
#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO

#define M_CSIF_MAILBOX_HW_INFO(Size, HW_ID)
#define M_CSIF_MAILBOX_C2S_INFO(Code, HW_ID)
#define M_CSIF_MAILBOX_S2C_INFO(Code, HW_ID) CSIF_MAILBOX_S2C_##Code=CSIF_MAILBOX_##HW_ID,
typedef enum CSIF_MAILBOX_S2C_Index_Enum{
    #include "basic/csif_mailbox_config.h"
    CSIF_MAILBOX_S2C_LAST_ID
}CSIF_MAILBOX_S2C_INDEX;

#undef M_CSIF_MAILBOX_HW_INFO
#undef M_CSIF_MAILBOX_C2S_INFO
#undef M_CSIF_MAILBOX_S2C_INFO



/*******************************************************************************
  * Macros 
  *******************************************************************************/

#define CSIF_C2S_N0_TOTAL_NUMBER               (CSIF_C2S_N0_TOTAL_NUMBER_ENUM)
#define CSIF_C2S_N1_TOTAL_NUMBER               (CSIF_C2S_N1_TOTAL_NUMBER_ENUM)
#define CSIF_C2S_N2_TOTAL_NUMBER               (CSIF_C2S_N2_TOTAL_NUMBER_ENUM)
#define CSIF_C2S_N3_TOTAL_NUMBER               (CSIF_C2S_N3_TOTAL_NUMBER_ENUM)
//#define CSIF_C2S_N1_TOTAL_NUMBER               (CSIF_C2S_N1_TOTAL_NUMBER_ENUM - CSIF_C2S_N1_START_ID - 1)
//#define CSIF_C2S_N2_TOTAL_NUMBER               (CSIF_C2S_N2_TOTAL_NUMBER_ENUM - CSIF_C2S_N2_START_ID - 1)
//#define CSIF_C2S_N3_TOTAL_NUMBER               (CSIF_C2S_N3_TOTAL_NUMBER_ENUM - CSIF_C2S_N3_START_ID - 1)


#define CSIF_S2C_N0_TOTAL_NUMBER               (CSIF_S2C_N0_TOTAL_NUMBER_ENUM)
#define CSIF_S2C_N1_TOTAL_NUMBER               (CSIF_S2C_N1_TOTAL_NUMBER_ENUM)
#define CSIF_S2C_N2_TOTAL_NUMBER               (CSIF_S2C_N2_TOTAL_NUMBER_ENUM)
#define CSIF_S2C_N3_TOTAL_NUMBER               (CSIF_S2C_N3_TOTAL_NUMBER_ENUM)
#define CSIF_S2C_N4_TOTAL_NUMBER               (CSIF_S2C_N4_TOTAL_NUMBER_ENUM)
#define CSIF_S2C_N5_TOTAL_NUMBER               (CSIF_S2C_N5_TOTAL_NUMBER_ENUM)
//#define CSIF_S2C_N1_TOTAL_NUMBER               (CSIF_S2C_N1_TOTAL_NUMBER_ENUM - CSIF_S2C_N1_START_ID - 1)
//#define CSIF_S2C_N2_TOTAL_NUMBER               (CSIF_S2C_N2_TOTAL_NUMBER_ENUM - CSIF_S2C_N2_START_ID - 1)
//#define CSIF_S2C_N3_TOTAL_NUMBER               (CSIF_S2C_N3_TOTAL_NUMBER_ENUM - CSIF_S2C_N3_START_ID - 1)
//#define CSIF_S2C_N4_TOTAL_NUMBER               (CSIF_S2C_N4_TOTAL_NUMBER_ENUM - CSIF_S2C_N4_START_ID - 1)
//#define CSIF_S2C_N5_TOTAL_NUMBER               (CSIF_S2C_N5_TOTAL_NUMBER_ENUM - CSIF_S2C_N5_START_ID - 1)

#define CSIF_MAILBOX_TOTAL_NUM                  (CSIF_MAILBOX_SW_TOTAL_NUMBER)
#define CSIF_MAILBOX_C2S_NUM                    (CSIF_MAILBOX_SW_TOTAL_C2S_NUMBER)
#define CSIF_MAILBOX_S2C_NUM                    (CSIF_MAILBOX_SW_TOTAL_S2C_NUMBER)