/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2005
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE. 
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*****************************************************************************
 *
 * Filename:
 * ---------
 *   lcd_ip_cqueue.h
 *
 * Project:
 * --------
 *   Maui_Software
 *
 * Description:
 * ------------
 *   This file defines Generic circular queue data structure definition
 *
 * Author:
 * -------
 * -------
 *
 *============================================================================
 *             HISTORY
 * Below this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *------------------------------------------------------------------------------
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *============================================================================
 ****************************************************************************/
/*******************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2002
*
*******************************************************************************/

/*********************************************************************
   (C) _____ (year of first publication) Sasken communication
   Technologies Limited, All rights reserved.
*   This file provides a template for .c files. This space
*   should be used to describe the file contents
*   Component-specific prefix : xxxx
*********************************************************************/
 
#ifndef _LCD_IP_CQUEUE_H
#define _LCD_IP_CQUEUE_H

/*************************************************************************
 * Include the common header file
 *************************************************************************/
#if defined(__MTK_TARGET__)
#include "kal_itc.h"
#else
#include "kal_hrt_api.h"
#endif

/*************************************************************************
 * Macros With Parameters
 *************************************************************************/
#if defined(__MTK_TARGET__)
#define LCD_IP_CQUEUE_MT_LOCK(_lock)                                 \
    unsigned int irq_status = 0, mt_status = 0, prio = 0;            \
    KAL_ITC_LOCK_TAKE_DI_DMT_PRIO(_lock, irq_status, mt_status, prio)

#define LCD_IP_CQUEUE_MT_UNLOCK(_lock)                               \
    KAL_ITC_LOCK_GIVE_EI_EMT_PRIO((_lock), irq_status, mt_status, prio)
#else
#define LCD_IP_CQUEUE_MT_LOCK(_lock)                                 \
    kal_hrt_take_itc_lock(KAL_ITC_ISR_Q, KAL_INFINITE_WAIT)

#define LCD_IP_CQUEUE_MT_UNLOCK(_lock)                               \
    kal_hrt_give_itc_lock(KAL_ITC_ISR_Q)
#endif

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE
*
* DESCRIPTION
*
* PARAMETERS
*  _type is the type of item to be put in queue.
* _length is the size of the queue.
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE(_type, _length)                                \
    struct {                                                         \
        unsigned int    head;                                        \
        unsigned int    tail;                                        \
        unsigned int    multiple;                                    \
        unsigned int    max_used_item;                               \
        unsigned int    total_item;                                  \
        kal_bool        is_full;                                     \
        _type           queue[_length];                              \
    }

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INIT
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INIT(_q)                                       \
do{                                                                  \
    (_q).head = (_q).tail = 0;                                       \
    (_q).multiple = 1;                                               \
    (_q).max_used_item = 0;                                          \
    (_q).total_item = (sizeof((_q).queue)*(_q).multiple / sizeof((_q).queue[0]));  \
    (_q).is_full = KAL_FALSE;                                        \
}while(0)

#define LCD_IP_CQUEUE_INIT_N(_q, n)                                  \
do{                                                                  \
    (_q).head = (_q).tail = 0;                                       \
    (_q).multiple = n;                                               \
    (_q).max_used_item = 0;                                          \
    (_q).total_item = (sizeof((_q).queue)*(_q).multiple / sizeof((_q).queue[0]));  \
    (_q).is_full = KAL_FALSE;                                        \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INSERT
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*  _item is the item to be inserted  to the queue
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/
/* (_q).tail = ((_q).tail + 1) % (sizeof((_q).queue)*(_q).multiple/sizeof((_q).queue[0])); */
#define LCD_IP_CQUEUE_INSERT(_q, _item)                              \
do{                                                                  \
    (_q).queue[(_q).tail] = _item;                                   \
    (_q).tail++;                                                     \
    if ((_q).tail == (_q).total_item)                                \
        (_q).tail = 0;                                               \
    if ((_q).head == (_q).tail) { (_q).is_full = KAL_TRUE; }         \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INSERT_DISCARD
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INSERT_DISCARD(_q)                             \
do{                                                                  \
    /* (_q).queue[(_q).tail] = _item; */                             \
    (_q).tail++;                                                     \
    if ((_q).tail == (_q).total_item)                                \
        (_q).tail = 0;                                               \
    if ((_q).head == (_q).tail) { (_q).is_full = KAL_TRUE; }         \
}while(0)

/************************************************************************* 
 * FUNCTION 
 *  LCD_IP_CQUEUE_INSERT_HEAD 
 * 
 * DESCRIPTION 
 * 
 * PARAMETERS 
 *  _q is the structure variable of the queue 
 *  _item is the item to be inserted  to the queue 
 * 
 * RETURNS 
 * 
 * GLOBALS AFFECTED 
 * 
 *************************************************************************/ 

#define LCD_IP_CQUEUE_INSERT_HEAD(_q, _item)                         \
do{                                                                  \
    if((_q).head == 0) {(_q).head = (_q).total_item; }               \
    (_q).head--;                                                     \
    (_q).queue[(_q).head] = _item;                                   \
    if ((_q).head == (_q).tail) { (_q).is_full = KAL_TRUE; }         \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_REMOVE
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*  _item is the variable to which removed item is stored
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/
/*(_q).head = ((_q).head + 1) % (sizeof((_q).queue)*(_q).multiple/sizeof((_q).queue[0]));*/

#define LCD_IP_CQUEUE_REMOVE(_q, _item)                              \
do{                                                                  \
    _item = (_q).queue[(_q).head];                                   \
    (_q).head++;                                                     \
    if((_q).head == (_q).total_item)                                 \
        (_q).head = 0;                                               \
    if ((_q).is_full == KAL_TRUE)                                    \
        (_q).is_full = KAL_FALSE;                                    \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_DISCARD
*
* DESCRIPTION
* Just for removing last node from CQUEUE
*
* PARAMETERS
*  _q is the structure variable of the queue
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/
/*(_q).head = ((_q).head + 1) % (sizeof((_q).queue)*(_q).multiple/sizeof((_q).queue[0]));*/
#define LCD_IP_CQUEUE_DISCARD(_q)                                    \
do{                                                                  \
    /*_item = (_q).queue[(_q).head];*/                               \
    (_q).head++;                                                     \
    if((_q).head == (_q).total_item)                                 \
        (_q).head = 0;                                               \
    if ((_q).is_full == KAL_TRUE)                                    \
        (_q).is_full = KAL_FALSE;                                    \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_NUM_OF_ITEMS
*
* DESCRIPTION
*
* PARAMETERS
* _q is the structure variable of the queue
* _num_of_items is the variable to which the
* number of items in the queue is assigned
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_NUM_OF_ITEMS(_q,_num_of_items)                 \
do{                                                                  \
    if((_q).is_full)                                                 \
        _num_of_items = (_q).total_item;                             \
    else if((_q).tail >= (_q).head)                                  \
        _num_of_items = (_q).tail - (_q).head;                       \
    else                                                             \
        _num_of_items = (_q).tail + (_q).total_item - (_q).head;     \
}while(0)

#define LCD_IP_CQUEUE_RETURN_NUM_OF_ITEMS(_q)                        \
    ((_q).is_full ? ((_q).total_item) :                              \
        ((_q).tail >= (_q).head ? ((_q).tail - (_q).head) :          \
        ((_q).tail + (_q).total_item - (_q).head)))

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INDEX
*
* DESCRIPTION
*
* PARAMETERS
* _q is the structure variable of the queue
* _index is the index position of the queue from which queue item to be accessed
* _item is the variable to which element at index is stored.
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INDEX(_q,_index,_item)                         \
do{                                                                  \
    if(((_q).head + _index) > ((_q).total_item - 1))                 \
    {                                                                \
        /*user need to ensure index must be in scope [0,q->size-1], which is the valid-scope*/ \
        ASSERT(((_q).head + _index - (_q).total_item) <= ((_q).total_item - 1)); \
        _item = (_q).queue[(_q).head + _index - (_q).total_item];    \
    }                                                                \
    else                                                             \
        _item = (_q).queue[(_q).head + _index];                      \
}while(0)


#define LCD_IP_CQUEUE_UPDATE_MAX(_q, _max)                           \
do{                                                                  \
    LCD_IP_CQUEUE_NUM_OF_ITEMS(_q, _max);                            \
    if (_max > (_q).max_used_item)                                   \
    {                                                                \
        (_q).max_used_item = _max;                                   \
    }                                                                \
    else if (_max < (_q).max_used_item)                              \
    {                                                                \
        _max = (_q).max_used_item;                                   \
    }                                                                \
}while(0)

#define LCD_UP_CQUEUE_UPDATE_MAX(_q, _max) LCD_IP_CQUEUE_UPDATE_MAX(_q, _max)

/* _q is the structure variable of the queue */
#define LCD_IP_CQUEUE_IS_FULL(_q)  ((_q).is_full)
#define LCD_IP_CQUEUE_IS_EMPTY(_q) (((_q).head == (_q).tail) && !(_q).is_full)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_MT
*
* DESCRIPTION
*
* PARAMETERS
*  _type is the type of item to be put in queue.
* _length is the size of the queue.
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/
#define LCD_IP_CQUEUE_MT(_type, _length)                             \
    struct {                                                         \
        unsigned int     head;                                       \
        unsigned int     tail;                                       \
        unsigned int     multiple;                                   \
        unsigned int     max_used_item;                              \
        unsigned int     total_item;                                 \
        unsigned int     lock_flag;                                  \
        kal_bool         is_full;                                    \
        _type            queue[_length];                             \
    }

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INIT_MT
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INIT_N_MT(_q, n)                               \
    do{                                                              \
        (_q).head = (_q).tail = 0;                                   \
        (_q).multiple = n;                                           \
        (_q).max_used_item = 0;                                      \
        (_q).total_item = (sizeof((_q).queue)*(_q).multiple / sizeof((_q).queue[0])); \
        (_q).lock_flag = 0;                                          \
        (_q).is_full = KAL_FALSE;                                    \
    }while(0)

#define LCD_IP_CQUEUE_INIT_MT(_q) LCD_IP_CQUEUE_INIT_N_MT(_q, 1)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INSERT_MT
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*  _item is the item to be inserted to the queue
*  _is_full is the queue full flag before insert item
*
* RETURNS
*  _is_full
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INSERT_MT(_q, _item, _is_full)                 \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if (!LCD_IP_CQUEUE_IS_FULL(_q)) {                                \
        _is_full = KAL_FALSE;                                        \
        LCD_IP_CQUEUE_INSERT(_q, _item);                             \
    } else {                                                         \
        _is_full = KAL_TRUE;                                         \
    }                                                                \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)


/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INSERT_DISCARD_MT
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*  _is_full is the queue full flag before insert item
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INSERT_DISCARD_MT(_q, _is_full)                \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if (!LCD_IP_CQUEUE_IS_FULL(_q)) {                                \
        _is_full = KAL_FALSE;                                        \
        LCD_IP_CQUEUE_INSERT_DISCARD(_q);                            \
    } else {                                                         \
        _is_full = KAL_TRUE;                                         \
    }                                                                \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)


/************************************************************************* 
 * FUNCTION 
 *  LCD_IP_CQUEUE_INSERT_HEAD_MT
 * 
 * DESCRIPTION 
 * 
 * PARAMETERS 
 *  _q is the structure variable of the queue 
 *  _item is the item to be inserted  to the queue 
 *  _is_full is the queue full flag before insert item
 *
 * RETURNS
 *  _is_full
 * 
 * GLOBALS AFFECTED 
 * 
 *************************************************************************/ 

#define LCD_IP_CQUEUE_INSERT_HEAD_MT(_q, _item, _is_full)            \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if (!LCD_IP_CQUEUE_IS_FULL(_q)) {                                \
        _is_full = KAL_FALSE;                                        \
        LCD_IP_CQUEUE_INSERT_HEAD(_q, _item);                        \
    } else {                                                         \
        _is_full = KAL_TRUE;                                         \
    }                                                                \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)


/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_REMOVE_MT
*
* DESCRIPTION
*
* PARAMETERS
*  _q is the structure variable of the queue
*  _item is the variable to which removed item is stored
*  _is_empty is the queue empty flag before remove item
*
* RETURNS
*  _is_empty
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_REMOVE_MT(_q, _item, _is_empty)                \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if (!LCD_IP_CQUEUE_IS_EMPTY(_q)) {                               \
        _is_empty = KAL_FALSE;                                       \
        LCD_IP_CQUEUE_REMOVE(_q, _item);                             \
    } else {                                                         \
        _is_empty = KAL_TRUE;                                        \
    }                                                                \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_DISCARD_MT
*
* DESCRIPTION
* Just for removing last node from CQUEUE
*
* PARAMETERS
*  _q is the structure variable of the queue
*  _is_empty is the queue empty flag before remove item
*
* RETURNS
*  _is_empty
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_DISCARD_MT(_q, _is_empty)                      \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if (!LCD_IP_CQUEUE_IS_EMPTY(_q)) {                               \
        _is_empty = KAL_FALSE;                                       \
        LCD_IP_CQUEUE_DISCARD(_q);                                   \
    } else {                                                         \
        _is_empty = KAL_TRUE;                                        \
    }                                                                \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_NUM_OF_ITEMS_MT
*
* DESCRIPTION
*
* PARAMETERS
* _q is the structure variable of the queue
* _num_of_items is the variable to which the
* number of items in the queue is assigned
*
* RETURNS
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_NUM_OF_ITEMS_MT(_q,_num_of_items)              \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if((_q).is_full)                                                 \
        _num_of_items = (_q).total_item;                             \
    else if((_q).tail >= (_q).head)                                  \
        _num_of_items = (_q).tail - (_q).head;                       \
    else                                                             \
        _num_of_items = (_q).tail + (_q).total_item - (_q).head;     \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)

/*************************************************************************
* FUNCTION
*  LCD_IP_CQUEUE_INDEX_MT
*
* DESCRIPTION
*
* PARAMETERS
* _q is the structure variable of the queue
* _index is the index position of the queue from which queue item to be accessed
* _item is the variable to which element at index is stored.
*  _is_full is the queue full flag before insert item
*  _is_empty is the queue empty flag before remove item
*
* RETURNS
*  _is_full, _is_empty
*
* GLOBALS AFFECTED
*
*************************************************************************/

#define LCD_IP_CQUEUE_INDEX_MT(_q,_index,_item, _is_full, _is_empty) \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    if (LCD_IP_CQUEUE_IS_FULL(_q))                                   \
        _is_full = KAL_TRUE;                                         \
    else                                                             \
        _is_full = KAL_FALSE;                                        \
    if (LCD_IP_CQUEUE_IS_EMPTY(_q) || (_index >= LCD_IP_CQUEUE_RETURN_NUM_OF_ITEMS(_q))) \
        _is_empty = KAL_TRUE;                                        \
    else                                                             \
        _is_empty = KAL_FALSE;                                       \
    LCD_IP_CQUEUE_INDEX(_q,_index,_item);                            \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)

#define LCD_IP_CQUEUE_IS_FULL_MT(_q, _is_full)                       \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    _is_full = LCD_IP_CQUEUE_IS_FULL(_q);                            \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)

#define LCD_IP_CQUEUE_IS_EMPTY_MT(_q, _is_empty)                     \
do{                                                                  \
    LCD_IP_CQUEUE_MT_LOCK((_q).lock_flag);                           \
    _is_empty = LCD_IP_CQUEUE_IS_EMPTY(_q);                          \
    LCD_IP_CQUEUE_MT_UNLOCK((_q).lock_flag);                         \
}while(0)


#endif /* _LCD_IP_CQUEUE_H */
