/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * -----------
 *   drv_mdap_interface.c
 *
 * Project:
 * -----------
 *   UMOLY
 *
 * Description:
 * ------------
 *   MD/AP interface driver related code
 *
 * Author:
 * -------
 * -------
 *
 *============================================================================
 *             HISTORY
 * Below this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *------------------------------------------------------------------------------
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *============================================================================
 ****************************************************************************/
#include "drv_mdap_interface.h"
#include "reg_base.h"
#include "elm.h"
#include "sync_data.h"
#include "kal_hrt_api.h"
#include "us_timer.h"
#include "intrCtrl.h"
#include "stdlib.h"
#include "drv_mdap_interface_int_cfg.h"
#include "drv_mdap_interface_int.h"


#if defined(__AMIF_TRACE_ENABLE__)
#include "TrcMod.h"		//for L1 Trace API
#define AMIF_AMIF_MET_DUMP MD_TRC_L1TRC_AMIF_AMIF_MET_DUMP      /* [AMIF_MET][Frc=%UL] Func = %MMD2AP_FUNC_T, MD2AP_SIM_ID = %MMD2AP_SIM_ID, MD2AP_SCENARIO_GROUP = %MMD2AP_SCENARIO_GROUP, MD2AP_SCENARIO = %MMD2AP_SCENARIO, Scenario Request = %UL, AMIF Request = %UL */
#define AMIF_DVFSRC_MET_DUMP MD_TRC_L1TRC_AMIF_DVFSRC_MET_DUMP  /* [AMIF_MET][Frc=%UL] DVFS Current Scenario = %UL, DVFS Current Level(OPP) = %UL */

#define AMIF_ELM_CFG_DIRECT_LOG MD_TRC_L1TRC_AMIF_ELM_CFG_DIRECT_LOG /* [INFO][AMIF][ELM_CFG][Direct] Update MD2AP_ELM_CFG from %ul to %ul ==> ELM_R_lat_ns = %ul, ELM_W_lat_ns = %ul" */

#define AMIF_BIT_UPDATE_LOG MD_TRC_L1TRC_AMIF_BIT_UPDATE_DBG /* [INFO][AMIF][BIT_UPDATE] curr: %ul, next: %ul, bitmask: %xl -> %xl */
#define AMIF_NOBIT_DBG MD_TRC_L1TRC_AMIF_NOBIT_DBG           /* [INFO][AMIF][DBG] mdap_interface_invoked_bitmask = 0 is encountered */

#define AMIF_EXCEP_ERR_PARA_LOG MD_TRC_L1TRC_AMIF_EXCEP_ERR_PARA_LOG /* [EXCEP][AMIF] Parameter is out of range, func=%MMD2AP_FUNC_T, MD2AP_SIM_ID = %MMD2AP_SIM_ID, MD2AP_SCENARIO = %MMD2AP_SCENARIO, extra id = %XL */
#define AMIF_EXCEP_TBL_CORRUPT_LOG MD_TRC_L1TRC_AMIF_EXCEP_TBL_CORRUPT_LOG /* [EXCEP][AMIF] Table is corrupted, func=%MMD2AP_FUNC_T, Excpect value = %MMD2AP_SIM_ID, real value = %MMD2AP_SCENARIO */
#define AMIF_EXCEP_SEQ_UNEXPECT MD_TRC_L1TRC_AMIF_EXCEP_UNEXPECTED_SEQ_LOG /* [EXCEP][AMIF] Function is called in unexpected sequence, func=%MMD2AP_FUNC_T */
#define AMIF_EXCEP_DRV_HIGHEST_BIT_ERR MD_TRC_L1TRC_AMIF_EXCEP_DRV_HIGHEST_BIT_ERR /* [EXCEP][AMIF] Highest bit for driver out of range. value: %XL, bitmask: %XL */
#else
#define AMIF_AMIF_MET_DUMP
#define AMIF_DVFSRC_MET_DUMP

#define AMIF_ELM_CFG_DIRECT_LOG

#define AMIF_BIT_UPDATE_LOG
#define AMIF_NOBIT_DBG

#define AMIF_EXCEP_ERR_PARA_LOG
#define AMIF_EXCEP_TBL_CORRUPT_LOG
#define AMIF_EXCEP_SEQ_UNEXPECT
#define AMIF_EXCEP_DRV_HIGHEST_BIT_ERR
#endif

/*******************************************************************************
 * Functions
 *******************************************************************************/
#if defined(ENABLE_MDAPINTERFACE)

#include "intrCtrl.h"


/* define scenario mapping array for easy use */
#undef MDAP_SCENARIO_GROUP_INSTANCE
#undef MDAP_SCENARIO_INSTANCE
#undef MDAP_INSTANCE_BEGING
#undef MDAP_INSTANCE_END
#undef MDAP_ELM_INSTANCE
#undef MDAP_GEAR_INSTANCE
#define MDAP_SCENARIO_INSTANCE(SCENARIO,SCENARIO_GROUP,VALUE,GEAR_INDEX,MODE) {SCENARIO, GEAR_INDEX, SCENARIO_GROUP},
SCENARIO_INFO_T MD2AP_Scenario_Info[E_MD2AP_SCENARIO_END] = {
                                        #include "drv_mdap_interface_config.h"
                                        };

MD2AP_ELM_INDEX MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX = MD2AP_ELM_CFG_0; //Current ELM index setting for latency check.



/* ELM configuration array: ELM index with related latency setting. */
#undef MDAP_SCENARIO_GROUP_INSTANCE
#undef MDAP_SCENARIO_INSTANCE
#undef MDAP_INSTANCE_BEGING
#undef MDAP_INSTANCE_END
#undef MDAP_ELM_INSTANCE
#undef MDAP_GEAR_INSTANCE
#define MDAP_ELM_INSTANCE(ELM_INDEX, VALUE, R_LAT_NS, R_WIN_US, W_LAT_NS, W_WIN_US)    {ELM_INDEX, R_LAT_NS, R_WIN_US, W_LAT_NS, W_WIN_US},
ELM_CFG_T MD2AP_ELM_CFG[E_MD2AP_ELM_INDEX_END] =  {
                                                        #include "drv_mdap_interface_config.h"
                                                  };

/* GEAR configuration array: Gear index with related ELM index setting. */
#undef MDAP_SCENARIO_GROUP_INSTANCE
#undef MDAP_SCENARIO_INSTANCE
#undef MDAP_INSTANCE_BEGING
#undef MDAP_INSTANCE_END
#undef MDAP_ELM_INSTANCE
#undef MDAP_GEAR_INSTANCE
#define MDAP_GEAR_INSTANCE(GEAR_INDEX, VALUE, ELM_INDEX)    {GEAR_INDEX, ELM_INDEX},
GEAR_CFG_T MD2AP_Gear_Info[E_MD2AP_GEAR_INDEX_END] =  {
                                                        #include "drv_mdap_interface_config.h"
                                                  };


/* Current scenario for specified SIM and SCENARIO_GROUP. */
GROUP_STATUS_T MD2AP_sim_status[E_MD2AP_SIM_COUNT][E_MD2AP_SCENARIO_GROUP_END];

kal_uint32        AMIF_Scenario_Dor_BackupRestore=0;

/* For AMIF dormant restore log */
kal_uint32        AMIF_Scenario_Dor_restore_frc = 0;
kal_uint32        dvfsrc_md_scenario_Dor_restore = 0, dvfsrc_opp_Dor_restore = 0;

kal_uint32        mdap_interface_scen_shm_addr;    // Used to store share memory address for AP LPM. (Allocated from sleep_drv)

/* Control by AT CMD to determine should we print DVFSRC log in L1 trace */
kal_int32         amif_dvfsrc_log_on = 0;

/* Record the gear we need by bit mask */
volatile kal_uint32        mdap_interface_invoked_bitmask = 0;
/* Record the highest bit(the highest scenario) in "mdap_interface_invoked_bitmask". ==> the scenario value set to AMIF */
volatile kal_uint32        mdap_interface_invoked_scenario = 0;
/* Record the user's number for each gear */
volatile kal_uint32        mdap_interface_invoked_bit_cnt[32];    // Assume 32 bit/gear of EMI DVFS CON in max case.



/*******************************************************************************
 * Functions Definition
 *******************************************************************************/
 /*------------------------------------------------------------------------
 * void    _Drv_MD2AP_lpm_shm_init
 * Purpose:     Used to initialize share memory located from sleep_drv
 * Parameters:
 *    Input:    None
 *    Output:   None
 * returns :    None
 * Note    :    Be sure to add option equal to sleep_drv (defined(__HIF_CCCI_SUPPORT__) && defined(__MTK_TARGET__))
 *------------------------------------------------------------------------
 */
static void _Drv_MD2AP_lpm_shm_init()
{
#if defined(__HIF_CCCI_SUPPORT__) && defined(__MTK_TARGET__)
    /* This shared memory is maintained by EJ */
    /* SLP_SHM_4G_8_SECTION_LEVEL: store the address of share memory. This variable is declared in NC region (bank 0) */
    /* Use mdap_interface_scen_shm_addr to store the share memory address */
    DECLARE_SHARED_VAR(kal_uint32, SLP_SHM_4G_8_SECTION_LEVEL);
    mdap_interface_scen_shm_addr = SHARED_VAR(SLP_SHM_4G_8_SECTION_LEVEL);
#endif
}

 /*------------------------------------------------------------------------
 * void   _drv_MD2AP_lpm_shm_update 
 * Purpose:     Write the bitmask to AP-MD share memory for LPM.
 * Parameters:
 *    Input:    scenario_mask: bit mask for active scenarios.
 *    Output:   None
 * returns :    None
 * Note    :    Be sure to add option equal to sleep_drv (defined(__HIF_CCCI_SUPPORT__) && defined(__MTK_TARGET__))
                No need to clean dcache because this is write to non-cacheable region. 
 *------------------------------------------------------------------------
 */
static void _Drv_MD2AP_lpm_shm_update(kal_uint32 scenario_mask)
{
#if defined(__HIF_CCCI_SUPPORT__) && defined(__MTK_TARGET__)
    *(volatile kal_uint32 *)mdap_interface_scen_shm_addr = scenario_mask;
#endif
}

 /*------------------------------------------------------------------------
 * void    MD2AP_ScenarioCheckAndConfig
 * Purpose:	   Update the AMIF Gear/Scenario setting, then config ELM latency check.
 * Parameters:
 *    Input:	MD2AP_FUNC_T check_and_cofig_flag: Function scenario. No use now...
 *              
 *    Output:	None.
 * returns :	KAL_TRUE/KAL_FALSE. 
 * Note    :    Caller need take HW ITC.
 *              
 *------------------------------------------------------------------------
 */ 
static kal_bool _Drv_MD2AP_ScenarioCheckAndConfig(MD2AP_FUNC_T check_and_cofig_flag)
{
    MD2AP_ELM_INDEX highest_REQ_elm_index;

    /* case that state trans to NOBIT */
    /* Unexpected scenario */
    if (mdap_interface_invoked_bitmask == 0)
    {
        AMIF_NOBIT_DBG();
        //We check MD2AP_GEAR_INVALID in _Drv_MD2AP_Update_ScenarioBitMask(). Shouldn't come here! 
        DEBUG_ASSERT(0);
        highest_REQ_elm_index = MD2AP_ELM_CFG_0;
        drv_mdap_interface_hw_trigger(MD2AP_GEAR_INVALID); 
    }
    else
    {
        highest_REQ_elm_index = MD2AP_Gear_Info[mdap_interface_invoked_scenario].elm_index;
        drv_mdap_interface_hw_trigger(mdap_interface_invoked_scenario);
    }

    if (MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX != highest_REQ_elm_index)
    {//Need to update ELM configuration.

        //To avoid updating scenario but config ELM too late, we always config it at the same time.
        AMIF_ELM_CFG_DIRECT_LOG(MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX, highest_REQ_elm_index, MD2AP_ELM_CFG[highest_REQ_elm_index].r_lat_ns, MD2AP_ELM_CFG[highest_REQ_elm_index].w_lat_ns);

        if(drv_mdap_interface_get_DVFSRC_Status()==1)
        {/* DVFSRC enable, ELM could really work. */
            ELM_MCU_threshold_change_lightweight(MD2AP_ELM_CFG[highest_REQ_elm_index].r_lat_ns, \
                                                 MD2AP_ELM_CFG[highest_REQ_elm_index].w_lat_ns, \
                                                 MD2AP_ELM_CFG[highest_REQ_elm_index].r_win_us);
        }
        
        MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX = highest_REQ_elm_index;
    }
    return KAL_TRUE;
}

 /*------------------------------------------------------------------------
 * void    _Drv_MD2AP_Update_ScenarioBitMask
 * Purpose:	   Update AMIF bit mask global variable(mdap_interface_invoked_bitmask) for scenario change and
 *             update the highest we need.
 * Parameters:
 *    Input:	MD2AP_SCENARIO curr: Current Scenario.
 *              MD2AP_SCENARIO next: Next Scenario.
 *              
 *    Output:	None.
 * returns :	KAL_TRUE : Gear/Scenario change, need update AMIF.  
 *              KAL_FALSE: Gear/Scenario no change, no need update AMIF. 
 *
 * Note    :    Caller need take HW ITC.
 *              
 *------------------------------------------------------------------------
 */ 
static kal_uint32 _Drv_MD2AP_Update_ScenarioBitMask(MD2AP_SCENARIO curr, MD2AP_SCENARIO next)
{

    //kal_uint32   orig_bitmask = mdap_interface_invoked_bitmask;
    MD2AP_GEAR_INDEX curr_bit = MD2AP_Scenario_Info[curr].gear_index;
    MD2AP_GEAR_INDEX next_bit = MD2AP_Scenario_Info[next].gear_index;
    kal_uint32 highest_bit;

    //Note: default scenario would be MD2AP_GEAR_INVALID, so we only check next_bit here!
    DEBUG_ASSERT(next_bit!=MD2AP_GEAR_INVALID);//EXT_ASSERT(next_bit!=MD2AP_GEAR_INVALID, curr, next, 0x12345678);

    if (curr_bit == next_bit)
        return KAL_FALSE;

    if(curr_bit != MD2AP_GEAR_INVALID)
    { 
        mdap_interface_invoked_bit_cnt[curr_bit]--;
        if(mdap_interface_invoked_bit_cnt[curr_bit] == 0)
        {//none require this gear, release it
            mdap_interface_invoked_bitmask &= ~(1 << curr_bit);
        }
    }
    
    if(next_bit != MD2AP_GEAR_INVALID)
    {//add new gear required by user
        mdap_interface_invoked_bit_cnt[next_bit]++;
        mdap_interface_invoked_bitmask |= (1 << next_bit);
    }

    /* Write the bitmask to AP-MD share memory for LPM. */
    _Drv_MD2AP_lpm_shm_update(mdap_interface_invoked_bitmask);

    //AMIF_BIT_UPDATE_LOG(curr_bit, next_bit, orig_bitmask, mdap_interface_invoked_bitmask);

    highest_bit = 32 - __builtin_clz(mdap_interface_invoked_bitmask) - 1;//clz: return the number of 0 before 1st "1". EX: CLZ(0x2)=30
    if(highest_bit >= 32)
    {
#if !defined(__PRODUCTION_RELEASE__)
/* under construction !*/
#endif
        AMIF_EXCEP_DRV_HIGHEST_BIT_ERR(highest_bit, mdap_interface_invoked_bitmask);
        return KAL_FALSE;
    }

    if(highest_bit!=mdap_interface_invoked_scenario)
    {//highest scenario change, need to update AMIF
        mdap_interface_invoked_scenario = highest_bit;
        return KAL_TRUE;
    }
    else
    {//highest scenario didn't change, no need to update AMIF
        return KAL_FALSE;        
    }

}
 
static void _Drv_MD2AP_ErrParaHdlr(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO value, MD2AP_FUNC_T func, kal_uint32 id)
{
    AMIF_EXCEP_ERR_PARA_LOG(func, sim_id, value, id);
#if !defined(__PRODUCTION_RELEASE__)
/* under construction !*/
#endif
}

static void _Drv_MD2AP_ScenTblCorruptHdlr(MD2AP_SCENARIO value, MD2AP_FUNC_T func)
{
    MD2AP_SCENARIO corrupted_value = MD2AP_Scenario_Info[value].scenario;

    AMIF_EXCEP_TBL_CORRUPT_LOG(func, value, corrupted_value);
#if !defined(__PRODUCTION_RELEASE__)
/* under construction !*/
#else
    /* do recovery */
    MD2AP_Scenario_Info[value].scenario = value;
#endif
}

static void _Drv_MD2AP_SeqUnexpectHdlr(MD2AP_FUNC_T func)
{
    AMIF_EXCEP_SEQ_UNEXPECT(func);
#if !defined(__PRODUCTION_RELEASE__)
/* under construction !*/
#endif
}

 /*------------------------------------------------------------------------
 * void    _Drv_MD2AP_SwitchScenario
 * Purpose:	   Sim card change scenario and update AMIF.
 * Parameters:
 *    Input:	MD2AP_SIM_ID sim_id         : sim card number.
 *              MD2AP_SCENARIO next_scenario: Next Scenario.
 *              
 *    Output:	None.
 * returns :	MD2AP_RET_PARA_OUT_OF_RANGE/MD2AP_RET_SUCCESS. 
 * Note    :    This function would update AMIF right away. But DVFSRC need latency to valid.  
 *              
 *------------------------------------------------------------------------
 */ 
MD2AP_RET_T _Drv_MD2AP_SwitchScenario(MD2AP_SIM_ID sim_id, MD2AP_SCENARIO next_scenario)
{
    MD2AP_SCENARIO_GROUP input_scenario_group;
    MD2AP_SCENARIO       curr_scenario;
    kal_uint32           frc, request_scenario, dvfsrc_md_scenario = 0, dvfsrc_opp = 0;
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    ELM_MAX_LOG_T emi_elm_max_log ;
#endif
    /* Error check 1: Check scenario legality */
    if(E_MD2AP_SCENARIO_END <= next_scenario || E_MD2AP_SIM_COUNT <= sim_id)
    {
        _Drv_MD2AP_ErrParaHdlr(sim_id, next_scenario, E_MD2AP_SWITCH, 0);
        return MD2AP_RET_PARA_OUT_OF_RANGE;
    }
    /* Error check 2: Check mapping table */
    if(next_scenario != MD2AP_Scenario_Info[next_scenario].scenario)
    {
        _Drv_MD2AP_ScenTblCorruptHdlr(next_scenario, E_MD2AP_SWITCH);
    }

    /* Get group information for current scenario */
    input_scenario_group = MD2AP_Scenario_Info[next_scenario].group;

    /* HRT EI/DI function supports caller from both HRT/normal domain */
    kal_hrt_take_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK ,KAL_INFINITE_WAIT);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_GET_MAX_LOG(&emi_elm_max_log);
#endif
    if(amif_dvfsrc_log_on)
    {//For log correctness, we need get DVFSRC status before AMIF trigger.
        dvfsrc_md_scenario = drv_mdap_interface_get_DVFSRC_MD_Scenario();
        dvfsrc_opp = drv_mdap_interface_get_DVFSRC_OPP();
    }

    curr_scenario = MD2AP_sim_status[sim_id][input_scenario_group].scenario;

    /* if input scenario equals current scenario in scenario group, nothing need to do */
    /* else, need to do scenario bit switch */
    if (curr_scenario != next_scenario)
    {
        /* update scenario in group to next scenario */
        MD2AP_sim_status[sim_id][input_scenario_group].scenario = next_scenario;
        
        if(_Drv_MD2AP_Update_ScenarioBitMask(curr_scenario, next_scenario)==KAL_TRUE)
        {
            _Drv_MD2AP_ScenarioCheckAndConfig(E_MD2AP_SWITCH);
        }
    }

    //For AMIF_MET record
    frc = AMIF_GET_CURRENT_TIME();
    request_scenario = mdap_interface_invoked_scenario;

    kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_AMIF_SCENARIO_CHANGE_LOGGING(emi_elm_max_log);
#endif  
    AMIF_AMIF_MET_DUMP(frc, E_MD2AP_SWITCH, sim_id, input_scenario_group, next_scenario, MD2AP_Scenario_Info[next_scenario].gear_index, request_scenario);

    if(amif_dvfsrc_log_on)
    {
        AMIF_DVFSRC_MET_DUMP(frc, dvfsrc_md_scenario, dvfsrc_opp);
    }

    return MD2AP_RET_SUCCESS;
}

 /*------------------------------------------------------------------------
 * void    _Drv_MD2AP_StartScenario
 * Purpose:	   4G Position require AMIF.
 * Parameters:
 *    Input:	MD2AP_SIM_ID sim_id : sim card number.
 *              MD2AP_SCENARIO next_scenario: Next Scenario. Only could be MD2AP_4G_POSITIONING/MD2AP_4G_NON_POSITIONING. 
 *              
 *    Output:	None.
 * returns :	MD2AP_RET_PARA_OUT_OF_RANGE/MD2AP_RET_SEQ_START_NOT_ALTER/MD2AP_RET_SUCCESS. 
 * Note    :    Only for 4G position use(Legacy code from Gen93). Maybe this function could merge to _Drv_MD2AP_SwitchScenario()
 *              
 *------------------------------------------------------------------------
 */ 
MD2AP_RET_T _Drv_MD2AP_StartScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO next_scenario)
{
    MD2AP_SCENARIO_GROUP input_scenario_group = E_MD2AP_SCENARIO_GROUP_DEFAULT;
    MD2AP_SCENARIO       curr_scenario;
    kal_uint32           frc, request_scenario, dvfsrc_md_scenario = 0, dvfsrc_opp = 0;
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    ELM_MAX_LOG_T emi_elm_max_log ;
#endif
    /* Error check 1: Check scenario legality */
    if(E_MD2AP_SCENARIO_END <= next_scenario)
    {
        /* if non-produciton release, assert in following function */
        _Drv_MD2AP_ErrParaHdlr(sim_id, next_scenario, E_MD2AP_START, 0);
        return MD2AP_RET_PARA_OUT_OF_RANGE;
    }
    /* Error check 2: Check mapping table */
    if(next_scenario != MD2AP_Scenario_Info[next_scenario].scenario)
    {
        _Drv_MD2AP_ScenTblCorruptHdlr(next_scenario, E_MD2AP_START);
    }

    /* Get group information for current scenario */
    input_scenario_group = MD2AP_Scenario_Info[next_scenario].group;

    kal_hrt_take_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK ,KAL_INFINITE_WAIT);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_GET_MAX_LOG(&emi_elm_max_log);
#endif    
    if(next_scenario == MD2AP_4G_POSITIONING)
    {
        // Error check 2: Current 4G positioning scenario must be inactivating
        if(MD2AP_4G_NON_POSITIONING != MD2AP_sim_status[sim_id][input_scenario_group].scenario)
        {
            _Drv_MD2AP_SeqUnexpectHdlr(E_MD2AP_START);
            kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
            return MD2AP_RET_SEQ_START_NOT_ALTER;
        }
        // Do not use else statement here due to keep set value for no assertion mode
    }
    else if(next_scenario == MD2AP_4G_NON_POSITIONING)
    {
        //// Error check 1: Current 4G positioning scenario must be activating
        ////if(MD2AP_4G_POSITIONING != MD2AP_sim_status[sim_id][input_scenario_group].scenario)
        ////{
        ////    AMIF_ASSERT(0);
        ////    return KAL_FALSE;
        ////}
        //// Do not use else statement here due to keep set value for no assertion mode
    }
    else
    {
        // Error check. assert for illegal parameter
        _Drv_MD2AP_ErrParaHdlr(sim_id, next_scenario, E_MD2AP_START, 1);
        kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
        return MD2AP_RET_PARA_OUT_OF_RANGE;
    }

    if(amif_dvfsrc_log_on)
    {//For log correctness, we need get DVFSRC status before AMIF trigger.
        dvfsrc_md_scenario = drv_mdap_interface_get_DVFSRC_MD_Scenario();
        dvfsrc_opp = drv_mdap_interface_get_DVFSRC_OPP();
    }

    curr_scenario = MD2AP_sim_status[sim_id][input_scenario_group].scenario;

    /* if input scenario equals current scenario in scenario group, nothing need to do */
    /* else, need to do scenario bit switch */
    if (curr_scenario != next_scenario)
    {
        /* update scenario in group to next scenario */
        MD2AP_sim_status[sim_id][input_scenario_group].scenario = next_scenario;
        
        if(_Drv_MD2AP_Update_ScenarioBitMask(curr_scenario, next_scenario)==KAL_TRUE)
        {
            _Drv_MD2AP_ScenarioCheckAndConfig(E_MD2AP_START);
        }
    }

    //For AMIF_MET record
    frc = AMIF_GET_CURRENT_TIME();
    request_scenario = mdap_interface_invoked_scenario;

    kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_AMIF_SCENARIO_CHANGE_LOGGING(emi_elm_max_log);
#endif
    AMIF_AMIF_MET_DUMP(frc, E_MD2AP_START, sim_id, input_scenario_group, next_scenario, MD2AP_Scenario_Info[next_scenario].gear_index, request_scenario);

    if(amif_dvfsrc_log_on)
    {
        AMIF_DVFSRC_MET_DUMP(frc, dvfsrc_md_scenario, dvfsrc_opp);
    }

    return MD2AP_RET_SUCCESS;
}

 /*------------------------------------------------------------------------
 * void    _Drv_MD2AP_preSetStartScenario
 * Purpose:	   Pre-set for a new scenario, only config AMIF when gear need up.
 * Parameters:
 *    Input:	MD2AP_SIM_ID sim_id : sim card number.
 *              MD2AP_SCENARIO next_scenario: Next Scenario.
 *              
 *    Output:	None.
 * returns :	MD2AP_RET_SUCCESS. 
 * Note    :    If you call _Drv_MD2AP_preSetStartScenario(), you must call _Drv_MD2AP_postSetStartScenario() when current scenario done. 
 *              
 *------------------------------------------------------------------------
 */ 
MD2AP_RET_T _Drv_MD2AP_preSetStartScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO next_scenario)
{
    MD2AP_SCENARIO_GROUP input_scenario_group = E_MD2AP_SCENARIO_GROUP_DEFAULT;
    MD2AP_SCENARIO       curr_scenario;
    kal_uint32           frc, request_scenario, dvfsrc_md_scenario = 0, dvfsrc_opp = 0;    
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    ELM_MAX_LOG_T emi_elm_max_log ;
#endif   
    /* Error check 1: Check mapping table */
    if(next_scenario != MD2AP_Scenario_Info[next_scenario].scenario)
    {
        _Drv_MD2AP_ScenTblCorruptHdlr(next_scenario, E_MD2AP_PRESET);
    }

    input_scenario_group = MD2AP_Scenario_Info[next_scenario].group;

    if(input_scenario_group == scenario_3GFDD)
    {//3G PS no need to call this function, but they didn't remove code, so bypass here.
        return MD2AP_RET_SUCCESS;
    }

    kal_hrt_take_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK ,KAL_INFINITE_WAIT);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_GET_MAX_LOG(&emi_elm_max_log);
#endif
    /* Error check 2: Check preSet and postSet pair in same group */
    /* Do not check preset after preset scenario for abort case */
    //if(KAL_TRUE == MD2AP_sim_status[sim_id][input_scenario_group].preSetting)
    //{
    //    AMIF_ASSERT(0);
    //    return KAL_FALSE;
    //}
    // Do not use else statement here due to keep set value for no assertion mode

    if(amif_dvfsrc_log_on)
    {//For log correctness, we need get DVFSRC status before AMIF trigger.
        dvfsrc_md_scenario = drv_mdap_interface_get_DVFSRC_MD_Scenario();
        dvfsrc_opp = drv_mdap_interface_get_DVFSRC_OPP();
    }

    MD2AP_sim_status[sim_id][input_scenario_group].preSetting= KAL_TRUE;

    curr_scenario = MD2AP_sim_status[sim_id][input_scenario_group].scenario;

    if(next_scenario > curr_scenario)
    {//Scenario up
        /* Update current scenario */
        MD2AP_sim_status[sim_id][input_scenario_group].scenario = next_scenario;
    
        if(_Drv_MD2AP_Update_ScenarioBitMask(curr_scenario, next_scenario)==KAL_TRUE)
        {
            _Drv_MD2AP_ScenarioCheckAndConfig(E_MD2AP_PRESET);
        }
    }
    else
    {
        //do nothing
    }

    //For AMIF_MET record
    frc = AMIF_GET_CURRENT_TIME();
    request_scenario = mdap_interface_invoked_scenario;

    kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_AMIF_SCENARIO_CHANGE_LOGGING(emi_elm_max_log);
#endif
    AMIF_AMIF_MET_DUMP(frc, E_MD2AP_PRESET, sim_id, input_scenario_group, next_scenario, MD2AP_Scenario_Info[next_scenario].gear_index, request_scenario); 

    if(amif_dvfsrc_log_on)
    {
        AMIF_DVFSRC_MET_DUMP(frc, dvfsrc_md_scenario, dvfsrc_opp);
    }

    return MD2AP_RET_SUCCESS;
}

 /*------------------------------------------------------------------------
 * void    _Drv_MD2AP_postSetStartScenario
 * Purpose:	   When the scenarior is end, Post-set the new scenario to know current scenario is done, 
 *             only config AMIF when gear need down.
 * Parameters:
 *    Input:	MD2AP_SIM_ID sim_id : sim card number.
 *              MD2AP_SCENARIO next_scenario: Next Scenario.
 *              
 *    Output:	None.
 * returns :	MD2AP_RET_SUCCESS/MD2AP_RET_SEQ_PRE_POST_NOT_IN_SEQ. 
 * Note    :    You must call _Drv_MD2AP_preSetStartScenario() before calling this function.
 *              
 *------------------------------------------------------------------------
 */ 
MD2AP_RET_T _Drv_MD2AP_postSetStartScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO next_scenario)
{
    MD2AP_SCENARIO_GROUP input_scenario_group = E_MD2AP_SCENARIO_GROUP_DEFAULT;
    MD2AP_SCENARIO       curr_scenario;
    kal_uint32           frc, request_scenario, dvfsrc_md_scenario = 0, dvfsrc_opp = 0;    
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    ELM_MAX_LOG_T emi_elm_max_log ;
#endif    
    /* Error check 1: Check mapping table */
    if(next_scenario != MD2AP_Scenario_Info[next_scenario].scenario)
    {
        _Drv_MD2AP_ScenTblCorruptHdlr(next_scenario, E_MD2AP_POSTSET);
    }

    input_scenario_group = MD2AP_Scenario_Info[next_scenario].group;

    if(input_scenario_group == scenario_3GFDD)
    {//3G PS no need to call this function, but they didn't remove code, so bypass here.
        return MD2AP_RET_SUCCESS;
    }

    kal_hrt_take_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK ,KAL_INFINITE_WAIT);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_GET_MAX_LOG(&emi_elm_max_log);
#endif
    /* Error check 2: Check preSet and postSet pair in same group */
    if(KAL_FALSE == MD2AP_sim_status[sim_id][input_scenario_group].preSetting)
    {
        _Drv_MD2AP_SeqUnexpectHdlr(E_MD2AP_POSTSET);
        kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
        return MD2AP_RET_SEQ_PRE_POST_NOT_IN_SEQ; 
    }
    // Do not use else statement here due to keep set value for no assertion mode

    if(amif_dvfsrc_log_on)
    {//For log correctness, we need get DVFSRC status before AMIF trigger.
        dvfsrc_md_scenario = drv_mdap_interface_get_DVFSRC_MD_Scenario();
        dvfsrc_opp = drv_mdap_interface_get_DVFSRC_OPP();
    }

    MD2AP_sim_status[sim_id][input_scenario_group].preSetting= KAL_FALSE;

    curr_scenario = MD2AP_sim_status[sim_id][input_scenario_group].scenario;    

    if(next_scenario < curr_scenario)
    {//Scenario down
        /* Update current scenario */
        MD2AP_sim_status[sim_id][input_scenario_group].scenario = next_scenario;
    
        if(_Drv_MD2AP_Update_ScenarioBitMask(curr_scenario, next_scenario)==KAL_TRUE)
        {
            _Drv_MD2AP_ScenarioCheckAndConfig(E_MD2AP_POSTSET);
        }                
    }
    else
    {
        //do nothing
    }

    //For AMIF_MET record
    frc = AMIF_GET_CURRENT_TIME();
    request_scenario = mdap_interface_invoked_scenario;

    kal_hrt_give_itc_lock(KAL_ITC_ERRC_C2K_AMIF_LOCK);
#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */
    EMI_ELM_AMIF_SCENARIO_CHANGE_LOGGING(emi_elm_max_log);
#endif
    AMIF_AMIF_MET_DUMP(frc, E_MD2AP_POSTSET, sim_id, input_scenario_group, next_scenario, MD2AP_Scenario_Info[next_scenario].gear_index, request_scenario);

    if(amif_dvfsrc_log_on)
    {
        AMIF_DVFSRC_MET_DUMP(frc, dvfsrc_md_scenario, dvfsrc_opp);
    }

    return MD2AP_RET_SUCCESS;
}

 /*------------------------------------------------------------------------
 * void    Drv_MDAPInterface_Init
 * Purpose:	   AMIF init function.
 * Parameters:
 *    Input:	None.              
 *              
 *    Output:	None.
 * returns :	None. 
 * Note    :    called in init.c.
 *              
 *------------------------------------------------------------------------
 */ 
void Drv_MDAPInterface_Init(void)
{ 
    kal_uint32 loop_index = 0;

    drv_mdap_inteface_hw_init();

    /* Initialize the following variables
    **      MD2AP_sim_status:   two dimension array. SIM X Scenario Groups
    **      Every initial value of Scenario Group must be no scenario
    */
    for(loop_index = 0; loop_index<E_MD2AP_SIM_COUNT; loop_index++)
    {
        #undef MDAP_SCENARIO_GROUP_INSTANCE
        #undef MDAP_SCENARIO_INSTANCE
        #undef MDAP_INSTANCE_BEGING
        #undef MDAP_INSTANCE_END
        #undef MDAP_GEAR_INSTANCE
        #undef MDAP_ELM_INSTANCE

        #define MDAP_SCENARIO_GROUP_INSTANCE(SCENARIO_GROUP, SCENARIO_GROUP_DEFAULT_SCENARIO,VALUE) \
                MD2AP_sim_status[loop_index][SCENARIO_GROUP].scenario = SCENARIO_GROUP_DEFAULT_SCENARIO;\
                MD2AP_sim_status[loop_index][SCENARIO_GROUP].preSetting= KAL_FALSE;

        #include "drv_mdap_interface_config.h"

    }

    _Drv_MD2AP_lpm_shm_init();
}

void Drv_MDAPInterface_Clear(void)
{//Clear AMIF setting, called in ostd.c. l4c_root_power_off_done_ind()-> OSTD_MD_Infinite_Sleep(void)
    kal_uint32 frc; 
    kal_uint32 dvfsrc_md_scenario = 0, dvfsrc_opp = 0;

    if(amif_dvfsrc_log_on)
    {//For log correctness, we need get DVFSRC status before AMIF trigger.
        dvfsrc_md_scenario = drv_mdap_interface_get_DVFSRC_MD_Scenario();
        dvfsrc_opp = drv_mdap_interface_get_DVFSRC_OPP();   
    }

    drv_mdap_interface_hw_trigger(MD2AP_GEAR_INVALID);

    frc = AMIF_GET_CURRENT_TIME();

#if defined(__MD93__) || defined(__MD95__)
    /* Didn't support. */
#else/* Support from Gen97 */  
    ELM_MAX_LOG_T emi_elm_max_log;
    EMI_ELM_GET_MAX_LOG(&emi_elm_max_log);
    EMI_ELM_AMIF_SCENARIO_CHANGE_LOGGING(emi_elm_max_log);
    AMIF_AMIF_MET_DUMP(frc, E_MD2AP_DOR, E_MD2AP_SIM_SS, scenario_DOR, MD2AP_DOR_Enter, MD2AP_Scenario_Info[MD2AP_DOR_Enter].gear_index, 0);
#endif

    if(amif_dvfsrc_log_on)
    {
        AMIF_DVFSRC_MET_DUMP(frc, dvfsrc_md_scenario, dvfsrc_opp);
    }

    /* Due to AMIF gear is cleared, ELM latency threshold need to be set to "no requirement" as well */
    /* This is to avoid ELM assert in MT6779 */
    /* Use MD2AP_ELM_CFG_0 (R=4000ns, W=4000ns) for "no requirement" gear */
    if(drv_mdap_interface_get_DVFSRC_Status()==1)
    {/* DVFSRC enable, ELM could really work. */    
        ELM_MCU_threshold_change_lightweight(MD2AP_ELM_CFG[MD2AP_ELM_CFG_0].r_lat_ns, \
            MD2AP_ELM_CFG[MD2AP_ELM_CFG_0].w_lat_ns, \
            MD2AP_ELM_CFG[MD2AP_ELM_CFG_0].r_win_us);
    }
    
}

void Drv_MDAPInterface_BackupClear(void)
{//Called in ostd.c OSTD_CheckSleep() -> OSTD_AMIF_backup(), Only Core0 VPE0 would call.(comment by Owen) 
    AMIF_Scenario_Dor_BackupRestore = drv_mdap_interface_hw_get_curr_scenario_reg();
    Drv_MDAPInterface_Clear();
}

void Drv_MDAPInterface_Restore(void)
{//Called in OSTD_AMIF_restore(). Only Core0 VPE0 would call

    if(amif_dvfsrc_log_on)
    {//For log correctness, we need get DVFSRC status before AMIF trigger.
        dvfsrc_md_scenario_Dor_restore = drv_mdap_interface_get_DVFSRC_MD_Scenario();
        dvfsrc_opp_Dor_restore = drv_mdap_interface_get_DVFSRC_OPP();   
    }
    
    drv_mdap_interface_hw_trigger(AMIF_Scenario_Dor_BackupRestore);

    AMIF_Scenario_Dor_restore_frc = AMIF_GET_CURRENT_TIME();

    /* Restore to original ELM configuration */
    /* Note that this function is called only by 1 TC. No race condition issue need to be concerned */ 
    if(drv_mdap_interface_get_DVFSRC_Status()==1)
    {/* DVFSRC enable, ELM could really work. */    
        ELM_MCU_threshold_change_lightweight(MD2AP_ELM_CFG[MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX].r_lat_ns, \
            MD2AP_ELM_CFG[MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX].w_lat_ns, \
            MD2AP_ELM_CFG[MD2AP_HIGHEST_REQ_SCENARIO_ELM_INDEX].r_win_us);
    }
}

void Drv_MDAPInterface_Dormant_Restore_Log(void)
{/* Every Core's VPE0 would call */
    kal_uint32 vpe_idx = kal_get_current_vpe_id();

    if(vpe_idx==0)
    {
    #if defined(__MD93__) || defined(__MD95__)
        /* Didn't support. */
    #else/* Support from Gen97 */  
        ELM_MAX_LOG_T emi_elm_max_log;
        EMI_ELM_GET_MAX_LOG(&emi_elm_max_log);
        EMI_ELM_AMIF_SCENARIO_CHANGE_LOGGING(emi_elm_max_log);
        AMIF_AMIF_MET_DUMP(AMIF_Scenario_Dor_restore_frc, E_MD2AP_DOR, E_MD2AP_SIM_SS, scenario_DOR, MD2AP_DOR_Leave, AMIF_Scenario_Dor_BackupRestore, AMIF_Scenario_Dor_BackupRestore);
    #endif
    
        if(amif_dvfsrc_log_on)
        {
            AMIF_DVFSRC_MET_DUMP(AMIF_Scenario_Dor_restore_frc, dvfsrc_md_scenario_Dor_restore, dvfsrc_opp_Dor_restore);
        }   
    }
}

void Drv_MDAPInterface_Test(MD2AP_TEST_TYPE_T test_type)
{//For testing, Called in mddbg.c
    if (MD2AP_TEST_TYPE_DEFAULT == test_type)
    {
        kal_uint32 amif_rand;

        amif_rand = rand() % AMIF_RAND_TEST_SCENARIO_MAX;
        drv_mdap_interface_hw_trigger(amif_rand);
    }
}

kal_uint32 Drv_MD2AP_Get_Scenario_Value()
{
    return drv_mdap_interface_hw_get_curr_scenario_reg();
}

 /*------------------------------------------------------------------------
 * void        Drv_MDAPInterface_DVFSRC_Log_On
 * Purpose:    Enable/Disable DVFSRC MET Log.
 * Parameters:
 *    Input:	0: Log off.   others: Log on. 
 *              
 *    Output:	None.
 * returns :	None. 
 * Note    :    Called in Custom_atcmd_parse.c
 *              CMD EX: AT+EGCMD=196, 1, "00"   
 *                                   "00": disable. "11": enable
 *              
 *------------------------------------------------------------------------
 */
void Drv_MDAPInterface_DVFSRC_Log_On(kal_uint32 on)
{
    if(on==0)
    {
        amif_dvfsrc_log_on = 0;
    }
    else
    {
        amif_dvfsrc_log_on = 1;
    }
}

#else//AMIF disable	//defined(ENABLE_MDAPINTERFACE)




MD2AP_RET_T _Drv_MD2AP_StartScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO value)
{
    return MD2AP_RET_SUCCESS;
}

MD2AP_RET_T _Drv_MD2AP_preSetStartScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO value)
{
    return MD2AP_RET_SUCCESS;
}

MD2AP_RET_T _Drv_MD2AP_postSetStartScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO value)
{
    return MD2AP_RET_SUCCESS;
}

MD2AP_RET_T _Drv_MD2AP_SwitchScenario(MD2AP_SIM_ID sim_id,MD2AP_SCENARIO value)
{
    return MD2AP_RET_SUCCESS;
}

void Drv_MDAPInterface_Init(void)
{
}

void Drv_MDAPInterface_Clear()
{
}

void Drv_MDAPInterface_BackupClear(void)
{
}

void Drv_MDAPInterface_Restore(void)
{
}

void Drv_MDAPInterface_Dormant_Restore_Log(void)
{
    
}

void Drv_MDAPInterface_Test(MD2AP_TEST_TYPE_T test_type)
{
}

kal_uint32 Drv_MD2AP_Get_Scenario_Value()
{
    return 0xDEADDEAD;
}

void Drv_MDAPInterface_DVFSRC_Log_On(kal_uint32 on)
{
}

#endif	//defined(ENABLE_MDAPINTERFACE)

