/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * -----------
 *   drv_mdap_interface_hw.c
 *
 * Project:
 * -----------
 *   UMOLYA
 *
 * Description:
 * ------------
 *   Low Level Driver of MDAP Interface
 *
 * Author:
 * -------
 * -------
 *
 *============================================================================
 *             HISTORY
 * Below this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *------------------------------------------------------------------------------
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *============================================================================
 ****************************************************************************/

#include "kal_general_types.h"
#include "kal_public_api.h"
#include "drv_mdap_interface.h"
#include "reg_base.h"
#include "sync_data.h"

typedef struct _MDAP_INTERFACE_INFO {
	kal_uint32	u32MD2AP_InitStatus;
	kal_uint32	u32AP2MD_InitStatus;
	kal_uint32	u32MD2AP_Status;
	kal_uint32	u32AP2MD_Status;
} MDAP_INTERFACE_INFO;

MDAP_INTERFACE_INFO             mdap_interface_info = {0};

void drv_mdap_interface_hw_trigger(MD2AP_GEAR_INDEX gear)
{
    ASSERT(gear <= E_MD2AP_GEAR_INDEX_END);

    if (MD2AP_GEAR_INVALID == gear)
        *MD2SPM_DVFS_CON = 0; 
    else
        *MD2SPM_DVFS_CON = (1 << gear);

    MO_Sync();
}

void drv_mdap_inteface_hw_init()
{
#if defined(__MDAP_INTERFACE_CAMOUFLAGE__)
    *MD2SPM_DVFS_CON = MD2AP_CAMOUFLAGE_VAL;
    MO_Sync();
#endif
}

kal_uint32 drv_mdap_interface_hw_get_curr_scenario_reg()
{
    return *MD2SPM_DVFS_CON;
}

void drv_mdap_interface_hw_set_curr_scenario_reg(kal_uint32 reg_val)
{
    *MD2SPM_DVFS_CON = reg_val;
    MO_Sync();
}

/* backward compatible function */
kal_bool Drv_MDAPInterface_Dump(void)
{
	mdap_interface_info.u32MD2AP_Status = *MD2SPM_DVFS_CON;
	mdap_interface_info.u32AP2MD_Status = *SPM2MD_DVFS_CON;
	return KAL_TRUE;
}

void Drv_MDAPInterface_Custom_Test(kal_uint32 cmd, kal_uint32 val)
{
}

