/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * -----------
 *   drv_mdap_interface_hw.c
 *
 * Project:
 * -----------
 *   UMOLYA
 *
 * Description:
 * ------------
 *   Low Level Driver of MDAP Interface
 *
 * Author:
 * -------
 * -------
 *
 *============================================================================
 *             HISTORY
 * Below this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *------------------------------------------------------------------------------
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *============================================================================
 ****************************************************************************/

#include "kal_general_types.h"
#include "kal_public_api.h"
#include "drv_mdap_interface.h"
#include "reg_base.h"
#include "sync_data.h"
#include "drv_mdap_interface_hw_reg.h"
#include "intrCtrl.h"
#include "drv_mdap_interface_int_cfg.h"
#include <ex_public.h>


#if defined(__AMIF_TRACE_ENABLE__)
#include "TrcMod.h"
#define AMIF_DRV_EXCEP_TIMEOUT() MD_TRC_L1TRC_AMIF_DRV_EXCEP_TIMEOUT()
#else
#define AMIF_DRV_EXCEP_TIMEOUT()
#endif


#if defined(__MTK_TARGET__)
/* bb reg dump setting */
EX_BBREG_DUMP amif_dump;
const kal_uint32 amif_dump_regions[] =
{
    EMI_DVFS_BASE_ADDR_NON_BUFFERABLE        , 0x04, 4,
    EMI_DVFS_BASE_ADDR_NON_BUFFERABLE + 0x100, 0x14, 4,
    EMI_DVFS_BASE_ADDR_NON_BUFFERABLE + 0x300, 0xA0, 4
};
#endif /* __MTK_TARGET__ */

/* debug info for SPM. Should offer by SPM owner */
const kal_uint32 drv_mdap_interface_spm_dump_addr[] = {AP_SPM_DEBUG_REG_ADDR};

typedef struct drv_mdap_interface_req_timeout_info_s {
    kal_uint32 urgent_rc_latch_status;        /* offset 0x330, DVFSRC latch gear.(already ack) */
    kal_uint32 urgent_md_trigger_status;      /* offset 0x340, MD current trigger gear. */
    kal_uint32 scenario_rc_latch_status;      /* offset 0x334, DVFSRC latch scenario.(already ack) */
    kal_uint32 scenario_md_trigger_status;    /* offset 0x344, MD current trigger scenario. */
    kal_uint32 dvfsrc_dbg_reg[AP_DVFSRC_RECORD_REG_NUM];
    kal_uint32 spm_dbg_reg[sizeof(drv_mdap_interface_spm_dump_addr) / sizeof(kal_uint32)];
} drv_mdap_interface_req_timeout_info_t;

drv_mdap_interface_req_timeout_info_t drv_mdap_interface_req_timeout_info;

kal_uint32 DVFSRC_Basic_Control = 0;/* DVFSRC BASIC Control register, record for debugging. */
kal_uint32 DVFSRC_enable = 0;/* AP DVFSRC is 1:enable or 0:disable */

#if defined(ENABLE_MDAPINTERFACE)
void drv_mdap_interface_req_timeout_hldr()
{//Dump related debug info for debugging.
    /* production release case */
#if defined(__AMIF_REQ_TIMEOUT_ASSERT__)
    kal_uint32 reg_index;

    /* md part */
    drv_mdap_interface_req_timeout_info.urgent_rc_latch_status     = *MDMCU_EMI_DVFS_LAT_CUR_URGENT;
    drv_mdap_interface_req_timeout_info.urgent_md_trigger_status   = *MDMCU_EMI_DVFS_LAT_URGENT;
    drv_mdap_interface_req_timeout_info.scenario_rc_latch_status   = *MDMCU_EMI_DVFS_LAT_CUR_SCENARIO;
    drv_mdap_interface_req_timeout_info.scenario_md_trigger_status = *MDMCU_EMI_DVFS_LAT_SCENARIO;

    /* DVFSRC part */
    for (reg_index = 0; reg_index < AP_DVFSRC_RECORD_REG_NUM; reg_index++)
    {
        drv_mdap_interface_req_timeout_info.dvfsrc_dbg_reg[reg_index] = *(volatile kal_uint32 *)(AP_DVFSRC_RECORD_BASE + reg_index * 4);
    }

    /* SPM part */
    for (reg_index = 0; reg_index < sizeof(drv_mdap_interface_spm_dump_addr) / sizeof(kal_uint32); reg_index++)
    {
        drv_mdap_interface_req_timeout_info.spm_dbg_reg[reg_index] = *(volatile kal_uint32 *)drv_mdap_interface_spm_dump_addr[reg_index];        
    }

    ASSERT(0);
#else
    /* just ack */
    AMIF_DRV_EXCEP_TIMEOUT();
    *MDMCU_EMI_DVFS_ERR_FLAG = 1;
#endif
}

static kal_bool amif_bbregdump_callback()
{
    return KAL_TRUE;
}

#endif

void drv_mdap_interface_update_DVFSRC_Status()
{//Update DVFSRC enable bit to know DVFSRC HW is enable/disable
    DVFSRC_Basic_Control = *(volatile kal_uint32 *)AP_DVFSRC_BASIC_CONTROL;
    DVFSRC_enable = DVFSRC_Basic_Control & 0x1;
}

kal_uint32 drv_mdap_interface_get_DVFSRC_Status()
{//Get DVFSRC enable bit to know DVFSRC HW is enable/disable
    return DVFSRC_enable;
}

kal_uint32 drv_mdap_interface_get_DVFSRC_MD_Scenario()
{
    //return (*AP_DVFSRC_DEBUG_STA_0)&0xFFFF;
    return 0;//we didn't support this function in Gen95
}

kal_uint32 drv_mdap_interface_get_DVFSRC_OPP()
{
    //return *AP_DVFSRC_CURRENT_LEVEL;
    return 0;//we didn't support this function in Gen95
}

void drv_mdap_interface_hw_trigger(MD2AP_GEAR_INDEX gear)
{//Config related Gear to DVFSRC

    if(drv_mdap_interface_get_DVFSRC_Status()==1)
    {/* DVFSRC enable, AMIF could real work. */
        /* leave the error handling to user */
        if (MD2AP_GEAR_INVALID == gear)
            *MDMCU_EMI_DVFS_SCENARIO_VAL_BUFF = 0; 
        else
            *MDMCU_EMI_DVFS_SCENARIO_VAL_BUFF = gear;
    
        *MDMCU_EMI_DVFS_SCENARIO_SW_EVT_W1E_BUFF = 1;
        *MDMCU_EMI_DVFS_SCENARIO_SW_EVT_W1C = 1;
    
        MO_Sync();
    }
    else
    {/* DVFSRC is disable, AMIF disable, too. */
        /* Do nothing */
    }
}

void drv_mdap_inteface_hw_init()
{//AMIF HW init function, called by Drv_MDAPInterface_Init()
#if !defined(ENABLE_MDAPINTERFACE)//AMIF Disable

    /* DE: Since we didn't enable AMIF, these setting here is no meaning. */
    *MDMCU_EMI_DVFS_SCENARIO_VAL_BUFF = MDAP_INTERFACE_GEAR_MAX;
    *MDMCU_EMI_DVFS_SCENARIO_SW_EVT_W1E_BUFF = 1;
    *MDMCU_EMI_DVFS_SCENARIO_SW_EVT_W1C = 1;
    MO_Sync();

#else//AMIF enable

    /* Get and save DVFSRC Status. */
    drv_mdap_interface_update_DVFSRC_Status();

    if(drv_mdap_interface_get_DVFSRC_Status()==1)
    {/* DVFSRC enable, AMIF could real enable. */
        /* AMIF HW Configuration */
        *MDMCU_EMI_DVFS_SETTLET = MDAP_INTERFACE_HW_REQ_TIMEOUT_US;    // Set AMIF Timeout
        *MDMCU_EMI_DVFS_CONFG |= (1 << 2);    // Enable AMIF Timer
        *MDMCU_EMI_DVFS_CONFG |= 1;    // Enable AMIF
    
        /* Enable AMIF timeout check */
        *MDMCU_DVFS_CONFG |= 0x80;
        
        /* AMIF Timeout IRQ CFG */
        #if 0 /* Remove IRQ_Register_LISR() and IRQSensitivity() due to ISR Centralization. */ 
/* under construction !*/
/* under construction !*/
        #endif
        IRQUnmask(MD_IRQID_MDMCU_DVFS_CTRL);
    
        /* Dummy Trigger to AP to clear status before modem boot. */
        drv_mdap_interface_hw_trigger(MD2AP_GEAR_INVALID);
        
        /* Life-saving HW path, total 15 channels */
        //*MDMCU_DVFS_TMR_REMAP_REQ_EN = 0x7FFF;
        //*MDMCU_DVFS_TMR_REMAP_EN     = 0x7FFF;
    }
    else
    {/* DVFSRC disable, AMIF could bypass. */
        /* do noting */
    }

  #if defined(__MTK_TARGET__)
    /* register bb reg dump */
    amif_dump.regions = (kal_uint32*)amif_dump_regions;
    amif_dump.num     = sizeof(amif_dump_regions) / (sizeof(kal_uint32) * 3);
    amif_dump.bbreg_dump_callback = amif_bbregdump_callback;
    EX_REGISTER_BBREG_DUMP(&amif_dump);
  #endif /* __MTK_TARGET__ */

#endif
}

kal_uint32 drv_mdap_interface_hw_get_curr_scenario_reg()
{// return current requesting scenario
    return *MDMCU_EMI_DVFS_CUR_SCENARIO;
}

void drv_mdap_interface_enable_dvfsrc_gear_switch()
{//Use for IT with DVFSRC on full load(this function enable DVFSRC function and use on EIGER). Related setting offer from DVFSRC.
    *(volatile kal_uint32 *)0xC001200C = 0;
    *(volatile kal_uint32 *)0xC0012024 = 0;
    *(volatile kal_uint32 *)0xC001202C = 0;
    *(volatile kal_uint32 *)0xC0012030 = 0;
    *(volatile kal_uint32 *)0xC0012038 = 0;
    *(volatile kal_uint32 *)0xC001202C = 0;
    *(volatile kal_uint32 *)0xC001203C = 0;
    *(volatile kal_uint32 *)0xC0012040 = 0;
    *(volatile kal_uint32 *)0xC0012070 = 0;
    *(volatile kal_uint32 *)0xC0012078 = 0;
    *(volatile kal_uint32 *)0xC001207C = 0;
    *(volatile kal_uint32 *)0xC0012800 = 0;
    *(volatile kal_uint32 *)0xC0012804 = 0;
}

void Drv_MDAPInterface_Custom_Test(kal_uint32 cmd, kal_uint32 val)
{//Called in Custom_atcmd_parse.c. Use for IT with DVFSRC on full load(on EIGER).
    if (cmd == 0)
    {
        drv_mdap_interface_enable_dvfsrc_gear_switch();
    }
    else if (cmd == 1)
    {
        drv_mdap_interface_hw_trigger(val);
    }
}

