/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2010
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

 /*****************************************************************************
 *
 * Filename:
 * ---------
 *      logseq_drv.h
 *
 * Project:
 * --------
 *      UMOLYYA
 *
 * Description:
 * ------------
 *      This module defines the public APIs of log_seq driver
 *
 * Author:
 * -------
 * -------
 *
 *============================================================================
 *             HISTORY
 * Below this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *------------------------------------------------------------------------------
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 *
 * removed!
 * removed!
 *
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *
 * removed!
 * removed!
 * removed!
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *============================================================================
 *****************************************************************************/

#ifndef LOGSEQ_DRV_H_
#define LOGSEQ_DRV_H_

#include "kal_general_types.h"

#if defined(__MD93__) || defined(__MD95__)
/*!
 *  @brief LS error code enumeration
 *  @param LS_NO_ERROR                  LS no error
 *  @param LS_FLUSH_TIMEOUT             LS do flush timeout
 *  @param LS_ABORT_TIMEOUT             LS do abort timeout
 *  @param LS_FLUSH_RESUME_TIMEOUT      LS do flush & resume_after_flush timeout
 *  @param LS_ABORT_RESUME_TIMEOUT      LS do abort & resume_after_abort timeout
 *  @param LS_WHOLE_SYS_FLUSH_TIMEOUT   LS do whole system flush timeout
 *  @param LS_BACKUP_FAIL               LS do backup fail
 *  @param LS_RESTORE_FAIL              LS do restore fail
 */
typedef enum {
    LS_NO_ERROR = 0,
    LS_FLUSH_TIMEOUT = 0x1,
    LS_ABORT_TIMEOUT = 0x2,
    LS_FLUSH_RESUME_TIMEOUT = 0x4,
    LS_ABORT_RESUME_TIMEOUT = 0x8,
    LS_WHOLE_SYS_FLUSH_TIMEOUT = 0x10,
    LS_BACKUP_FAIL = 0x20,
    LS_RESTORE_FAIL = 0x40,
    LS_NO_DATA = 0x80,
    LS_INSERT_FAIL = 0x100,
    LS_EX_FAIL = 0x200,
    LS_FORCE_RLS_FAIL = 0x400,
    LS_FORCE_ABORT_FAIL = 0x800,
    LS_PLS_FLUSH_FAILED_DSP = 0x1000,
    LS_PLS_FLUSH_FAILED_MCU = 0x2000
}LS_ERROR_CODE;

/*!
 *  @brief LS channel id enumeration
 *  @param LS_DSP_CH             LS DSP channel
 *  @param LS_MCU_CH             LS MCU channel
 *  @param LS_CH_NUM             LS total channel number
 */
typedef enum {
    LS_DSP_CH,
    LS_MCU_CH,
    LS_CH_NUM
}LS_CH_ID;

/*!
 *  @brief LS EMI mode selection: user could configure LS_PLS for pls mode and LS_NORMAL_STREAM for streaming mode 
 */
typedef enum{
    LS_STREAM_EMI = 0,
    LS_PLS_EMI = 1,
    LS_EMI_MODE_NUM
}LS_EMI_MODE;

#elif defined(__MD97__)||defined(__MD97P__)
/*!
 *  @brief LS error code enumeration
 *  @param LS_NO_ERROR                  LS no error
 *  @param LS_FLUSH_TIMEOUT             LS do flush timeout
 *  @param LS_ABORT_TIMEOUT             LS do abort timeout
 *  @param LS_FLUSH_RESUME_TIMEOUT      LS do flush & resume_after_flush timeout
 *  @param LS_ABORT_RESUME_TIMEOUT      LS do abort & resume_after_abort timeout
 *  @param LS_WHOLE_SYS_FLUSH_TIMEOUT   LS do whole system flush timeout
 *  @param LS_BACKUP_FAIL               LS do backup fail
 *  @param LS_RESTORE_FAIL              LS do restore fail
 *  @param LS_NO_DATA					LS do not have any new data that do not query by the user
 * 	@param LS_INSERT_FAIL               LS insert emi_address != prev_emi_addr + new read length
 *  @param LS_EX_FAIL					LS is eigther not inital correctly or  in the wrong backup/restore state as entering EE flow
 * 	@param LS_FORCE_RLS_FAIL		    LS do not initial as calling force release API
 *	@param LS_FORCE_ABORT_FAIL			LS do force abort failed
 *	@param LS_PLS_FLUSH_FAILED_4G_DSP	LS failed to do the LS_FLUSH/ABORT in PLS mode(4G DSP)
 * 	@param LS_PLS_FLUSH_FAILED_5G_DSP	LS failed to do the LS_FLUSH/ABORT in PLS mode(5G DSP)
 *	@param LS_PLS_FLUSH_FAILED_MCU		LS failed to do the LS_FLUSH/ABORT in PLS mode(Shaolin or iA)
 * 	@param LS_INVALID_GROUP_POLICY      LS set group policy with the false configuration
 */

/*add abort operation record for debug*/
typedef struct {
			kal_uint32 FRC; // FRC
			kal_uint32 linnum;	//line number
			kal_uint32 status;//status 0:abort 1:check  
} ABORT_CHID_INFO;

typedef struct {
			kal_uint32 record_count; // channel ID 
			ABORT_CHID_INFO  abort_record_ch[10];
} ABORT_DEBUG_INFO;

typedef enum{
	LS_NORMAL_ABORT = 0,
	LS_NORMAL_CHECK ,
	LS_DORMANT_ABORT,
	LS_DORMANT_CHECK,
	LS_RESUME_CHECK,
	LS_EXCEPTION_ABORT,
	LS_EXCEPTION_CHECK,
}LS_ABORT_STATUS;


typedef enum {
    LS_NO_ERROR = 0,
    LS_FLUSH_TIMEOUT = 0x1,
    LS_ABORT_TIMEOUT = 0x2,
    LS_FLUSH_RESUME_TIMEOUT = 0x4,
    LS_ABORT_RESUME_TIMEOUT = 0x8,
    LS_WHOLE_SYS_FLUSH_TIMEOUT = 0x10,
    LS_BACKUP_FAIL = 0x20,
    LS_RESTORE_FAIL = 0x40,
    LS_NO_DATA = 0x80,
    LS_INSERT_FAIL = 0x100,
    LS_EX_FAIL = 0x200,
    LS_FORCE_RLS_FAIL = 0x400,
    LS_FORCE_ABORT_FAIL = 0x800,
	LS_PLS_FLUSH_FAILED_4G_DSP = 0x1000,
	LS_PLS_FLUSH_FAILED_5G_DSP = 0x2000,
	LS_PLS_FLUSH_FAILED_MCU = 0x4000,
	LS_INVALID_GROUP_POLICY = 0x8000,
	LS_INVALID_STOP_ADDR = 0x10000
}LS_ERROR_CODE;

/*!
 *  @brief LS error code enumeration specifiy for sleep it
 *  @param LS_SLEEP_NO_ERROR            LS no error
 *  @param LS_SLEEP_ABORT_TIMEOUT  		LS do abort timeout
 *  @param LS_SLEEP_BACKUP_FAIL  		LS do backup timeout
 */
typedef enum{
	LS_SLEEP_NO_ERROR = 0,
	LS_SLEEP_ABORT_TIMEOUT = 0x1,
	LS_SLEEP_BACKUP_FAIL = 0x2,
	LS_SLEEP_RESTORE_FAIL = 0x4
}LS_SLEEP_ERROR_CODE;

/*!
 *  @brief LS channel id enumeration
 *  @param LS_4G_DSP_NORMAL_CH             LS 4G DSP normal channel
 *  @param LS_4G_DSP_ONDEMAND_CH           LS 4G DSP ondemand channel
 *  @param LS_5G_DSP_NORMAL_CH             LS 5G DSP normal channel
 * 	@param LS_5G_DSP_ONDEMAND_CH           LS 5G DSP ondemand channel
 * 	@param LS_MCU_NORMAL_CH				   LS MCU normal channel
 * 	@param LS_MCU_ONDEMAND_CH			   LS MCU ondemand channel
 *	@param LS_CH_NUM					   LS total channel number
 */
typedef enum {
	LS_4G_DSP_NORMAL_CH = 0,
	LS_4G_DSP_ONDEMAND_CH = 1,
	LS_5G_DSP_NORMAL_CH,
	LS_5G_DSP_ONDEMAND_CH,
	LS_MCU_NORMAL_CH, //Shaolin or iA
	LS_MCU_ONDEMAND_CH, //Shaolin or iA
	LS_CH_NUM
}LS_CH_ID;

/*!
 *  @brief LS set id enumeration
 *  @param LS_4G_DSP_ALL             LS 4G DSP normal and ondemand channel
 *  @param LS_5G_DSP_ALL             LS 5G DSP normal and ondemand channel
 * 	@param LS_MCU_ALL				 LS MCU normal and ondemand channel
 * 	@param LS_SET_NUM			     LS all set channel number
 */
typedef enum {
    LS_4G_DSP_ALL = 0,
    LS_5G_DSP_ALL, 
    LS_MCU_ALL,
    LS_SET_NUM
}LS_SET_ID;


/*!
 *  @brief LS EMI mode enumeration
 *  @param LS_STREAM_EMI			LS configures streaming EMI
 *	@param LS_WRAP_EMI				LS configures wrapping EMI
 *	@param LS_EMI_MODE_NUM          LS EMI mode number
 */
typedef enum{
	LS_STREAM_EMI = 0,
	LS_WRAP_EMI = 1,
	LS_EMI_MODE_NUM
}LS_EMI_MODE;

/*!
 *  @brief LS mode type enumeration
 *  @param LS_NON_PLS_MODE			user set LS as non-PLS logging/normal logging(USB, SD logging)
 *	@param LS_PLS_MODE				user set LS as PLS logging(Passive Logging to SD)
 *	@param LS_MODE_TYPE_NUM         LS mode type number
 */
typedef enum{
    LS_NON_PLS_MODE = 0, 
    LS_PLS_MODE = 1,
    LS_MODE_TYPE_NUM
}LS_MODE_TYPE;

/*!
 *  @brief LS output enumeration
 *  @param LS_TO_SIB			LS output to SIB.
 *	@param LS_TO_EMI			LS output to EMI.
 *	@param LS_OUTPUT_NUM        LS output number
 */
typedef enum {
    LS_TO_SIB = 0,
    LS_TO_EMI,
    LS_OUTPUT_NUM
}LS_OUTPUT;

/*!
 *  @brief LS internal buffer unlock threshold setting enumeration
 *  @param LS_EMPTY					 LS buffer unlock when the L2 is totally empty
 *	@param LS_HALF_EMPTY			 LS buffer unlock when the L2 is 1/2 empty
 *	@param LS_QUATER_EMPTY           LS buffer unlock when the L2 is 1/4 empty
 *  @param LS_BUF_UNLOCK_THRS_NUM    LS buffer unlock number
 */
typedef enum {
    LS_EMPTY = 0,
    LS_HALF_EMPTY = 1,
    LS_QUATER_EMPTY = 2,
    LS_BUF_UNLOCK_THRS_NUM
}LS_INTERNAL_BUF_UNLOCK_THS;

/*!
 *  @brief LS mode type enumeration
 *  @param DENY_ALL						LS do not let any data in.
 *	@param ACCEPT_GROUP0				LS only let the souce ID MSB = 0 data in.
 *	@param ACCEPT_GROUP1         		LS only let the source ID MSB = 1 data in.
 *	@param ACCEPT_BOTH					LS accept all source ID data.
 *	@param DECODER_GROUP_POLICY_NUM     The group policy setting number
 */
typedef enum{
    DENY_ALL = 0,
    ACCEPT_GROUP0 = 1,
    ACCEPT_GROUP1 = 2,
    ACCEPT_BOTH = 3,
    DECODER_GROUP_POLICY_NUM
}DECODER_GROUP_POLICY;

#else
#error "No chip matched, please check it."
#endif

/*!
 *  @brief LS get EMI buffer address & length whether is wrapped or not
 *  @param LS_NO_WRAPPED          LS return without wrapped address & length
 *  @param LS_WRAPPED             LS return with wrapped address & length
 */
typedef enum {
    LS_GET_DATA,
    LS_GET_NO_DATA
}LS_GET_ADDR_LEN_INFO;

/*!
 *  @brief LS interrupt issue mode
 *  @param LS_INT_THRESHOLD_MODE        LS issue interrupt by threshold count
 *  @param LS_INT_REMAIN_SIZE_MODE      LS issue interrupt by EMI remain size
 */
typedef enum {
    LS_INT_THRESHOLD_MODE,
    LS_INT_REMAIN_SIZE_MODE
}LS_LOGSEQ_INT_MODE;

/*!
 *  @brief LS EMI bandwidth selection. HW default is LS_BW_5US
 */
typedef enum{
    LS_BW_NO_LIMIMT,
    LS_BW_4US,
    LS_BW_5US,
    LS_BW_10US,
    LS_BW_16US,
    LS_BW_21US,
    LS_BW_32US,
    LS_BW_64US,
    LS_BW_128US,
    LS_BW_256US
}LS_BW_CTRL;

/*!
 *  @brief LS logging mode: user only uses LS_NORMAL, and the others are for driver verification
 */
typedef enum{
    LS_NORMAL = 0,
    LS_L2AUTO = 1,
    LS_INAUTO = 2,
    LS_TEST_MODE = 4
}LS_LOGGING_MODE;



/*!
 *  @brief LS threshold buffer query result: when user query threshold buffer info, the return value will be as below
 */
typedef enum {
    LS_QUERY_END,
    LS_QUERY_CONTINUE,
    LS_QUERY_INVALID
}LS_QUERY_THRS_BUF_INFO;

#if defined(__MD93__) || defined(__MD95__)
/*!
 *  @brief define macro to configure LSInitInfo
 */
#define LS_Init_Info_initial    {0, 0, LS_BW_5US, 0, 0, 0, LS_NORMAL, 1, 0, 1, 0, 0, 0, LS_STREAM_EMI, 0}

/*!
 *  @brief LOG_SEQ_Init_Info is used to record the LOG_SEQ IP initial information
 */
typedef struct{
    /*!
     *  @brief ls_emi_base_addr is EMI base address
     */
    kal_uint32  ls_emi_base_addr;           // emi buffer address
    /*!
     *  @brief ls_emi_size is EMI buffer size (unit:byte)
     */
    kal_uint32  ls_emi_size:27;                // emi buffer size (unit:byte)
     /*!
     *  @brief ls_emi_bandwidth_ctrl is EMI bandwidth control(0~9, 0 is no limit)
     */
    kal_uint32  ls_emi_bandwidth_ctrl:4;      // 0~9, 0 is no limit
    /*!
     *  @brief ls_emi_wrapping_mode_en is EMI buffer wrapping mode enable(no interrupt will be issued, no EMI buffer blocking when LS write EMI buffer)
     */
    kal_uint32  ls_emi_wrapping_mode_en:1;    // 1, wrapping mode enable
    /*!
     *  @brief ls_emi_over_ths_int_level is EMI buffer over threshold interrupt level(unit:byte)
     *         when threshold count over this level, LS will issue interrupt
     */
    kal_uint32  ls_emi_over_ths_int_level:27;
    /*!
     *  @brief ls_emi_over_ths_en is Enable LS to issue interrupt when threshold count beyond the LS_EMI_BUF_OVER_THS_LEVEL
     */
    kal_uint32  ls_emi_over_ths_en:1;
    /*!
     *  @brief ls_log_mode_en is LS input mode selection (0:normal, 1:L2AUTO mode, 2:INAUTO mode, 4:SW test mode,
     */
    kal_uint32  ls_log_mode_en:3;
    /*!
     *  @brief ls_output_to_emi is LS output path(0:output to ATB, 1:output to EMI)
     */
    kal_uint32  ls_output_to_emi:1;
    /*!
     *  @brief ls_auto_test_init_val is initial value control of auto test mode counter
     */
    kal_uint32  ls_auto_test_init_val:14;
    /*!
     *  @brief ls_internal_buf_unlock_ths is internal buffer unlock thesis after internal buffer full(0~2, 0:total empty, 1:half empty, 2:usage 1/4)
     */
    kal_uint32  ls_internal_buf_unlock_ths:2; // 0~2
    /*!
     *  @brief ls_emi_pri_ultra_en is LS Enable EMI Priority Dynamic Adjustment Feature
     */
    kal_uint32  ls_emi_pri_ultra_en:1;
    /*!
     *  @brief ls_emi_pri_ultra_h_level is LS set EMI priority to ULTRA if L2 buffer usage beyond this level (unit:128 bytes)
     */
    kal_uint32  ls_emi_pri_ultra_h_level:6;
    /*!
     *  @brief ls_emi_pri_ultra_l_level is LS set EMI priority to normal if L2 buffer usage below this level (unit:128 bytes)
     */
    kal_uint32  ls_emi_pri_ultra_l_level:6;
	/*!
	*  @brief ls_emi_mode is user can select emi to streaming mode or PLS mode
	*/
	kal_uint32	ls_emi_mode_select:1;
    /*!
     *  @brief reserve
     */
    kal_uint32  rsv:2;
}LOG_SEQ_Init_Info;

/*!
 *  @brief LOG_SEQ_Callback_Info is used to record the LOG_SEQ IP callback functions
 */
typedef struct{
    /*!
     *  @brief buffer_over_ths_callback is LS callback function for EMI over threshold
     */
    void (*buffer_over_ths_callback)(kal_uint8);
    /*!
     *  @brief flush_callback is LS callback function for EMI flush in exception mode
     */
    void (*flush_ex_callback)(kal_uint8, kal_uint32, kal_uint32);
    /*!
     *  @brief the swwa callback for DHL to decide if activating sw workaround or assert.     
     *  @param channel id     
     */
    void (*action_for_ls_abort_timeout)(kal_uint8);
    
}LOG_SEQ_Callback_Info;

#elif defined(__MD97__)||defined(__MD97P__)
/*!
 *  @brief LOG_SEQ_Init_Info is used to record the LOG_SEQ IP initial information
 */
typedef struct{
	/*!
	 *	@brief ls_emi_base_addr is EMI base address
	 */
	kal_uint32	ls_emi_base_addr;			// emi buffer address
	/*!
	 *	@brief ls_emi_size is EMI buffer size (unit:byte)
	 */
	kal_uint32	ls_emi_size:27; 			   // emi buffer size (unit:byte)
	 /*!
	 *	@brief ls_emi_bandwidth_ctrl is EMI bandwidth control(0~9, 0 is no limit)
	 */
	kal_uint32	ls_emi_bandwidth_ctrl:4;	  // 0~9, 0 is no limit
	/*!
	 *	@brief ls_emi_wrapping_mode_en is EMI buffer wrapping mode enable(no interrupt will be issued, no EMI buffer blocking when LS write EMI buffer)
	 */
	kal_uint32	ls_emi_wrapping_mode_en:1;	  //0, streaming mode enable. 1, wrapping mode enable (DHL did not have to fill this variable)
	/*!
	 *	@brief ls_emi_over_ths_int_level is EMI buffer over threshold interrupt level(unit:byte)
	 *		   when threshold count over this level, LS will issue interrupt
	 */
	kal_uint32	ls_emi_over_ths_int_level:27;
	/*!
	 *	@brief ls_emi_over_ths_en is Enable LS to issue interrupt when threshold count beyond the LS_EMI_BUF_OVER_THS_LEVEL
	 */
	kal_uint32	ls_emi_over_ths_en:1;
	/*!
	 *	@brief ls_log_mode_en is LS input mode selection (0:normal, 1:L2AUTO mode, 2:INAUTO mode, 4:SW test mode,
	 */
	kal_uint32	ls_log_mode_en:3;
	/*!
	 *	@brief ls_output_to_emi is LS output path(0:output to ATB, 1:output to EMI)
	 */
	kal_uint32	ls_output_to_emi:1;
	/*!
	 *	@brief ls_auto_test_init_val is initial value control of auto test mode counter
	 */
	kal_uint32	ls_auto_test_init_val:14;
	/*!
	 *	@brief ls_internal_buf_unlock_ths is internal buffer unlock thesis after internal buffer full(0~2, 0:total empty, 1:half empty, 2:usage 1/4)
	 */
	kal_uint32	ls_internal_buf_unlock_ths:2; // 0~2 0: empty, 1: half-empty, 2: quater-empty
	/*!
	 *	@brief ls_emi_pri_ultra_en is LS Enable EMI Priority Dynamic Adjustment Feature
	 */
	kal_uint32	ls_emi_pri_ultra_en:1;
	/*!
	 *	@brief ls_emi_pri_ultra_h_level is LS set EMI priority to ULTRA if L2 buffer usage beyond this level (unit:128 bytes)
	 */
	kal_uint32	ls_emi_pri_ultra_h_level:6;
	/*!
	 *	@brief ls_emi_pri_ultra_l_level is LS set EMI priority to normal if L2 buffer usage below this level (unit:128 bytes)
	 */
	kal_uint32	ls_emi_pri_ultra_l_level:6;
	/*!
	*  @brief ls_emi_mode is user can select emi to streaming mode or PLS mode
	*/
	kal_uint32	ls_mode_type_select:1; //PLS mode/non-PLS mode
	/*!
	 *	@brief reserve1
	 */
	kal_uint32	rsv1:2;
	/*!
	 *	@brief ls_group_policy is set the decoder policy to each LS (total 6 LS need to set)
	 */
	kal_uint8	ls_group_policy:2;
	/*!
	 *	@brief ls_hw_pwr_protect_en is set the hw lock power if ls_back_done = 0
	 */	
	kal_uint8	ls_hw_pwr_protect_en:1;
	/*!
	 *	@brief reserve2
	 */
	kal_uint8	rsv2:5;
    /*!
     *  @brief buffer_over_ths_callback is LS callback function for EMI over threshold
     */
	void (*buffer_over_ths_callback)(LS_CH_ID); 	// EMI interrupt callback(SW)
    /*!
     *  @brief flush_callback is LS callback function for EMI flush in exception mode
     */
	void (*flush_ex_callback)(LS_CH_ID, kal_uint32, kal_uint32);// LS flush in EE flow callback(SW)
    /*!
     *  @brief the swwa callback for DHL to decide if activating sw workaround or assert.     
     *  @param channel id     
     */
	void (*action_for_ls_abort_timeout)(LS_CH_ID); // LS abort timeout swwa callback(SW)
}LOG_SEQ_Init_Info;

/*!
 *  @brief LOG_SEQ_Sleep_Error_Status is used to record the LOG_SEQ sleep flow error information
 */
typedef struct{
	LS_SLEEP_ERROR_CODE error_id[LS_CH_NUM];//the error information is recorded by channel
}LOG_SEQ_Sleep_Error_Status;

#else
#error "No chip matched, please check it."
#endif

/*!
 *  @brief LOG_SEQ_Emi_Buf_Addr_Len is EMI buffer address & length of EMI log
 */
typedef struct{
    /*!
     *  @brief addr is EMI log start address
     */
    kal_uint32  addr;
    /*!
     *  @brief len is EMI log length
     */
    kal_uint32  len;
}LOG_SEQ_Emi_Buf_Addr_Len;

/*!
 *  @brief LOG_SEQ_Thrs_Buf_Info is EMI threshold buffer address & length of EMI log
 */
typedef struct log_seq_thrs_buf_info_t{
    kal_uint32  addr;
    kal_uint32  len;
} LOG_SEQ_Thrs_Buf_Info;

//===========================================================================

#if defined(__MD93__) || defined(__MD95__)
/*!
 *  @brief LOG SEQ driver init
 *  @param ch_id            channel id
 *  @param pInitInfo        initial info.
 */
void logseq_drv_init(kal_uint8 ch_id, LOG_SEQ_Init_Info* pInitInfo);

/*!
 *  @brief LOG SEQ callback function init
 *  @param pCallbackInfo    callback function info
 */
void logseq_drv_buf_full_callback_init(LOG_SEQ_Callback_Info* pCallbackInfo);

/*!
 *  @brief LOG SEQ get address and length that should be handled
 *  @param ch_id            channel id
 *  @param ls_addr_len      addr&len info
 */
void logseq_drv_get_addr_len(kal_uint8 ch_id, LOG_SEQ_Thrs_Buf_Info *thrs_buf);

/*!
 *  @brief LOG SEQ release EMI buffer from read pointer
 *  @param ch_id            channel id
 *  @param release_size     release size of EMI buffer
 */
void logseq_drv_release_emi_buf(kal_uint8 ch_id, kal_uint32 release_size);


/*!
 *  @brief LOG SEQ release EMI buffer from read pointer
 *  @param ch_id            channel id
 *  @param release_size     release size of EMI buffer
 */
void logseq_drv_release_emi_buf_ex(kal_uint8 ch_id, kal_uint32 release_size);


/*!
 *  @brief LOG SEQ stop LS with flush log in EMI buffer
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_stop(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ stop LS immediately
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_stop_im(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ resume LS logging from stop
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_resume(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ stop/re-dump LS in exception mode
 *  @param ch_id                channel id
 *  @param whole_sys_flush_en   trigger whole system flush or not
 */
kal_uint32 logseq_drv_stop_redump_ex(kal_uint8 ch_id, kal_bool whole_sys_flush_en);

/*!
 *  @brief LOG SEQ query EMI threshold buffer information
 *  @param ch_id                channel id
 *  @param thrs_buf             threshold buffer information
 */
kal_uint8 logseq_drv_query_thrs_buf(kal_uint8 ch_id, LOG_SEQ_Thrs_Buf_Info* thrs_buf);

/*!
 *  @brief LOG SEQ force release EMI threshold count without over threshold level
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_force_rls_ths_count(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ set EMI mode, default is LS_STREAM_EMI
 *  @param ch_id            channel id
 *	@param mode				LS_STREAM_EMI, LS_PLS_EMI
 */
kal_uint32 logseq_drv_set_mode(kal_uint8 ch_id, kal_atomic_uint32 mode);

/*!
 *  @brief LOG SEQ start tag log
 *  @param void            
 */
kal_uint32 logseq_drv_tagStart(void);

/*!
 *  @brief LOG SEQ set EMI mode, default is LS_STREAM_EMI
 *  @param void            
 */
void logseq_drv_tagEnd(void);

#elif defined(__MD97__)||defined(__MD97P__)

/*!
 *  @brief LOG SEQ set/get SW TEST DATA register for test flag
 *  @param ch_id           	channel ID
 *  @param vaule             test flag vaule
 */
void  logseq_drv_set_sw_test_reg(LS_CH_ID ch_id, kal_uint32 vaule);	
kal_uint32 logseq_drv_get_sw_test_reg(kal_uint8 ch_id);



/*!
 *  @brief LOG SEQ driver init (New in Gen97)
 *  @param ch_id           	channel ID
 *  @param pInitInfo  		fill the HW register initial value.
 */
void logseq_drv_set_default_value(LS_CH_ID ch_id, LOG_SEQ_Init_Info* pInitInfo);

/*!
 *  @brief LOG SEQ driver init
 *  @param set_id           set id
 *  @param normal_InitInfo  normal LS initial information
 *	@param ondemand_InitInfo ondemand LS initial information
 */
void logseq_drv_init(LS_SET_ID set_id, LOG_SEQ_Init_Info* normalInitInfo, LOG_SEQ_Init_Info* ondemandInitInfo); 

/*!
 *  @brief LOG SEQ release EMI buffer from read pointer
 *  @param ch_id            channel id
 *  @param release_size     release size of EMI buffer
 */
void logseq_drv_release_emi_buf(LS_CH_ID ch_id, kal_uint32 release_size);

/*!
 *  @brief LOG SEQ stop LS with flush log in EMI buffer
 *  @param 4G_DSP_en            4G DSP should do the LS backup/restore
 *  @param 5G_DSP_en            5G DSP should do the LS backup/restore
 *  @param MCU_en           	MCU should do the LS backup/restore
 */
LS_ERROR_CODE logseq_drv_stop(kal_uint8 _4G_DSP_en, kal_uint8 _5G_DSP_en, kal_uint8 MCU_en);

/*!
 *  @brief LOG SEQ stop LS immediately
 *  @param 4G_DSP_en            4G DSP should do the LS backup/restore
 *  @param 5G_DSP_en            5G DSP should do the LS backup/restore
 *  @param MCU_en           	MCU should do the LS backup/restore
 */
LOG_SEQ_Sleep_Error_Status logseq_drv_stop_im(kal_uint8 _4G_DSP_en, kal_uint8 _5G_DSP_en, kal_uint8 MCU_en);

/*!
 *  @brief LOG SEQ resume LS logging from stop
 *  @param 4G_DSP_en            4G DSP should do the LS backup/restore
 *  @param 5G_DSP_en            5G DSP should do the LS backup/restore
 *  @param MCU_en           	MCU should do the LS backup/restore
 */
LOG_SEQ_Sleep_Error_Status logseq_drv_resume(kal_uint8 _4G_DSP_en, kal_uint8 _5G_DSP_en, kal_uint8 MCU_en);

/*!
 *  @brief LOG SEQ resume LS logging from stop
 *  @param 4G_DSP_en            4G DSP should do the LS backup/restore
 *  @param 5G_DSP_en            5G DSP should do the LS backup/restore
 *  @param MCU_en           	MCU should do the LS backup/restore
 */
LOG_SEQ_Sleep_Error_Status logseq_drv_resume_ex(kal_uint8 _4G_DSP_en, kal_uint8 _5G_DSP_en, kal_uint8 MCU_en);


/*!
 *  @brief LOG SEQ stop/re-dump LS in exception mode
 *  @param ch_id                channel id
 *  @param whole_sys_flush_en   trigger whole system flush or not
 */
LS_ERROR_CODE logseq_drv_stop_redump_ex(LS_CH_ID ch_id, kal_bool whole_sys_flush_en);

/*!
 *  @brief LOG SEQ query EMI threshold buffer information
 *  @param ch_id                channel id
 *  @param thrs_buf             threshold buffer information
 */
LS_QUERY_THRS_BUF_INFO logseq_drv_query_thrs_buf(LS_CH_ID ch_id, LOG_SEQ_Thrs_Buf_Info* thrs_buf);

/*!
 *  @brief LOG SEQ force release EMI threshold count without over threshold level
 *  @param ch_id            channel id
 */
LS_ERROR_CODE logseq_drv_force_rls_ths_count(LS_CH_ID ch_id);

/*!
 *  @brief LOG SEQ set EMI mode, default is LS_STREAM_EMI
 *  @param set_id            channel id
 *	@param mode				 LS_NON_PLS_MODE, LS_PLS_MODE
 */
LS_ERROR_CODE logseq_drv_set_mode(LS_SET_ID set_id, LS_MODE_TYPE mode);

/*!
 *  @brief LOG SEQ start tag log
 *  @param void            
 */
LS_ERROR_CODE logseq_drv_tagStart(void);

/*!
 *  @brief LOG SEQ set EMI mode, default is LS_STREAM_EMI
 *  @param void            
 */
void logseq_drv_tagEnd(void);

/*!
 *  @brief set the stop address to the specific channel id (New in Gen97)
 *  @param ch_id                channel id          
 */
LS_ERROR_CODE logseq_drv_set_stopAddr(LS_CH_ID ch_id, kal_uint32 addr);

/*!
 *  @brief clear the stop_address of specific channel id (New in Gen97)
 *  @param ch_id                channel id          
 */
kal_bool logseq_drv_remove_stopAddr(LS_CH_ID ch_id);

kal_uint32 logseq_drv_get_emi_type(kal_uint8 ch_id);

#else
#error "No chip matched, please check it."
#endif

//93.95.97 common prototype API
/*!
 *  @brief LOG SEQ set flush and resume simultaneously
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_flush_and_resume(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ get level 2 buffer usage
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_get_L2_usage(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ get EMI buffer size
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_get_emi_size(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ get EMI remain size
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_get_emi_remain_size(kal_uint32 ch_id);

/*!
 *  @brief check if LOG SEQ is init
 *  @param ch_id            channel id
 */
kal_bool is_logseq_drv_init(kal_uint32 ch_id);

/*!
 *  @brief LOG SEQ call DHL callback after leaving dormant flow
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_resume_force_rls(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ LS reset on 93 sw workaround for LS abort failed
 *  @param ch_id            channel id
 */
kal_uint32 logseq_drv_reinit_after_abort_failed(kal_uint8 ch_id);

/*!
 *  @brief LOG SEQ stop LS in exception mode
 *  @param ch_id                channel id
 *  @param whole_sys_flush_en   trigger whole system flush or not
 */
kal_uint32 logseq_drv_stop_ex(kal_uint8 ch_id, kal_bool whole_sys_flush_en);

//20170801- OPPO NEW feature: to take the log from memory dump 
//add two new APIs -logseq_drv_get_write_align_addr and logseq_drv_get_emi_wrapping_bit
/*!
 *  @brief get the emi write aligned address, read from HW reg or SW global on demand.
register and backup variable
 *  @param ch_id                channel id          
 */
kal_uint32 logseq_drv_get_write_align_addr(kal_uint8 ch_id);

/*!
 *  @brief judge if LOG SEQ get emi wrapping bit is set or not, read hw register and backup variable
 *  @param ch_id                channel id          
 */
kal_bool logseq_drv_get_emi_wrapping_bit(kal_uint8 ch_id);

//20180802- Gen97 new feature required by st3
/*!
 *  @brief get the emi write  address, read from HW reg.
 *  @param ch_id                channel id          
 */
kal_uint32 logseq_drv_get_write_addr(kal_uint8 ch_id);

/*!
 *  @brief get the LS dbg information if LS abort timeout happened, 
 the DHL should assert while using this API or it could cause HRT failed.
 *  @param ch_id                channel id          
 */
void logseq_drv_ls_hang_dbg_info(kal_uint8 ch_id);

/*!
 *  @brief get the LS mode information 
 the DHL can not call get mode API and set mode API at the same time
 *  @param ch_id                channel id          
 */
kal_uint32 logseq_drv_get_mode_select(kal_uint8 ch_id);

#endif /* LOG_SEQ_H_ */
