/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * ---------
 *   http_apis.h 
 *
 * Project:
 * --------
 *   Submarine
 *
 * Description:
 * ------------
 *   
 *
 * Author:
 * -------
 * -------
 *
 * ==========================================================================
 * $Log$
 *
 * 08 11 2022 panu.peisa
 * [MOLY00844196] [CR Review Excluded][SV Focus][Internal][MT6895][Pichon][S0][Pre-DCP][IMS][France][Orange][LiveNW][TCID: 59x.1.4.1.1.b] XCAP failures in flight mode + WFC
 * 	
 * 	.
 *
 * 09 18 2020 jing.cui
 * [MOLY00565233] Telus requirement TELUS-v11.0_VOLTE-431 and TELUS-v11.0_VOLTE-432 UE SHALL NOT include the port number in the Host header of the HTTP request
 * hide port: interface part.
 *
 * 09 11 2020 jing.cui
 * [MOLY00565233] Telus requirement TELUS-v11.0_VOLTE-431 and TELUS-v11.0_VOLTE-432 UE SHALL NOT include the port number in the Host header of the HTTP request
 * hide port number:interface part.
 *
 * 09 01 2020 jing.cui
 * [MOLY00565233] Telus requirement TELUS-v11.0_VOLTE-431 and TELUS-v11.0_VOLTE-432 UE SHALL NOT include the port number in the Host header of the HTTP request
 * 	
 * hide port number:interface part. 
 * EWSP0000149753
 *
 * 07 01 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   1) Added MTU size in config
 *   2) Added dest ip info in REQ_CNF
 *
 * 06 25 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   1) Add connection IP priority config
 *   2) Fix EE
 *
 * 06 13 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   Add DNS TTL value config
 *
 * 05 03 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 * 	
 * 	.
 *
 *
****************************************************************************/
#ifndef _HTTP_APIS_H
#define _HTTP_APIS_H

#include "kal_public_defs.h"
#include "ps_public_enum.h"

typedef enum {
    HTTP_CONFIG_IDX_BOOL_START = 0,
    HTTP_CONFIG_IDX_BOOL_GZIP_SUPPORT,
    HTTP_CONFIG_IDX_BOOL_SSL_TRUST,
    HTTP_CONFIG_IDX_BOOL_AUTH_REQ_HANDLE_BY_APP,
    HTTP_CONFIG_IDX_BOOL_ENABLE_QUICK_ATTEMPT,
    HTTP_CONFIG_IDX_BOOL_HIDE_PORT_NUMBER,
    HTTP_CONFIG_IDX_BOOL_DNS_FORCE_QUERY,    
    HTTP_CONFIG_IDX_BOOL_END,

    HTTP_CONFIG_IDX_INT_START,
    HTTP_CONFIG_IDX_INT_DNS_SERVER_IPV4V6_PRIORITY,
    HTTP_CONFIG_IDX_INT_CONNECTION_TIMEOUT,
    HTTP_CONFIG_IDX_INT_REQUEST_TIMEOUT,
    HTTP_CONFIG_IDX_INT_DNS_TIMEOUT,
    HTTP_CONFIG_IDX_INT_DNS_TTL_VALUE,
    HTTP_CONFIG_IDX_INT_CONNECTION_IPV4V6_PRIORITY,
    HTTP_CONFIG_IDX_INT_MAX_MTU_SIZE,
    HTTP_CONFIG_IDX_INT_END,

    HTTP_CONFIG_IDX_STR_START,
    HTTP_CONFIG_IDX_STR_END
}HTTP_CONFIG_IDX_ENUM;

typedef struct {
    kal_bool    support_gzip;
    kal_bool    support_always_trust_ssl; //skip UE verifying Server's certificate
    kal_bool    auth_req_handle_by_app; // If APP wants to process and reply to 401 unauthorised:true(default), else:false
    kal_bool    quick_connect_attempt_enabled;   // Use quick attempt mechanism of connection
    // Use IPv6 DNS server at first or IPv4 DNS server at first for query; 0:No_preference, 1:IPv4, 2:IPv6
    kal_uint8   dns_server_ipv4v6_priority; 
    // Use IPv6 resolved IP first or IPv4 first for connection; 0:No_preference(default), 1:IPv4, 2:IPv6
    kal_uint8   connection_ipv4v6_priority;
    kal_uint32  connect_timeout;        // HTTP Connection timeout
    kal_uint32  timeout;                // HTTP Communcation timeout
    kal_uint32  dns_timeout;            // DNS query timeout
    kal_uint32  dns_ttl_value;          // DNS query's response TTL value
    kal_uint32  max_mtu_size;           // Max MTU size of TCP/UDP
    kal_bool    hide_port_number;       //xcap request hide port number. KAL_TRUE:hide, KAL_FALSE:display
    kal_bool    dns_force_query;        // Force DNS query in AP mode for new PDN connection. When this flag is set, HTTP module pass it to DNS module and it should trigger new DNS query.    
} app_http_config_struct;

void app_http_get_default_config(app_http_config_struct *config);
kal_bool app_http_set_config(HTTP_CONFIG_IDX_ENUM index, void *value, app_http_config_struct *config);

#endif
