/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * ---------
 *   http_if.h 
 *
 * Project:
 * --------
 *   Submarine
 *
 * Description:
 * ------------
 *   
 *
 * Author:
 * -------
 * -------
 *
 * ==========================================================================
 * $Log$
 *
 * 11 19 2020 heiping.lei
 * [MOLY00574882] ?19420_NZ??Network??OP_Vodafone???????CSFB
 * 	
 * 	add header files for cipher list function.
 *
 * 09 18 2020 jing.cui
 * [MOLY00565295] Telus requirement  TELUS-v11.0_VoLTE-137 and TELUS-v11.0_VoLTE-138 DNS Failover
 * specify_ip:interface part.
 *
 * 09 14 2020 jing.cui
 * [MOLY00565295] Telus requirement  TELUS-v11.0_VoLTE-137 and TELUS-v11.0_VoLTE-138 DNS Failover
 * specify IP:interface part.
 *
 * 09 01 2020 jing.cui
 * [MOLY00565295] Telus requirement  TELUS-v11.0_VoLTE-137 and TELUS-v11.0_VoLTE-138 DNS Failover
 * 	
 * 	specify ip:interface part.
 * 	EWSP0000149880
 *
 * 07 01 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   1) Added MTU size in config
 *   2) Added dest ip info in REQ_CNF
 *
 * 06 13 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   Add DNS TTL value config
 *
 * 06 11 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 * 1) Content length max size increased to 13k
 * 2) DNS query family & flag based on local ip address type
 * 3) Remove memory leaks
 *
 * 05 22 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   1) Check UE IP type to select NW IP
 *   2) Provide cipher suite ID in MSG_ID_APP_HTTP_REQUEST_CNF MSG
 *
 * 05 20 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 *   TLS integration
 *
 * 05 18 2019 deepti.singh
 * [MOLY00402207] [Submarine][M1][RDIT][CT][PCT][TC-ID][Anite][VOLTE][E03][15.5]Step 1 - 4: timeout during HTTP authentication
 * [MOLY00397188] [Submarine]HTTP dev
 *   Zlib lib porting & integration for gZip decoding/uncompression
 *
 * 05 03 2019 deepti.singh
 * [MOLY00397188] [Submarine]HTTP dev
 * 	1. Remove Asserts
 * 	2. DNS timeout fix
 * 	3. connection timeout fix
 * 	4. Add trace in Inet lib
 *
 *
****************************************************************************/
#ifndef _HTTP_IF_H
#define _HTTP_IF_H

#include "kal_public_defs.h"
#include "ps_public_enum.h"
#include "netinfo_common_struct.h"
#include "http_apis.h"
#include "tls_app_enums.h"

/* The maximum size of header in each http request peer buff */
#define HTTP_MAX_HEADER_SIZE  (3*1024)

/* The maximum size of content in each http request or response peer buff */
#define HTTP_MAX_CONTENT_SIZE  (13*1024)

/* The maximum size of a complete http request */
#define HTTP_MAX_REQUEST_SIZE 100*1024

#define HTTP_MAX_USERNAME_LEN 256
#define HTTP_MAX_PASSWORD_LEN 256
#define HTTP_MAX_CONTENT_TYPE_LEN 128
#define HTTP_MAX_AUTH_REALM_LEN 512
#define HTTP_DEFAULT_CONNECTION_TIMEOUT 30000 // 30 seconds
#define HTTP_DEFAULT_TIMEOUT 30000 // 30 seconds
#define HTTP_DEFAULT_DNS_TIMEOUT 0 // 0: means 5secs default timeout in DNS module
#define HTTP_MAX_DNS_ADDR_BUF_NUM 10
#define HTTP_DEFAULT_DNS_TTL_VALUE 0
#define HTTP_IPv4_ADDR_LEN 4
#define HTTP_IPv6_ADDR_LEN 16


typedef enum
{
    /* Status Codes: 2xx */
    HTTP_STATUS_OK = 200,
    HTTP_STATUS_CREATED,
    HTTP_STATUS_ACCEPTED,
    HTTP_STATUS_NON_AUTH_INFORMATION,
    HTTP_STATUS_NO_CONTENT,
    HTTP_STATUS_RESET_CONTENT,
    HTTP_STATUS_PARTIAL_CONTENT,
    HTTP_STATUS_OK_MAX_NUM = 299,

    /* Status Codes: 3xx */
    HTTP_STATUS_MULTIPLE_CHOICES = 300,
    HTTP_STATUS_MOVED_PERMANENTLY,
    HTTP_STATUS_FOUND,
    HTTP_STATUS_SEE_OTHER,
    HTTP_STATUS_NOT_MODIFIED,
    HTTP_STATUS_USE_PROXY,
    HTTP_STATUS_TEMPORARY_REDIRECT = 307,
    HTTP_STATUS_REDIRECT_MAX_NUM = 399,

    /* Status Codes: 4xx */
    HTTP_STATUS_BAD_REQUEST = 400,
    HTTP_STATUS_UNAUTHORIZED,
    HTTP_STATUS_PAYMENT_REQUIRED,
    HTTP_STATUS_FORBIDDEN,
    HTTP_STATUS_NOT_FOUND,
    HTTP_STATUS_METHOD_NOT_ALLOWED,
    HTTP_STATUS_NOT_ACCEPTABLE,
    HTTP_STATUS_PROXY_AUTH_REQUIRED,
    HTTP_STATUS_REQUEST_TIMEOUT,
    HTTP_STATUS_CONFLICT,
    HTTP_STATUS_GONE,
    HTTP_STATUS_LENGTH_REQUIRED,
    HTTP_STATUS_PRECONDITION_FAILED,
    HTTP_STATUS_REQUEST_TOO_LARGE,
    HTTP_STATUS_REQUEST_URI_TOO_LARGE,
    HTTP_STATUS_UNSUPPORTED_MEDIA_TYPE,
    HTTP_STATUS_RANGE_NOT_SATISFIABLE,
    HTTP_STATUS_EXPECTATION_FAILED,

    /* Status Codes: 5xx */
    HTTP_INTERNAL_SERVER_ERROR = 500,
    HTTP_NOT_IMPLEMENTED,
    HTTP_BAD_GATEWAY,
    HTTP_SERVICE_UNAVAILABLE,
    HTTP_GATEWAY_TIMEOUT,
    HTTP_VERSION_NOT_SUPPORTED,
    HTTP_HIGHEST_STATUS_ALLOWED = 599
} http_status_enum;

typedef enum
{
    HTTP_METHOD_GET,
    HTTP_METHOD_POST,
    HTTP_METHOD_HEAD,
    HTTP_METHOD_PUT,
    HTTP_METHOD_DELETE,
    HTTP_METHOD_NUM
} http_method_enum;

typedef enum
{
    HTTP_RESULT_OK,
    HTTP_RESULT_ERROR = -200,
    HTTP_RESULT_ACCEESS_DENY,
    HTTP_RESULT_INVALID_PARAM,
    HTTP_RESULT_INVALID_CACHE_CONTROL_PARAM,
    HTTP_RESULT_INVALID_MESSAGE,
    HTTP_RESULT_INVALID_METHOD,
    HTTP_RESULT_INVALID_TRANS_ID,
    HTTP_RESULT_INVALID_CHANNEL_ID,
    HTTP_RESULT_INVALID_CONNECION_ID,
    HTTP_RESULT_INVALID_PASSWD,
    HTTP_RESULT_INVALID_LENGTH,
    HTTP_RESULT_PARAM_NULL,
    HTTP_RESULT_NO_RESOURCE,
    HTTP_RESULT_NO_MEMORY,
    HTTP_RESULT_NO_FREE_TRANS,
    HTTP_RESULT_NO_FREE_CHANNELS,
    HTTP_RESULT_NO_READY,
    HTTP_RESULT_PENDING_REQ_EXIST, //-183

    /* */
    HTTP_RESULT_REQ_ERROR_INVALID_URI,
    HTTP_RESULT_REQ_ERROR_REQUEST_ID,
    HTTP_RESULT_REQ_ERROR_ABORT_BY_APP,
    HTTP_RESULT_REQ_ERROR_UNKONWN_HOST,
    HTTP_RESULT_REQ_ERROR_HEADERS_TOO_LARGE,
    HTTP_RESULT_REQ_ERROR_MSG_TOO_LARGE,
    HTTP_RESULT_RSP_ERROR_NO_STATUS_CODE,
    HTTP_RESULT_RSP_ERROR_HEADERS_TOO_LARGE,
    /* INET MSG LIB PACK and UNPACK */
    HTTP_RESULT_MSG_ERROR_UNPACK,
    HTTP_RESULT_MSG_ERROR_PACK, //-173

    /* Files error codes */
    HTTP_RESULT_FILE_ERROR_INVALID,
    HTTP_RESULT_FILE_ERROR_ACCESS,
    HTTP_RESULT_FILE_ERROR_FULL,
    HTTP_RESULT_FILE_ERROR_EXIST,
    HTTP_RESULT_FILE_ERROR_DELAYED,
    HTTP_RESULT_FILE_ERROR_CORRUPTED,
    HTTP_RESULT_FILE_ERROR_PATH,    // -166

    HTTP_RESULT_COOKIES_ERROR_STORAGE_FULL, // -165

    /* Socket error codes */
    HTTP_RESULT_SOC_ERROR,
    HTTP_RESULT_SOC_ERROR_BEARER_FAIL,
    HTTP_RESULT_SOC_ERROR_CONNECT_RESET,
    HTTP_RESULT_SOC_ERROR_CONNECT_ABORT,
    HTTP_RESULT_SOC_ERROR_PEER_NO_RESPONSE,
    HTTP_RESULT_SOC_ERROR_NO_FREE_SOCKETS,
    HTTP_RESULT_SOC_ERROR_MSG_TOO_LARGE,
    HTTP_RESULT_SOC_ERROR_DELAYED,
    HTTP_RESULT_SOC_ERROR_INVALID_ACCOUNT_ID,
    HTTP_RESULT_SOC_ERROR_INVALID_SOCKET_ID,
    HTTP_RESULT_SOC_ERROR_INVALID_PARAM,
    HTTP_RESULT_SOC_ERROR_INVALID_ADDRESS,
    HTTP_RESULT_SOC_ERROR_INVALID_PROTOCOL,
    HTTP_RESULT_SOC_ERROR_INVALID_IP_TYPE,
    HTTP_RESULT_SOC_ERROR_CONN_DISCONNECTED,    // -150

    HTTP_RESULT_UNTRUSTED_SERVER,
    HTTP_RESULT_UNSUPPORTED_AUTH_METHOD,
    HTTP_RESULT_UNSUPPORTED_AUTH_ALOGRITHM,
    HTTP_RESULT_UNSUPPORTED_AUTH_QOP,   // -146

    /* Configuration error codes */
    HTTP_RESULT_CONFIG_NO_VALUE_PRESENT,    // -145

    /* DNS error codes */
    HTTP_RESULT_DNS_ERROR,  // -144
    HTTP_RESULT_DNS_FAILED_QUERY,
    HTTP_RESULT_DNS_NOT_A_HOST,
    HTTP_RESULT_DNS_INVALID_PARAM,
    HTTP_RESULT_DNS_NO_DNS_SERVER,
    HTTP_RESULT_DNS_HOST_MISMATCH,
    HTTP_RESULT_DNS_INVALID_IP_TYPE, // -138

    /* Encoding-Decoding error codes */
    HTTP_RESULT_ENCODING_NOT_SUPPORTED, // -137
    HTTP_RESULT_ENCODING_UNCOMPRESSION_FAIL,

    /* TLS error codes */
    HTTP_RESULT_TLS_ERROR,  //-135
    HTTP_RESULT_TLS_WOULD_BLOCK,
    HTTP_RESULT_TLS_CONN_CLOSED,
    HTTP_RESULT_TLS_WAITING_CERT,
    HTTP_RESULT_TLS_ALREADY_EXIST,
    HTTP_RESULT_TLS_HANDSHAKED,
    HTTP_RESULT_TLS_HANDSHAKING, //-129
	HTTP_RESULT_TLS_SSL_HOSTNAME_ERROR,
} http_result_enum;

typedef enum
{
    HTTP_POST_DATA_TYPE_BUFFER,
    HTTP_POST_DATA_TYPE_FILE
} http_post_data_type_enum;

typedef enum
{
    HTTP_REPLY_DATA_TYPE_BUFFER,
    HTTP_REPLY_DATA_TYPE_FILE,
    HTTP_REPLY_DATA_TYPE_FILE_NO_PROGRESS
} http_reply_data_type_enum;

typedef enum
{
    HTTP_CACHE_CONTROL_NO_CACHE,
    HTTP_CACHE_CONTROL_NO_STORE,
    HTTP_CACHE_CONTROL_NO_TRANSFORM,
    HTTP_CACHE_CONTROL_ONLY_IF_CACHED,
    HTTP_CACHE_CONTROL_NUM,
    HTTP_CACHE_CONTROL_NOT_PRESENT
} http_cache_control_enum;

typedef enum
{
    HTTP_CLEAR_CACHES_BY_URL,
    HTTP_CLEAR_CACHES_BY_DOMAIN,
    HTTP_CLEAR_CACHES_BY_MODULE,
    HTTP_CLEAR_CACHES_ALL,
    HTTP_CLEAR_COOKIES_BY_DOMAIN,
    HTTP_CLEAR_COOKIES_BY_MODULE,
    HTTP_CLEAR_COOKIES_ALL,
    HTTP_CLEAR_AUTHS_BY_REALM,
    HTTP_CLEAR_AUTHS_BY_HOST,
    HTTP_CLEAR_AUTHS_BY_MODULE,
    HTTP_CLEAR_AUTHS_ALL
} http_clear_method_enum;


#define HTTP_REQ_LOCAL_PARA_HDR    \
    LOCAL_PARA_HDR \
    kal_uint8 channel_id; \
    kal_uint8 request_id;

#define HTTP_CNF_LOCAL_PARA_HDR    \
    LOCAL_PARA_HDR \
    kal_uint8 channel_id; \
    kal_uint8 request_id;

#define HTTP_IND_LOCAL_PARA_HDR    \
    LOCAL_PARA_HDR \
    kal_uint8 channel_id; \
    kal_uint8 request_id;

#define HTTP_RSP_LOCAL_PARA_HDR    \
    LOCAL_PARA_HDR \
    kal_uint8 channel_id; \
    kal_uint8 request_id;

#define HTTP_RSP_HEADER_CONTENT \
    kal_uint16 response_header_len; \
    kal_uint32 response_content_len; \
    kal_uint8 *response_header; \
    kal_uint8 *response_content;

typedef struct
{
    kal_int32 if_id;
    kal_uint8 protocol; // 1= UDP, 2=TCP
    kal_uint16 source_port;
    ip_info_struct source_address_info;
    ip_info_struct dest_address_info;
    kal_uint8 dnsv4_num;
    kal_char dnsv4_addr[HTTP_MAX_DNS_ADDR_BUF_NUM][HTTP_IPv4_ADDR_LEN];
    kal_uint8 dnsv6_num;
    kal_char dnsv6_addr[HTTP_MAX_DNS_ADDR_BUF_NUM][HTTP_IPv6_ADDR_LEN];
}http_req_net_info;

typedef struct
{
    LOCAL_PARA_HDR
    kal_bool use_proxy;
    kal_uint8 prx_ip_type; // 1=v4, 2=v6
    kal_uint8 prx_ip[16]; 
    kal_uint16 prx_port;
    kal_uint8 username[HTTP_MAX_USERNAME_LEN];  /* proxy username */
    kal_uint8 password[HTTP_MAX_PASSWORD_LEN];  /* proxy password */    
}HTTP_SET_CHANNEL_REQ_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 channel_id;
    kal_bool force_remove;
}HTTP_REMOVE_CHANNEL_REQ_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 channel_id;
    http_result_enum result;
}HTTP_CHANNEL_OPERATION_CNF_STRUCT;

typedef struct
{
    HTTP_REQ_LOCAL_PARA_HDR

    kal_uint16 url_length;
    kal_uint16 header_length;      /* Total header length of the request */
    kal_uint32 content_length;     /* Total content length of the request */

    kal_uint16 ilm_header_length;  /* Length of header in this ILM's peer buff. Can be <= header_length  */
    kal_uint32 ilm_content_length; /* Length of content in this ILM's peer buff. Can be <= content_length */

    http_method_enum method;
    http_cache_control_enum cache_control;
    http_post_data_type_enum post_content_method;
    http_reply_data_type_enum reply_content_method;
    kal_bool close_connection;
    kal_bool use_specified_ip;

    /* Net info  of source */
    http_req_net_info net_info;
    
    /* Path should be present if post_content_method != HTTP_POST_DATA_TYPE_BUFFER, else init buff with 0 */
    kal_wchar post_content_path[256];
    /* Path should be present if reply_content_method != HTTP_REPLY_DATA_TYPE_BUFFER, else init buff with 0 */
    kal_wchar reply_content_path[256];

    kal_bool more_data;
}HTTP_REQUEST_REQ_STRUCT;

typedef struct
{
    HTTP_CNF_LOCAL_PARA_HDR

    http_result_enum result;
    http_status_enum status;
    kal_uint16 header_length;      /* Total header length of the response */
    kal_uint32 content_length;     /* Total content length of the response */
    kal_uint16 ilm_header_length;  /* Length of header in this ILM's peer buff. Can be <= header_length */
    kal_uint32 ilm_content_length; /* Length of content in this ILM's peer buff. Can be <= content_length */
    kal_char content_type[HTTP_MAX_CONTENT_TYPE_LEN];
    kal_bool more_data;
    tls_ciphersuites_enum cipher_suite_id;
    ip_info_struct dest_address_info;
}HTTP_REQUEST_CNF_STRUCT;

typedef struct
{
    HTTP_IND_LOCAL_PARA_HDR
    kal_uint8 seq_num;
}HTTP_POST_CONTENT_IND_STRUCT;

typedef struct
{
    HTTP_RSP_LOCAL_PARA_HDR
    kal_uint8 seq_num;
    kal_uint16 ilm_url_length;
    kal_uint16 ilm_header_length;
    kal_uint32 ilm_content_length;
    kal_bool more_data;
}HTTP_POST_CONTENT_RSP_STRUCT;

typedef struct
{
    HTTP_IND_LOCAL_PARA_HDR
    kal_uint8 seq_num;
}HTTP_READ_CONTENT_IND_STRUCT;

typedef struct
{
    HTTP_RSP_LOCAL_PARA_HDR
    kal_uint8 seq_num;
    http_result_enum result;
    kal_uint16 ilm_header_length;
    kal_uint32 ilm_content_length;
    kal_bool more_data;
}HTTP_READ_CONTENT_RSP_STRUCT;

typedef struct
{
    HTTP_REQ_LOCAL_PARA_HDR
}HTTP_CANCEL_REQUEST_REQ_STRUCT;

typedef struct
{
    HTTP_CNF_LOCAL_PARA_HDR
    http_result_enum result;
}HTTP_CANCEL_REQUEST_CNF_STRUCT;

typedef struct
{
    HTTP_IND_LOCAL_PARA_HDR
    kal_uint32 realm_len;
    kal_char realm[HTTP_MAX_AUTH_REALM_LEN];
    kal_uint8 auth_type;
}HTTP_USERNAME_PASSWD_QUERY_IND_STRUCT;

typedef struct
{
    HTTP_RSP_LOCAL_PARA_HDR
    kal_uint8 username[HTTP_MAX_USERNAME_LEN];  /* proxy username */
    kal_uint8 password[HTTP_MAX_PASSWORD_LEN];  /* proxy password */
}HTTP_USERNAME_PASSWD_QUERY_RSP_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 request_id;
    kal_uint8 clear_method;
    kal_uint16  delete_criteria_len;
}HTTP_CLEAR_REQ_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 request_id;
    http_result_enum result;
}HTTP_CLEAR_CNF_STRUCT;

typedef struct
{
    HTTP_IND_LOCAL_PARA_HDR
    kal_uint8 direction;
    http_status_enum status;
    kal_int32 abort_reason;
    kal_uint32 acc_size;
    kal_uint32 total_size;
}HTTP_NOTIFY_IND_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 channel_id;
    app_http_config_struct configurations;
}HTTP_CONFIG_REQ_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 channel_id;
    http_result_enum result;
}HTTP_CONFIG_CNF_STRUCT;

typedef struct
{
    LOCAL_PARA_HDR
    kal_uint8 channel_id;
    kal_uint8 request_id;
}HTTP_FORCE_CLOSE_CONNECTION_IND_STRUCT;

/******************** XML ILM structure parsing *************************/
typedef HTTP_SET_CHANNEL_REQ_STRUCT             app_http_set_channel_req_struct; //MSG_ID_APP_HTTP_SET_CHANNEL_REQ
typedef HTTP_CHANNEL_OPERATION_CNF_STRUCT       app_http_set_channel_cnf_struct; //MSG_ID_APP_HTTP_SET_CHANNEL_CNF
typedef HTTP_REMOVE_CHANNEL_REQ_STRUCT          app_http_remove_channel_req_struct; //MSG_ID_APP_HTTP_REMOVE_CHANNEL_REQ
typedef HTTP_CHANNEL_OPERATION_CNF_STRUCT       app_http_remove_channel_cnf_struct; //MSG_ID_APP_HTTP_REMOVE_CHANNEL_CNF
typedef HTTP_REQUEST_REQ_STRUCT                 app_http_request_req_struct; //HTTP_REQUEST_REQ_STRUCT : local_para
typedef HTTP_REQUEST_CNF_STRUCT                 app_http_request_cnf_struct; //MSG_ID_APP_HTTP_REQUEST_CNF
typedef HTTP_POST_CONTENT_IND_STRUCT            app_http_post_content_ind_struct; //MSG_ID_APP_HTTP_POST_CONTENT_IND
typedef HTTP_POST_CONTENT_RSP_STRUCT            app_http_post_content_rsp_struct; // MSG_ID_APP_HTTP_POST_CONTENT_RSP : local_para
typedef HTTP_READ_CONTENT_IND_STRUCT            app_http_read_content_ind_struct; //MSG_ID_APP_HTTP_READ_CONTENT_IND
typedef HTTP_READ_CONTENT_RSP_STRUCT            app_http_read_content_rsp_struct; //MSG_ID_APP_HTTP_READ_CONTENT_RSP: local_para
typedef HTTP_CANCEL_REQUEST_REQ_STRUCT          app_http_cancel_request_req_struct; //MSG_ID_APP_HTTP_CANCEL_REQUEST_REQ
typedef HTTP_CANCEL_REQUEST_CNF_STRUCT          app_http_cancel_request_cnf_struct; // MSG_ID_APP_HTTP_CANCEL_REQUEST_CNF
typedef HTTP_USERNAME_PASSWD_QUERY_IND_STRUCT   app_http_username_passwd_query_ind_struct; //MSG_ID_APP_HTTP_USERNAME_PASSWD_QUERY_IND
typedef HTTP_USERNAME_PASSWD_QUERY_RSP_STRUCT   app_http_username_passwd_query_rsp_struct; //MSG_ID_APP_HTTP_USERNAME_PASSWD_QUERY_RSP
typedef HTTP_CLEAR_REQ_STRUCT                   app_http_clear_req_struct; //MSG_ID_APP_HTTP_CLEAR_REQ : local_para
typedef HTTP_CLEAR_CNF_STRUCT                   app_http_clear_cnf_struct; //  MSG_ID_APP_HTTP_CLEAR_CNF
typedef HTTP_CONFIG_REQ_STRUCT                  app_http_config_req_struct; //MSG_ID_APP_HTTP_CONFIG_REQ
typedef HTTP_CONFIG_CNF_STRUCT                  app_http_config_cnf_struct; //  MSG_ID_APP_HTTP_CONFIG_CNF
typedef HTTP_NOTIFY_IND_STRUCT                  app_http_notify_ind_struct; // MSG_ID_APP_HTTP_NOTIFY_IND
typedef HTTP_FORCE_CLOSE_CONNECTION_IND_STRUCT  app_http_force_close_connection_ind_struct; // MSG_ID_APP_FORCE_CLOSE_CONNECTION_IND

#endif //#define _HTTP_IF_H
