/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * ---------
 *   tls_if.h 
 *
 * Project:
 * --------
 *   Submarine
 *
 * Description:
 * ------------
 *   
 *
 * Author:
 * -------
 * -------
 *
 * ==========================================================================
 * $Log$
 *
****************************************************************************/
#ifndef _TLS_IF_H
#define _TLS_IF_H

#include "kal_public_defs.h"
#include "ps_public_enum.h"
#include "netinfo_common_struct.h"
#include "http_apis.h"
#include "tls_app_enums.h"

/***************************************************************************
 * <GROUP Structures>
 *
 * Indication to app for a common event.
 * Local parameter of MSG_ID_APP_TLS_NOTIFY_IND.
 ***************************************************************************/
typedef struct
{
    kal_uint8       ref_count;
    kal_uint16      msg_len;
    kal_int32        sock_id;       /* Socket id to handle this notification. */
    tls_event_enum  event;         /* Reported event from TLS task.
    Applications should verifiy the event type and calls the corresponding
    handler.

    * TLS_HANDSHAKE_READY is an indication of the result of connection context
    creation procedure. tls_new_conn() might return TLS_ERR_WAITING_CERT for
    loading certificates and waiting response from MOD_CERTMAN. After received
    this message, application can then call tls_handshake() to start TLS
    handshake procedure.

    * TLS_HANDSHAKE_DONE is an indication of the handshake result procedure.
    Application can call tls_read() to receive data from or call tls_write() to
    send data to the peer.

    * For TLS_READ, application should call tls_read() repeatedly until
    WOULDBLOCK returned.

    * For TLS_WRITE, application is allowed to transmit the holding data by
    calling tls_write().

    * For TLS_CLOSE, application should call tls_delete_conn() to de-associate
    the connection with a socket id.
    */
    kal_bool        result;        /* Success or failure of the notification. */
    kal_int32       error;         /* Error code. */
    kal_int32       detail_cause;  /* Detail error cause. */
} app_tls_notify_ind_struct;

#endif // _TLS_IF_H
