/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2018
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*****************************************************************************
 *
 * Filename:
 * ---------
 *   enl2_sap_common.h
 *
 * Project:
 * --------
 *
 *
 * Description:
 * ------------
 *   Common header file for all ENL2 SAPs.
 *   This file defines the common structures used by all ENL2 SAPs.
 *
 * Author:
 * -------
 *
 *
 * ==========================================================================
 * $Log$
 *
 * 10 22 2020 head.hsu
 * [MOLY00574624] [Gen97] [Gemini] NPDCP HW arbitration
 * [Interface][ENL2 Common]
 *
 * 12 09 2019 yiting.cheng
 * [MOLY00464632] [GEN97] 5G4 IRAT HO with nr_rb configuration
 * .
 *
 * 12 03 2019 sakari.niemela
 * [MOLY00462238] [Gen97][VMOLY] Smart Idle Feature SA part(MPD)
 * VGMM-NRRC, NRRC-ENPDCP and NRRC Internal SAP updates for 'Smart Idle'
 *
 * 10 14 2019 yiting.cheng
 * [MOLY00442846] [Gen97] Modem feature - NSA part (implementation)
 * .
 *
 * 09 25 2019 yiting.cheng
 * [MOLY00443312] [MT6885][Petrus][Sanity][VMOLY][VMOLY][2019-09-21_1700] ASSERT = [1][core1,vpe0,tc0(vpe3)] Assert fail: epdcp_rbm.c 6392 - EL2 _
 * .
 *
 * 09 09 2019 jia-shi.lin
 * [MOLY00430672] [Gen97][NWSIM][5G][SA][GCF TEST] TC 8.1.4.1.6 Fails ate test step 7
 * [ENPDCP] change for securty suspension.
 * - ENPDCP_FLAG_DL_SECURITY_EN and ENPDCP_FLAG_UL_SECURITY_EN only depends on SRB1.
 *    Suspending the security of RBs excluding SRB1 does not change the security flag.
 * - This change supports for the suspension of indivisual RB.
 *    when the security of a RB is suspended, integrity and cipher of it are turned off (ul: zero MACI/dl: skip & null cipher).
 *
 * 08 01 2019 head.hsu
 * [MOLY00427285] [6297][NRRC][ENPDCP] 5G inter-RAT dev
 * release from NR (SAP)
 *
 * 05 30 2019 charley-cc.cheng
 * [MOLY00402003] [VMOLY] GEMINI N+L DSDS
 * 	
 * 	[CONFIG][SA and NSA Gemini] Config code and interface
 *
 * 01 31 2019 yiting.cheng
 * [MOLY00382599] [GEN97][ENPDCP] PDCP entity suspend procedure
 * .
 *
 * 01 25 2019 yiting.cheng
 * [MOLY00381176] [GEN97][ENPDCP/ERRC/ETC] new loopback mode interface
 * .
 *
 * 01 18 2019 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Modify RRC-ENPDCP SAP constant
 *
 * 01 08 2019 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Interface for LBM - new and old interface co-exist
 *
 * 11 29 2018 mingtsung.sun
 * [MOLY00361902] [Gen97][KS-IODT][5G][R15_ENDC_RLC_COMPLETE_SEG_Change_june][1] Assert fail: protocol/enl2/el2_sec/el2it/copro/src/cipher.c 533 - EL1B_U4G_ADAPTOR
 * Integrate FPGA SEP DEV
 *
 * 10 19 2018 nienteh.hsu
 * [MOLY00352007] [MT6297] NRLC development: NRLCUL Gemini code check-in
 * 	
 * 	.
 *
 * 10 04 2018 shihyu.wang
 * [MOLY00356595] [Gen97][ENPDCP] EPDCP FeMDT Feature
 * 	
 * 	upgrade ENPDCP_SAP_MAX_NUM_QUEUING_DELAY_DSLT to align max DRB number
 *
 * 10 02 2018 shihyu.wang
 * [MOLY00356595] [Gen97][ENPDCP] EPDCP FeMDT Feature
 * 	
 * 	rollback old interface
 *
 * 09 14 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * add primary_cgid_valid and primary_lcid_valid
 *
 * 08 27 2018 antti.kaisto
 * [MOLY00346011] [Gen97][NRRC] Merge to VMOLY TRUNK
 * Merge enl2_sap_common.h from CL#6159798.
 *
 * 08 17 2018 yk.liu
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * merge EMOLY CLs to VMOLY
 *
 * 08 07 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * SDAP configuration and 5QI update
 *
 * 07 24 2018 antti.kaisto
 * [MOLY00309859] [6297][NRRC] CONFIG module EN-DC implementation
 * NRRC CONFIG: Corrections to L2 configuration handling (prioritisedBitRate for SRBs validation, t-Reordering).
 *
 * 07 12 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Remove dc_bearer_type according to SAP
 * 
 * [Protocol build tag]
 * [Is CL self testable: YES]
 * [Group CL list: NO]
 *
 * 07 02 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * New interface for PDCP duplication
 * 
 * [Protocol build tag]
 * [Is CL self testable: YES]
 * [Group CL list: NO]
 *
 * 06 21 2018 doug.shih
 * [MOLY00324797] [6297][ERRC] CHM development
 * modification for suspend_scg cmd interface change.
 * 
 * [Protocol build tag]
 * [Is CL self testable: NO]
 * [Group CL list: WAIT]
 * .
 *
 * 05 30 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * RRC-ENPDCP Gemini VC interface naming change
 *
 * 05 18 2018 head.hsu
 * [MOLY00326691] [MT6297] GEN97.DEV ENL2 Patch back
 * 	port latest interface and code on Gen97.DEV (interface)
 *
 ****************************************************************************/

#ifndef _ENL2_SAP_COMMON_H_
#define _ENL2_SAP_COMMON_H_

#include "kal_public_api.h"

/*****************************************************************************
 *   CONSTANTS 
 *****************************************************************************/
#define ENPDCP_SAP_MAX_NUM_CFG_RB   32  /* SRB: 3 (SRB1, SRB2, SRB3)
                                         * DRB:
                                         *   - LTE: 8 (36.331 section 11.1 specifies the number of DRBs constraint is 8)
                                         *   - NR: 29 ((38.331 section 6.4 specifies the number of DRBs constraint is 29))
                                         */

#define ENPDCP_SAP_MAX_NUM_RB_IDX    8  /* Although RB Index allocation can be 0~36, but the association of EBI (EBI value range: 0~15)
                                         * and RB ID one-to-one mapping attribute and the maximum number of DRBs (8) make the interface
                                         * only has a maximum number 8 */

#define ENPDCP_SAP_MAX_ROHC_PROF     9

#define ENPDCP_SAP_MAX_NUM_QUEUING_DELAY_RSLT    (8) ///< aligned to maximum number of DRBs in LTE



#define MAX_EMBMS_MTCH_SUPPORT             8
#define MAX_EMBMS_MRB_SUPPORT              MAX_EMBMS_MTCH_SUPPORT
#define MAX_EMBMS_MCCH_SUPPORT             8
#define MAX_AREA_NUM_PER_CELL              8
#define MAX_MTCH_NUM_PER_PMCH_29           29
#define MAX_SF_IN_ONE_RF                   6
#define MAX_MBSFN_ALLOCATIONS              8
#define MAX_PMCH_PER_MBSFN                 15
#define MAX_NUM_MTCH_PER_PMCH              29
#define MAX_QOS_FLOWS_PER_PDU_SESSION  64
#define MAX_NUM_PDU_SESSION      16
#define ENPDCP_T_REORDERING_TIMER_INFINITY      0xFFFF
#define ENPDCP_DISCARD_TIMER_INFINITY           0xFFFF
#define ENPDCP_UL_DATA_SPLIT_THRESHOLD_INFINITY 0xFFFFFFFF
#define ENPDCP_SRB3_RB_IDX_VALUE                16
#define ENPDCP_SRB2_RB_IDX_VALUE                17
#define ENPDCP_SRB1_RB_IDX_VALUE                18
#define ENPDCP_MTCH_RB_IDX_VALUE                15
#define ENPDCP_MCCH_RB_IDX_VALUE                19
#define ENPDCP_NR_DRB_RB_IDX_RANGE1_MIN_VALUE   0
#define ENPDCP_NR_DRB_RB_IDX_RANGE1_MAX_VALUE   14
#define ENPDCP_NR_DRB_RB_IDX_RANGE2_MIN_VALUE   20
#define ENPDCP_NR_DRB_RB_IDX_RANGE2_MAX_VALUE   36
#define ENL2_RB_IDX_DEDICATED_NUM 15
#define ENL2_RB_IDX_DEDICATED_MIN ENPDCP_NR_DRB_RB_IDX_RANGE1_MIN_VALUE
#define ENL2_RB_IDX_DEDICATED_MAX ENPDCP_NR_DRB_RB_IDX_RANGE1_MAX_VALUE
#define ENL2_RB_IDX_SHARED_MIN ENPDCP_NR_DRB_RB_IDX_RANGE2_MIN_VALUE
#define ENL2_RB_IDX_SHARED_MAX ENPDCP_NR_DRB_RB_IDX_RANGE2_MAX_VALUE

/*****************************************************************************
 *   ENUM TYPES 
 *****************************************************************************/
typedef enum {
    ENPDCP_RB_TYPE_SRB,
    ENPDCP_RB_TYPE_DRB
} enpdcp_rb_type_enum;

typedef enum {
    ENPDCP_PDCP_VERSION_LTE_PDCP,
    ENPDCP_PDCP_VERSION_NR_PDCP
} enpdcp_pdcp_version_enum;

typedef enum {
    ENPDCP_RB_CMD_EST_N_SUSP,
    ENPDCP_RB_CMD_EST_N_RESUME,
    ENPDCP_RB_CMD_SUSPEND,
    ENPDCP_RB_CMD_RECONFIG,
    ENPDCP_RB_CMD_RE_ESTABLISH,
    ENPDCP_RB_CMD_RECOVERY,
    ENPDCP_RB_CMD_RESUME,
    ENPDCP_RB_CMD_DISCARD,
    ENPDCP_RB_CMD_RELEASE,
    ENPDCP_RB_CMD_RELEASE_FROM_LTE,
    ENPDCP_RB_CMD_RELEASE_FROM_NR,
} enpdcp_rb_cmd_enum;

/* cause of CONFIG_REQ */
typedef enum
{
    ENPDCP_SAP_CONFIG_REQ_CAUSE_OTHERS = 0,              // used for those ENPDCP doesn't care
    ENPDCP_SAP_CONFIG_REQ_CAUSE_HANDOVER,
    ENPDCP_SAP_CONFIG_REQ_CAUSE_HANDOVER_FROM_LTE,       // inter-RAT (from LTE)
    ENPDCP_SAP_CONFIG_REQ_CAUSE_HANDOVER_FROM_NR,        // inter-RAT (from NR)

    ENPDCP_SAP_CONFIG_REQ_CAUSE_NUM,
    ENPDCP_SAP_CONFIG_REQ_CAUSE_PAD = 0x7fffffff
} enpdcp_config_req_cause_enum;

typedef enum {
    ENPDCP_DRB_TYPE_LTE,
    ENPDCP_DRB_TYPE_LWA
} enpdcp_drb_type_enum;

typedef enum {
    ENPDCP_CN_GENERATION_EPS,
    ENPDCP_CN_GENERATION_5G
} enpdcp_cn_generation_enum;

typedef enum {
    ENPDCP_ROHC_STATUS_NOT_CONFIGURED,
    ENPDCP_ROHC_STATUS_BIDIR,
    ENPDCP_ROCH_STATUS_UL_ONLY
} enpdcp_rohc_status_enum;

typedef enum {
    ENPDCP_STUS_RPT_TYPE_ON_POLL_TYPE_1,
    ENPDCP_STUS_RPT_TYPE_ON_POLL_TYPE_2
} enpdcp_stus_rpt_type_on_poll_enum;

typedef enum {
    ENPDCP_RLC_MODE_AM,
    ENPDCP_RLC_MODE_UM_BIDIR,
    ENPDCP_RLC_MODE_UM_UL,
    ENPDCP_RLC_MODE_UM_DL
} enpdcp_rlc_mode_enum;

typedef enum
{
    ENPDCP_LB_CMD_DEACTIVATE,
    ENPDCP_LB_CMD_ACTIVATE_MODE_A,
    ENPDCP_LB_CMD_ACTIVATE_MODE_B
} enpdcp_lb_cmd_enum;

typedef enum {
    ENPDCP_CIPHERING_ALG_EEA0_NEA0,
    ENPDCP_CIPHERING_ALG_EEA1_NEA1,
    ENPDCP_CIPHERING_ALG_EEA2_NEA2,
    ENPDCP_CIPHERING_ALG_EEA3_NEA3
} enpdcp_ciphering_alg_enum;

typedef enum {
    ENPDCP_INTEGRITY_ALG_EIA0_NIA0,
    ENPDCP_INTEGRITY_ALG_EIA1_NIA1,
    ENPDCP_INTEGRITY_ALG_EIA2_NIA2,
    ENPDCP_INTEGRITY_ALG_EIA3_NIA3
} enpdcp_integrity_alg_enum;

typedef enum
{
    ENPDCP_SAP_MEASUREMENT_OFF = 0, 
    ENPDCP_SAP_MEASUREMENT_ON, 
    ENPDCP_SAP_MEASUREMENT_MODIFY
} enpdcp_delay_measurement_enum;


/* UDC enum */
typedef enum
{
    ENPDCP_SAP_UDC_BUF_SZ_KBYTE_2 = 0,
    ENPDCP_SAP_UDC_BUF_SZ_KBYTE_4,
    ENPDCP_SAP_UDC_BUF_SZ_KBYTE_8,

    ENPDCP_SAP_UDC_BUF_SZ_KBYTE_PAD = 0x7fffffff
} enpdcp_udc_buf_sz_enum;

typedef enum
{
    ENPDCP_SAP_UDC_DIC_INVALID = 0,
    ENPDCP_SAP_UDC_DIC_STANDARD,
    ENPDCP_SAP_UDC_DIC_OPERATOR,

    ENPDCP_SAP_UDC_DIC_PAD = 0x7fffffff
} enpdcp_udc_dic_enum;

typedef enum
{
    ENPDCP_SEC_CFG_CMD_INVALID = 0,
    ENPDCP_SEC_CFG_CMD_UPDATE,
    ENPDCP_SEC_CFG_CMD_SUSPEND
} enpdcp_sec_cfg_cmd_enum;

/*--------------------------------------------------------------------------
 * RRC configuration to enter/leave virtual connected state
 *--------------------------------------------------------------------------*/

/// command to pdcp and rlc

typedef enum
{
    RRC_ENL2_VIRTUAL_CONNECTED_ENTER_PREPARE                        =  0, // PDCP, RLC-UL
    RRC_ENL2_VIRTUAL_CONNECTED_ENTER                                =  1, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_ENTER_END                            =  2, // PDCP, NRLC-UL
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_PREPARE                        =  3, // PDCP
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE                                =  4, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_FAIL_TO_RELEASE                =  5, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_FAIL_TO_REESTABLISH            =  6, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_ENTER_PREPARE_FOR_SRLTE              =  7, // RLC-UL
    RRC_ENL2_VIRTUAL_CONNECTED_ENTER_FOR_SRLTE                      =  8, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_ENTER_END_FOR_SRLTE                  =  9, // PDCP
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_PREPARE_FOR_SRLTE              = 10, // PDCP
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_FOR_SRLTE                      = 11, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_FAIL_TO_RELEASE_FOR_SRLTE      = 12, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_LEAVE_FAIL_TO_REESTABLISH_FOR_SRLTE  = 13, // PDCP, RLC-UL, RLC-DL
    RRC_ENL2_VIRTUAL_CONNECTED_INVALID_CAUSE                        = 14,
} rrc_enl2_switch_virtual_connected_enum;

/*****************************************************************************
 *   STRUCTURES
 *****************************************************************************/
typedef struct {
    kal_uint8   pdu_session_id;                 /* PDU session ID */
    kal_bool    is_sdap_header_present_in_dl;   /* specify if SDAP header is present in DL in this DRB or not */
    kal_bool    is_sdap_header_present_in_ul;   /* specify if SDAP header is present in UL in this DRB or not */
    kal_bool    is_default_drb;                 /* specify if this DRB is the default DRB for the PDU session */
    kal_uint8   mapped_qos_flows_add_num;   /* number of QoS flows of the PDU session indicated by 'pdu_session_id' to be added to be mapped to this DRB */
    kal_uint8   mapped_qos_flows_add_list[MAX_QOS_FLOWS_PER_PDU_SESSION];    /* Array of QoS flows of the PDU session indicated by 'pdu_session_id' to be added to be mapped to this DRB */
    kal_uint8   mapped_qos_flows_rel_num;   /* number of QoS flows of the PDU session indicated by 'pdu_session_id' to be released from being mapped to this DRB. */
    kal_uint8   mapped_qos_flows_rel_list[MAX_QOS_FLOWS_PER_PDU_SESSION];    /* Array of QoS flows of the PDU session indicated by 'pdu_session_id' to be released from being mapped to this DRB. */
} enpdcp_sdap_config_struct;


typedef struct {
    kal_bool                           type_on_poll_valid;       /* specify if 'type_on_poll' is valid or not */
    enpdcp_stus_rpt_type_on_poll_enum  type_on_poll;             /* indicate the PDCP Control PDU option when it is triggered by E-UTRAN polling */
    kal_bool                           type1_periodicity_valid;  /* specify if 'type1_periodicity' is valid or not */
    kal_bool                           type2_periodicity_valid;  /* specify if 'type2_periodicity' is valid or not */
    kal_bool                           offset_valid;             /* specify if 'offset' is valid or not */
    kal_bool                           type1_periodicity_recfg;  /* specify if type1 periodicity configuration is reconfigured */
    kal_bool                           type2_periodicity_recfg;  /* specify if type2 periodicity configuration is reconfigured */
    kal_uint32                         type1_periodicity;        /* indicate the value of the PDCP Status reporting periodicity for type1 Status PDU */
    kal_uint32                         type2_periodicity;        /* indicate the value of the PDCP Status reporting periodicity for type2 Status PDU */
    kal_uint32                         offset;                   /* indicate the value of the offset for type2 Status PDU periodicity */
} enpdcp_stus_rpt_param_struct;


typedef struct {
    enpdcp_drb_type_enum          drb_type;       /* specify the DRB Type is LWA or LTE, only for LTE PDCP */
    enpdcp_sdap_config_struct     sdap_config;    /* valid only when cn_generation indicate 5G */
    kal_uint8                     eps_bearer_id;  /* value range: 0-15 */
    kal_bool                      is_gbr_bearer;  /* specify if EPS bearer is guaranteed bit rate bearer */
    kal_bool                      qci_valid;      /* specify if 'qci' is valid or not */
    kal_uint8                     qci;            /* QoS Class Identfier */
    enpdcp_rohc_status_enum       rohc_status;                           /* specify if RoHC is configured or not, and if RoHC is bi-directional or UL only */
    kal_uint16                    rohc_max_cid;                          /* parameter MAX_CID, see 36.323 and 38.323 */
    kal_bool                      rohc_profs[ENPDCP_SAP_MAX_ROHC_PROF];  /* parameter PROFILES, see 36.323 and 38.323 */
    kal_bool                      drb_continue_rohc;                     /* specify if the header compression protocol context continues or is reset */
    kal_uint16                    discard_timer;           /* timer discardTimer, see 36.323 and 38.323, please use ENPDCP_DISCARD_TIMER_INFINITY for 'infinity' */
    kal_bool                      status_report_required;  /* parameter statusReportRequired, see 36.323 and 38.323 */
    enpdcp_stus_rpt_param_struct  stus_rpt_param;          /* status report parameter for LWA type DRB */
    kal_bool                      out_of_order_delivery;   /* parameter outOfOrderDelivery, see 38.323 */

    enpdcp_rlc_mode_enum          rlc_mode;    /* specify RLC mode, and for RLC UM also direction, of associated RLC bearer(s) */
    kal_uint8                     sn_size_dl;  /* PDCP SN size in DL */
    kal_uint8                     sn_size_ul;  /* PDCP SN size in UL */

    kal_bool                        udc_enabled;
    enpdcp_udc_buf_sz_enum           udc_buf_sz;
    enpdcp_udc_dic_enum              udc_dic;
} enpdcp_drb_params_struct;


typedef struct {
    enpdcp_ciphering_alg_enum  ciphering_algorithm;  /* ciphering algorithm */
    enpdcp_integrity_alg_enum  integrity_algorithm;  /* integrity algorithm */
    kal_uint8                  ciphering_key_idx;    /* index of KRRCenc / KUPenc ciphering key in cipher HW, value range: 0-255 */
    kal_uint8                  integrity_key_idx;    /* index of KRRCint / KUPint integrity key in cipher HW, value range: 0-255 */
} enpdcp_sec_cfg_struct;


typedef struct {
    kal_bool    primary_path_cell_group_id_valid;  /* specify if primary_path_cell_group_id is valid or not */
    kal_uint8   primary_path_cell_group_id;     /* cell group ID of the primary RLC bearer */
    kal_bool    primary_path_lcid_valid;        /* specify if primary_path_lcid is valid or not */
    kal_uint8   primary_path_lcid;              /* logical channel identity (LCID) of the primary RLC bearer */
    kal_bool    ul_data_split_threshold_valid;  /* specify if 'ul_data_split_threshold' is valid or not */
    kal_uint32  ul_data_split_threshold;        /* parameter ul-DataSplitThreshold, see 38.323, please use ENPDCP_UL_DATA_SPLIT_THRESHOLD_INFINITY for 'Infinity' */
    kal_bool    ul_duplication;                 /* parameter 'pdcpDuplication', see 38.323 */
    kal_bool    ul_duplication_activated_valid; /* specify if 'ul_duplication_activated' is valid or not */
    kal_bool    ul_duplication_activated;
} enpdcp_more_than_one_rlc_config_struct;


typedef struct {
    enpdcp_drb_params_struct                drb_params;                      /* Parameters which apply only when radio bearer is DRB, valid only for DRB */
    enpdcp_sec_cfg_cmd_enum                 sec_cfg_cmd;                     /* specify if 'sec_cfg' is valid or not */
    enpdcp_sec_cfg_struct                   sec_cfg;                         /* security parameters for ciphering and integrity */
    kal_bool                                t_reordering_valid;              /* specify if 't_reordering' is valid or not */
    kal_uint16                              t_reordering;                    /* specify 't_reordering' value, please use ENPDCP_T_REORDERING_TIMER_INFINITY for 'Infinity' */
    kal_bool                                more_than_one_rlc_config_valid;  /* specify if 'more_than_once_rlc_config' is valid or not */
    enpdcp_more_than_one_rlc_config_struct  more_than_one_rlc_config;        /* parameters for the case when more than one RLC bearers are associated with the PDCP entity, only for NR PDCP */
} enpdcp_rb_params_struct;


typedef struct {
    kal_uint8                   rb_idx;        /* RB Index for the added or modified RB, value range: 0-36 */
    enpdcp_rb_type_enum         rb_type;       /* SRB or DRB */
    kal_uint8                   rbid;          /* RB Identity, value range: 1-32, SRB: 1-3, DRB: 1-32 */
    enpdcp_cn_generation_enum   cn_generation;  /* specify core network generation. Identifies the radio bearer together with rb_type and rbid. */
    enpdcp_pdcp_version_enum    pdcp_version;  /* specify if PDCP entity is LTE PDCP or NR PDCP */
    kal_bool                    pdcp_entity_suspend; /* specify if ENPDCP should perform PDCP entity suspend as per 38.323 or not */
    enpdcp_rb_cmd_enum          cmd;           /* operation command for the radio bearer */
    enpdcp_rb_params_struct     rb_params;     /* parameters of the radio bearer */
} enpdcp_rb_addmod_struct;


typedef struct {
    kal_uint8            rb_idx;      /* RB Index for the release RB, value range: 0-36 */
    enpdcp_rb_type_enum  rb_type;     /* SRB or DRB */
    kal_uint8            rbid;        /* RB Identity, value range: 1-32, SRB: 1-3, DRB: 1-32 */
    enpdcp_cn_generation_enum   cn_generation;  /* specify core network generation. Identifies the radio bearer together with rb_type and rbid. */
    kal_bool             release_second_entity;  /* Specifies whoich PDCP entity to release. */
    enpdcp_rb_cmd_enum   cmd;         /* operation command for the radio bearer */
} enpdcp_rb_rel_struct;

typedef struct {
    kal_uint64 lte_rb_bitmap; /// LTE version RB index bitmap
    kal_uint64 nr_rb_bitmap; /// NR version RB index bitmap
} enl2_rb_idx_bitmap_struct;

typedef struct {
    enl2_rb_idx_bitmap_struct config_list; /// current RB index Config list
    enl2_rb_idx_bitmap_struct temp_list; /// RB index Re-Config list
    kal_bool temp_list_active; /// if RRC already fork temp_list from config_list (for debug only)
} enl2_rb_idx_rrc_struct;

typedef struct {
    enl2_rb_idx_rrc_struct errc; /// ERRC RB index bitmap
    enl2_rb_idx_rrc_struct nrrc; /// NRRC RB index bitmap
    kal_bool vc_state; /// is the protocol in VC
} enl2_rb_idx_struct;

#if defined(__GEMINI_LTE__)
#define ENL2_RB_IDX_CTXT_NUM (2)
#elif defined(__GTEST_ENABLE__)
#define ENL2_RB_IDX_CTXT_NUM (2)
#else
#define ENL2_RB_IDX_CTXT_NUM (1)
#endif

#if __MTK_TARGET__
#define L2_FLAG_CHK_64(bmp, i) (((kal_uint32 *)&(bmp))[((kal_uint32)i >> 5) & 1] & (1u << ((kal_uint32)i & 0x1F)))
#define L2_FLAG_SET_64(bmp, i) (((kal_uint32 *)&(bmp))[((kal_uint32)i >> 5) & 1] |= (1u << ((kal_uint32)i & 0x1F)))
#define L2_FLAG_CLR_64(bmp, i) (((kal_uint32 *)&(bmp))[((kal_uint32)i >> 5) & 1] &= ~(1u << ((kal_uint32)i & 0x1F)))
#else
#define L2_FLAG_CHK_64(v, ofst)	((v) & 1ull << (ofst))
#define L2_FLAG_SET_64(v, ofst)	((v) |= 1ull << (ofst))
#define L2_FLAG_CLR_64(v, ofst)	((v) &= ~(1ull << (ofst)))
#endif

/**
 * @brief initialization function for enl2 rb index contexy
 */
void enl2_rb_idx_api_init();

/**
 * @brief for hacking API working
 */
void enl2_rb_idx_hack(kal_uint8 hack);

/**
 * @brief
 *  When EN-RRC received RRC-Reconfiguration from network and start IE check phase, 
 *  the EN-RRC will invoke this API to fork current configure RB index list (called as config_list) 
 *  as temp configure RB index list which (called as temp_list) imply 
 *  the future RB index list if the reconfiguration result is success.
 *
 * @param sim_idx The protocol index to build temp_list
 * @param src_mod The source RRC to build temp_list
 */
void l2_rb_idx_fork_temp_list(kal_uint8 sim_idx, module_type src_mod);

/**
 * @brief
 *  The API will allocate a new RB index for the source RRC and protocol index.
 *  It will consider the L2 copro resource utilization and best effort ensure UE can stay DSDA mode.
 *  The new RB index will update to temp_list.
 *
 * @param sim_idx The protocol index to allocate new RB index to temp_list
 * @param src_mod The source RRC to allocate new RB index to temp_list
 * @param pdcp_ver The PDCP version of the new RB index of temp_list
 *
 * @return A available RB index for src_mod to be used. Range is [0, 14] and [20, 36]
 */
kal_uint8 l2_rb_idx_alloc_on_temp_list(kal_uint8 sim_idx, module_type src_mod, enpdcp_pdcp_version_enum pdcp_ver);

/**
 * @brief
 *  The API will update configuration of the specified RB index for the source RRC and protocol index.
 *  The change will update to temp_list.
 *
 * @param sim_idx The protocol index of the updated RB index
 * @param src_mod The source RRC of the updated RB index
 * @param rb_idx The RB index to be updated
 * @param pdcp_ver The PDCP version of the updated RB index
 */
void l2_rb_idx_update_on_temp_list(kal_uint8 sim_idx, module_type src_mod, kal_uint8 rb_idx, enpdcp_pdcp_version_enum pdcp_ver);

/**
 * @brief
 *  The API will release configuration of the specified RB index for the source RRC and protocol index.
 *  The change will update to temp_list.
 *
 * @param sim_idx The protocol index of the released RB index
 * @param src_mod The source RRC of the released RB index
 * @param rb_idx The RB index to be released
 */
void l2_rb_idx_rel_on_temp_list(kal_uint8 sim_idx, module_type src_mod, kal_uint8 rb_idx);

/**
 * @brief
 *  When EN-RRC complete IE check phase and confirm the temp_list can be applied as new configuration,
 *  it invoke the API to copy temp_list to config_list.
 *
 * @param sim_idx The protocol index to apply the temp_list
 * @param src_mod The source RRC to apply the temp_list
 */
void l2_rb_idx_apply_temp_list(kal_uint8 sim_idx, module_type src_mod);

/**
 * @brief
 *  When EN-RRC fail the IE check phase or judge the temp_list cannot be applied as new configuration,
 *  it invoke the API to discard temp_list.
 *  The config_list is still the current configuration.
 *
 * @param sim_idx The protocol index to discard the temp_list
 * @param src_mod The source RRC to discard the temp_list
 */
void l2_rb_idx_discard_temp_list(kal_uint8 sim_idx, module_type src_mod);

/**
 * @brief
 *  When EN-RRC launch connection release directly even if the current procedure is not IE check phase,
 *  it will invoke the API to release all RB index in config_list and temp_list of the source RRC and protocol index.
 *
 * @param sim_idx The protocol index release all RB index
 * @param src_mod The source RRC release all RB index
 */
void l2_rb_idx_reset(kal_uint8 sim_idx, module_type src_mod);

/**
 * @brief
 *  EN-RRC will update the VC status of specified protocol index to make ENL2 RB index API learn the information
 *  due to L2 Copro resource can be shared if a protocol is in Virtual Connected.
 *
 * @param sim_idx The protocol index to enter/leave VC
 * @param is_enter_vc The source RRC to enter/leave VC
 */
void l2_rb_idx_set_vc(kal_uint8 sim_idx, kal_bool is_enter_vc);

/**
 * @brief
 *  MSPM invoke the API to query if the L2 Copro resource is conflict.
 *  The compared configuration are (config_list + temp_list) of any 2 SIM index.
 *
 * @return
 *  True, if the L2 Copro resource do not conflict by any 2 SIM combination under current state
 *  False, if the L2 Copro resource have conflict by one of 2 SIM combination under current state
 */
kal_bool l2_rb_idx_dual_active_status_check();

#endif /* _ENL2_SAP_COMMON_H_ */
