/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2018
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*******************************************************************************
 * Filename:
 * ---------
 *  rrc_enpdcp_msg.h
 *
 * Project:
 * --------
 *
 *
 * Description:
 * ------------
 *  Messages and common definitions for RRC-ENPDCP interface
 *
 * Author:
 * -------
 *
 *
 * ==========================================================================
 * $Log$
 *
 * 05 18 2022 penny.wu
 * [MOLY00775343] SCG failure suddenly and no SCG release received which caused long time PS service stuck
 * 	
 * 	SCG fail 20157558
 *
 * 10 21 2021 atlas.xu
 * [MOLY00656491] 21041 EVTɨ5G-SAͨ1438  21041CT+CU˫5G̬·MTʧ3Σ3/50
 * 	
 * 	.
 *
 * 	
 * 	.
 *
 * 04 06 2020 yiting.cheng
 * [MOLY00509299] [MT6873][Margaux][Q0][MP3][SQC][NSA][5GMM][NLO FT][Beijing][?ģ][CT+CMCC][Bus]Margaux's total freezed latency lose Mate30(81s vs. 51s)
 * .
 *
 * 03 23 2020 yiting.cheng
 * [MOLY00502844] 2713368Gi19165jiMPjiWIj?d`?5GA?kWI
 * .
 *
 * 02 10 2020 yiting.cheng
 * [MOLY00495934] [MT6873][Margaux][Q0][MP2][SQC][China][Shanghai][4GMM][Internal][FT][MDST][CAT][Moving][CT+CMCC]md1:(MCU_core0.vpe1.tc2(VPE1)) [ASSERT] file:mcu/driver/dpcopro/src/dpcopro_hisr.c line:775
 * .
 *
 * 12 03 2019 sakari.niemela
 * [MOLY00462238] [Gen97][VMOLY] Smart Idle Feature SA part(MPD)
 * VGMM-NRRC, NRRC-ENPDCP and NRRC Internal SAP updates for 'Smart Idle'
 *
 * 10 14 2019 yiting.cheng
 * [MOLY00442846] [Gen97] Modemfeature - NSA part (implementation)
 * .
 *
 * 05 30 2019 charley-cc.cheng
 * [MOLY00402003] [VMOLY] GEMINI N+L DSDS
 * 	
 * 	[CONFIG][SA and NSA Gemini] Config code and interface
 *
 * 04 25 2019 ken.li
 * [MOLY00383711] [MT6297][Apollo][PreSQC][MP0.5][NVIOT][Nokia][Oulu][4G]: Assert Fail: dpcopro_hisr.c 713 - (LISR)mml2_excep_lisr
 * 	
 * 	EPDCP DL OOB and HFN desync handling
 *
 * 04 22 2019 ken.li
 * [MOLY00383711] [MT6297][Apollo][PreSQC][MP0.5][NVIOT][Nokia][Oulu][4G]: Assert Fail: dpcopro_hisr.c 713 - (LISR)mml2_excep_lisr
 * 	
 * 	EPDCP DL OOB and HFN desync handling
 *
 * 01 25 2019 yiting.cheng
 * [MOLY00381176] [GEN97][ENPDCP/ERRC/ETC] new loopback mode interface
 * .
 *
 * 01 23 2019 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Add maci_len in DCCH_DATA_IND
 *
 * 01 18 2019 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Modify RRC-ENPDCP SAP constant
 *
 * 01 08 2019 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Interface for LBM - new and old interface co-exist
 *
 * 11 29 2018 mingtsung.sun
 * [MOLY00361902] [Gen97][KS-IODT][5G][R15_ENDC_RLC_COMPLETE_SEG_Change_june][1] Assert fail: protocol/enl2/el2_sec/el2it/copro/src/cipher.c 533 - EL1B_U4G_ADAPTOR
 * Integrate FPGA SEP DEV
 *
 * 10 31 2018 sakari.niemela
 * [MOLY00342137] [6297][NRRC][NCONN] SA implementation
 * [NCONN] Merge CBr3 to VMOLY.FPGA.SEP.DEV (part 3)
 *
 * 08 17 2018 yk.liu
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * merge EMOLY CLs to VMOLY
 *
 * 06 14 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * Suspend SCG new interface
 * Update reassemble order for full-configuration + PDCP version change
 *
 * 06 07 2018 nicky.chou
 * [MOLY00320629] [6297] PS.DEV patch back to GEN97.DEV
 * [ENPDCP] L3_CRITICAL_DATA for Gemini.
 *
 * 05 30 2018 yiting.cheng
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in
 * RRC-ENPDCP Gemini VC interface naming change
 *
 * 05 28 2018 shihyu.wang
 * [MOLY00327926] [GEN97][ENPDCP] base development check-in protocol interface patchback
 *
 * 03 28 2018 hannu.huusko
 * [MOLY00308815] [6297][NRRC] MAIN module implementation
 * 	NRRC-ENPDCP message ID update
 *
 *
 ****************************************************************************/


#ifndef  _RRC_ENPDCP_MSG_H
#define  _RRC_ENPDCP_MSG_H

#include "kal_general_types.h"
#include "kal_public_defs.h"
#include "kal_public_api.h"

#include "enl2_sap_common.h"
#include "el2_sap_common.h"
#include "common_def.h"
#include "as_inter_core_struct.h"
/*****************************************************************************
 *   CONSTANTS
 *****************************************************************************/
/* numbers */
#define ENPDCP_SAP_MAX_NUM_DRB       (29)  //8 DRBs


/*****************************************************************************
 *   ENUM TYPES
 *****************************************************************************/
/* dcch_data_req flag_bmp bit index definition */
typedef enum
{
    ENPDCP_DATAREQ_FLAG_SMC              = 0,
    ENPDCP_DATAREQ_FLAG_DRX_NO_WAKEUP    = 1,
    ENPDCP_DATAREQ_FLAG_TIME_BOUND       = 2,
    ENPDCP_DATAREQ_FLAG_L3_CRITICAL_DATA = 3
} enpdcp_datareq_flag_enum;


/* dcch_data_req result */
typedef enum
{
    ENPDCP_DATAREQ_OK = 0,
    ENPDCP_DATAREQ_FAILURE = 1
}enpdcp_datareq_result_enum;


/* integrity check result */
typedef enum
{
    ENPDCP_INTCHK_OK = 0,
    ENPDCP_INTCHK_FAILURE = 1,          /* integrity check failure */
    ENPDCP_INTCHK_SKIPPED = 2           /* integrity check is not applied */
} enpdcp_intchk_result_enum;

/* HFN desync RLF */
typedef enum
{
    ENPDCP_CUT_CELL_SMALL_GRANT = 0, 
    ENPDCP_CUT_CELL_POSSIBLE_DCI_IN_MEAS_GAP = 1,
    ENPDCP_CUT_CELL_INV
} enpdcp_cut_cell_cause_enum;

/* L2 cut cell ind cause */
typedef enum
{
    ENPDCP_SAP_RLF_HFN_DESYNC = 0, 
    ENPDCP_SAP_RLF_ROHC_FAILURE = 1, 
    ENPDCP_SAP_RLF_SCG_ONLY_TX_FAILURE = 2,
    ENPDCP_SAP_RLF_INV
} enpdcp_rlf_cause_enum;


/*****************************************************************************
 *   STRUCTURES
 *****************************************************************************/
typedef struct {
    kal_uint8               mbsfn_area_id;  /* value range: 0-255 */
    kal_uint8               mcch_idx;       /* numbered by eRRC(not from NW), value range 0-7 */
} epdcp_mcch_add_struct;


typedef struct
{
    kal_uint8               mbsfn_area_id;  /* value range: 0-255, currently for debug purpose only */
    kal_uint8               mcch_idx;       /* numbered by eRRC(not from NW), value range 0-7 */
} epdcp_mcch_del_struct;


typedef struct
{
    kal_uint8               mbsfn_area_id;  /* value range: 0-255 */
    kal_uint8               pmch_id;        /* value range: 0-15 */
    kal_uint16              sessionId;      /* 0xFFFF means no configure session id */
    kal_uint8               TMGI[6];        /* Temporary Mobile Group Identity */
    kal_uint8               lc_id;          /* value range: 0-28 */
    kal_uint8               mrb_idx;        /* value range: 0-7, numbered by eRRC(not from NW) */
} epdcp_mrb_add_struct;


typedef struct
{
    kal_uint8               mbsfn_area_id;  /* value range: 0-255, currently for debug usage only */
    kal_uint8               pmch_id;        /* value range: 0-15, currently for debug usage only */
    kal_uint16              sessionId;      /* currently for debug usage only */
    kal_uint8               TMGI[6];        /* currently for debug usage only */
    kal_uint8               lc_id;          /* value range: 0-28, currently for debug usage only */
    kal_uint8               mrb_idx;        /* value range: 0-7, numbered by eRRC(not from NW) */
} epdcp_mrb_del_struct;


/* RB COUNT info structure */
typedef struct
{
    kal_uint8               rb_idx;         //RB index
    kal_uint8               rb_id;
    kal_uint16              pad;

    kal_uint32              rx_count;       //HFN + SN
    kal_uint32              tx_count;       //HFN + SN
} enpdcp_rb_cntinfo_struct;

/* queuing delay result structure */
typedef struct
{
    kal_uint8               qci;
    kal_uint32              excess_delay_num;
    kal_uint32              total_num;
} enpdcp_delay_result_struct;


/* PDCP queuing delay config structure */
typedef struct{
    kal_bool                        valid;
    enpdcp_delay_measurement_enum    measurement_status;                                                                                                                                            // if valid=false,  delay_theshold and delay_report_interval should be ignored
    kal_uint32                       threshold;
    kal_uint32                       report_interval;
} enpdcp_delay_cfg_struct;


/* RB loopback config structure */
typedef struct
{
    kal_uint8               rbid;
    kal_uint16              size;           //scaling size
} enpdcp_rb_lbcfg_struct;


/*****************************************************************************
 *   MESSAGE STRUCTURE
 *****************************************************************************/
/* MSG_ID_ERRC_ENPDCP_CONFIG_REQ / MSG_ID_NRRC_ENPDCP_CONFIG_REQ */
typedef struct {
    LOCAL_PARA_HDR
    /* common for ERRC and NRRC */
    enpdcp_config_req_cause_enum cause;

    kal_uint8                rel_num;
    kal_uint8                mod_num;
    kal_uint8                add_num;
    enpdcp_rb_rel_struct     rb_rel_list[ENPDCP_SAP_MAX_NUM_CFG_RB];
    enpdcp_rb_addmod_struct  rb_mod_list[ENPDCP_SAP_MAX_NUM_CFG_RB];
    enpdcp_rb_addmod_struct  rb_add_list[ENPDCP_SAP_MAX_NUM_CFG_RB];

    /* ERRC only - LTE eMBMS configuration */
    kal_uint8                mcch_add_num[MAX_EMBMS_FREQ_SUPPORT];
    kal_uint8                mcch_del_num[MAX_EMBMS_FREQ_SUPPORT];
    epdcp_mcch_add_struct    mcch_add[MAX_EMBMS_FREQ_SUPPORT][MAX_EMBMS_MCCH_SUPPORT];
    epdcp_mcch_del_struct    mcch_del[MAX_EMBMS_FREQ_SUPPORT][MAX_EMBMS_MCCH_SUPPORT];
    kal_uint8                mrb_add_num[MAX_EMBMS_FREQ_SUPPORT];
    kal_uint8                mrb_del_num[MAX_EMBMS_FREQ_SUPPORT];
    epdcp_mrb_add_struct     mrb_add[MAX_EMBMS_FREQ_SUPPORT][MAX_EMBMS_MCCH_SUPPORT];
    epdcp_mrb_del_struct     mrb_del[MAX_EMBMS_FREQ_SUPPORT][MAX_EMBMS_MCCH_SUPPORT];

    kal_bool                 suspend_scg_valid;
    kal_bool                 suspend_scg;

    kal_bool                 wait_for_key_update;  // Specifies if ENPDCP needs to wait KEY_UPDATE_DONE_REQ before applying security procedures on PDCP PDU's.
    enpdcp_delay_cfg_struct      delay_cfg;
} errc_enpdcp_config_req_struct, nrrc_enpdcp_config_req_struct;


/*
 * MSG_ID_ERRC_ENPDCP_MCCH_DATA_IND,
 */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                   ci; 			/* 0~MAX_EMBMS_FREQ_SUPPORT-1 */
    kal_uint8                   mcch_idx;
    kal_uint8                   mcch_mp_id;
    kal_uint8                   resv; // this field would be used by ERRC; EPDCP reset it to 0 for ERRC
    void                        *p_data;
    kal_uint32                  data_len; /* including RRC message & MAC-I */
} errc_enpdcp_mcch_data_ind_struct;


/* MSG_ID_ERRC_ENPDCP_DCCH_DATA_REQ / MSG_ID_NRRC_ENPDCP_DCCH_DATA_REQ */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                   rbid;
    kal_uint16                  trans_id;
    kal_uint16                  flag_bmp;
    void                        *data_ptr;
    kal_uint32                  data_len;
    KAL_AFM_ID                  afm_id;
} errc_enpdcp_dcch_data_req_struct, nrrc_enpdcp_dcch_data_req_struct;


/* MSG_ID_ERRC_ENPDCP_DCCH_DATA_CNF / MSG_ID_NRRC_ENPDCP_DCCH_DATA_CNF */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                   rbid;
    kal_uint16                  trans_id;
    enpdcp_datareq_result_enum  result;
} errc_enpdcp_dcch_data_cnf_struct, nrrc_enpdcp_dcch_data_cnf_struct;


/* MSG_ID_ERRC_ENPDCP_DCCH_DATA_IND / MSG_ID_NRRC_ENPDCP_DCCH_DATA_IND */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                   rbid;
    enpdcp_intchk_result_enum   integrity_check_result;
    kal_uint32                  pdcp_count;
    kal_uint32                  maci_len;
    void                        *data_ptr;
    kal_uint32                  data_len;   /* including RRC message & MAC-I */
} errc_enpdcp_dcch_data_ind_struct, nrrc_enpdcp_dcch_data_ind_struct;


/* MSG_ID_ERRC_ENPDCP_DCCH_DATA_RSP / MSG_ID_NRRC_ENPDCP_DCCH_DATA_RSP */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                   rbid;
} errc_enpdcp_dcch_data_rsp_struct, nrrc_enpdcp_dcch_data_rsp_struct;


/* MSG_ID_ERRC_ENPDCP_CONFIG_CNF / MSG_ID_NRRC_ENPDCP_CONFIG_CNF */
typedef struct {
    LOCAL_PARA_HDR
} errc_enpdcp_config_cnf_struct, nrrc_enpdcp_config_cnf_struct;

/* MSG_ID_ERRC_ENPDCP_KEY_UPDATE_DONE_REQ / MSG_ID_NRRC_ENPDCP_KEY_UPDATE_DONE_REQ */
typedef struct {
    LOCAL_PARA_HDR
} errc_enpdcp_key_update_done_req_struct, nrrc_enpdcp_key_update_done_req_struct;

/* MSG_ID_ERRC_ENPDCP_TEST_REQ / MSG_ID_NRRC_ENPDCP_TEST_REQ */
typedef struct {
    LOCAL_PARA_HDR

    enpdcp_lb_cmd_enum          cmd;
    kal_uint8                   rb_num;  // only valid for mode A
    enpdcp_rb_lbcfg_struct      rb_cfg[ENPDCP_SAP_MAX_NUM_DRB];  // only valid for mode A
} errc_enpdcp_test_req_struct, nrrc_enpdcp_test_req_struct;


/* MSG_ID_ERRC_ENPDCP_TEST_CNF / MSG_ID_NRRC_ENPDCP_TEST_CNF */
typedef struct {
    LOCAL_PARA_HDR
} errc_enpdcp_test_cnf_struct, nrrc_enpdcp_test_cnf_struct;


/* MSG_ID_ERRC_ENPDCP_SWITCH_VIRTUAL_CONNECTED_REQ / MSG_ID_NRRC_ENPDCP_SWITCH_VIRTUAL_CONNECTED_REQ */
typedef struct {
    LOCAL_PARA_HDR
    rrc_enl2_switch_virtual_connected_enum status;
} errc_enpdcp_switch_virtual_connected_req_struct, nrrc_enpdcp_switch_virtual_connected_req_struct;


/* MSG_ID_ERRC_ENPDCP_SWITCH_VIRTUAL_CONNECTED_CNF / MSG_ID_NRRC_ENPDCP_SWITCH_VIRTUAL_CONNECTED_CNF */
typedef struct {
    LOCAL_PARA_HDR
} errc_enpdcp_switch_virtual_connected_cnf_struct, nrrc_enpdcp_switch_virtual_connected_cnf_struct;


/* MSG_ID_ERRC_ENPDCP_CNTINFO_REQ / MSG_ID_NRRC_ENPDCP_CNTINFO_REQ */
typedef struct {
    LOCAL_PARA_HDR
} errc_enpdcp_cntinfo_req_struct, nrrc_enpdcp_cntinfo_req_struct;


/* MSG_ID_ERRC_ENPDCP_CNTINFO_CNF / MSG_ID_NRRC_ENPDCP_CNTINFO_CNF */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                   rb_num;
    kal_uint8                   pad01;
    kal_uint16                  pad02;
    enpdcp_rb_cntinfo_struct    rb_cntinfo[ENPDCP_SAP_MAX_NUM_DRB];
} errc_enpdcp_cntinfo_cnf_struct, nrrc_enpdcp_cntinfo_cnf_struct;


/* MSG_ID_ERRC_ENPDCP_DETECTION_TIMER_START_REQ */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint32                   detection_time_value;
} errc_enpdcp_detection_timer_start_req_struct;

/*
 *   MSG_ID_ERRC_ENPDCP_DETECTION_TIMER_2_START_REQ,
 *
 *   note: ERRC configure ENPDPC detection timer value
 */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint32                   detection_time_value; // in seconds
} errc_enpdcp_detection_timer_2_start_req_struct;

/*
 *   MSG_ID_ERRC_ENPDCP_DETECTION_TIMER_3_START_REQ,
 *
 *   note: ERRC configure EPDPC detection timer value (T3)
 */
typedef struct
{
    LOCAL_PARA_HDR
    
    kal_uint32                   detection_time_value; // in seconds
    kal_bool                     restart_timer; // PDCP need to restart timer if True
} errc_enpdcp_detection_timer_3_start_req_struct;

/*
 *   MSG_ID_ERRC_ENPDCP_DETECTION_TIMER_3_TIMEOUT_IND,
 *
 *   note: ERRC configure EPDPC detection timer (T3) TIMEOUT
 */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint32                   exp_timer_value; // in seconds
} errc_enpdcp_detection_timer_3_timeout_ind_struct;

/* MSG_ID_NRRC_ENPDCP_DETECTION_TIMER_3_START_REQ */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint16                   detection_time_value;
    kal_bool                     restart_timer;
} nrrc_enpdcp_detection_timer_3_start_req_struct;

/* MSG_ID_NRRC_ENPDCP_DETECTION_TIMER_3_TIMEOUT_IND */
typedef struct
{
    LOCAL_PARA_HDR

    kal_bool                     local_release_needed;
} nrrc_enpdcp_detection_timer_3_timeout_ind_struct;

/* MSG_ID_NRRC_ENPDCP_DETECTION_TIMER_4_START_REQ */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint16                   detection_time_value; // in milliseconds
} nrrc_enpdcp_detection_timer_4_start_req_struct;

/* MSG_ID_ERRC_ENPDCP_PS_DATA_INACTIVE_TIME_IND */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint32                   inactive_time;
} errc_enpdcp_ps_data_inactive_time_ind_struct;

/*
 *  MSG_ID_ERRC_ENPDCP_EXCESS_DELAY_IND
 */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                       list_num;
    enpdcp_delay_result_struct       result_list[ENPDCP_SAP_MAX_NUM_QUEUING_DELAY_RSLT];
    kal_uint32                       threshold;
    kal_uint32                       report_interval;
} errc_enpdcp_excess_delay_ind_struct;

/*
 *  MSG_ID_ERRC_ENPDCP_RLF_IND
 *  is_old_rb: indicate the RLF entity is the first one or second one that established for fullconfig handover
 *             true stands for the first entity 
 */
typedef struct
{
    LOCAL_PARA_HDR

    kal_uint8                       rb_id;
    kal_bool                        is_old_rb;
    enpdcp_rlf_cause_enum            cause;
} errc_enpdcp_rlf_ind_struct;


/* MSG_ID_ERRC_ENPDCP_CUT_CELL_IND / MSG_ID_NRRC_ENPDCP_CUT_CELL_IND */
typedef struct
{
    LOCAL_PARA_HDR

    enpdcp_cut_cell_cause_enum  cause;
    kal_bool                    is_cell_valid;
    kal_uint32                  earfcn;
    kal_uint16                  pci;
    kal_uint16                  bar_time; // in second
} errc_enpdcp_cut_cell_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR

    enpdcp_cut_cell_cause_enum  cause;
    kal_bool                    is_cell_valid;
    nr_cell_info                nr_cell_info;
    kal_uint16                  bar_time; // in second
} nrrc_enpdcp_cut_cell_ind_struct;

#endif /* _RRC_ENPDCP_MSG_H */
