/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2012
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

/*****************************************************************************
 *
 * Filename:
 * ---------
 *   upcm_enpdcp_interface.h
 *
 * Project:
 * --------
 *   VMOLY
 *
 * Description:
 * ------------
 *   UPCM-ENPDCP interface
 *
 * Author:
 * -------
 * -------
 *
 * ==========================================================================
 * $Log$
 *
 * 07 12 2019 yiting.cheng
 * [MOLY00421061] [Gen97] ANBR (RBR,RBRQ) over NR
 * .
 *
 * 05 17 2019 tc.chang
 * [MOLY00404770] [Gen97] Sync Gen95 UMOLYE patch
 * BEARER_APP_REQ update.
 *
 ****************************************************************************/

#ifndef __UPCM_ENPDCP_INTERFACE_H__
#define __UPCM_ENPDCP_INTERFACE_H__

#include "kal_public_api.h"
#include "kal_public_defs.h"

#include "ps_public_enum_public.h"
#include "enl2_sap_common.h"

typedef struct {
    LOCAL_PARA_HDR

    enpdcp_cn_generation_enum cn_generation;

    /* Bit set to 1 iff the corresponding EPSB or PDU session is Internet.
     * (DDM_APN_TYPE_DEFAULT)
     * LSB: for EBI / PSI 0
     * MSB: for EBI / PSI 15
     */
    kal_uint16 internet_bearer_bmp;

    /* Bit set to 1 iff the corresponding EPSB or PDU session is IMS.
     * (DDM_APN_TYPE_IMS)
     * LSB: for EBI / PSI 0
     * MSB: for EBI / PSI 15
     */
    kal_uint16 ims_bearer_bmp;

    /* Valid when cn_generation is 5G.
     * ims_signalling_5g_qfi[1] = 2; // PSI 1 QFI 2 is IMS signalling bearer.
     */
    kal_uint8 ims_signalling_5g_qfi[MAX_NUM_OF_SUPPORTED_PDUS + 1];

} upcm_enpdcp_bearer_app_req_struct;

typedef struct {
    kal_uint8 psi;
    kal_uint8 num_qfi;
    kal_uint8 qfi[MAX_QOS_FLOWS_PER_PDU_SESSION];
} upcm_enpdcp_rb_psi_qfi_struct;

/**
 * @brief get psi and qfi by rb_idx
 *
 * @param rb_idx
 * @param psi_qfi the psi/num_qfi/qfi[] mapped by rb_idx, the API will update it
 * 
 * @return void
 */
void upcm_enpdcp_rb_to_psi_qfi(kal_uint8 rb_idx, upcm_enpdcp_rb_psi_qfi_struct *psi_qfi, kal_uint8 protocol_idx);

/**
 * @brief get rb_idx by psi and qfi
 *
 * @param psi
 * @param qfi
 * 
 * @return rb_idx mapped by the corresponding psi/qfi, 0xFF means no mapped RB
 */
kal_uint8 upcm_enpdcp_psi_qfi_to_rb(kal_uint8 psi, kal_uint8 qfi, kal_uint8 protocol_idx);


#endif // __UPCM_ENPDCP_INTERFACE_H__
